/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.internal.zzbq;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzae
implements Handler.Callback {
    private final zzaf zzgab;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zzgac = new ArrayList();
    private ArrayList<GoogleApiClient.ConnectionCallbacks> zzgad = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zzgae = new ArrayList();
    private volatile boolean zzgaf = false;
    private final AtomicInteger zzgag = new AtomicInteger(0);
    private boolean zzgah = false;
    private final Handler mHandler;
    private final Object mLock = new Object();

    public zzae(Looper looper, zzaf zzaf2) {
        this.zzgab = zzaf2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public final void zzali() {
        this.zzgaf = false;
        this.zzgag.incrementAndGet();
    }

    public final void zzalj() {
        this.zzgaf = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzk(Bundle bundle) {
        zzbq.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.mLock;
        synchronized (object) {
            zzbq.checkState((!this.zzgah ? 1 : 0) != 0);
            this.mHandler.removeMessages(1);
            this.zzgah = true;
            zzbq.checkState((this.zzgad.size() == 0 ? 1 : 0) != 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzgac);
            int n = this.zzgag.get();
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                GoogleApiClient.ConnectionCallbacks connectionCallbacks = arrayList2.get(i);
                GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
                if (!this.zzgaf || !this.zzgab.isConnected() || this.zzgag.get() != n) break;
                if (this.zzgad.contains(connectionCallbacks2)) continue;
                connectionCallbacks2.onConnected(bundle);
            }
            this.zzgad.clear();
            this.zzgah = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcg(int n) {
        zzbq.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.mLock;
        synchronized (object) {
            this.zzgah = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzgac);
            int n2 = this.zzgag.get();
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList2 = arrayList;
            int n3 = arrayList2.size();
            for (int i = 0; i < n3; ++i) {
                GoogleApiClient.ConnectionCallbacks connectionCallbacks = arrayList2.get(i);
                GoogleApiClient.ConnectionCallbacks connectionCallbacks2 = connectionCallbacks;
                if (!this.zzgaf || this.zzgag.get() != n2) break;
                if (!this.zzgac.contains(connectionCallbacks2)) continue;
                connectionCallbacks2.onConnectionSuspended(n);
            }
            this.zzgad.clear();
            this.zzgah = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzk(ConnectionResult connectionResult) {
        zzbq.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zzgae);
            int n = this.zzgag.get();
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = arrayList2.get(i);
                GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener2 = onConnectionFailedListener;
                if (this.zzgaf && this.zzgag.get() == n) continue;
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzbq.checkNotNull((Object)connectionCallbacks);
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzgac.contains(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(62 + String.valueOf(string2).length()).append("registerConnectionCallbacks(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zzgac.add(connectionCallbacks);
            }
        }
        if (this.zzgab.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)connectionCallbacks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzbq.checkNotNull((Object)connectionCallbacks);
        Object object = this.mLock;
        synchronized (object) {
            return this.zzgac.contains(connectionCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzbq.checkNotNull((Object)connectionCallbacks);
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzgac.remove(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(52 + String.valueOf(string2).length()).append("unregisterConnectionCallbacks(): listener ").append(string2).append(" not found").toString());
            } else if (this.zzgah) {
                this.zzgad.add(connectionCallbacks);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzbq.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzgae.contains(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(67 + String.valueOf(string2).length()).append("registerConnectionFailedListener(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zzgae.add(onConnectionFailedListener);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzbq.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.mLock;
        synchronized (object) {
            return this.zzgae.contains(onConnectionFailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzbq.checkNotNull((Object)onConnectionFailedListener);
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzgae.remove(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(57 + String.valueOf(string2).length()).append("unregisterConnectionFailedListener(): listener ").append(string2).append(" not found").toString());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleMessage(Message message) {
        if (message.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)message.obj;
            Object object = this.mLock;
            synchronized (object) {
                if (this.zzgaf && this.zzgab.isConnected() && this.zzgac.contains(connectionCallbacks)) {
                    Bundle bundle = this.zzgab.zzafi();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        int n = message.what;
        Log.wtf((String)"GmsClientEvents", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        return false;
    }
}

