/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzae;
import com.google.android.gms.common.api.internal.zzbm;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbq;
import com.google.android.gms.common.api.internal.zzbr;
import com.google.android.gms.common.api.internal.zzbs;
import com.google.android.gms.common.api.internal.zzbu;
import com.google.android.gms.common.api.internal.zzck;
import com.google.android.gms.common.api.internal.zzcr;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.internal.zzbz;
import com.google.android.gms.internal.zzcxd;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class zzbo<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zzu {
    private final Queue<zza> zzftj = new LinkedList<zza>();
    private final Api.zze zzfpv;
    private final Api.zzb zzftk;
    private final zzh<O> zzfmf;
    private final zzae zzftl;
    private final Set<zzj> zzftm = new HashSet<zzj>();
    private final Map<zzck<?>, zzcr> zzftn = new HashMap();
    private final int zzfto;
    private final zzcv zzftp;
    private boolean zzfrw;
    private ConnectionResult zzftq = null;
    final /* synthetic */ zzbm zzfti;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zzbo(zzbm zzbm2, GoogleApi googleApi) {
        this.zzfti = zzbm2;
        this.zzfpv = googleApi.zza(zzbm.zza(zzbm2).getLooper(), this);
        this.zzftk = this.zzfpv instanceof zzbz ? zzbz.zzals() : this.zzfpv;
        this.zzfmf = googleApi.zzagn();
        this.zzftl = new zzae();
        this.zzfto = googleApi.getInstanceId();
        if (this.zzfpv.zzaay()) {
            this.zzftp = googleApi.zza(zzbm.zzb(zzbm2), zzbm.zza(zzbm2));
            return;
        }
        this.zzftp = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        if (Looper.myLooper() == zzbm.zza(this.zzfti).getLooper()) {
            this.zzaiw();
            return;
        }
        zzbm.zza(this.zzfti).post((Runnable)new zzbp(this));
    }

    @WorkerThread
    private final void zzaiw() {
        this.zzaiz();
        this.zzi(ConnectionResult.zzfkr);
        this.zzajb();
        for (zzcr zzcr2 : this.zzftn.values()) {
            try {
                zzcr2.zzfnq.zzb(this.zzftk, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzfpv.disconnect();
                break;
            }
            catch (RemoteException remoteException) {
            }
        }
        zzbo zzbo2 = this;
        while (zzbo2.zzfpv.isConnected() && !zzbo2.zzftj.isEmpty()) {
            zza zza2 = zzbo2.zzftj.remove();
            zzbo2.zzb(zza2);
        }
        this.zzajc();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == zzbm.zza(this.zzfti).getLooper()) {
            this.zzaix();
            return;
        }
        zzbm.zza(this.zzfti).post((Runnable)new zzbq(this));
    }

    @WorkerThread
    private final void zzaix() {
        this.zzaiz();
        this.zzfrw = true;
        this.zzftl.zzahw();
        zzbm.zza(this.zzfti).sendMessageDelayed(Message.obtain((Handler)zzbm.zza(this.zzfti), (int)9, this.zzfmf), zzbm.zzc(this.zzfti));
        zzbm.zza(this.zzfti).sendMessageDelayed(Message.obtain((Handler)zzbm.zza(this.zzfti), (int)11, this.zzfmf), zzbm.zzd(this.zzfti));
        zzbm.zza(this.zzfti, -1);
    }

    @WorkerThread
    public final void zzh(@NonNull ConnectionResult connectionResult) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfti));
        this.zzfpv.disconnect();
        this.onConnectionFailed(connectionResult);
    }

    @Override
    public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (Looper.myLooper() == zzbm.zza(this.zzfti).getLooper()) {
            this.onConnectionFailed(connectionResult);
            return;
        }
        zzbm.zza(this.zzfti).post((Runnable)new zzbr(this, connectionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfti));
        if (this.zzftp != null) {
            this.zzftp.zzajq();
        }
        this.zzaiz();
        zzbm.zza(this.zzfti, -1);
        this.zzi(connectionResult);
        if (connectionResult.getErrorCode() == 4) {
            this.zzw(zzbm.zzaiu());
            return;
        }
        if (this.zzftj.isEmpty()) {
            this.zzftq = connectionResult;
            return;
        }
        Object object = zzbm.zzaiv();
        synchronized (object) {
            if (zzbm.zze(this.zzfti) != null && zzbm.zzf(this.zzfti).contains(this.zzfmf)) {
                zzbm.zze(this.zzfti).zzb(connectionResult, this.zzfto);
                return;
            }
        }
        if (!this.zzfti.zzc(connectionResult, this.zzfto)) {
            if (connectionResult.getErrorCode() == 18) {
                this.zzfrw = true;
            }
            if (this.zzfrw) {
                zzbm.zza(this.zzfti).sendMessageDelayed(Message.obtain((Handler)zzbm.zza(this.zzfti), (int)9, this.zzfmf), zzbm.zzc(this.zzfti));
                return;
            }
            object = this.zzfmf.zzagy();
            this.zzw(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
        }
    }

    @WorkerThread
    public final void zza(zza zza2) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfti));
        if (this.zzfpv.isConnected()) {
            this.zzb(zza2);
            this.zzajc();
            return;
        }
        this.zzftj.add(zza2);
        if (this.zzftq != null && this.zzftq.hasResolution()) {
            this.onConnectionFailed(this.zzftq);
            return;
        }
        this.connect();
    }

    @WorkerThread
    public final void signOut() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfti));
        this.zzw(zzbm.zzfsy);
        this.zzftl.zzahv();
        for (zzck zzck2 : this.zzftn.keySet().toArray(new zzck[this.zzftn.size()])) {
            this.zza(new zzf(zzck2, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
        }
        this.zzi(new ConnectionResult(4));
        if (this.zzfpv.isConnected()) {
            this.zzfpv.zza(new zzbs(this));
        }
    }

    public final Api.zze zzahp() {
        return this.zzfpv;
    }

    public final Map<zzck<?>, zzcr> zzaiy() {
        return this.zzftn;
    }

    @WorkerThread
    public final void zzaiz() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfti));
        this.zzftq = null;
    }

    @WorkerThread
    public final ConnectionResult zzaja() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfti));
        return this.zzftq;
    }

    @WorkerThread
    private final void zzb(zza zza2) {
        zza2.zza(this.zzftl, this.zzaay());
        try {
            zza2.zza(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zzfpv.disconnect();
            return;
        }
    }

    @WorkerThread
    public final void zzw(Status status) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfti));
        Iterator iterator = this.zzftj.iterator();
        while (iterator.hasNext()) {
            ((zza)iterator.next()).zzs(status);
        }
        this.zzftj.clear();
    }

    @WorkerThread
    public final void resume() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfti));
        if (this.zzfrw) {
            this.connect();
        }
    }

    @WorkerThread
    private final void zzajb() {
        if (this.zzfrw) {
            zzbm.zza(this.zzfti).removeMessages(11, this.zzfmf);
            zzbm.zza(this.zzfti).removeMessages(9, this.zzfmf);
            this.zzfrw = false;
        }
    }

    @WorkerThread
    public final void zzaij() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfti));
        if (this.zzfrw) {
            this.zzajb();
            Status status = zzbm.zzg(this.zzfti).isGooglePlayServicesAvailable(zzbm.zzb(this.zzfti)) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
            this.zzw(status);
            this.zzfpv.disconnect();
        }
    }

    private final void zzajc() {
        zzbm.zza(this.zzfti).removeMessages(12, this.zzfmf);
        zzbm.zza(this.zzfti).sendMessageDelayed(zzbm.zza(this.zzfti).obtainMessage(12, this.zzfmf), zzbm.zzh(this.zzfti));
    }

    @WorkerThread
    public final void zzajd() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfti));
        if (this.zzfpv.isConnected() && this.zzftn.size() == 0) {
            if (this.zzftl.zzahu()) {
                this.zzajc();
                return;
            }
            this.zzfpv.disconnect();
        }
    }

    @WorkerThread
    public final void connect() {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfti));
        if (this.zzfpv.isConnected() || this.zzfpv.isConnecting()) {
            return;
        }
        if (this.zzfpv.zzagg() && zzbm.zzi(this.zzfti) != 0) {
            zzbm.zza(this.zzfti, zzbm.zzg(this.zzfti).isGooglePlayServicesAvailable(zzbm.zzb(this.zzfti)));
            if (zzbm.zzi(this.zzfti) != 0) {
                ConnectionResult connectionResult = new ConnectionResult(zzbm.zzi(this.zzfti), null);
                this.onConnectionFailed(connectionResult);
                return;
            }
        }
        zzbu zzbu2 = new zzbu(this.zzfti, this.zzfpv, this.zzfmf);
        if (this.zzfpv.zzaay()) {
            this.zzftp.zza(zzbu2);
        }
        this.zzfpv.zza(zzbu2);
    }

    @WorkerThread
    public final void zza(zzj zzj2) {
        com.google.android.gms.common.internal.zzbq.zza((Handler)zzbm.zza(this.zzfti));
        this.zzftm.add(zzj2);
    }

    @WorkerThread
    private final void zzi(ConnectionResult connectionResult) {
        for (zzj zzj2 : this.zzftm) {
            String string2 = null;
            if (connectionResult == ConnectionResult.zzfkr) {
                string2 = this.zzfpv.zzagi();
            }
            zzj2.zza(this.zzfmf, connectionResult, string2);
        }
        this.zzftm.clear();
    }

    final boolean isConnected() {
        return this.zzfpv.isConnected();
    }

    public final boolean zzaay() {
        return this.zzfpv.zzaay();
    }

    public final int getInstanceId() {
        return this.zzfto;
    }

    final zzcxd zzaje() {
        if (this.zzftp == null) {
            return null;
        }
        return this.zzftp.zzaje();
    }

    static /* synthetic */ void zzc(zzbo zzbo2) {
        zzbo2.zzaiw();
    }

    static /* synthetic */ void zzd(zzbo zzbo2) {
        zzbo2.zzaix();
    }

    static /* synthetic */ Api.zze zze(zzbo zzbo2) {
        return zzbo2.zzfpv;
    }
}

