/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.zzal;
import com.google.android.gms.common.api.internal.zzao;
import com.google.android.gms.common.api.internal.zzaz;
import com.google.android.gms.common.api.internal.zzba;
import com.google.android.gms.common.api.internal.zzbh;
import com.google.android.gms.common.api.internal.zzbj;
import com.google.android.gms.common.api.internal.zzbk;
import com.google.android.gms.common.api.internal.zzcc;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzcxd;
import com.google.android.gms.internal.zzcxe;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzbi
implements zzcc,
zzu {
    private final Lock zzfps;
    private final Condition zzfso;
    private final Context mContext;
    private final zzf zzfqc;
    private final zzbk zzfsp;
    final Map<Api.zzc<?>, Api.zze> zzfsb;
    final Map<Api.zzc<?>, ConnectionResult> zzfsq = new HashMap();
    private zzr zzfpx;
    private Map<Api<?>, Boolean> zzfqa;
    private Api.zza<? extends zzcxd, zzcxe> zzfmz;
    private volatile zzbh zzfsr;
    private ConnectionResult zzfss = null;
    int zzfst;
    final zzba zzfpi;
    final zzcd zzfsu;

    public zzbi(Context context, zzba zzba2, Lock lock, Looper looper, zzf zzf2, Map<Api.zzc<?>, Api.zze> map, zzr zzr2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcxd, zzcxe> zza2, ArrayList<zzt> arrayList, zzcd zzcd2) {
        this.mContext = context;
        this.zzfps = lock;
        this.zzfqc = zzf2;
        this.zzfsb = map;
        this.zzfpx = zzr2;
        this.zzfqa = map2;
        this.zzfmz = zza2;
        this.zzfpi = zzba2;
        this.zzfsu = zzcd2;
        ArrayList<zzt> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzt zzt2 = arrayList2.get(i);
            zzt2.zza(this);
        }
        this.zzfsp = new zzbk(this, looper);
        this.zzfso = lock.newCondition();
        this.zzfsr = new zzaz(this);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        t.zzahi();
        return this.zzfsr.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        t.zzahi();
        return this.zzfsr.zze(t);
    }

    @Override
    public final void connect() {
        this.zzfsr.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfso.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfkr;
        }
        if (this.zzfss != null) {
            return this.zzfss;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfso.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfkr;
        }
        if (this.zzfss != null) {
            return this.zzfss;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        if (this.zzfsr.disconnect()) {
            this.zzfsq.clear();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        Api.zzc<?> zzc2 = api.zzagf();
        if (this.zzfsb.containsKey(zzc2)) {
            if (this.zzfsb.get(zzc2).isConnected()) {
                return ConnectionResult.zzfkr;
            }
            if (this.zzfsq.containsKey(zzc2)) {
                return this.zzfsq.get(zzc2);
            }
        }
        return null;
    }

    final void zzain() {
        this.zzfps.lock();
        try {
            this.zzfsr = new zzao(this, this.zzfpx, this.zzfqa, this.zzfqc, this.zzfmz, this.zzfps, this.mContext);
            this.zzfsr.begin();
            this.zzfso.signalAll();
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    final void zzaio() {
        this.zzfps.lock();
        try {
            this.zzfpi.zzaik();
            this.zzfsr = new zzal(this);
            this.zzfsr.begin();
            this.zzfso.signalAll();
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    final void zzg(ConnectionResult connectionResult) {
        this.zzfps.lock();
        try {
            this.zzfss = connectionResult;
            this.zzfsr = new zzaz(this);
            this.zzfsr.begin();
            this.zzfso.signalAll();
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        return this.zzfsr instanceof zzal;
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfsr instanceof zzao;
    }

    @Override
    public final boolean zza(zzcu zzcu2) {
        return false;
    }

    @Override
    public final void zzags() {
    }

    @Override
    public final void zzahk() {
        if (this.isConnected()) {
            ((zzal)this.zzfsr).zzaia();
        }
    }

    @Override
    public final void zza(@NonNull ConnectionResult connectionResult, @NonNull Api<?> api, boolean bl) {
        this.zzfps.lock();
        try {
            this.zzfsr.zza(connectionResult, api, bl);
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        this.zzfps.lock();
        try {
            this.zzfsr.onConnected(bundle);
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    @Override
    public final void onConnectionSuspended(int n) {
        this.zzfps.lock();
        try {
            this.zzfsr.onConnectionSuspended(n);
            return;
        }
        finally {
            this.zzfps.unlock();
        }
    }

    final void zza(zzbj zzbj2) {
        Message message = this.zzfsp.obtainMessage(1, zzbj2);
        this.zzfsp.sendMessage(message);
    }

    final void zza(RuntimeException runtimeException) {
        Message message = this.zzfsp.obtainMessage(2, runtimeException);
        this.zzfsp.sendMessage(message);
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3 = String.valueOf(string2).concat("  ");
        printWriter.append(string2).append("mState=").println(this.zzfsr);
        for (Api<?> api : this.zzfqa.keySet()) {
            printWriter.append(string2).append(api.getName()).println(":");
            this.zzfsb.get(api.zzagf()).dump(string3, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ Lock zza(zzbi zzbi2) {
        return zzbi2.zzfps;
    }

    static /* synthetic */ zzbh zzb(zzbi zzbi2) {
        return zzbi2.zzfsr;
    }
}

