/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.accounts.Account;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.zza;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInAccount
extends zzbfm
implements ReflectedParcelable {
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new zzb();
    private static zzd zzegr = zzh.zzamg();
    private int versionCode;
    private String zzbuz;
    private String zzefs;
    private String zzegs;
    private String zzegt;
    private Uri zzegu;
    private String zzegv;
    private long zzegw;
    private String zzegx;
    private List<Scope> zzecp;
    private String zzefb;
    private String zzefc;
    private Set<Scope> zzegy = new HashSet<Scope>();

    @Nullable
    public static GoogleSignInAccount zzeu(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        Uri uri = null;
        String string3 = jSONObject.optString("photoUrl", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            uri = Uri.parse((String)string3);
        }
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        String string4 = jSONObject.optString("serverAuthCode", null);
        GoogleSignInAccount googleSignInAccount = GoogleSignInAccount.zza(jSONObject.optString("id"), jSONObject.optString("tokenId", null), jSONObject.optString("email", null), jSONObject.optString("displayName", null), jSONObject.optString("givenName", null), jSONObject.optString("familyName", null), uri, l, jSONObject.getString("obfuscatedIdentifier"), hashSet);
        GoogleSignInAccount.zza(jSONObject.optString("id"), jSONObject.optString("tokenId", null), jSONObject.optString("email", null), jSONObject.optString("displayName", null), jSONObject.optString("givenName", null), jSONObject.optString("familyName", null), uri, l, jSONObject.getString("obfuscatedIdentifier"), hashSet).zzegv = string4;
        return googleSignInAccount;
    }

    private static GoogleSignInAccount zza(@Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable Uri uri, @Nullable Long l, @NonNull String string8, @NonNull Set<Scope> set) {
        if (l == null) {
            l = zzegr.currentTimeMillis() / 1000L;
        }
        return new GoogleSignInAccount(3, string2, string3, string4, string5, uri, null, l, zzbq.zzgm((String)string8), new ArrayList<Scope>((Collection)zzbq.checkNotNull(set)), string6, string7);
    }

    public static GoogleSignInAccount zzaaz() {
        HashSet<Scope> hashSet = new HashSet<Scope>();
        Account account = new Account("<<default account>>", "com.google");
        return GoogleSignInAccount.zza(null, null, account.name, null, null, null, null, 0L, account.name, hashSet);
    }

    GoogleSignInAccount(int n, String string2, String string3, String string4, String string5, Uri uri, String string6, long l, String string7, List<Scope> list, String string8, String string9) {
        this.versionCode = n;
        this.zzbuz = string2;
        this.zzefs = string3;
        this.zzegs = string4;
        this.zzegt = string5;
        this.zzegu = uri;
        this.zzegv = string6;
        this.zzegw = l;
        this.zzegx = string7;
        this.zzecp = list;
        this.zzefb = string8;
        this.zzefc = string9;
    }

    @Nullable
    public String getId() {
        return this.zzbuz;
    }

    @Nullable
    public String getIdToken() {
        return this.zzefs;
    }

    @Nullable
    public String getEmail() {
        return this.zzegs;
    }

    @Nullable
    public Account getAccount() {
        if (this.zzegs == null) {
            return null;
        }
        return new Account(this.zzegs, "com.google");
    }

    @Nullable
    public String getDisplayName() {
        return this.zzegt;
    }

    @Nullable
    public String getGivenName() {
        return this.zzefb;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzefc;
    }

    @Nullable
    public Uri getPhotoUrl() {
        return this.zzegu;
    }

    public final GoogleSignInAccount zza(Scope ... scopeArray) {
        if (scopeArray != null) {
            Collections.addAll(this.zzegy, scopeArray);
        }
        return this;
    }

    @Nullable
    public String getServerAuthCode() {
        return this.zzegv;
    }

    public final boolean zza() {
        return zzegr.currentTimeMillis() / 1000L >= this.zzegw - 300L;
    }

    @NonNull
    public final String zzaba() {
        return this.zzegx;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        return new HashSet<Scope>(this.zzecp);
    }

    @NonNull
    public final Set<Scope> zzabb() {
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzecp);
        hashSet.addAll(this.zzegy);
        return hashSet;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GoogleSignInAccount googleSignInAccount = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zzc((Parcel)parcel2, (int)1, (int)googleSignInAccount.versionCode);
        zzbfp.zza((Parcel)parcel2, (int)2, (String)googleSignInAccount.getId(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)3, (String)googleSignInAccount.getIdToken(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)4, (String)googleSignInAccount.getEmail(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)5, (String)googleSignInAccount.getDisplayName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)6, (Parcelable)googleSignInAccount.getPhotoUrl(), (int)n, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)7, (String)googleSignInAccount.getServerAuthCode(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)8, (long)googleSignInAccount.zzegw);
        zzbfp.zza((Parcel)parcel2, (int)9, (String)googleSignInAccount.zzegx, (boolean)false);
        zzbfp.zzc((Parcel)parcel2, (int)10, googleSignInAccount.zzecp, (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)11, (String)googleSignInAccount.getGivenName(), (boolean)false);
        zzbfp.zza((Parcel)parcel2, (int)12, (String)googleSignInAccount.getFamilyName(), (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    public int hashCode() {
        return (527 + this.zzegx.hashCode()) * 31 + this.zzabb().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GoogleSignInAccount)) {
            return false;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)((Object)object);
        return googleSignInAccount.zzegx.equals(this.zzegx) && googleSignInAccount.zzabb().equals(this.zzabb());
    }

    public final String zzabc() {
        JSONObject jSONObject = this.toJsonObject();
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }

    private final JSONObject toJsonObject() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.getId() != null) {
                jSONObject.put("id", (Object)this.getId());
            }
            if (this.getIdToken() != null) {
                jSONObject.put("tokenId", (Object)this.getIdToken());
            }
            if (this.getEmail() != null) {
                jSONObject.put("email", (Object)this.getEmail());
            }
            if (this.getDisplayName() != null) {
                jSONObject.put("displayName", (Object)this.getDisplayName());
            }
            if (this.getGivenName() != null) {
                jSONObject.put("givenName", (Object)this.getGivenName());
            }
            if (this.getFamilyName() != null) {
                jSONObject.put("familyName", (Object)this.getFamilyName());
            }
            if (this.getPhotoUrl() != null) {
                jSONObject.put("photoUrl", (Object)this.getPhotoUrl().toString());
            }
            if (this.getServerAuthCode() != null) {
                jSONObject.put("serverAuthCode", (Object)this.getServerAuthCode());
            }
            jSONObject.put("expirationTime", this.zzegw);
            jSONObject.put("obfuscatedIdentifier", (Object)this.zzegx);
            JSONArray jSONArray = new JSONArray();
            Scope[] scopeArray = this.zzecp.toArray(new Scope[this.zzecp.size()]);
            Arrays.sort(scopeArray, zza.zzegz);
            Scope[] scopeArray2 = scopeArray;
            int n = scopeArray.length;
            for (int i = 0; i < n; ++i) {
                Scope scope = scopeArray2[i];
                jSONArray.put((Object)scope.zzagw());
            }
            jSONObject.put("grantedScopes", (Object)jSONArray);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }

    static final /* synthetic */ int zza(Scope scope, Scope scope2) {
        return scope.zzagw().compareTo(scope2.zzagw());
    }
}

