/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzah;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbs;
import com.google.android.gms.common.api.internal.zzbt;
import com.google.android.gms.common.api.internal.zzbu;
import com.google.android.gms.common.api.internal.zzbv;
import com.google.android.gms.common.api.internal.zzbx;
import com.google.android.gms.common.api.internal.zzcn;
import com.google.android.gms.common.api.internal.zzcu;
import com.google.android.gms.common.api.internal.zzcy;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.internal.zzbz;
import com.google.android.gms.internal.zzcwb;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class zzbr<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zzx {
    private final Queue<zza> zzfqz = new LinkedList<zza>();
    private final Api.zze zzfnl;
    private final Api.zzb zzfra;
    private final zzh<O> zzfjv;
    private final zzah zzfrb;
    private final Set<zzj> zzfrc = new HashSet<zzj>();
    private final Map<zzcn<?>, zzcu> zzfrd = new HashMap();
    private final int zzfre;
    private final zzcy zzfrf;
    private boolean zzfpm;
    private ConnectionResult zzfrg = null;
    final /* synthetic */ zzbp zzfqy;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zzbr(zzbp zzbp2, GoogleApi googleApi) {
        this.zzfqy = zzbp2;
        this.zzfnl = googleApi.zza(zzbp.zza(zzbp2).getLooper(), this);
        this.zzfra = this.zzfnl instanceof zzbz ? zzbz.zzalh() : this.zzfnl;
        this.zzfjv = googleApi.zzagb();
        this.zzfrb = new zzah();
        this.zzfre = googleApi.getInstanceId();
        if (this.zzfnl.zzaan()) {
            this.zzfrf = googleApi.zza(zzbp.zzb(zzbp2), zzbp.zza(zzbp2));
            return;
        }
        this.zzfrf = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        if (Looper.myLooper() == zzbp.zza(this.zzfqy).getLooper()) {
            this.zzail();
            return;
        }
        zzbp.zza(this.zzfqy).post((Runnable)new zzbs(this));
    }

    @WorkerThread
    private final void zzail() {
        this.zzaio();
        this.zzi(ConnectionResult.zzfii);
        this.zzaiq();
        for (zzcu zzcu2 : this.zzfrd.values()) {
            try {
                zzcu2.zzflg.zzb(this.zzfra, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzfnl.disconnect();
                break;
            }
            catch (RemoteException remoteException) {
            }
        }
        zzbr zzbr2 = this;
        while (zzbr2.zzfnl.isConnected() && !zzbr2.zzfqz.isEmpty()) {
            zza zza2 = zzbr2.zzfqz.remove();
            zzbr2.zzb(zza2);
        }
        this.zzair();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == zzbp.zza(this.zzfqy).getLooper()) {
            this.zzaim();
            return;
        }
        zzbp.zza(this.zzfqy).post((Runnable)new zzbt(this));
    }

    @WorkerThread
    private final void zzaim() {
        this.zzaio();
        this.zzfpm = true;
        this.zzfrb.zzahl();
        zzbp.zza(this.zzfqy).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfqy), (int)9, this.zzfjv), zzbp.zzc(this.zzfqy));
        zzbp.zza(this.zzfqy).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfqy), (int)11, this.zzfjv), zzbp.zzd(this.zzfqy));
        zzbp.zza(this.zzfqy, -1);
    }

    @WorkerThread
    public final void zzh(@NonNull ConnectionResult connectionResult) {
        zzbq.zza((Handler)zzbp.zza(this.zzfqy));
        this.zzfnl.disconnect();
        this.onConnectionFailed(connectionResult);
    }

    @Override
    public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (Looper.myLooper() == zzbp.zza(this.zzfqy).getLooper()) {
            this.onConnectionFailed(connectionResult);
            return;
        }
        zzbp.zza(this.zzfqy).post((Runnable)new zzbu(this, connectionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbq.zza((Handler)zzbp.zza(this.zzfqy));
        if (this.zzfrf != null) {
            this.zzfrf.zzajf();
        }
        this.zzaio();
        zzbp.zza(this.zzfqy, -1);
        this.zzi(connectionResult);
        if (connectionResult.getErrorCode() == 4) {
            this.zzx(zzbp.zzaij());
            return;
        }
        if (this.zzfqz.isEmpty()) {
            this.zzfrg = connectionResult;
            return;
        }
        Object object = zzbp.zzaik();
        synchronized (object) {
            if (zzbp.zze(this.zzfqy) != null && zzbp.zzf(this.zzfqy).contains(this.zzfjv)) {
                zzbp.zze(this.zzfqy).zzb(connectionResult, this.zzfre);
                return;
            }
        }
        if (!this.zzfqy.zzc(connectionResult, this.zzfre)) {
            if (connectionResult.getErrorCode() == 18) {
                this.zzfpm = true;
            }
            if (this.zzfpm) {
                zzbp.zza(this.zzfqy).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfqy), (int)9, this.zzfjv), zzbp.zzc(this.zzfqy));
                return;
            }
            object = this.zzfjv.zzagm();
            this.zzx(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
        }
    }

    @WorkerThread
    public final void zza(zza zza2) {
        zzbq.zza((Handler)zzbp.zza(this.zzfqy));
        if (this.zzfnl.isConnected()) {
            this.zzb(zza2);
            this.zzair();
            return;
        }
        this.zzfqz.add(zza2);
        if (this.zzfrg != null && this.zzfrg.hasResolution()) {
            this.onConnectionFailed(this.zzfrg);
            return;
        }
        this.connect();
    }

    @WorkerThread
    public final void signOut() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqy));
        this.zzx(zzbp.zzfqo);
        this.zzfrb.zzahk();
        for (zzcn zzcn2 : this.zzfrd.keySet().toArray(new zzcn[this.zzfrd.size()])) {
            this.zza(new zzf(zzcn2, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
        }
        this.zzi(new ConnectionResult(4));
        this.zzfnl.zza(new zzbv(this));
    }

    public final Api.zze zzahe() {
        return this.zzfnl;
    }

    public final Map<zzcn<?>, zzcu> zzain() {
        return this.zzfrd;
    }

    @WorkerThread
    public final void zzaio() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqy));
        this.zzfrg = null;
    }

    @WorkerThread
    public final ConnectionResult zzaip() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqy));
        return this.zzfrg;
    }

    @WorkerThread
    private final void zzb(zza zza2) {
        zza2.zza(this.zzfrb, this.zzaan());
        try {
            zza2.zza(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zzfnl.disconnect();
            return;
        }
    }

    @WorkerThread
    public final void zzx(Status status) {
        zzbq.zza((Handler)zzbp.zza(this.zzfqy));
        Iterator iterator = this.zzfqz.iterator();
        while (iterator.hasNext()) {
            ((zza)iterator.next()).zzt(status);
        }
        this.zzfqz.clear();
    }

    @WorkerThread
    public final void resume() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqy));
        if (this.zzfpm) {
            this.connect();
        }
    }

    @WorkerThread
    private final void zzaiq() {
        if (this.zzfpm) {
            zzbp.zza(this.zzfqy).removeMessages(11, this.zzfjv);
            zzbp.zza(this.zzfqy).removeMessages(9, this.zzfjv);
            this.zzfpm = false;
        }
    }

    @WorkerThread
    public final void zzahy() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqy));
        if (this.zzfpm) {
            this.zzaiq();
            Status status = zzbp.zzg(this.zzfqy).isGooglePlayServicesAvailable(zzbp.zzb(this.zzfqy)) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
            this.zzx(status);
            this.zzfnl.disconnect();
        }
    }

    private final void zzair() {
        zzbp.zza(this.zzfqy).removeMessages(12, this.zzfjv);
        zzbp.zza(this.zzfqy).sendMessageDelayed(zzbp.zza(this.zzfqy).obtainMessage(12, this.zzfjv), zzbp.zzh(this.zzfqy));
    }

    @WorkerThread
    public final void zzais() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqy));
        if (this.zzfnl.isConnected() && this.zzfrd.size() == 0) {
            if (this.zzfrb.zzahj()) {
                this.zzair();
                return;
            }
            this.zzfnl.disconnect();
        }
    }

    @WorkerThread
    public final void connect() {
        zzbq.zza((Handler)zzbp.zza(this.zzfqy));
        if (this.zzfnl.isConnected() || this.zzfnl.isConnecting()) {
            return;
        }
        if (this.zzfnl.zzafv() && zzbp.zzi(this.zzfqy) != 0) {
            zzbp.zza(this.zzfqy, zzbp.zzg(this.zzfqy).isGooglePlayServicesAvailable(zzbp.zzb(this.zzfqy)));
            if (zzbp.zzi(this.zzfqy) != 0) {
                ConnectionResult connectionResult = new ConnectionResult(zzbp.zzi(this.zzfqy), null);
                this.onConnectionFailed(connectionResult);
                return;
            }
        }
        zzbx zzbx2 = new zzbx(this.zzfqy, this.zzfnl, this.zzfjv);
        if (this.zzfnl.zzaan()) {
            this.zzfrf.zza(zzbx2);
        }
        this.zzfnl.zza(zzbx2);
    }

    @WorkerThread
    public final void zza(zzj zzj2) {
        zzbq.zza((Handler)zzbp.zza(this.zzfqy));
        this.zzfrc.add(zzj2);
    }

    @WorkerThread
    private final void zzi(ConnectionResult connectionResult) {
        Iterator<zzj> iterator = this.zzfrc.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(this.zzfjv, connectionResult);
        }
        this.zzfrc.clear();
    }

    final boolean isConnected() {
        return this.zzfnl.isConnected();
    }

    public final boolean zzaan() {
        return this.zzfnl.zzaan();
    }

    public final int getInstanceId() {
        return this.zzfre;
    }

    final zzcwb zzait() {
        if (this.zzfrf == null) {
            return null;
        }
        return this.zzfrf.zzait();
    }

    static /* synthetic */ void zzc(zzbr zzbr2) {
        zzbr2.zzail();
    }

    static /* synthetic */ void zzd(zzbr zzbr2) {
        zzbr2.zzaim();
    }

    static /* synthetic */ Api.zze zze(zzbr zzbr2) {
        return zzbr2.zzfnl;
    }
}

