/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzah;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzbs;
import com.google.android.gms.common.api.internal.zzbt;
import com.google.android.gms.common.api.internal.zzbu;
import com.google.android.gms.common.api.internal.zzbv;
import com.google.android.gms.common.api.internal.zzcl;
import com.google.android.gms.common.api.internal.zzcs;
import com.google.android.gms.common.api.internal.zzcw;
import com.google.android.gms.common.api.internal.zzf;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzby;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class zzbr<O extends Api.ApiOptions>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
zzx {
    private final Queue<zza> zzfnu = new LinkedList<zza>();
    private final Api.zze zzfkg;
    private final Api.zzb zzfnv;
    private final zzh<O> zzfgr;
    private final zzah zzfnw;
    private final Set<zzj> zzfnx = new HashSet<zzj>();
    private final Map<zzcl<?>, zzcs> zzfny = new HashMap();
    private final int zzfnz;
    private final zzcw zzfoa;
    private boolean zzfmh;
    private ConnectionResult zzfob = null;
    private /* synthetic */ zzbp zzfnt;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    @WorkerThread
    public zzbr(zzbp zzbp2, GoogleApi googleApi) {
        this.zzfnt = zzbp2;
        this.zzfkg = googleApi.zza(zzbp.zza(zzbp2).getLooper(), this);
        this.zzfnv = this.zzfkg instanceof zzby ? zzby.zzakp() : this.zzfkg;
        this.zzfgr = googleApi.zzafk();
        this.zzfnw = new zzah();
        this.zzfnz = googleApi.getInstanceId();
        if (this.zzfkg.zzaac()) {
            this.zzfoa = googleApi.zza(zzbp.zzb(zzbp2), zzbp.zza(zzbp2));
            return;
        }
        this.zzfoa = null;
    }

    @Override
    public final void onConnected(@Nullable Bundle bundle) {
        if (Looper.myLooper() == zzbp.zza(this.zzfnt).getLooper()) {
            this.zzahu();
            return;
        }
        zzbp.zza(this.zzfnt).post((Runnable)new zzbs(this));
    }

    @WorkerThread
    private final void zzahu() {
        this.zzahx();
        this.zzi(ConnectionResult.zzffe);
        this.zzahz();
        for (zzcs zzcs2 : this.zzfny.values()) {
            try {
                zzcs2.zzfic.zzb(this.zzfnv, (TaskCompletionSource<Void>)new TaskCompletionSource());
            }
            catch (DeadObjectException deadObjectException) {
                this.onConnectionSuspended(1);
                this.zzfkg.disconnect();
                break;
            }
            catch (RemoteException remoteException) {
            }
        }
        zzbr zzbr2 = this;
        while (zzbr2.zzfkg.isConnected() && !zzbr2.zzfnu.isEmpty()) {
            zza zza2 = zzbr2.zzfnu.remove();
            zzbr2.zzb(zza2);
        }
        this.zzaia();
    }

    @Override
    public final void onConnectionSuspended(int n) {
        if (Looper.myLooper() == zzbp.zza(this.zzfnt).getLooper()) {
            this.zzahv();
            return;
        }
        zzbp.zza(this.zzfnt).post((Runnable)new zzbt(this));
    }

    @WorkerThread
    private final void zzahv() {
        this.zzahx();
        this.zzfmh = true;
        this.zzfnw.zzagu();
        zzbp.zza(this.zzfnt).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfnt), (int)9, this.zzfgr), zzbp.zzc(this.zzfnt));
        zzbp.zza(this.zzfnt).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfnt), (int)11, this.zzfgr), zzbp.zzd(this.zzfnt));
        zzbp.zza(this.zzfnt, -1);
    }

    @WorkerThread
    public final void zzh(@NonNull ConnectionResult connectionResult) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnt));
        this.zzfkg.disconnect();
        this.onConnectionFailed(connectionResult);
    }

    @Override
    public final void zza(ConnectionResult connectionResult, Api<?> api, boolean bl) {
        if (Looper.myLooper() == zzbp.zza(this.zzfnt).getLooper()) {
            this.onConnectionFailed(connectionResult);
            return;
        }
        zzbp.zza(this.zzfnt).post((Runnable)new zzbu(this, connectionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnt));
        if (this.zzfoa != null) {
            this.zzfoa.zzain();
        }
        this.zzahx();
        zzbp.zza(this.zzfnt, -1);
        this.zzi(connectionResult);
        if (connectionResult.getErrorCode() == 4) {
            this.zzv(zzbp.zzahs());
            return;
        }
        if (this.zzfnu.isEmpty()) {
            this.zzfob = connectionResult;
            return;
        }
        Object object = zzbp.zzaht();
        synchronized (object) {
            if (zzbp.zze(this.zzfnt) != null && zzbp.zzf(this.zzfnt).contains(this.zzfgr)) {
                zzbp.zze(this.zzfnt).zzb(connectionResult, this.zzfnz);
                return;
            }
        }
        if (!this.zzfnt.zzc(connectionResult, this.zzfnz)) {
            if (connectionResult.getErrorCode() == 18) {
                this.zzfmh = true;
            }
            if (this.zzfmh) {
                zzbp.zza(this.zzfnt).sendMessageDelayed(Message.obtain((Handler)zzbp.zza(this.zzfnt), (int)9, this.zzfgr), zzbp.zzc(this.zzfnt));
                return;
            }
            object = this.zzfgr.zzafv();
            this.zzv(new Status(17, new StringBuilder(38 + String.valueOf(object).length()).append("API: ").append((String)object).append(" is not available on this device.").toString()));
        }
    }

    @WorkerThread
    public final void zza(zza zza2) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnt));
        if (this.zzfkg.isConnected()) {
            this.zzb(zza2);
            this.zzaia();
            return;
        }
        this.zzfnu.add(zza2);
        if (this.zzfob != null && this.zzfob.hasResolution()) {
            this.onConnectionFailed(this.zzfob);
            return;
        }
        this.connect();
    }

    @WorkerThread
    public final void signOut() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnt));
        this.zzv(zzbp.zzfnj);
        this.zzfnw.zzagt();
        for (zzcl<?> zzcl2 : this.zzfny.keySet()) {
            this.zza(new zzf(zzcl2, (TaskCompletionSource<Boolean>)new TaskCompletionSource()));
        }
        this.zzi(new ConnectionResult(4));
        this.zzfkg.disconnect();
    }

    public final Api.zze zzagn() {
        return this.zzfkg;
    }

    public final Map<zzcl<?>, zzcs> zzahw() {
        return this.zzfny;
    }

    @WorkerThread
    public final void zzahx() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnt));
        this.zzfob = null;
    }

    @WorkerThread
    public final ConnectionResult zzahy() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnt));
        return this.zzfob;
    }

    @WorkerThread
    private final void zzb(zza zza2) {
        zza2.zza(this.zzfnw, this.zzaac());
        try {
            zza2.zza(this);
            return;
        }
        catch (DeadObjectException deadObjectException) {
            this.onConnectionSuspended(1);
            this.zzfkg.disconnect();
            return;
        }
    }

    @WorkerThread
    public final void zzv(Status status) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnt));
        Iterator iterator = this.zzfnu.iterator();
        while (iterator.hasNext()) {
            ((zza)iterator.next()).zzr(status);
        }
        this.zzfnu.clear();
    }

    @WorkerThread
    public final void resume() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnt));
        if (this.zzfmh) {
            this.connect();
        }
    }

    @WorkerThread
    private final void zzahz() {
        if (this.zzfmh) {
            zzbp.zza(this.zzfnt).removeMessages(11, this.zzfgr);
            zzbp.zza(this.zzfnt).removeMessages(9, this.zzfgr);
            this.zzfmh = false;
        }
    }

    @WorkerThread
    public final void zzahh() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnt));
        if (this.zzfmh) {
            this.zzahz();
            Status status = zzbp.zzg(this.zzfnt).isGooglePlayServicesAvailable(zzbp.zzb(this.zzfnt)) == 18 ? new Status(8, "Connection timed out while waiting for Google Play services update to complete.") : new Status(8, "API failed to connect while resuming due to an unknown error.");
            this.zzv(status);
            this.zzfkg.disconnect();
        }
    }

    private final void zzaia() {
        zzbp.zza(this.zzfnt).removeMessages(12, this.zzfgr);
        zzbp.zza(this.zzfnt).sendMessageDelayed(zzbp.zza(this.zzfnt).obtainMessage(12, this.zzfgr), zzbp.zzh(this.zzfnt));
    }

    @WorkerThread
    public final void zzaib() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnt));
        if (this.zzfkg.isConnected() && this.zzfny.size() == 0) {
            if (this.zzfnw.zzags()) {
                this.zzaia();
                return;
            }
            this.zzfkg.disconnect();
        }
    }

    @WorkerThread
    public final void connect() {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnt));
        if (this.zzfkg.isConnected() || this.zzfkg.isConnecting()) {
            return;
        }
        if (this.zzfkg.zzaff() && zzbp.zzi(this.zzfnt) != 0) {
            zzbp.zza(this.zzfnt, zzbp.zzg(this.zzfnt).isGooglePlayServicesAvailable(zzbp.zzb(this.zzfnt)));
            if (zzbp.zzi(this.zzfnt) != 0) {
                ConnectionResult connectionResult = new ConnectionResult(zzbp.zzi(this.zzfnt), null);
                this.onConnectionFailed(connectionResult);
                return;
            }
        }
        zzbv zzbv2 = new zzbv(this.zzfnt, this.zzfkg, this.zzfgr);
        if (this.zzfkg.zzaac()) {
            this.zzfoa.zza(zzbv2);
        }
        this.zzfkg.zza(zzbv2);
    }

    @WorkerThread
    public final void zza(zzj zzj2) {
        com.google.android.gms.common.internal.zzbp.zza((Handler)zzbp.zza(this.zzfnt));
        this.zzfnx.add(zzj2);
    }

    @WorkerThread
    private final void zzi(ConnectionResult connectionResult) {
        Iterator<zzj> iterator = this.zzfnx.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(this.zzfgr, connectionResult);
        }
        this.zzfnx.clear();
    }

    final boolean isConnected() {
        return this.zzfkg.isConnected();
    }

    public final boolean zzaac() {
        return this.zzfkg.zzaac();
    }

    public final int getInstanceId() {
        return this.zzfnz;
    }

    final zzcps zzaic() {
        if (this.zzfoa == null) {
            return null;
        }
        return this.zzfoa.zzaic();
    }

    static /* synthetic */ void zzc(zzbr zzbr2) {
        zzbr2.zzahu();
    }

    static /* synthetic */ void zzd(zzbr zzbr2) {
        zzbr2.zzahv();
    }
}

