/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzad;
import com.google.android.gms.common.api.internal.zzbe;
import com.google.android.gms.common.api.internal.zzbf;
import com.google.android.gms.common.api.internal.zzbg;
import com.google.android.gms.common.api.internal.zzbh;
import com.google.android.gms.common.api.internal.zzbi;
import com.google.android.gms.common.api.internal.zzbj;
import com.google.android.gms.common.api.internal.zzbl;
import com.google.android.gms.common.api.internal.zzby;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzce;
import com.google.android.gms.common.api.internal.zzcf;
import com.google.android.gms.common.api.internal.zzcj;
import com.google.android.gms.common.api.internal.zzcn;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzda;
import com.google.android.gms.common.api.internal.zzdf;
import com.google.android.gms.common.api.internal.zzdi;
import com.google.android.gms.common.api.internal.zzdl;
import com.google.android.gms.common.api.internal.zzi;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzy;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbcj;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzbd
extends GoogleApiClient
implements zzce {
    private final Lock zzfjy;
    private boolean zzfhj;
    private final com.google.android.gms.common.internal.zzad zzfma;
    private zzcd zzfmb = null;
    private final int zzfhd;
    private final Context mContext;
    private final Looper zzakl;
    final Queue<zzm<?, ?>> zzfkm = new LinkedList();
    private volatile boolean zzfmc;
    private long zzfmd = 120000L;
    private long zzfme = 5000L;
    private final zzbi zzfmf;
    private final GoogleApiAvailability zzfhf;
    private zzby zzfmg;
    final Map<Api.zzc<?>, Api.zze> zzfmh;
    Set<Scope> zzfmi = new HashSet<Scope>();
    private zzq zzfkd;
    private Map<Api<?>, Boolean> zzfkg;
    private Api.zza<? extends zzcps, zzcpt> zzfhg;
    private final zzcn zzfmj = new zzcn();
    private final ArrayList<zzw> zzfmk;
    private Integer zzfml = null;
    Set<zzdf> zzfmm = null;
    final zzdi zzfmn;
    private final zzae zzfmo = new zzbe(this);

    public zzbd(Context context, Lock lock, Looper looper, zzq zzq2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzcps, zzcpt> zza2, Map<Api<?>, Boolean> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzw> arrayList, boolean bl) {
        this.mContext = context;
        this.zzfjy = lock;
        this.zzfhj = false;
        this.zzfma = new com.google.android.gms.common.internal.zzad(looper, this.zzfmo);
        this.zzakl = looper;
        this.zzfmf = new zzbi(this, looper);
        this.zzfhf = googleApiAvailability;
        this.zzfhd = n;
        if (this.zzfhd >= 0) {
            this.zzfml = n2;
        }
        this.zzfkg = map;
        this.zzfmh = map2;
        this.zzfmk = arrayList;
        this.zzfmn = new zzdi(this.zzfmh);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzfma.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzfma.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzfkd = zzq2;
        this.zzfhg = zza2;
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        zzbp.zzb((t.zzafd() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzafi() != null ? t.zzafi().getName() : "the API";
        zzbp.zzb((boolean)this.zzfmh.containsKey(t.zzafd()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.zzfjy.lock();
        try {
            if (this.zzfmb == null) {
                this.zzfkm.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.zzfmb.zzd(t);
            return (T)string2;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        zzbp.zzb((t.zzafd() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzafi() != null ? t.zzafi().getName() : "the API";
        zzbp.zzb((boolean)this.zzfmh.containsKey(t.zzafd()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.zzfjy.lock();
        try {
            if (this.zzfmb == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzfmc) {
                this.zzfkm.add(t);
                while (!this.zzfkm.isEmpty()) {
                    object = this.zzfkm.remove();
                    this.zzfmn.zzb((zzs<? extends Result>)object);
                    ((zzm)object).zzs(Status.zzfhr);
                }
                object = t;
                return (T)object;
            }
            object = this.zzfmb.zze(t);
            return (T)object;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final <L> zzcj<L> zzp(@NonNull L l) {
        this.zzfjy.lock();
        try {
            Looper looper = this.zzakl;
            L l2 = l;
            zzcj<L> zzcj2 = this.zzfmj.zza(l2, looper, "NO_TYPE");
            return zzcj2;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    @NonNull
    public final <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.zzfmh.get(zzc2);
        zzbp.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public final boolean zza(@NonNull Api<?> api) {
        return this.zzfmh.containsKey(api.zzafd());
    }

    @Override
    public final boolean hasConnectedApi(@NonNull Api<?> api) {
        if (!((GoogleApiClient)this).isConnected()) {
            return false;
        }
        Api.zze zze2 = this.zzfmh.get(api.zzafd());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        block6: {
            ConnectionResult connectionResult;
            block7: {
                block8: {
                    this.zzfjy.lock();
                    if (!((GoogleApiClient)this).isConnected() && !this.zzfmc) {
                        throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
                    }
                    if (!this.zzfmh.containsKey(api.zzafd())) break block6;
                    connectionResult = this.zzfmb.getConnectionResult(api);
                    if (connectionResult != null) break block7;
                    if (!this.zzfmc) break block8;
                    ConnectionResult connectionResult2 = ConnectionResult.zzfez;
                    this.zzfjy.unlock();
                    return connectionResult2;
                }
                Log.w((String)"GoogleApiClientImpl", (String)this.zzahj());
                Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                return connectionResult3;
            }
            ConnectionResult connectionResult4 = connectionResult;
            this.zzfjy.unlock();
            return connectionResult4;
        }
        try {
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final void connect() {
        this.zzfjy.lock();
        try {
            if (this.zzfhd >= 0) {
                zzbp.zza((this.zzfml != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfml == null) {
                this.zzfml = zzbd.zza(this.zzfmh.values(), false);
            } else if (this.zzfml == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            ((GoogleApiClient)this).connect(this.zzfml);
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final void connect(int n) {
        this.zzfjy.lock();
        try {
            zzbp.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzbs(n);
            this.zzahf();
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        zzbp.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.zzfjy.lock();
        try {
            if (this.zzfhd >= 0) {
                zzbp.zza((this.zzfml != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzfml == null) {
                this.zzfml = zzbd.zza(this.zzfmh.values(), false);
            } else if (this.zzfml == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbs(this.zzfml);
            this.zzfma.zzakf();
            ConnectionResult connectionResult = this.zzfmb.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzbp.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzbp.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.zzfjy.lock();
        try {
            if (this.zzfml == null) {
                this.zzfml = zzbd.zza(this.zzfmh.values(), false);
            } else if (this.zzfml == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbs(this.zzfml);
            this.zzfma.zzakf();
            ConnectionResult connectionResult = this.zzfmb.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final void disconnect() {
        this.zzfjy.lock();
        try {
            this.zzfmn.release();
            if (this.zzfmb != null) {
                this.zzfmb.disconnect();
            }
            this.zzfmj.release();
            for (zzm zzm2 : this.zzfkm) {
                ((zzs)zzm2).zza((zzdl)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfkm.clear();
            if (this.zzfmb == null) {
                return;
            }
            this.zzahh();
            this.zzfma.zzake();
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final void reconnect() {
        ((GoogleApiClient)this).disconnect();
        ((GoogleApiClient)this).connect();
    }

    @Override
    public final PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzbp.zza((boolean)((GoogleApiClient)this).isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzbp.zza((this.zzfml != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        zzda zzda2 = new zzda(this);
        if (this.zzfmh.containsKey(zzbcj.zzdwq)) {
            this.zza(this, zzda2, false);
        } else {
            AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            zzbf zzbf2 = new zzbf(this, atomicReference, zzda2);
            zzbg zzbg2 = new zzbg(this, zzda2);
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzbcj.API).addConnectionCallbacks(zzbf2).addOnConnectionFailedListener(zzbg2).setHandler(this.zzfmf).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzda2;
    }

    private final void zza(GoogleApiClient googleApiClient, zzda zzda2, boolean bl) {
        zzbcj.zzfwb.zzd(googleApiClient).setResultCallback(new zzbh(this, zzda2, bl, googleApiClient));
    }

    @Override
    public final void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        zzcf zzcf2 = new zzcf((Activity)fragmentActivity);
        zzbd zzbd2 = this;
        if (zzbd2.zzfhd >= 0) {
            zzi.zza(zzcf2).zzbo(zzbd2.zzfhd);
            return;
        }
        throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
    }

    @Override
    public final boolean isConnected() {
        return this.zzfmb != null && this.zzfmb.isConnected();
    }

    @Override
    public final boolean isConnecting() {
        return this.zzfmb != null && this.zzfmb.isConnecting();
    }

    private final void zzbs(int n) {
        if (this.zzfml == null) {
            this.zzfml = n;
        } else if (this.zzfml != n) {
            String string2 = zzbd.zzbt(n);
            String string3 = zzbd.zzbt(this.zzfml);
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.zzfmb != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.zzfmh.values()) {
            if (zze2.zzaaa()) {
                bl = true;
            }
            if (!zze2.zzaak()) continue;
            bl2 = true;
        }
        switch (this.zzfml) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                if (this.zzfhj) {
                    this.zzfmb = new zzad(this.mContext, this.zzfjy, this.zzakl, this.zzfhf, this.zzfmh, this.zzfkd, this.zzfkg, this.zzfhg, this.zzfmk, this, true);
                    return;
                }
                this.zzfmb = zzy.zza(this.mContext, this, this.zzfjy, this.zzakl, this.zzfhf, this.zzfmh, this.zzfkd, this.zzfkg, this.zzfhg, this.zzfmk);
                return;
            }
        }
        if (this.zzfhj && !bl2) {
            this.zzfmb = new zzad(this.mContext, this.zzfjy, this.zzakl, this.zzfhf, this.zzfmh, this.zzfkd, this.zzfkg, this.zzfhg, this.zzfmk, this, false);
            return;
        }
        this.zzfmb = new zzbl(this.mContext, this, this.zzfjy, this.zzakl, this.zzfhf, this.zzfmh, this.zzfkd, this.zzfkg, this.zzfhg, this.zzfmk, this);
    }

    private final void zzahf() {
        this.zzfma.zzakf();
        this.zzfmb.connect();
    }

    private final void resume() {
        this.zzfjy.lock();
        try {
            if (this.zzfmc) {
                this.zzahf();
            }
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    private final void zzahg() {
        this.zzfjy.lock();
        try {
            if (this.zzahh()) {
                this.zzahf();
            }
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    final boolean zzahh() {
        if (!this.zzfmc) {
            return false;
        }
        this.zzfmc = false;
        this.zzfmf.removeMessages(2);
        this.zzfmf.removeMessages(1);
        if (this.zzfmg != null) {
            this.zzfmg.unregister();
            this.zzfmg = null;
        }
        return true;
    }

    @Override
    public final void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfma.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.zzfma.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public final void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.zzfma.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public final void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfma.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.zzfma.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public final void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.zzfma.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public final void zzi(Bundle bundle) {
        while (!this.zzfkm.isEmpty()) {
            ((GoogleApiClient)this).zze(this.zzfkm.remove());
        }
        this.zzfma.zzj(bundle);
    }

    @Override
    public final void zzc(ConnectionResult connectionResult) {
        if (!zze.zze((Context)this.mContext, (int)connectionResult.getErrorCode())) {
            this.zzahh();
        }
        if (!this.zzfmc) {
            this.zzfma.zzk(connectionResult);
            this.zzfma.zzake();
        }
    }

    @Override
    public final void zzf(int n, boolean bl) {
        if (n == 1 && !bl) {
            zzbd zzbd2 = this;
            if (!zzbd2.zzfmc) {
                zzbd2.zzfmc = true;
                if (zzbd2.zzfmg == null) {
                    zzbd2.zzfmg = GoogleApiAvailability.zza(zzbd2.mContext.getApplicationContext(), new zzbj(zzbd2));
                }
                zzbd2.zzfmf.sendMessageDelayed(zzbd2.zzfmf.obtainMessage(1), zzbd2.zzfmd);
                zzbd2.zzfmf.sendMessageDelayed(zzbd2.zzfmf.obtainMessage(2), zzbd2.zzfme);
            }
        }
        this.zzfmn.zzaiq();
        this.zzfma.zzcd(n);
        this.zzfma.zzake();
        if (n == 2) {
            this.zzahf();
        }
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.zzakl;
    }

    @Override
    public final boolean zza(zzcv zzcv2) {
        return this.zzfmb != null && this.zzfmb.zza(zzcv2);
    }

    @Override
    public final void zzafo() {
        if (this.zzfmb != null) {
            this.zzfmb.zzafo();
        }
    }

    @Override
    public final void zza(zzdf zzdf2) {
        this.zzfjy.lock();
        try {
            if (this.zzfmm == null) {
                this.zzfmm = new HashSet<zzdf>();
            }
            this.zzfmm.add(zzdf2);
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final void zzb(zzdf zzdf2) {
        this.zzfjy.lock();
        try {
            if (this.zzfmm == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzfmm.remove(zzdf2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzahi()) {
                this.zzfmb.zzagh();
            }
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    final boolean zzahi() {
        this.zzfjy.lock();
        try {
            if (this.zzfmm == null) {
                return false;
            }
            boolean bl = !this.zzfmm.isEmpty();
            return bl;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    final String zzahj() {
        StringWriter stringWriter = new StringWriter();
        ((GoogleApiClient)this).dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.zzfmc);
        printWriter.append(" mWorkQueue.size()=").print(this.zzfkm.size());
        PrintWriter printWriter2 = printWriter;
        zzdi zzdi2 = this.zzfmn;
        printWriter2.append(" mUnconsumedApiCalls.size()=").println(zzdi2.zzfpm.size());
        if (this.zzfmb != null) {
            this.zzfmb.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzaaa()) {
                bl2 = true;
            }
            if (!zze2.zzaak()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    private static String zzbt(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    static /* synthetic */ void zza(zzbd zzbd2) {
        zzbd2.resume();
    }

    static /* synthetic */ void zzb(zzbd zzbd2) {
        zzbd2.zzahg();
    }

    static /* synthetic */ void zza(zzbd zzbd2, GoogleApiClient googleApiClient, zzda zzda2, boolean bl) {
        zzbd2.zza(googleApiClient, zzda2, true);
    }

    static /* synthetic */ Context zzc(zzbd zzbd2) {
        return zzbd2.mContext;
    }
}

