/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzac;
import com.google.android.gms.common.api.internal.zzaf;
import com.google.android.gms.common.api.internal.zzag;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzdl;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbdq;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzad
implements zzcd {
    private final Map<Api.zzc<?>, zzac<?>> zzfke = new HashMap();
    private final Map<Api.zzc<?>, zzac<?>> zzfkf = new HashMap();
    private final Map<Api<?>, Boolean> zzfkg;
    private final zzbp zzfgp;
    private final zzbd zzfkh;
    private final Lock zzfjy;
    private final Looper zzakl;
    private final zze zzfki;
    private final Condition zzfkj;
    private final zzq zzfkd;
    private final boolean zzfkk;
    private final boolean zzfkl;
    private final Queue<zzm<?, ?>> zzfkm = new LinkedList();
    private boolean zzfkn;
    private Map<zzh<?>, ConnectionResult> zzfko;
    private Map<zzh<?>, ConnectionResult> zzfkp;
    private zzag zzfkq;
    private ConnectionResult zzfkr;

    public zzad(Context context, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcps, zzcpt> zza2, ArrayList<zzw> arrayList, zzbd zzbd2, boolean bl) {
        this.zzfjy = lock;
        this.zzakl = looper;
        this.zzfkj = lock.newCondition();
        this.zzfki = zze2;
        this.zzfkh = zzbd2;
        this.zzfkg = map2;
        this.zzfkd = zzq2;
        this.zzfkk = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.zzafd(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zzw> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList2.get(i);
            zzw zzw3 = zzw2;
            hashMap2.put(zzw3.zzfda, zzw3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze3 = entry.getValue();
            if (zze3.zzafe()) {
                bl4 = true;
                if (!this.zzfkg.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zzw zzw4 = (zzw)hashMap2.get(api);
            zzac zzac2 = new zzac(context, api, looper, zze3, zzw4, zzq2, zza2);
            this.zzfke.put(entry.getKey(), zzac2);
            if (!zze3.zzaaa()) continue;
            this.zzfkf.put(entry.getKey(), zzac2);
        }
        this.zzfkl = bl4 && !bl3 && !bl2;
        this.zzfgp = zzbp.zzahn();
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzfkk && this.zzg(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zzfkm.add(t);
            return t;
        }
        this.zzfkh.zzfmn.zzb(t);
        return this.zzfke.get(t.zzafd()).zza(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        Api.zzc<A> zzc2 = t.zzafd();
        if (this.zzfkk && this.zzg(t)) {
            return t;
        }
        this.zzfkh.zzfmn.zzb(t);
        return this.zzfke.get(zzc2).zzb(t);
    }

    private final <T extends zzm<? extends Result, ? extends Api.zzb>> boolean zzg(@NonNull T t) {
        Api.zzc<? extends Api.zzb> zzc2 = t.zzafd();
        ConnectionResult connectionResult = this.zzb(zzc2);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.zzs(new Status(4, null, this.zzfgp.zza(this.zzfke.get(zzc2).zzafj(), System.identityHashCode(this.zzfkh))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zzfjy.lock();
        try {
            if (this.zzfkn) {
                return;
            }
            this.zzfkn = true;
            this.zzfko = null;
            this.zzfkp = null;
            this.zzfkq = null;
            this.zzfkr = null;
            this.zzfgp.zzafv();
            this.zzfgp.zza(this.zzfke.values()).addOnCompleteListener((Executor)new zzbdq(this.zzakl), (OnCompleteListener)new zzaf(this, null));
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfkj.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfez;
        }
        if (this.zzfkr != null) {
            return this.zzfkr;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfkj.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfez;
        }
        if (this.zzfkr != null) {
            return this.zzfkr;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zzfjy.lock();
        try {
            this.zzfkn = false;
            this.zzfko = null;
            this.zzfkp = null;
            if (this.zzfkq != null) {
                this.zzfkq.cancel();
                this.zzfkq = null;
            }
            this.zzfkr = null;
            while (!this.zzfkm.isEmpty()) {
                zzm<?, ?> zzm2 = this.zzfkm.remove();
                ((zzs)zzm2).zza((zzdl)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfkj.signalAll();
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zzb(api.zzafd());
    }

    @Nullable
    private final ConnectionResult zzb(@NonNull Api.zzc<?> zzc2) {
        this.zzfjy.lock();
        try {
            zzac<?> zzac2 = this.zzfke.get(zzc2);
            if (this.zzfko != null && zzac2 != null) {
                ConnectionResult connectionResult = this.zzfko.get(zzac2.zzafj());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        this.zzfjy.lock();
        try {
            boolean bl = this.zzfko != null && this.zzfkr == null;
            return bl;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfjy.lock();
        try {
            boolean bl = this.zzfko == null && this.zzfkn;
            return bl;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    private final boolean zzagn() {
        this.zzfjy.lock();
        try {
            if (!this.zzfkn || !this.zzfkk) {
                return false;
            }
            for (Api.zzc<?> zzc2 : this.zzfkf.keySet()) {
                ConnectionResult connectionResult = this.zzb(zzc2);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final boolean zza(zzcv zzcv2) {
        this.zzfjy.lock();
        try {
            if (this.zzfkn && !this.zzagn()) {
                this.zzfgp.zzafv();
                this.zzfkq = new zzag(this, zzcv2);
                this.zzfgp.zza(this.zzfkf.values()).addOnCompleteListener((Executor)new zzbdq(this.zzakl), (OnCompleteListener)this.zzfkq);
                return true;
            }
            return false;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final void zzafo() {
        this.zzfjy.lock();
        try {
            this.zzfgp.zzafo();
            if (this.zzfkq != null) {
                this.zzfkq.cancel();
                this.zzfkq = null;
            }
            if (this.zzfkp == null) {
                this.zzfkp = new ArrayMap(this.zzfkf.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zzac<?> zzac2 : this.zzfkf.values()) {
                this.zzfkp.put(zzac2.zzafj(), connectionResult);
            }
            if (this.zzfko != null) {
                this.zzfko.putAll(this.zzfkp);
            }
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zzagh() {
    }

    private final void zzago() {
        if (this.zzfkd == null) {
            this.zzfkh.zzfmi = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzfkd.zzajr());
        Map<Api<?>, com.google.android.gms.common.internal.zzs> map = this.zzfkd.zzajt();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).zzecn);
        }
        this.zzfkh.zzfmi = hashSet;
    }

    private final void zzagp() {
        while (!this.zzfkm.isEmpty()) {
            this.zze(this.zzfkm.remove());
        }
        this.zzfkh.zzi(null);
    }

    private final boolean zza(zzac<?> zzac2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zzfkg.get(zzac2.zzafi()) != false && zzac2.zzagm().zzafe() && this.zzfki.isUserResolvableError(connectionResult.getErrorCode());
    }

    @Nullable
    private final ConnectionResult zzagq() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zzac<?> zzac2 : this.zzfke.values()) {
            int n3;
            Api api = zzac2.zzafi();
            zzh zzh2 = zzac2.zzafj();
            ConnectionResult connectionResult3 = this.zzfko.get(zzh2);
            if (connectionResult3.isSuccess() || this.zzfkg.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zzfki.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zzfkk) {
                n3 = api.zzafb().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zzafb().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zza(zzad zzad2) {
        return zzad2.zzfjy;
    }

    static /* synthetic */ boolean zzb(zzad zzad2) {
        return zzad2.zzfkn;
    }

    static /* synthetic */ Map zza(zzad zzad2, Map map) {
        zzad2.zzfko = map;
        return zzad2.zzfko;
    }

    static /* synthetic */ Map zzc(zzad zzad2) {
        return zzad2.zzfke;
    }

    static /* synthetic */ Map zzd(zzad zzad2) {
        return zzad2.zzfko;
    }

    static /* synthetic */ boolean zze(zzad zzad2) {
        return zzad2.zzfkl;
    }

    static /* synthetic */ boolean zza(zzad zzad2, zzac zzac2, ConnectionResult connectionResult) {
        return zzad2.zza(zzac2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zza(zzad zzad2, ConnectionResult connectionResult) {
        zzad2.zzfkr = connectionResult;
        return zzad2.zzfkr;
    }

    static /* synthetic */ ConnectionResult zzf(zzad zzad2) {
        return zzad2.zzagq();
    }

    static /* synthetic */ Map zzg(zzad zzad2) {
        return zzad2.zzfkp;
    }

    static /* synthetic */ ConnectionResult zzh(zzad zzad2) {
        return zzad2.zzfkr;
    }

    static /* synthetic */ void zzi(zzad zzad2) {
        zzad2.zzago();
    }

    static /* synthetic */ void zzj(zzad zzad2) {
        zzad2.zzagp();
    }

    static /* synthetic */ boolean zza(zzad zzad2, boolean bl) {
        zzad2.zzfkn = false;
        return false;
    }

    static /* synthetic */ zzbd zzk(zzad zzad2) {
        return zzad2.zzfkh;
    }

    static /* synthetic */ Condition zzl(zzad zzad2) {
        return zzad2.zzfkj;
    }

    static /* synthetic */ Map zzb(zzad zzad2, Map map) {
        zzad2.zzfkp = map;
        return zzad2.zzfkp;
    }

    static /* synthetic */ Map zzm(zzad zzad2) {
        return zzad2.zzfkf;
    }
}

