/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.zzcg;
import com.google.android.gms.common.api.internal.zzp;
import com.google.android.gms.common.api.internal.zzq;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzo
extends LifecycleCallback
implements DialogInterface.OnCancelListener {
    protected volatile boolean mStarted;
    protected final AtomicReference<zzp> zzfiq = new AtomicReference<Object>(null);
    private final Handler zzfir = new Handler(Looper.getMainLooper());
    protected final GoogleApiAvailability zzfhf;

    protected zzo(zzcg zzcg2) {
        this(zzcg2, GoogleApiAvailability.getInstance());
    }

    private zzo(zzcg zzcg2, GoogleApiAvailability googleApiAvailability) {
        super(zzcg2);
        this.zzfhf = googleApiAvailability;
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(new ConnectionResult(13, null), zzo.zza(this.zzfiq.get()));
        this.zzaga();
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (bundle != null) {
            zzp zzp2;
            Bundle bundle2 = bundle;
            if (bundle2.getBoolean("resolving_error", false)) {
                ConnectionResult connectionResult = new ConnectionResult(bundle2.getInt("failed_status"), (PendingIntent)bundle2.getParcelable("failed_resolution"));
                int n = bundle2.getInt("failed_client_id", -1);
                zzp2 = new zzp(connectionResult, n);
            } else {
                zzp2 = null;
            }
            this.zzfiq.set(zzp2);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        Bundle bundle2 = bundle;
        zzp zzp2 = this.zzfiq.get();
        if (zzp2 != null) {
            bundle2.putBoolean("resolving_error", true);
            bundle2.putInt("failed_client_id", zzp2.zzagb());
            bundle2.putInt("failed_status", zzp2.zzagc().getErrorCode());
            bundle2.putParcelable("failed_resolution", (Parcelable)zzp2.zzagc().getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        boolean bl = false;
        zzp zzp2 = this.zzfiq.get();
        switch (n) {
            case 2: {
                int n3 = this.zzfhf.isGooglePlayServicesAvailable((Context)this.getActivity());
                if (n3 == 0) {
                    bl = true;
                }
                if (zzp2 == null) {
                    return;
                }
                if (zzp2.zzagc().getErrorCode() != 18 || n3 != 18) break;
                return;
            }
            case 1: {
                if (n2 == -1) {
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                int n4 = 13;
                if (intent != null) {
                    n4 = intent.getIntExtra("<<ResolutionFailureErrorDetail>>", 13);
                }
                zzp2 = new zzp(new ConnectionResult(n4, null), zzo.zza(zzp2));
                this.zzfiq.set(zzp2);
            }
        }
        if (bl) {
            this.zzaga();
            return;
        }
        if (zzp2 != null) {
            this.zza(zzp2.zzagc(), zzp2.zzagb());
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
    }

    protected abstract void zza(ConnectionResult var1, int var2);

    protected abstract void zzafv();

    protected final void zzaga() {
        this.zzfiq.set(null);
        this.zzafv();
    }

    public final void zzb(ConnectionResult connectionResult, int n) {
        zzp zzp2 = new zzp(connectionResult, n);
        if (this.zzfiq.compareAndSet(null, zzp2)) {
            this.zzfir.post((Runnable)new zzq(this, zzp2));
        }
    }

    private static int zza(@Nullable zzp zzp2) {
        if (zzp2 == null) {
            return -1;
        }
        return zzp2.zzagb();
    }
}

