/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaae;
import com.google.android.gms.internal.zzabd;
import com.google.android.gms.internal.zzabe;
import com.google.android.gms.internal.zzabf;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzaaa
extends zzaae {
    private final SparseArray<zza> zzazN = new SparseArray();

    public static zzaaa zza(zzabd zzabd2) {
        zzabf zzabf2 = zzaaa.zzc((zzabd)zzabd2);
        zzaaa zzaaa2 = (zzaaa)zzabf2.zza("AutoManageHelper", zzaaa.class);
        if (zzaaa2 != null) {
            return zzaaa2;
        }
        return new zzaaa(zzabf2);
    }

    private zzaaa(zzabf zzabf2) {
        super(zzabf2);
        this.zzaCR.zza("AutoManageHelper", (zzabe)this);
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzac.zzb((Object)googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzac.zza((this.zzazN.indexOfKey(n) < 0 ? 1 : 0) != 0, (Object)new StringBuilder(54).append("Already managing a GoogleApiClient with id ").append(n).toString());
        boolean bl = this.mStarted;
        boolean bl2 = this.zzazZ;
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(54).append("starting AutoManage for client ").append(n).append(" ").append(bl).append(" ").append(bl2).toString());
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.zzazN.put(n, (Object)zza2);
        if (this.mStarted && !this.zzazZ) {
            String string2 = String.valueOf(googleApiClient);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(11 + String.valueOf(string2).length()).append("connecting ").append(string2).toString());
            googleApiClient.connect();
        }
    }

    public void zzcA(int n) {
        zza zza2 = (zza)this.zzazN.get(n);
        this.zzazN.remove(n);
        if (zza2 != null) {
            zza2.zzvy();
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        int n = this.mStarted;
        Object object = String.valueOf(this.zzazN);
        Log.d((String)"AutoManageHelper", (String)new StringBuilder(14 + String.valueOf(object).length()).append("onStart ").append(n != 0).append(" ").append((String)object).toString());
        if (!this.zzazZ) {
            for (n = 0; n < this.zzazN.size(); ++n) {
                object = (zza)this.zzazN.valueAt(n);
                ((zza)object).zzazP.connect();
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        for (int i = 0; i < this.zzazN.size(); ++i) {
            zza zza2 = (zza)this.zzazN.valueAt(i);
            zza2.zzazP.disconnect();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        for (int i = 0; i < this.zzazN.size(); ++i) {
            zza zza2 = (zza)this.zzazN.valueAt(i);
            zza2.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    protected void zza(ConnectionResult connectionResult, int n) {
        Log.w((String)"AutoManageHelper", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        if (n < 0) {
            Log.wtf((String)"AutoManageHelper", (String)"AutoManageLifecycleHelper received onErrorResolutionFailed callback but no failing client ID is set", (Throwable)new Exception());
            return;
        }
        zza zza2 = (zza)this.zzazN.get(n);
        if (zza2 != null) {
            this.zzcA(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzazQ;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    @Override
    protected void zzvx() {
        for (int i = 0; i < this.zzazN.size(); ++i) {
            zza zza2 = (zza)this.zzazN.valueAt(i);
            zza2.zzazP.connect();
        }
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzazO;
        public final GoogleApiClient zzazP;
        public final GoogleApiClient.OnConnectionFailedListener zzazQ;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzazO = n;
            this.zzazP = googleApiClient;
            this.zzazQ = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            String string2 = String.valueOf(connectionResult);
            Log.d((String)"AutoManageHelper", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("beginFailureResolution for ").append(string2).toString());
            zzaaa.this.zzb(connectionResult, this.zzazO);
        }

        public void zzvy() {
            this.zzazP.unregisterConnectionFailedListener(this);
            this.zzazP.disconnect();
        }

        public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            printWriter.append(string2).append("GoogleApiClient #").print(this.zzazO);
            printWriter.println(":");
            this.zzazP.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        }
    }
}

