/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;

public final class zzacb
extends Drawable
implements Drawable.Callback {
    private int zzaED = 0;
    private long zzafe;
    private int mFrom;
    private int zzaEE;
    private int zzaEF = 255;
    private int zzaEG;
    private int zzaEH = 0;
    private boolean zzaEy = true;
    private boolean zzaEI;
    private zzb zzaEJ;
    private Drawable zzaEK;
    private Drawable zzaEL;
    private boolean zzaEM;
    private boolean zzaEN;
    private boolean zzaEO;
    private int zzaEP;

    public zzacb(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = zza.zzaEQ;
        }
        this.zzaEK = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.zzaEJ.zzaES |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = zza.zzaEQ;
        }
        this.zzaEL = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.zzaEJ.zzaES |= drawable3.getChangingConfigurations();
    }

    zzacb(zzb zzb2) {
        this.zzaEJ = new zzb(zzb2);
    }

    public void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, runnable, l);
        }
    }

    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, runnable);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.zzaEJ.mChangingConfigurations | this.zzaEJ.zzaES;
    }

    public void setAlpha(int n) {
        if (this.zzaEH == this.zzaEF) {
            this.zzaEH = n;
        }
        this.zzaEF = n;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzaEK.setColorFilter(colorFilter);
        this.zzaEL.setColorFilter(colorFilter);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.zzaEK.getIntrinsicWidth(), this.zzaEL.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.zzaEK.getIntrinsicHeight(), this.zzaEL.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect rect) {
        this.zzaEK.setBounds(rect);
        this.zzaEL.setBounds(rect);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.zzaEJ.mChangingConfigurations = this.getChangingConfigurations();
            return this.zzaEJ;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.zzaEO) {
            this.zzaEP = Drawable.resolveOpacity((int)this.zzaEK.getOpacity(), (int)this.zzaEL.getOpacity());
            this.zzaEO = true;
        }
        return this.zzaEP;
    }

    public boolean canConstantState() {
        if (!this.zzaEM) {
            this.zzaEN = this.zzaEK.getConstantState() != null && this.zzaEL.getConstantState() != null;
            this.zzaEM = true;
        }
        return this.zzaEN;
    }

    public Drawable mutate() {
        if (!this.zzaEI && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.zzaEK.mutate();
            this.zzaEL.mutate();
            this.zzaEI = true;
        }
        return this;
    }

    public Drawable zzxs() {
        return this.zzaEL;
    }

    public void startTransition(int n) {
        this.mFrom = 0;
        this.zzaEE = this.zzaEF;
        this.zzaEH = 0;
        this.zzaEG = n;
        this.zzaED = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl = true;
        switch (this.zzaED) {
            case 1: {
                this.zzafe = SystemClock.uptimeMillis();
                bl = false;
                this.zzaED = 2;
                break;
            }
            case 2: {
                if (this.zzafe < 0L) break;
                float f = (float)(SystemClock.uptimeMillis() - this.zzafe) / (float)this.zzaEG;
                boolean bl2 = bl = f >= 1.0f;
                if (bl) {
                    this.zzaED = 0;
                }
                f = Math.min(f, 1.0f);
                this.zzaEH = (int)(0.0f + (float)(this.zzaEE - 0) * f);
            }
        }
        int n = this.zzaEH;
        boolean bl3 = this.zzaEy;
        Drawable drawable2 = this.zzaEK;
        Drawable drawable3 = this.zzaEL;
        if (bl) {
            if (!bl3 || n == 0) {
                drawable2.draw(canvas);
            }
            if (n == this.zzaEF) {
                drawable3.setAlpha(this.zzaEF);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl3) {
            drawable2.setAlpha(this.zzaEF - n);
        }
        drawable2.draw(canvas);
        if (bl3) {
            drawable2.setAlpha(this.zzaEF);
        }
        if (n > 0) {
            drawable3.setAlpha(n);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.zzaEF);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.zzacb$zza
    extends Drawable {
        private static final com.google.android.gms.internal.zzacb$zza zzaEQ = new com.google.android.gms.internal.zzacb$zza();
        private static final zza zzaER = new zza();

        private com.google.android.gms.internal.zzacb$zza() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int n) {
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return zzaER;
        }

        private static final class zza
        extends Drawable.ConstantState {
            private zza() {
            }

            public Drawable newDrawable() {
                return zzaEQ;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class zzb
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        int zzaES;

        zzb(zzb zzb2) {
            if (zzb2 != null) {
                this.mChangingConfigurations = zzb2.mChangingConfigurations;
                this.zzaES = zzb2.zzaES;
            }
        }

        public Drawable newDrawable() {
            return new zzacb(this);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

