/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzac;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzm
implements Handler.Callback {
    private final zza zzaFU;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zzaFV = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> zzaFW = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zzaFX = new ArrayList();
    private volatile boolean zzaFY = false;
    private final AtomicInteger zzaFZ = new AtomicInteger(0);
    private boolean zzaGa = false;
    private final Handler mHandler;
    private final Object zzrJ = new Object();

    public zzm(Looper looper, zza zza2) {
        this.zzaFU = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public void zzxX() {
        this.zzaFY = false;
        this.zzaFZ.incrementAndGet();
    }

    public void zzxY() {
        this.zzaFY = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzq(Bundle bundle) {
        zzac.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zzrJ;
        synchronized (object) {
            zzac.zzaw((!this.zzaGa ? 1 : 0) != 0);
            this.mHandler.removeMessages(1);
            this.zzaGa = true;
            zzac.zzaw((this.zzaFW.size() == 0 ? 1 : 0) != 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzaFV);
            int n = this.zzaFZ.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzaFY || !this.zzaFU.isConnected() || this.zzaFZ.get() != n) break;
                if (this.zzaFW.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.zzaFW.clear();
            this.zzaGa = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcV(int n) {
        zzac.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzaGa = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzaFV);
            int n2 = this.zzaFZ.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzaFY || this.zzaFZ.get() != n2) break;
                if (!this.zzaFV.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.zzaFW.clear();
            this.zzaGa = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzn(ConnectionResult connectionResult) {
        zzac.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzrJ;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zzaFX);
            int n = this.zzaFZ.get();
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList) {
                if (!this.zzaFY || this.zzaFZ.get() != n) {
                    return;
                }
                if (!this.zzaFX.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzac.zzw((Object)connectionCallbacks);
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzaFV.contains(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(62 + String.valueOf(string2).length()).append("registerConnectionCallbacks(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zzaFV.add(connectionCallbacks);
            }
        }
        if (this.zzaFU.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)connectionCallbacks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzac.zzw((Object)connectionCallbacks);
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaFV.contains(connectionCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzac.zzw((Object)connectionCallbacks);
        Object object = this.zzrJ;
        synchronized (object) {
            boolean bl = this.zzaFV.remove(connectionCallbacks);
            if (!bl) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(52 + String.valueOf(string2).length()).append("unregisterConnectionCallbacks(): listener ").append(string2).append(" not found").toString());
            } else if (this.zzaGa) {
                this.zzaFW.add(connectionCallbacks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzac.zzw((Object)onConnectionFailedListener);
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.zzaFX.contains(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(67 + String.valueOf(string2).length()).append("registerConnectionFailedListener(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.zzaFX.add(onConnectionFailedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzac.zzw((Object)onConnectionFailedListener);
        Object object = this.zzrJ;
        synchronized (object) {
            return this.zzaFX.contains(onConnectionFailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzac.zzw((Object)onConnectionFailedListener);
        Object object = this.zzrJ;
        synchronized (object) {
            boolean bl = this.zzaFX.remove(onConnectionFailedListener);
            if (!bl) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(57 + String.valueOf(string2).length()).append("unregisterConnectionFailedListener(): listener ").append(string2).append(" not found").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        if (message.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)message.obj;
            Object object = this.zzrJ;
            synchronized (object) {
                if (this.zzaFY && this.zzaFU.isConnected() && this.zzaFV.contains(connectionCallbacks)) {
                    Bundle bundle = this.zzaFU.zzuC();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        int n = message.what;
        Log.wtf((String)"GmsClientEvents", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        return false;
    }

    public static interface zza {
        public boolean isConnected();

        public Bundle zzuC();
    }
}

