/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.HttpUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzaw;
import com.google.android.gms.internal.gtm.zzbr;
import com.google.android.gms.internal.gtm.zzfb;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@VisibleForTesting
public final class zzfs {
    public static long zza(String string) {
        if (string == null) {
            return 0L;
        }
        try {
            long l = Long.parseLong(string);
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static zzaw zzb(zzfb object, String object2) {
        Preconditions.checkNotNull((Object)object);
        if (TextUtils.isEmpty((CharSequence)object2)) {
            return null;
        }
        new HashMap();
        try {
            String string = "?";
            object2 = String.valueOf(object2);
            int n = ((String)object2).length();
            object2 = n != 0 ? string.concat((String)object2) : new String(string);
            URI uRI = new URI((String)object2);
            object2 = HttpUtils.parse((URI)uRI, (String)"UTF-8");
            object = new zzaw();
            ((zzaw)object).zzp((String)object2.get("utm_content"));
            ((zzaw)object).zzu((String)object2.get("utm_medium"));
            ((zzaw)object).zzv((String)object2.get("utm_campaign"));
            ((zzaw)object).zzw((String)object2.get("utm_source"));
            ((zzaw)object).zzt((String)object2.get("utm_term"));
            ((zzaw)object).zzs((String)object2.get("utm_id"));
            ((zzaw)object).zzo((String)object2.get("anid"));
            ((zzaw)object).zzr((String)object2.get("gclid"));
            ((zzaw)object).zzq((String)object2.get("dclid"));
            ((zzaw)object).zzn((String)object2.get("aclid"));
            return object;
        }
        catch (URISyntaxException uRISyntaxException) {
            ((zzbr)object).zzS("No valid campaign data found", uRISyntaxException);
            return null;
        }
    }

    public static String zzc(boolean bl) {
        if (!bl) {
            return "0";
        }
        return "1";
    }

    public static String zzd(Locale locale) {
        if (locale == null) {
            return null;
        }
        String string = locale.getLanguage();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.toLowerCase(locale));
        if (!TextUtils.isEmpty((CharSequence)locale.getCountry())) {
            stringBuilder.append("-");
            stringBuilder.append(locale.getCountry().toLowerCase(locale));
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MessageDigest zze(String string) {
        String string2 = "MD5";
        int n = 0;
        while (n < 2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string2);
                if (messageDigest != null) {
                    return messageDigest;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            ++n;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Map<String, String> zzf(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray2 = stringArray[n2].split("=", 3);
            int n3 = stringArray2.length;
            if (n3 > 1) {
                String string2 = stringArray2[0];
                String string3 = TextUtils.isEmpty((CharSequence)stringArray2[1]) ? null : stringArray2[1];
                hashMap.put(string2, string3);
                if (n3 == 3 && !TextUtils.isEmpty((CharSequence)stringArray2[1]) && !hashMap.containsKey(stringArray2[1])) {
                    String string4 = stringArray2[1];
                    string3 = TextUtils.isEmpty((CharSequence)stringArray2[2]) ? null : stringArray2[2];
                    hashMap.put(string4, string3);
                }
            } else if (n3 == 1 && stringArray2[0].length() != 0) {
                hashMap.put(stringArray2[0], null);
            }
            ++n2;
        }
        return hashMap;
    }

    public static void zzg(Map<String, String> map, String string, String string2) {
        if (string2 != null && !map.containsKey(string)) {
            map.put(string, string2);
            return;
        }
    }

    public static void zzh(Map<String, String> map, String string, Map<String, String> map2) {
        zzfs.zzg(map, string, map2.get(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean zzi(Context context, String string, boolean bl) {
        block5: {
            try {
                PackageManager packageManager = context.getPackageManager();
                ComponentName componentName = new ComponentName(context, string);
                context = packageManager.getReceiverInfo(componentName, 0);
                if (context == null) break block5;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
            boolean bl2 = context.enabled;
            if (!bl2) break block5;
            if (!bl) return true;
            boolean bl3 = context.exported;
            if (!bl3) break block5;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean zzj(double d, String string) {
        int n;
        if (d <= 0.0 || d >= 100.0) {
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            int n2 = 0;
            for (int i = string.length() + -1; i >= 0; --i) {
                int n3 = string.charAt(i);
                n2 = (n2 << 6 & 0xFFFFFFF) + n3 + (n3 << 14);
                n3 = n2 >> 21;
                if ((n2 & 0xFE00000) == 0) continue;
                n2 ^= n3 & 0x7F;
            }
            n = n2;
            return (double)(n % 10000) >= d * 100.0;
        }
        n = 1;
        return (double)(n % 10000) >= d * 100.0;
    }
}

