/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.gtm;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import com.google.android.gms.analytics.zzr;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzbj;
import com.google.android.gms.internal.gtm.zzbq;
import com.google.android.gms.internal.gtm.zzbr;
import com.google.android.gms.internal.gtm.zzbv;

final class zzfc
extends BroadcastReceiver {
    @VisibleForTesting
    static final String zza = zzfc.class.getName();
    private final zzbv zzb;
    private boolean zzc;
    private boolean zzd;

    zzfc(zzbv zzbv2) {
        Preconditions.checkNotNull((Object)zzbv2);
        this.zzb = zzbv2;
    }

    public final void onReceive(Context object, Intent object2) {
        Object object3;
        ((zzfc)((Object)object3)).zzb.zzm();
        ((zzfc)((Object)object3)).zzb.zzf();
        object = object2.getAction();
        ((zzfc)((Object)object3)).zzb.zzm().zzP("NetworkBroadcastReceiver received action", object);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(object)) {
            boolean bl = ((zzfc)((Object)object3)).zze();
            if (((zzfc)((Object)object3)).zzd != bl) {
                ((zzfc)((Object)object3)).zzd = bl;
                object3 = ((zzfc)((Object)object3)).zzb.zzf();
                ((zzbr)object3).zzP("Network connectivity status changed", bl);
                object2 = ((zzbr)object3).zzq();
                zzbj zzbj2 = new zzbj((zzbq)object3, bl);
                ((zzr)object2).zzi(zzbj2);
                return;
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(object)) {
            if (!object2.hasExtra(zza)) {
                object3 = ((zzfc)((Object)object3)).zzb.zzf();
                ((zzbr)object3).zzO("Radio powered up");
                ((zzbq)object3).zzc();
                return;
            }
            return;
        }
        ((zzfc)((Object)object3)).zzb.zzm().zzS("NetworkBroadcastReceiver received unknown action", object);
    }

    public final void zza() {
        this.zzb.zzm();
        this.zzb.zzf();
        if (this.zzc) {
            return;
        }
        Context context = this.zzb.zza();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        intentFilter = new IntentFilter("com.google.analytics.RADIO_POWERED");
        intentFilter.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        this.zzd = this.zze();
        this.zzb.zzm().zzP("Registering connectivity change receiver. Network connected", this.zzd);
        this.zzc = true;
    }

    @VisibleForTesting
    public final void zzb() {
        zzfc zzfc2 = zzfc2.zzb.zza();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(zzfc2.getPackageName());
        intent.putExtra(zza, true);
        zzfc2.sendOrderedBroadcast(intent, null);
    }

    public final void zzc() {
        if (!this.zzc) {
            return;
        }
        this.zzb.zzm().zzO("Unregistering connectivity change receiver");
        this.zzc = false;
        this.zzd = false;
        Context context = this.zzb.zza();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzb.zzm().zzK("Failed to unregister the network broadcast receiver", illegalArgumentException);
            return;
        }
    }

    public final boolean zzd() {
        if (!this.zzc) {
            this.zzb.zzm().zzR("Connectivity unknown. Receiver not registered");
        }
        return this.zzd;
    }

    @VisibleForTesting
    protected final boolean zze() {
        block3: {
            zzfc zzfc2 = (ConnectivityManager)zzfc2.zzb.zza().getSystemService("connectivity");
            try {
                zzfc2 = zzfc2.getActiveNetworkInfo();
                if (zzfc2 == null) break block3;
            }
            catch (SecurityException securityException) {
                return false;
            }
            boolean bl = zzfc2.isConnected();
            if (!bl) break block3;
            return true;
        }
        return false;
    }
}

