/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.zzd;
import com.google.android.gms.analytics.zzh;
import com.google.android.gms.analytics.zzt;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.gtm.zzav;
import com.google.android.gms.internal.gtm.zzaw;
import com.google.android.gms.internal.gtm.zzax;
import com.google.android.gms.internal.gtm.zzay;
import com.google.android.gms.internal.gtm.zzaz;
import com.google.android.gms.internal.gtm.zzba;
import com.google.android.gms.internal.gtm.zzbb;
import com.google.android.gms.internal.gtm.zzbc;
import com.google.android.gms.internal.gtm.zzbd;
import com.google.android.gms.internal.gtm.zzbe;
import com.google.android.gms.internal.gtm.zzbf;
import com.google.android.gms.internal.gtm.zzbg;
import com.google.android.gms.internal.gtm.zzbh;
import com.google.android.gms.internal.gtm.zzbr;
import com.google.android.gms.internal.gtm.zzbt;
import com.google.android.gms.internal.gtm.zzbv;
import com.google.android.gms.internal.gtm.zzbx;
import com.google.android.gms.internal.gtm.zzex;
import com.google.android.gms.internal.gtm.zzfs;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzb
extends zzbr
implements zzt {
    private static DecimalFormat zza;
    private final zzbv zzb;
    private final String zzc;
    private final Uri zzd;

    static Uri zza(String string) {
        Preconditions.checkNotEmpty((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public final Uri zzb() {
        return this.zzd;
    }

    static String zzc(double d) {
        if (zza == null) {
            DecimalFormat decimalFormat;
            zza = decimalFormat = new DecimalFormat("0.######");
        }
        return zza.format(d);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    public static Map<String, String> zzd(zzh object) {
        zzba zzba2;
        Object object2;
        Map.Entry<Integer, Double> entry2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object object3 = ((zzh)object).zzc(zzaz.class);
        if (object3 != null) {
            entry2 = ((zzaz)object3).zzd().entrySet().iterator();
            while (entry2.hasNext()) {
                object2 = entry2.next();
                object3 = object2.getValue();
                if (object3 == null) {
                    object3 = null;
                } else if (object3 instanceof String) {
                    if (TextUtils.isEmpty((CharSequence)(object3 = (String)object3))) {
                        object3 = null;
                    }
                } else {
                    object3 = object3 instanceof Double ? ((Double)(object3 = (Double)object3) != 0.0 ? com.google.android.gms.analytics.zzb.zzc((Double)object3) : null) : (object3 instanceof Boolean ? (object3 != Boolean.FALSE ? "1" : null) : String.valueOf(object3));
                }
                if (object3 == null) continue;
                hashMap.put(object2.getKey(), (String)object3);
            }
        }
        if ((object3 = ((zzh)object).zzc(zzbe.class)) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "t", ((zzbe)object3).zzf());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "cid", ((zzbe)object3).zze());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "uid", ((zzbe)object3).zzg());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "sc", null);
            com.google.android.gms.analytics.zzb.zzg(hashMap, "ni", ((zzbe)object3).zzo());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "adid", ((zzbe)object3).zzd());
            com.google.android.gms.analytics.zzb.zzg(hashMap, "ate", ((zzbe)object3).zzn());
        }
        if ((object3 = ((zzh)object).zzc(zzbf.class)) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "cd", null);
            double d = ((zzbf)object3).zzd();
            if (d != 0.0) {
                hashMap.put("a", com.google.android.gms.analytics.zzb.zzc(d));
            }
            com.google.android.gms.analytics.zzb.zzf(hashMap, "dr", null);
        }
        if (((zzh)object).zzc(zzbc.class) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "ec", null);
            com.google.android.gms.analytics.zzb.zzf(hashMap, "ea", null);
            com.google.android.gms.analytics.zzb.zzf(hashMap, "el", null);
        }
        if ((object3 = ((zzh)object).zzc(zzaw.class)) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "cn", ((zzaw)object3).zzl());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "cs", ((zzaw)object3).zzm());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "cm", ((zzaw)object3).zzk());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "ck", ((zzaw)object3).zzj());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "cc", ((zzaw)object3).zzf());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "ci", ((zzaw)object3).zzi());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "anid", ((zzaw)object3).zze());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "gclid", ((zzaw)object3).zzh());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "dclid", ((zzaw)object3).zzg());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "aclid", ((zzaw)object3).zzd());
        }
        if (((zzh)object).zzc(zzbd.class) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "exd", null);
        }
        if (((zzh)object).zzc(zzbg.class) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "sn", null);
            com.google.android.gms.analytics.zzb.zzf(hashMap, "sa", null);
            com.google.android.gms.analytics.zzb.zzf(hashMap, "st", null);
        }
        if (((zzh)object).zzc(zzbh.class) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "utv", null);
            com.google.android.gms.analytics.zzb.zzf(hashMap, "utc", null);
            com.google.android.gms.analytics.zzb.zzf(hashMap, "utl", null);
        }
        if ((object3 = ((zzh)object).zzc(zzax.class)) != null) {
            object3 = ((zzax)object3).zzd().entrySet().iterator();
            while (object3.hasNext()) {
                entry2 = (Map.Entry)object3.next();
                object2 = com.google.android.gms.analytics.zzd.zzb((Integer)entry2.getKey());
                if (TextUtils.isEmpty(object2)) continue;
                hashMap.put((String)object2, (String)((Object)entry2.getValue()));
            }
        }
        if ((object3 = ((zzh)object).zzc(zzay.class)) != null) {
            for (Map.Entry<Integer, Double> entry2 : ((zzay)object3).zzd().entrySet()) {
                object2 = com.google.android.gms.analytics.zzd.zze(entry2.getKey());
                if (TextUtils.isEmpty((CharSequence)object2)) continue;
                hashMap.put((String)object2, com.google.android.gms.analytics.zzb.zzc(entry2.getValue()));
            }
        }
        if ((entry2 = ((zzh)object).zzc(zzbb.class)) != null) {
            object2 = ((zzbb)((Object)entry2)).zze().iterator();
            int n = 1;
            while (object2.hasNext()) {
                hashMap.putAll(((Promotion)object2.next()).zza(com.google.android.gms.analytics.zzd.zzm(n)));
                ++n;
            }
            object2 = ((zzbb)((Object)entry2)).zzd().iterator();
            n = 1;
            while (object2.hasNext()) {
                hashMap.putAll(object2.next().zza(com.google.android.gms.analytics.zzd.zzk(n)));
                ++n;
            }
            Iterator<Map.Entry<String, List<Product>>> iterator = ((zzbb)((Object)entry2)).zzf().entrySet().iterator();
            n = 1;
            while (iterator.hasNext()) {
                Map.Entry<String, List<Product>> entry3 = iterator.next();
                entry2 = entry3.getValue();
                entry2 = (List)((Object)entry2);
                String string = com.google.android.gms.analytics.zzd.zzh(n);
                Iterator iterator2 = entry2.iterator();
                int n2 = 1;
                while (iterator2.hasNext()) {
                    Product product = (Product)iterator2.next();
                    object2 = String.valueOf(string);
                    String string2 = String.valueOf(com.google.android.gms.analytics.zzd.zzi(n2));
                    if (string2.length() != 0) {
                        object2 = ((String)object2).concat(string2);
                    } else {
                        string2 = new String((String)object2);
                        object2 = string2;
                    }
                    hashMap.putAll(product.zza((String)object2));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry3.getKey())) {
                    hashMap.put(String.valueOf(string).concat("nm"), entry3.getKey());
                }
                ++n;
            }
        }
        if ((zzba2 = ((zzh)object).zzc(zzba.class)) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "ul", zzba2.zzd());
            int n = zzba2.zza;
            int n3 = zzba2.zzb;
            if (n > 0 && n3 > 0) {
                object2 = new StringBuilder(23);
                ((StringBuilder)object2).append(n);
                ((StringBuilder)object2).append("x");
                ((StringBuilder)object2).append(n3);
                hashMap.put("sr", ((StringBuilder)object2).toString());
            }
        }
        if ((object = ((zzh)object).zzc(zzav.class)) != null) {
            com.google.android.gms.analytics.zzb.zzf(hashMap, "an", ((zzav)object).zzf());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "aid", ((zzav)object).zzd());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "aiid", ((zzav)object).zze());
            com.google.android.gms.analytics.zzb.zzf(hashMap, "av", ((zzav)object).zzg());
        }
        return hashMap;
    }

    public zzb(zzbv zzbv2, String string) {
        super(zzbv2);
        Preconditions.checkNotEmpty((String)string);
        this.zzb = zzbv2;
        this.zzc = string;
        this.zzd = com.google.android.gms.analytics.zzb.zza(this.zzc);
    }

    private static void zzf(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
            return;
        }
    }

    private static void zzg(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
            return;
        }
    }

    @Override
    public final void zze(zzh object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkArgument((boolean)((zzh)object).zzm(), (Object)"Can't deliver not submitted measurement");
        Preconditions.checkNotMainThread((String)"deliver should be called on worker thread");
        Iterator<Map.Entry<String, String>> iterator = new Iterator<Map.Entry<String, String>>((zzh)object);
        zzbe object22 = ((zzh)((Object)iterator)).zzb(zzbe.class);
        if (TextUtils.isEmpty((CharSequence)object22.zzf())) {
            this.zzz().zzc(com.google.android.gms.analytics.zzb.zzd((zzh)((Object)iterator)), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)object22.zze())) {
            this.zzz().zzc(com.google.android.gms.analytics.zzb.zzd((zzh)((Object)iterator)), "Ignoring measurement without client id");
            return;
        }
        if (!this.zzb.zzc().getAppOptOut()) {
            if (zzfs.zzj(0.0, object22.zze())) {
                this.zzG("Sampling enabled. Hit sampled out. sampling rate", 0.0);
                return;
            }
            iterator = com.google.android.gms.analytics.zzb.zzd((zzh)((Object)iterator));
            iterator.put("v", "1");
            iterator.put("_v", zzbt.zzb);
            iterator.put("tid", this.zzc);
            if (this.zzb.zzc().isDryRunEnabled()) {
                object = new StringBuilder();
                for (Map.Entry entry : iterator.entrySet()) {
                    if (((StringBuilder)object).length() != 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append((String)entry.getKey());
                    ((StringBuilder)object).append("=");
                    ((StringBuilder)object).append((String)entry.getValue());
                }
                this.zzN("Dry run is enabled. GoogleAnalytics would have sent", ((StringBuilder)object).toString());
                return;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            zzfs.zzg(hashMap, "uid", object22.zzg());
            Object object2 = ((zzh)object).zzc(zzav.class);
            if (object2 != null) {
                zzfs.zzg(hashMap, "an", ((zzav)object2).zzf());
                zzfs.zzg(hashMap, "aid", ((zzav)object2).zzd());
                zzfs.zzg(hashMap, "av", ((zzav)object2).zzg());
                zzfs.zzg(hashMap, "aiid", ((zzav)object2).zze());
            }
            object2 = new zzbx(0L, object22.zze(), this.zzc, TextUtils.isEmpty((CharSequence)object22.zzd()) ^ true, 0L, hashMap);
            iterator.put("_s", String.valueOf(this.zzs().zza((zzbx)object2)));
            zzex zzex2 = new zzex(this.zzz(), (Map<String, String>)((Object)iterator), ((zzh)object).zza(), true);
            this.zzs().zzh(zzex2);
            return;
        }
    }
}

