/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ext.rtmp;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.upstream.BaseDataSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import io.antmedia.rtmp_client.RtmpClient;
import java.io.IOException;

public final class RtmpDataSource
extends BaseDataSource {
    @Nullable
    private RtmpClient rtmpClient;
    @Nullable
    private Uri uri;

    public RtmpDataSource() {
        super(true);
    }

    public long open(DataSpec dataSpec) throws RtmpClient.RtmpIOException {
        this.transferInitializing(dataSpec);
        this.rtmpClient = new RtmpClient();
        this.rtmpClient.open(dataSpec.uri.toString(), false);
        this.uri = dataSpec.uri;
        this.transferStarted(dataSpec);
        return -1L;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead = ((RtmpClient)Util.castNonNull((Object)this.rtmpClient)).read(buffer, offset, length);
        if (bytesRead == -1) {
            return -1;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    public void close() {
        if (this.uri != null) {
            this.uri = null;
            this.transferEnded();
        }
        if (this.rtmpClient != null) {
            this.rtmpClient.close();
            this.rtmpClient = null;
        }
    }

    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.rtmp");
    }

    public static final class Factory
    implements DataSource.Factory {
        @Nullable
        private TransferListener transferListener;

        public Factory setTransferListener(@Nullable TransferListener transferListener) {
            this.transferListener = transferListener;
            return this;
        }

        public RtmpDataSource createDataSource() {
            RtmpDataSource dataSource = new RtmpDataSource();
            if (this.transferListener != null) {
                dataSource.addTransferListener(this.transferListener);
            }
            return dataSource;
        }
    }
}

