/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui.spherical;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.SurfaceTexture;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.AnyThread;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.util.AttributeSet;
import android.view.Display;
import android.view.Surface;
import android.view.WindowManager;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.ui.spherical.SceneRenderer;
import com.google.android.exoplayer2.ui.spherical.SingleTapListener;
import com.google.android.exoplayer2.ui.spherical.TouchTracker;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoFrameMetadataListener;
import com.google.android.exoplayer2.video.spherical.CameraMotionListener;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

@TargetApi(value=15)
public final class SphericalSurfaceView
extends GLSurfaceView {
    private static final int FIELD_OF_VIEW_DEGREES = 90;
    private static final float Z_NEAR = 0.1f;
    private static final float Z_FAR = 100.0f;
    private static final float PX_PER_DEGREES = 25.0f;
    static final float UPRIGHT_ROLL = (float)Math.PI;
    private final SensorManager sensorManager;
    @Nullable
    private final Sensor orientationSensor;
    private final PhoneOrientationListener phoneOrientationListener;
    private final Renderer renderer;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private final TouchTracker touchTracker;
    private final SceneRenderer scene;
    @Nullable
    private SurfaceListener surfaceListener;
    @Nullable
    private SurfaceTexture surfaceTexture;
    @Nullable
    private Surface surface;
    @Nullable
    private Player.VideoComponent videoComponent;

    public SphericalSurfaceView(Context context) {
        this(context, null);
    }

    public SphericalSurfaceView(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.sensorManager = (SensorManager)Assertions.checkNotNull((Object)context.getSystemService("sensor"));
        int type = Util.SDK_INT >= 18 ? 15 : 11;
        this.orientationSensor = this.sensorManager.getDefaultSensor(type);
        this.scene = new SceneRenderer();
        this.renderer = new Renderer(this.scene);
        this.touchTracker = new TouchTracker(context, this.renderer, 25.0f);
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        Display display = ((WindowManager)Assertions.checkNotNull((Object)windowManager)).getDefaultDisplay();
        this.phoneOrientationListener = new PhoneOrientationListener(display, this.touchTracker, this.renderer);
        this.setEGLContextClientVersion(2);
        this.setRenderer(this.renderer);
        this.setOnTouchListener(this.touchTracker);
    }

    public void setDefaultStereoMode(int stereoMode) {
        this.scene.setDefaultStereoMode(stereoMode);
    }

    public void setVideoComponent(@Nullable Player.VideoComponent newVideoComponent) {
        if (newVideoComponent == this.videoComponent) {
            return;
        }
        if (this.videoComponent != null) {
            if (this.surface != null) {
                this.videoComponent.clearVideoSurface(this.surface);
            }
            this.videoComponent.clearVideoFrameMetadataListener((VideoFrameMetadataListener)this.scene);
            this.videoComponent.clearCameraMotionListener((CameraMotionListener)this.scene);
        }
        this.videoComponent = newVideoComponent;
        if (this.videoComponent != null) {
            this.videoComponent.setVideoFrameMetadataListener((VideoFrameMetadataListener)this.scene);
            this.videoComponent.setCameraMotionListener((CameraMotionListener)this.scene);
            this.videoComponent.setVideoSurface(this.surface);
        }
    }

    public void setSurfaceListener(@Nullable SurfaceListener listener) {
        this.surfaceListener = listener;
    }

    public void setSingleTapListener(@Nullable SingleTapListener listener) {
        this.touchTracker.setSingleTapListener(listener);
    }

    public void onResume() {
        super.onResume();
        if (this.orientationSensor != null) {
            this.sensorManager.registerListener((SensorEventListener)this.phoneOrientationListener, this.orientationSensor, 0);
        }
    }

    public void onPause() {
        if (this.orientationSensor != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this.phoneOrientationListener);
        }
        super.onPause();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mainHandler.post(() -> {
            if (this.surface != null) {
                if (this.surfaceListener != null) {
                    this.surfaceListener.surfaceChanged(null);
                }
                SphericalSurfaceView.releaseSurface(this.surfaceTexture, this.surface);
                this.surfaceTexture = null;
                this.surface = null;
            }
        });
    }

    private void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture) {
        this.mainHandler.post(() -> {
            SurfaceTexture oldSurfaceTexture = this.surfaceTexture;
            Surface oldSurface = this.surface;
            this.surfaceTexture = surfaceTexture;
            this.surface = new Surface(surfaceTexture);
            if (this.surfaceListener != null) {
                this.surfaceListener.surfaceChanged(this.surface);
            }
            SphericalSurfaceView.releaseSurface(oldSurfaceTexture, oldSurface);
        });
    }

    private static void releaseSurface(@Nullable SurfaceTexture oldSurfaceTexture, @Nullable Surface oldSurface) {
        if (oldSurfaceTexture != null) {
            oldSurfaceTexture.release();
        }
        if (oldSurface != null) {
            oldSurface.release();
        }
    }

    class Renderer
    implements GLSurfaceView.Renderer,
    TouchTracker.Listener {
        private final SceneRenderer scene;
        private final float[] projectionMatrix = new float[16];
        private final float[] viewProjectionMatrix = new float[16];
        private final float[] deviceOrientationMatrix = new float[16];
        private final float[] touchPitchMatrix = new float[16];
        private final float[] touchYawMatrix = new float[16];
        private float touchPitch;
        private float deviceRoll;
        private final float[] viewMatrix = new float[16];
        private final float[] tempMatrix = new float[16];

        public Renderer(SceneRenderer scene) {
            this.scene = scene;
            Matrix.setIdentityM((float[])this.deviceOrientationMatrix, (int)0);
            Matrix.setIdentityM((float[])this.touchPitchMatrix, (int)0);
            Matrix.setIdentityM((float[])this.touchYawMatrix, (int)0);
            this.deviceRoll = (float)Math.PI;
        }

        public synchronized void onSurfaceCreated(GL10 gl, EGLConfig config) {
            SphericalSurfaceView.this.onSurfaceTextureAvailable(this.scene.init());
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
            float aspect = (float)width / (float)height;
            float fovY = this.calculateFieldOfViewInYDirection(aspect);
            Matrix.perspectiveM((float[])this.projectionMatrix, (int)0, (float)fovY, (float)aspect, (float)0.1f, (float)100.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDrawFrame(GL10 gl) {
            Renderer renderer = this;
            synchronized (renderer) {
                Matrix.multiplyMM((float[])this.tempMatrix, (int)0, (float[])this.deviceOrientationMatrix, (int)0, (float[])this.touchYawMatrix, (int)0);
                Matrix.multiplyMM((float[])this.viewMatrix, (int)0, (float[])this.touchPitchMatrix, (int)0, (float[])this.tempMatrix, (int)0);
            }
            Matrix.multiplyMM((float[])this.viewProjectionMatrix, (int)0, (float[])this.projectionMatrix, (int)0, (float[])this.viewMatrix, (int)0);
            this.scene.drawFrame(this.viewProjectionMatrix, 0);
        }

        @BinderThread
        public synchronized void setDeviceOrientation(float[] matrix, float deviceRoll) {
            System.arraycopy(matrix, 0, this.deviceOrientationMatrix, 0, this.deviceOrientationMatrix.length);
            this.deviceRoll = -deviceRoll;
            this.updatePitchMatrix();
        }

        @AnyThread
        private void updatePitchMatrix() {
            Matrix.setRotateM((float[])this.touchPitchMatrix, (int)0, (float)(-this.touchPitch), (float)((float)Math.cos(this.deviceRoll)), (float)((float)Math.sin(this.deviceRoll)), (float)0.0f);
        }

        @Override
        @UiThread
        public synchronized void onScrollChange(PointF scrollOffsetDegrees) {
            this.touchPitch = scrollOffsetDegrees.y;
            this.updatePitchMatrix();
            Matrix.setRotateM((float[])this.touchYawMatrix, (int)0, (float)(-scrollOffsetDegrees.x), (float)0.0f, (float)1.0f, (float)0.0f);
        }

        private float calculateFieldOfViewInYDirection(float aspect) {
            boolean landscapeMode;
            boolean bl = landscapeMode = aspect > 1.0f;
            if (landscapeMode) {
                double halfFovX = 45.0;
                double tanY = Math.tan(Math.toRadians(halfFovX)) / (double)aspect;
                double halfFovY = Math.toDegrees(Math.atan(tanY));
                return (float)(halfFovY * 2.0);
            }
            return 90.0f;
        }
    }

    private static class PhoneOrientationListener
    implements SensorEventListener {
        private final float[] phoneInWorldSpaceMatrix = new float[16];
        private final float[] remappedPhoneMatrix = new float[16];
        private final float[] angles = new float[3];
        private final Display display;
        private final TouchTracker touchTracker;
        private final Renderer renderer;

        public PhoneOrientationListener(Display display, TouchTracker touchTracker, Renderer renderer) {
            this.display = display;
            this.touchTracker = touchTracker;
            this.renderer = renderer;
        }

        @BinderThread
        public void onSensorChanged(SensorEvent event) {
            int yAxis;
            int xAxis;
            SensorManager.getRotationMatrixFromVector((float[])this.remappedPhoneMatrix, (float[])event.values);
            switch (this.display.getRotation()) {
                case 3: {
                    xAxis = 130;
                    yAxis = 1;
                    break;
                }
                case 2: {
                    xAxis = 129;
                    yAxis = 130;
                    break;
                }
                case 1: {
                    xAxis = 2;
                    yAxis = 129;
                    break;
                }
                default: {
                    xAxis = 1;
                    yAxis = 2;
                }
            }
            SensorManager.remapCoordinateSystem((float[])this.remappedPhoneMatrix, (int)xAxis, (int)yAxis, (float[])this.phoneInWorldSpaceMatrix);
            SensorManager.remapCoordinateSystem((float[])this.phoneInWorldSpaceMatrix, (int)1, (int)131, (float[])this.remappedPhoneMatrix);
            SensorManager.getOrientation((float[])this.remappedPhoneMatrix, (float[])this.angles);
            float roll = this.angles[2];
            this.touchTracker.setRoll(roll);
            Matrix.rotateM((float[])this.phoneInWorldSpaceMatrix, (int)0, (float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.renderer.setDeviceOrientation(this.phoneInWorldSpaceMatrix, roll);
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    public static interface SurfaceListener {
        public void surfaceChanged(@Nullable Surface var1);
    }
}

