/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.NotificationCompat;
import com.google.android.exoplayer2.offline.DownloadManager;
import com.google.android.exoplayer2.ui.R;

public final class DownloadNotificationUtil {
    @StringRes
    private static final int NULL_STRING_ID = 0;

    private DownloadNotificationUtil() {
    }

    public static Notification buildProgressNotification(Context context, @DrawableRes int smallIcon, String channelId, @Nullable PendingIntent contentIntent, @Nullable String message, DownloadManager.TaskState[] taskStates) {
        float totalPercentage = 0.0f;
        int downloadTaskCount = 0;
        boolean allDownloadPercentagesUnknown = true;
        boolean haveDownloadedBytes = false;
        boolean haveDownloadTasks = false;
        boolean haveRemoveTasks = false;
        for (DownloadManager.TaskState taskState : taskStates) {
            if (taskState.state != 1 && taskState.state != 2) continue;
            if (taskState.action.isRemoveAction) {
                haveRemoveTasks = true;
                continue;
            }
            haveDownloadTasks = true;
            if (taskState.downloadPercentage != -1.0f) {
                allDownloadPercentagesUnknown = false;
                totalPercentage += taskState.downloadPercentage;
            }
            haveDownloadedBytes |= taskState.downloadedBytes > 0L;
            ++downloadTaskCount;
        }
        int titleStringId = haveDownloadTasks ? R.string.exo_download_downloading : (haveRemoveTasks ? R.string.exo_download_removing : 0);
        NotificationCompat.Builder notificationBuilder = DownloadNotificationUtil.newNotificationBuilder(context, smallIcon, channelId, contentIntent, message, titleStringId);
        int progress = 0;
        boolean indeterminate = true;
        if (haveDownloadTasks) {
            progress = (int)(totalPercentage / (float)downloadTaskCount);
            indeterminate = allDownloadPercentagesUnknown && haveDownloadedBytes;
        }
        notificationBuilder.setProgress(100, progress, indeterminate);
        notificationBuilder.setOngoing(true);
        notificationBuilder.setShowWhen(false);
        return notificationBuilder.build();
    }

    public static Notification buildDownloadCompletedNotification(Context context, @DrawableRes int smallIcon, String channelId, @Nullable PendingIntent contentIntent, @Nullable String message) {
        int titleStringId = R.string.exo_download_completed;
        return DownloadNotificationUtil.newNotificationBuilder(context, smallIcon, channelId, contentIntent, message, titleStringId).build();
    }

    public static Notification buildDownloadFailedNotification(Context context, @DrawableRes int smallIcon, String channelId, @Nullable PendingIntent contentIntent, @Nullable String message) {
        int titleStringId = R.string.exo_download_failed;
        return DownloadNotificationUtil.newNotificationBuilder(context, smallIcon, channelId, contentIntent, message, titleStringId).build();
    }

    private static NotificationCompat.Builder newNotificationBuilder(Context context, @DrawableRes int smallIcon, String channelId, @Nullable PendingIntent contentIntent, @Nullable String message, @StringRes int titleStringId) {
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context, channelId).setSmallIcon(smallIcon);
        if (titleStringId != 0) {
            notificationBuilder.setContentTitle((CharSequence)context.getResources().getString(titleStringId));
        }
        if (contentIntent != null) {
            notificationBuilder.setContentIntent(contentIntent);
        }
        if (message != null) {
            notificationBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)message));
        }
        return notificationBuilder;
    }
}

