/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Tracks;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.trackselection.TrackSelectionOverride;
import com.google.android.exoplayer2.trackselection.TrackSelectionParameters;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.TrackNameProvider;
import com.google.android.exoplayer2.ui.TrackSelectionView;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@Deprecated
public final class TrackSelectionDialogBuilder {
    private final Context context;
    private final CharSequence title;
    private final List<Tracks.Group> trackGroups;
    private final DialogCallback callback;
    @StyleRes
    private int themeResId;
    private boolean allowAdaptiveSelections;
    private boolean allowMultipleOverrides;
    private boolean showDisableOption;
    @Nullable
    private TrackNameProvider trackNameProvider;
    private boolean isDisabled;
    private ImmutableMap<TrackGroup, TrackSelectionOverride> overrides;
    @Nullable
    private Comparator<Format> trackFormatComparator;

    public TrackSelectionDialogBuilder(Context context, CharSequence title, List<Tracks.Group> trackGroups, DialogCallback callback) {
        this.context = context;
        this.title = title;
        this.trackGroups = ImmutableList.copyOf(trackGroups);
        this.callback = callback;
        this.overrides = ImmutableMap.of();
    }

    public TrackSelectionDialogBuilder(Context context, CharSequence title, Player player, int trackType) {
        this.context = context;
        this.title = title;
        Tracks tracks = player.isCommandAvailable(30) ? player.getCurrentTracks() : Tracks.EMPTY;
        ImmutableList allTrackGroups = tracks.getGroups();
        this.trackGroups = new ArrayList<Tracks.Group>();
        for (int i = 0; i < allTrackGroups.size(); ++i) {
            Tracks.Group trackGroup = (Tracks.Group)allTrackGroups.get(i);
            if (trackGroup.getType() != trackType) continue;
            this.trackGroups.add(trackGroup);
        }
        this.overrides = player.getTrackSelectionParameters().overrides;
        this.callback = (isDisabled, overrides) -> {
            if (!player.isCommandAvailable(29)) {
                return;
            }
            TrackSelectionParameters.Builder parametersBuilder = player.getTrackSelectionParameters().buildUpon();
            parametersBuilder.setTrackTypeDisabled(trackType, isDisabled);
            parametersBuilder.clearOverridesOfType(trackType);
            for (TrackSelectionOverride override : overrides.values()) {
                parametersBuilder.addOverride(override);
            }
            player.setTrackSelectionParameters(parametersBuilder.build());
        };
    }

    public TrackSelectionDialogBuilder setTheme(@StyleRes int themeResId) {
        this.themeResId = themeResId;
        return this;
    }

    public TrackSelectionDialogBuilder setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
        return this;
    }

    public TrackSelectionDialogBuilder setOverride(@Nullable TrackSelectionOverride override) {
        return this.setOverrides((Map<TrackGroup, TrackSelectionOverride>)(override == null ? Collections.emptyMap() : ImmutableMap.of((Object)override.mediaTrackGroup, (Object)override)));
    }

    public TrackSelectionDialogBuilder setOverrides(Map<TrackGroup, TrackSelectionOverride> overrides) {
        this.overrides = ImmutableMap.copyOf(overrides);
        return this;
    }

    public TrackSelectionDialogBuilder setAllowAdaptiveSelections(boolean allowAdaptiveSelections) {
        this.allowAdaptiveSelections = allowAdaptiveSelections;
        return this;
    }

    public TrackSelectionDialogBuilder setAllowMultipleOverrides(boolean allowMultipleOverrides) {
        this.allowMultipleOverrides = allowMultipleOverrides;
        return this;
    }

    public TrackSelectionDialogBuilder setShowDisableOption(boolean showDisableOption) {
        this.showDisableOption = showDisableOption;
        return this;
    }

    public void setTrackFormatComparator(@Nullable Comparator<Format> trackFormatComparator) {
        this.trackFormatComparator = trackFormatComparator;
    }

    public TrackSelectionDialogBuilder setTrackNameProvider(@Nullable TrackNameProvider trackNameProvider) {
        this.trackNameProvider = trackNameProvider;
        return this;
    }

    public Dialog build() {
        Dialog dialog = this.buildForAndroidX();
        return dialog == null ? this.buildForPlatform() : dialog;
    }

    private Dialog buildForPlatform() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context, this.themeResId);
        LayoutInflater dialogInflater = LayoutInflater.from((Context)builder.getContext());
        View dialogView = dialogInflater.inflate(R.layout.exo_track_selection_dialog, null);
        DialogInterface.OnClickListener okClickListener = this.setUpDialogView(dialogView);
        return builder.setTitle(this.title).setView(dialogView).setPositiveButton(17039370, okClickListener).setNegativeButton(0x1040000, null).create();
    }

    @Nullable
    private Dialog buildForAndroidX() {
        try {
            Class<?> builderClazz = Class.forName("androidx.appcompat.app.AlertDialog$Builder");
            Constructor<?> builderConstructor = builderClazz.getConstructor(Context.class, Integer.TYPE);
            Object builder = builderConstructor.newInstance(this.context, this.themeResId);
            Context builderContext = (Context)builderClazz.getMethod("getContext", new Class[0]).invoke(builder, new Object[0]);
            LayoutInflater dialogInflater = LayoutInflater.from((Context)builderContext);
            View dialogView = dialogInflater.inflate(R.layout.exo_track_selection_dialog, null);
            DialogInterface.OnClickListener okClickListener = this.setUpDialogView(dialogView);
            builderClazz.getMethod("setTitle", CharSequence.class).invoke(builder, this.title);
            builderClazz.getMethod("setView", View.class).invoke(builder, dialogView);
            builderClazz.getMethod("setPositiveButton", Integer.TYPE, DialogInterface.OnClickListener.class).invoke(builder, 17039370, okClickListener);
            builderClazz.getMethod("setNegativeButton", Integer.TYPE, DialogInterface.OnClickListener.class).invoke(builder, 0x1040000, null);
            return (Dialog)builderClazz.getMethod("create", new Class[0]).invoke(builder, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private DialogInterface.OnClickListener setUpDialogView(View dialogView) {
        TrackSelectionView selectionView = (TrackSelectionView)dialogView.findViewById(R.id.exo_track_selection_view);
        selectionView.setAllowMultipleOverrides(this.allowMultipleOverrides);
        selectionView.setAllowAdaptiveSelections(this.allowAdaptiveSelections);
        selectionView.setShowDisableOption(this.showDisableOption);
        if (this.trackNameProvider != null) {
            selectionView.setTrackNameProvider(this.trackNameProvider);
        }
        selectionView.init(this.trackGroups, this.isDisabled, (Map<TrackGroup, TrackSelectionOverride>)this.overrides, this.trackFormatComparator, null);
        return (dialog, which) -> this.callback.onTracksSelected(selectionView.getIsDisabled(), selectionView.getOverrides());
    }

    public static interface DialogCallback {
        public void onTracksSelected(boolean var1, Map<TrackGroup, TrackSelectionOverride> var2);
    }
}

