/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.opengl.GLSurfaceView;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.TracksInfo;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.ui.AdOverlayInfo;
import com.google.android.exoplayer2.ui.AdViewProvider;
import com.google.android.exoplayer2.ui.AspectRatioFrameLayout;
import com.google.android.exoplayer2.ui.PlayerControlView;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.SubtitleView;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ErrorMessageProvider;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoSize;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class PlayerView
extends FrameLayout
implements AdViewProvider {
    public static final int SHOW_BUFFERING_NEVER = 0;
    public static final int SHOW_BUFFERING_WHEN_PLAYING = 1;
    public static final int SHOW_BUFFERING_ALWAYS = 2;
    private static final int SURFACE_TYPE_NONE = 0;
    private static final int SURFACE_TYPE_SURFACE_VIEW = 1;
    private static final int SURFACE_TYPE_TEXTURE_VIEW = 2;
    private static final int SURFACE_TYPE_SPHERICAL_GL_SURFACE_VIEW = 3;
    private static final int SURFACE_TYPE_VIDEO_DECODER_GL_SURFACE_VIEW = 4;
    private final ComponentListener componentListener = new ComponentListener();
    @Nullable
    private final AspectRatioFrameLayout contentFrame;
    @Nullable
    private final View shutterView;
    @Nullable
    private final View surfaceView;
    private final boolean surfaceViewIgnoresVideoAspectRatio;
    @Nullable
    private final ImageView artworkView;
    @Nullable
    private final SubtitleView subtitleView;
    @Nullable
    private final View bufferingView;
    @Nullable
    private final TextView errorMessageView;
    @Nullable
    private final PlayerControlView controller;
    @Nullable
    private final FrameLayout adOverlayFrameLayout;
    @Nullable
    private final FrameLayout overlayFrameLayout;
    @Nullable
    private Player player;
    private boolean useController;
    @Nullable
    private PlayerControlView.VisibilityListener controllerVisibilityListener;
    private boolean useArtwork;
    @Nullable
    private Drawable defaultArtwork;
    private int showBuffering;
    private boolean keepContentOnPlayerReset;
    @Nullable
    private ErrorMessageProvider<? super PlaybackException> errorMessageProvider;
    @Nullable
    private CharSequence customErrorMessage;
    private int controllerShowTimeoutMs;
    private boolean controllerAutoShow;
    private boolean controllerHideDuringAds;
    private boolean controllerHideOnTouch;
    private int textureViewRotation;
    private boolean isTouching;
    private static final int PICTURE_TYPE_FRONT_COVER = 3;
    private static final int PICTURE_TYPE_NOT_SET = -1;

    public PlayerView(Context context) {
        this(context, null);
    }

    public PlayerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.isInEditMode()) {
            this.contentFrame = null;
            this.shutterView = null;
            this.surfaceView = null;
            this.surfaceViewIgnoresVideoAspectRatio = false;
            this.artworkView = null;
            this.subtitleView = null;
            this.bufferingView = null;
            this.errorMessageView = null;
            this.controller = null;
            this.adOverlayFrameLayout = null;
            this.overlayFrameLayout = null;
            ImageView logo = new ImageView(context);
            if (Util.SDK_INT >= 23) {
                PlayerView.configureEditModeLogoV23(this.getResources(), logo);
            } else {
                PlayerView.configureEditModeLogo(this.getResources(), logo);
            }
            this.addView((View)logo);
            return;
        }
        boolean shutterColorSet = false;
        int shutterColor = 0;
        int playerLayoutId = R.layout.exo_player_view;
        boolean useArtwork = true;
        int defaultArtworkId = 0;
        boolean useController = true;
        int surfaceType = 1;
        int resizeMode = 0;
        int controllerShowTimeoutMs = 5000;
        boolean controllerHideOnTouch = true;
        boolean controllerAutoShow = true;
        boolean controllerHideDuringAds = true;
        int showBuffering = 0;
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PlayerView, defStyleAttr, 0);
            try {
                shutterColorSet = a.hasValue(R.styleable.PlayerView_shutter_background_color);
                shutterColor = a.getColor(R.styleable.PlayerView_shutter_background_color, shutterColor);
                playerLayoutId = a.getResourceId(R.styleable.PlayerView_player_layout_id, playerLayoutId);
                useArtwork = a.getBoolean(R.styleable.PlayerView_use_artwork, useArtwork);
                defaultArtworkId = a.getResourceId(R.styleable.PlayerView_default_artwork, defaultArtworkId);
                useController = a.getBoolean(R.styleable.PlayerView_use_controller, useController);
                surfaceType = a.getInt(R.styleable.PlayerView_surface_type, surfaceType);
                resizeMode = a.getInt(R.styleable.PlayerView_resize_mode, resizeMode);
                controllerShowTimeoutMs = a.getInt(R.styleable.PlayerView_show_timeout, controllerShowTimeoutMs);
                controllerHideOnTouch = a.getBoolean(R.styleable.PlayerView_hide_on_touch, controllerHideOnTouch);
                controllerAutoShow = a.getBoolean(R.styleable.PlayerView_auto_show, controllerAutoShow);
                showBuffering = a.getInteger(R.styleable.PlayerView_show_buffering, showBuffering);
                this.keepContentOnPlayerReset = a.getBoolean(R.styleable.PlayerView_keep_content_on_player_reset, this.keepContentOnPlayerReset);
                controllerHideDuringAds = a.getBoolean(R.styleable.PlayerView_hide_during_ads, controllerHideDuringAds);
            }
            finally {
                a.recycle();
            }
        }
        LayoutInflater.from((Context)context).inflate(playerLayoutId, (ViewGroup)this);
        this.setDescendantFocusability(262144);
        this.contentFrame = (AspectRatioFrameLayout)this.findViewById(R.id.exo_content_frame);
        if (this.contentFrame != null) {
            PlayerView.setResizeModeRaw(this.contentFrame, resizeMode);
        }
        this.shutterView = this.findViewById(R.id.exo_shutter);
        if (this.shutterView != null && shutterColorSet) {
            this.shutterView.setBackgroundColor(shutterColor);
        }
        boolean surfaceViewIgnoresVideoAspectRatio = false;
        if (this.contentFrame != null && surfaceType != 0) {
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
            switch (surfaceType) {
                case 2: {
                    this.surfaceView = new TextureView(context);
                    break;
                }
                case 3: {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("com.google.android.exoplayer2.video.spherical.SphericalGLSurfaceView");
                        this.surfaceView = (View)clazz.getConstructor(Context.class).newInstance(context);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("spherical_gl_surface_view requires an ExoPlayer dependency", e);
                    }
                    surfaceViewIgnoresVideoAspectRatio = true;
                    break;
                }
                case 4: {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("com.google.android.exoplayer2.video.VideoDecoderGLSurfaceView");
                        this.surfaceView = (View)clazz.getConstructor(Context.class).newInstance(context);
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("video_decoder_gl_surface_view requires an ExoPlayer dependency", e);
                    }
                }
                default: {
                    this.surfaceView = new SurfaceView(context);
                }
            }
            this.surfaceView.setLayoutParams(params);
            this.surfaceView.setOnClickListener((View.OnClickListener)this.componentListener);
            this.surfaceView.setClickable(false);
            this.contentFrame.addView(this.surfaceView, 0);
        } else {
            this.surfaceView = null;
        }
        this.surfaceViewIgnoresVideoAspectRatio = surfaceViewIgnoresVideoAspectRatio;
        this.adOverlayFrameLayout = (FrameLayout)this.findViewById(R.id.exo_ad_overlay);
        this.overlayFrameLayout = (FrameLayout)this.findViewById(R.id.exo_overlay);
        this.artworkView = (ImageView)this.findViewById(R.id.exo_artwork);
        boolean bl = this.useArtwork = useArtwork && this.artworkView != null;
        if (defaultArtworkId != 0) {
            this.defaultArtwork = ContextCompat.getDrawable((Context)this.getContext(), (int)defaultArtworkId);
        }
        this.subtitleView = (SubtitleView)this.findViewById(R.id.exo_subtitles);
        if (this.subtitleView != null) {
            this.subtitleView.setUserDefaultStyle();
            this.subtitleView.setUserDefaultTextSize();
        }
        this.bufferingView = this.findViewById(R.id.exo_buffering);
        if (this.bufferingView != null) {
            this.bufferingView.setVisibility(8);
        }
        this.showBuffering = showBuffering;
        this.errorMessageView = (TextView)this.findViewById(R.id.exo_error_message);
        if (this.errorMessageView != null) {
            this.errorMessageView.setVisibility(8);
        }
        PlayerControlView customController = (PlayerControlView)this.findViewById(R.id.exo_controller);
        View controllerPlaceholder = this.findViewById(R.id.exo_controller_placeholder);
        if (customController != null) {
            this.controller = customController;
        } else if (controllerPlaceholder != null) {
            this.controller = new PlayerControlView(context, null, 0, attrs);
            this.controller.setId(R.id.exo_controller);
            this.controller.setLayoutParams(controllerPlaceholder.getLayoutParams());
            ViewGroup parent = (ViewGroup)controllerPlaceholder.getParent();
            int controllerIndex = parent.indexOfChild(controllerPlaceholder);
            parent.removeView(controllerPlaceholder);
            parent.addView((View)this.controller, controllerIndex);
        } else {
            this.controller = null;
        }
        this.controllerShowTimeoutMs = this.controller != null ? controllerShowTimeoutMs : 0;
        this.controllerHideOnTouch = controllerHideOnTouch;
        this.controllerAutoShow = controllerAutoShow;
        this.controllerHideDuringAds = controllerHideDuringAds;
        this.useController = useController && this.controller != null;
        this.hideController();
        this.updateContentDescription();
        if (this.controller != null) {
            this.controller.addVisibilityListener(this.componentListener);
        }
    }

    public static void switchTargetView(Player player, @Nullable PlayerView oldPlayerView, @Nullable PlayerView newPlayerView) {
        if (oldPlayerView == newPlayerView) {
            return;
        }
        if (newPlayerView != null) {
            newPlayerView.setPlayer(player);
        }
        if (oldPlayerView != null) {
            oldPlayerView.setPlayer(null);
        }
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(@Nullable Player player) {
        Assertions.checkState((Looper.myLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        Assertions.checkArgument((player == null || player.getApplicationLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        if (this.player == player) {
            return;
        }
        Player oldPlayer = this.player;
        if (oldPlayer != null) {
            oldPlayer.removeListener((Player.Listener)this.componentListener);
            if (oldPlayer.isCommandAvailable(27)) {
                if (this.surfaceView instanceof TextureView) {
                    oldPlayer.clearVideoTextureView((TextureView)this.surfaceView);
                } else if (this.surfaceView instanceof SurfaceView) {
                    oldPlayer.clearVideoSurfaceView((SurfaceView)this.surfaceView);
                }
            }
        }
        if (this.subtitleView != null) {
            this.subtitleView.setCues(null);
        }
        this.player = player;
        if (this.useController()) {
            this.controller.setPlayer(player);
        }
        this.updateBuffering();
        this.updateErrorMessage();
        this.updateForCurrentTrackSelections(true);
        if (player != null) {
            if (player.isCommandAvailable(27)) {
                if (this.surfaceView instanceof TextureView) {
                    player.setVideoTextureView((TextureView)this.surfaceView);
                } else if (this.surfaceView instanceof SurfaceView) {
                    player.setVideoSurfaceView((SurfaceView)this.surfaceView);
                }
                this.updateAspectRatio();
            }
            if (this.subtitleView != null && player.isCommandAvailable(28)) {
                this.subtitleView.setCues(player.getCurrentCues());
            }
            player.addListener((Player.Listener)this.componentListener);
            this.maybeShowController(false);
        } else {
            this.hideController();
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.surfaceView instanceof SurfaceView) {
            this.surfaceView.setVisibility(visibility);
        }
    }

    public void setResizeMode(int resizeMode) {
        Assertions.checkStateNotNull((Object)((Object)this.contentFrame));
        this.contentFrame.setResizeMode(resizeMode);
    }

    public int getResizeMode() {
        Assertions.checkStateNotNull((Object)((Object)this.contentFrame));
        return this.contentFrame.getResizeMode();
    }

    public boolean getUseArtwork() {
        return this.useArtwork;
    }

    public void setUseArtwork(boolean useArtwork) {
        Assertions.checkState((!useArtwork || this.artworkView != null ? 1 : 0) != 0);
        if (this.useArtwork != useArtwork) {
            this.useArtwork = useArtwork;
            this.updateForCurrentTrackSelections(false);
        }
    }

    @Nullable
    public Drawable getDefaultArtwork() {
        return this.defaultArtwork;
    }

    public void setDefaultArtwork(@Nullable Drawable defaultArtwork) {
        if (this.defaultArtwork != defaultArtwork) {
            this.defaultArtwork = defaultArtwork;
            this.updateForCurrentTrackSelections(false);
        }
    }

    public boolean getUseController() {
        return this.useController;
    }

    public void setUseController(boolean useController) {
        Assertions.checkState((!useController || this.controller != null ? 1 : 0) != 0);
        if (this.useController == useController) {
            return;
        }
        this.useController = useController;
        if (this.useController()) {
            this.controller.setPlayer(this.player);
        } else if (this.controller != null) {
            this.controller.hide();
            this.controller.setPlayer(null);
        }
        this.updateContentDescription();
    }

    public void setShutterBackgroundColor(int color2) {
        if (this.shutterView != null) {
            this.shutterView.setBackgroundColor(color2);
        }
    }

    public void setKeepContentOnPlayerReset(boolean keepContentOnPlayerReset) {
        if (this.keepContentOnPlayerReset != keepContentOnPlayerReset) {
            this.keepContentOnPlayerReset = keepContentOnPlayerReset;
            this.updateForCurrentTrackSelections(false);
        }
    }

    public void setShowBuffering(int showBuffering) {
        if (this.showBuffering != showBuffering) {
            this.showBuffering = showBuffering;
            this.updateBuffering();
        }
    }

    public void setErrorMessageProvider(@Nullable ErrorMessageProvider<? super PlaybackException> errorMessageProvider) {
        if (this.errorMessageProvider != errorMessageProvider) {
            this.errorMessageProvider = errorMessageProvider;
            this.updateErrorMessage();
        }
    }

    public void setCustomErrorMessage(@Nullable CharSequence message) {
        Assertions.checkState((this.errorMessageView != null ? 1 : 0) != 0);
        this.customErrorMessage = message;
        this.updateErrorMessage();
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.player != null && this.player.isPlayingAd()) {
            return super.dispatchKeyEvent(event);
        }
        boolean isDpadKey = this.isDpadKey(event.getKeyCode());
        boolean handled = false;
        if (isDpadKey && this.useController() && !this.controller.isVisible()) {
            this.maybeShowController(true);
            handled = true;
        } else if (this.dispatchMediaKeyEvent(event) || super.dispatchKeyEvent(event)) {
            this.maybeShowController(true);
            handled = true;
        } else if (isDpadKey && this.useController()) {
            this.maybeShowController(true);
        }
        return handled;
    }

    public boolean dispatchMediaKeyEvent(KeyEvent event) {
        return this.useController() && this.controller.dispatchMediaKeyEvent(event);
    }

    public boolean isControllerVisible() {
        return this.controller != null && this.controller.isVisible();
    }

    public void showController() {
        this.showController(this.shouldShowControllerIndefinitely());
    }

    public void hideController() {
        if (this.controller != null) {
            this.controller.hide();
        }
    }

    public int getControllerShowTimeoutMs() {
        return this.controllerShowTimeoutMs;
    }

    public void setControllerShowTimeoutMs(int controllerShowTimeoutMs) {
        Assertions.checkStateNotNull((Object)((Object)this.controller));
        this.controllerShowTimeoutMs = controllerShowTimeoutMs;
        if (this.controller.isVisible()) {
            this.showController();
        }
    }

    public boolean getControllerHideOnTouch() {
        return this.controllerHideOnTouch;
    }

    public void setControllerHideOnTouch(boolean controllerHideOnTouch) {
        Assertions.checkStateNotNull((Object)((Object)this.controller));
        this.controllerHideOnTouch = controllerHideOnTouch;
        this.updateContentDescription();
    }

    public boolean getControllerAutoShow() {
        return this.controllerAutoShow;
    }

    public void setControllerAutoShow(boolean controllerAutoShow) {
        this.controllerAutoShow = controllerAutoShow;
    }

    public void setControllerHideDuringAds(boolean controllerHideDuringAds) {
        this.controllerHideDuringAds = controllerHideDuringAds;
    }

    public void setControllerVisibilityListener(@Nullable PlayerControlView.VisibilityListener listener) {
        Assertions.checkStateNotNull((Object)((Object)this.controller));
        if (this.controllerVisibilityListener == listener) {
            return;
        }
        if (this.controllerVisibilityListener != null) {
            this.controller.removeVisibilityListener(this.controllerVisibilityListener);
        }
        this.controllerVisibilityListener = listener;
        if (listener != null) {
            this.controller.addVisibilityListener(listener);
        }
    }

    public void setShowRewindButton(boolean showRewindButton) {
        Assertions.checkStateNotNull((Object)((Object)this.controller));
        this.controller.setShowRewindButton(showRewindButton);
    }

    public void setShowFastForwardButton(boolean showFastForwardButton) {
        Assertions.checkStateNotNull((Object)((Object)this.controller));
        this.controller.setShowFastForwardButton(showFastForwardButton);
    }

    public void setShowPreviousButton(boolean showPreviousButton) {
        Assertions.checkStateNotNull((Object)((Object)this.controller));
        this.controller.setShowPreviousButton(showPreviousButton);
    }

    public void setShowNextButton(boolean showNextButton) {
        Assertions.checkStateNotNull((Object)((Object)this.controller));
        this.controller.setShowNextButton(showNextButton);
    }

    public void setRepeatToggleModes(int repeatToggleModes) {
        Assertions.checkStateNotNull((Object)((Object)this.controller));
        this.controller.setRepeatToggleModes(repeatToggleModes);
    }

    public void setShowShuffleButton(boolean showShuffleButton) {
        Assertions.checkStateNotNull((Object)((Object)this.controller));
        this.controller.setShowShuffleButton(showShuffleButton);
    }

    public void setShowMultiWindowTimeBar(boolean showMultiWindowTimeBar) {
        Assertions.checkStateNotNull((Object)((Object)this.controller));
        this.controller.setShowMultiWindowTimeBar(showMultiWindowTimeBar);
    }

    public void setExtraAdGroupMarkers(@Nullable long[] extraAdGroupTimesMs, @Nullable boolean[] extraPlayedAdGroups) {
        Assertions.checkStateNotNull((Object)((Object)this.controller));
        this.controller.setExtraAdGroupMarkers(extraAdGroupTimesMs, extraPlayedAdGroups);
    }

    public void setAspectRatioListener(@Nullable AspectRatioFrameLayout.AspectRatioListener listener) {
        Assertions.checkStateNotNull((Object)((Object)this.contentFrame));
        this.contentFrame.setAspectRatioListener(listener);
    }

    @Nullable
    public View getVideoSurfaceView() {
        return this.surfaceView;
    }

    @Nullable
    public FrameLayout getOverlayFrameLayout() {
        return this.overlayFrameLayout;
    }

    @Nullable
    public SubtitleView getSubtitleView() {
        return this.subtitleView;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.useController() || this.player == null) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.isTouching = true;
                return true;
            }
            case 1: {
                if (this.isTouching) {
                    this.isTouching = false;
                    this.performClick();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean performClick() {
        super.performClick();
        return this.toggleControllerVisibility();
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (!this.useController() || this.player == null) {
            return false;
        }
        this.maybeShowController(true);
        return true;
    }

    public void onResume() {
        if (this.surfaceView instanceof GLSurfaceView) {
            ((GLSurfaceView)this.surfaceView).onResume();
        }
    }

    public void onPause() {
        if (this.surfaceView instanceof GLSurfaceView) {
            ((GLSurfaceView)this.surfaceView).onPause();
        }
    }

    protected void onContentAspectRatioChanged(@Nullable AspectRatioFrameLayout contentFrame, float aspectRatio) {
        if (contentFrame != null) {
            contentFrame.setAspectRatio(aspectRatio);
        }
    }

    public ViewGroup getAdViewGroup() {
        return (ViewGroup)Assertions.checkStateNotNull((Object)this.adOverlayFrameLayout, (Object)"exo_ad_overlay must be present for ad playback");
    }

    public List<AdOverlayInfo> getAdOverlayInfos() {
        ArrayList<AdOverlayInfo> overlayViews = new ArrayList<AdOverlayInfo>();
        if (this.overlayFrameLayout != null) {
            overlayViews.add(new AdOverlayInfo((View)this.overlayFrameLayout, 3, "Transparent overlay does not impact viewability"));
        }
        if (this.controller != null) {
            overlayViews.add(new AdOverlayInfo((View)this.controller, 0));
        }
        return ImmutableList.copyOf(overlayViews);
    }

    @EnsuresNonNullIf(expression={"controller"}, result=true)
    private boolean useController() {
        if (this.useController) {
            Assertions.checkStateNotNull((Object)((Object)this.controller));
            return true;
        }
        return false;
    }

    @EnsuresNonNullIf(expression={"artworkView"}, result=true)
    private boolean useArtwork() {
        if (this.useArtwork) {
            Assertions.checkStateNotNull((Object)this.artworkView);
            return true;
        }
        return false;
    }

    private boolean toggleControllerVisibility() {
        if (!this.useController() || this.player == null) {
            return false;
        }
        if (!this.controller.isVisible()) {
            this.maybeShowController(true);
        } else if (this.controllerHideOnTouch) {
            this.controller.hide();
        }
        return true;
    }

    private void maybeShowController(boolean isForced) {
        if (this.isPlayingAd() && this.controllerHideDuringAds) {
            return;
        }
        if (this.useController()) {
            boolean wasShowingIndefinitely = this.controller.isVisible() && this.controller.getShowTimeoutMs() <= 0;
            boolean shouldShowIndefinitely = this.shouldShowControllerIndefinitely();
            if (isForced || wasShowingIndefinitely || shouldShowIndefinitely) {
                this.showController(shouldShowIndefinitely);
            }
        }
    }

    private boolean shouldShowControllerIndefinitely() {
        if (this.player == null) {
            return true;
        }
        int playbackState = this.player.getPlaybackState();
        return this.controllerAutoShow && (playbackState == 1 || playbackState == 4 || !this.player.getPlayWhenReady());
    }

    private void showController(boolean showIndefinitely) {
        if (!this.useController()) {
            return;
        }
        this.controller.setShowTimeoutMs(showIndefinitely ? 0 : this.controllerShowTimeoutMs);
        this.controller.show();
    }

    private boolean isPlayingAd() {
        return this.player != null && this.player.isPlayingAd() && this.player.getPlayWhenReady();
    }

    private void updateForCurrentTrackSelections(boolean isNewPlayer) {
        Player player = this.player;
        if (player == null || !player.isCommandAvailable(30) || player.getCurrentTracksInfo().getTrackGroupInfos().isEmpty()) {
            if (!this.keepContentOnPlayerReset) {
                this.hideArtwork();
                this.closeShutter();
            }
            return;
        }
        if (isNewPlayer && !this.keepContentOnPlayerReset) {
            this.closeShutter();
        }
        if (player.getCurrentTracksInfo().isTypeSelected(2)) {
            this.hideArtwork();
            return;
        }
        this.closeShutter();
        if (this.useArtwork()) {
            if (this.setArtworkFromMediaMetadata(player.getMediaMetadata())) {
                return;
            }
            if (this.setDrawableArtwork(this.defaultArtwork)) {
                return;
            }
        }
        this.hideArtwork();
    }

    private void updateAspectRatio() {
        float videoAspectRatio;
        VideoSize videoSize = this.player != null ? this.player.getVideoSize() : VideoSize.UNKNOWN;
        int width = videoSize.width;
        int height = videoSize.height;
        int unappliedRotationDegrees = videoSize.unappliedRotationDegrees;
        float f = videoAspectRatio = height == 0 || width == 0 ? 0.0f : (float)width * videoSize.pixelWidthHeightRatio / (float)height;
        if (this.surfaceView instanceof TextureView) {
            if (videoAspectRatio > 0.0f && (unappliedRotationDegrees == 90 || unappliedRotationDegrees == 270)) {
                videoAspectRatio = 1.0f / videoAspectRatio;
            }
            if (this.textureViewRotation != 0) {
                this.surfaceView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.componentListener);
            }
            this.textureViewRotation = unappliedRotationDegrees;
            if (this.textureViewRotation != 0) {
                this.surfaceView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.componentListener);
            }
            PlayerView.applyTextureViewRotation((TextureView)this.surfaceView, this.textureViewRotation);
        }
        this.onContentAspectRatioChanged(this.contentFrame, this.surfaceViewIgnoresVideoAspectRatio ? 0.0f : videoAspectRatio);
    }

    @RequiresNonNull(value={"artworkView"})
    private boolean setArtworkFromMediaMetadata(MediaMetadata mediaMetadata) {
        if (mediaMetadata.artworkData == null) {
            return false;
        }
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])mediaMetadata.artworkData, (int)0, (int)mediaMetadata.artworkData.length);
        return this.setDrawableArtwork((Drawable)new BitmapDrawable(this.getResources(), bitmap));
    }

    @RequiresNonNull(value={"artworkView"})
    private boolean setDrawableArtwork(@Nullable Drawable drawable2) {
        if (drawable2 != null) {
            int drawableWidth = drawable2.getIntrinsicWidth();
            int drawableHeight = drawable2.getIntrinsicHeight();
            if (drawableWidth > 0 && drawableHeight > 0) {
                float artworkAspectRatio = (float)drawableWidth / (float)drawableHeight;
                this.onContentAspectRatioChanged(this.contentFrame, artworkAspectRatio);
                this.artworkView.setImageDrawable(drawable2);
                this.artworkView.setVisibility(0);
                return true;
            }
        }
        return false;
    }

    private void hideArtwork() {
        if (this.artworkView != null) {
            this.artworkView.setImageResource(17170445);
            this.artworkView.setVisibility(4);
        }
    }

    private void closeShutter() {
        if (this.shutterView != null) {
            this.shutterView.setVisibility(0);
        }
    }

    private void updateBuffering() {
        if (this.bufferingView != null) {
            boolean showBufferingSpinner = this.player != null && this.player.getPlaybackState() == 2 && (this.showBuffering == 2 || this.showBuffering == 1 && this.player.getPlayWhenReady());
            this.bufferingView.setVisibility(showBufferingSpinner ? 0 : 8);
        }
    }

    private void updateErrorMessage() {
        if (this.errorMessageView != null) {
            PlaybackException error;
            if (this.customErrorMessage != null) {
                this.errorMessageView.setText(this.customErrorMessage);
                this.errorMessageView.setVisibility(0);
                return;
            }
            PlaybackException playbackException = error = this.player != null ? this.player.getPlayerError() : null;
            if (error != null && this.errorMessageProvider != null) {
                CharSequence errorMessage = (CharSequence)this.errorMessageProvider.getErrorMessage((Throwable)error).second;
                this.errorMessageView.setText(errorMessage);
                this.errorMessageView.setVisibility(0);
            } else {
                this.errorMessageView.setVisibility(8);
            }
        }
    }

    private void updateContentDescription() {
        if (this.controller == null || !this.useController) {
            this.setContentDescription(null);
        } else if (this.controller.getVisibility() == 0) {
            this.setContentDescription(this.controllerHideOnTouch ? this.getResources().getString(R.string.exo_controls_hide) : null);
        } else {
            this.setContentDescription(this.getResources().getString(R.string.exo_controls_show));
        }
    }

    private void updateControllerVisibility() {
        if (this.isPlayingAd() && this.controllerHideDuringAds) {
            this.hideController();
        } else {
            this.maybeShowController(false);
        }
    }

    @RequiresApi(value=23)
    private static void configureEditModeLogoV23(Resources resources, ImageView logo) {
        logo.setImageDrawable(resources.getDrawable(R.drawable.exo_edit_mode_logo, null));
        logo.setBackgroundColor(resources.getColor(R.color.exo_edit_mode_background_color, null));
    }

    private static void configureEditModeLogo(Resources resources, ImageView logo) {
        logo.setImageDrawable(resources.getDrawable(R.drawable.exo_edit_mode_logo));
        logo.setBackgroundColor(resources.getColor(R.color.exo_edit_mode_background_color));
    }

    private static void setResizeModeRaw(AspectRatioFrameLayout aspectRatioFrame, int resizeMode) {
        aspectRatioFrame.setResizeMode(resizeMode);
    }

    private static void applyTextureViewRotation(TextureView textureView, int textureViewRotation) {
        Matrix transformMatrix = new Matrix();
        float textureViewWidth = textureView.getWidth();
        float textureViewHeight = textureView.getHeight();
        if (textureViewWidth != 0.0f && textureViewHeight != 0.0f && textureViewRotation != 0) {
            float pivotX = textureViewWidth / 2.0f;
            float pivotY = textureViewHeight / 2.0f;
            transformMatrix.postRotate((float)textureViewRotation, pivotX, pivotY);
            RectF originalTextureRect = new RectF(0.0f, 0.0f, textureViewWidth, textureViewHeight);
            RectF rotatedTextureRect = new RectF();
            transformMatrix.mapRect(rotatedTextureRect, originalTextureRect);
            transformMatrix.postScale(textureViewWidth / rotatedTextureRect.width(), textureViewHeight / rotatedTextureRect.height(), pivotX, pivotY);
        }
        textureView.setTransform(transformMatrix);
    }

    @SuppressLint(value={"InlinedApi"})
    private boolean isDpadKey(int keyCode) {
        return keyCode == 19 || keyCode == 270 || keyCode == 22 || keyCode == 271 || keyCode == 20 || keyCode == 269 || keyCode == 21 || keyCode == 268 || keyCode == 23;
    }

    private final class ComponentListener
    implements Player.Listener,
    View.OnLayoutChangeListener,
    View.OnClickListener,
    PlayerControlView.VisibilityListener {
        private final Timeline.Period period = new Timeline.Period();
        @Nullable
        private Object lastPeriodUidWithTracks;

        public void onCues(List<Cue> cues) {
            if (PlayerView.this.subtitleView != null) {
                PlayerView.this.subtitleView.setCues(cues);
            }
        }

        public void onVideoSizeChanged(VideoSize videoSize) {
            PlayerView.this.updateAspectRatio();
        }

        public void onRenderedFirstFrame() {
            if (PlayerView.this.shutterView != null) {
                PlayerView.this.shutterView.setVisibility(4);
            }
        }

        public void onTracksInfoChanged(TracksInfo tracksInfo) {
            Player player = (Player)Assertions.checkNotNull((Object)PlayerView.this.player);
            Timeline timeline = player.getCurrentTimeline();
            if (timeline.isEmpty()) {
                this.lastPeriodUidWithTracks = null;
            } else if (!player.getCurrentTracksInfo().getTrackGroupInfos().isEmpty()) {
                this.lastPeriodUidWithTracks = timeline.getPeriod((int)player.getCurrentPeriodIndex(), (Timeline.Period)this.period, (boolean)true).uid;
            } else if (this.lastPeriodUidWithTracks != null) {
                int lastPeriodIndexWithTracks = timeline.getIndexOfPeriod(this.lastPeriodUidWithTracks);
                if (lastPeriodIndexWithTracks != -1) {
                    int lastWindowIndexWithTracks = timeline.getPeriod((int)lastPeriodIndexWithTracks, (Timeline.Period)this.period).windowIndex;
                    if (player.getCurrentMediaItemIndex() == lastWindowIndexWithTracks) {
                        return;
                    }
                }
                this.lastPeriodUidWithTracks = null;
            }
            PlayerView.this.updateForCurrentTrackSelections(false);
        }

        public void onPlaybackStateChanged(int playbackState) {
            PlayerView.this.updateBuffering();
            PlayerView.this.updateErrorMessage();
            PlayerView.this.updateControllerVisibility();
        }

        public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
            PlayerView.this.updateBuffering();
            PlayerView.this.updateControllerVisibility();
        }

        public void onPositionDiscontinuity(Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
            if (PlayerView.this.isPlayingAd() && PlayerView.this.controllerHideDuringAds) {
                PlayerView.this.hideController();
            }
        }

        public void onLayoutChange(View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            PlayerView.applyTextureViewRotation((TextureView)view, PlayerView.this.textureViewRotation);
        }

        public void onClick(View view) {
            PlayerView.this.toggleControllerVisibility();
        }

        @Override
        public void onVisibilityChange(int visibility) {
            PlayerView.this.updateContentDescription();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowBuffering {
    }
}

