/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.ForwardingPlayer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.TracksInfo;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.trackselection.TrackSelectionOverrides;
import com.google.android.exoplayer2.trackselection.TrackSelectionParameters;
import com.google.android.exoplayer2.ui.DefaultTimeBar;
import com.google.android.exoplayer2.ui.DefaultTrackNameProvider;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.StyledPlayerControlViewLayoutManager;
import com.google.android.exoplayer2.ui.TimeBar;
import com.google.android.exoplayer2.ui.TrackNameProvider;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.RepeatModeUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.checkerframework.dataflow.qual.Pure;

public class StyledPlayerControlView
extends FrameLayout {
    public static final int DEFAULT_SHOW_TIMEOUT_MS = 5000;
    public static final int DEFAULT_REPEAT_TOGGLE_MODES = 0;
    public static final int DEFAULT_TIME_BAR_MIN_UPDATE_INTERVAL_MS = 200;
    public static final int MAX_WINDOWS_FOR_MULTI_WINDOW_TIME_BAR = 100;
    private static final int MAX_UPDATE_INTERVAL_MS = 1000;
    private static final int SETTINGS_PLAYBACK_SPEED_POSITION = 0;
    private static final int SETTINGS_AUDIO_TRACK_SELECTION_POSITION = 1;
    private final ComponentListener componentListener;
    private final CopyOnWriteArrayList<VisibilityListener> visibilityListeners;
    @Nullable
    private final View previousButton;
    @Nullable
    private final View nextButton;
    @Nullable
    private final View playPauseButton;
    @Nullable
    private final View fastForwardButton;
    @Nullable
    private final View rewindButton;
    @Nullable
    private final TextView fastForwardButtonTextView;
    @Nullable
    private final TextView rewindButtonTextView;
    @Nullable
    private final ImageView repeatToggleButton;
    @Nullable
    private final ImageView shuffleButton;
    @Nullable
    private final View vrButton;
    @Nullable
    private final TextView durationView;
    @Nullable
    private final TextView positionView;
    @Nullable
    private final TimeBar timeBar;
    private final StringBuilder formatBuilder;
    private final Formatter formatter;
    private final Timeline.Period period;
    private final Timeline.Window window;
    private final Runnable updateProgressAction;
    private final Drawable repeatOffButtonDrawable;
    private final Drawable repeatOneButtonDrawable;
    private final Drawable repeatAllButtonDrawable;
    private final String repeatOffButtonContentDescription;
    private final String repeatOneButtonContentDescription;
    private final String repeatAllButtonContentDescription;
    private final Drawable shuffleOnButtonDrawable;
    private final Drawable shuffleOffButtonDrawable;
    private final float buttonAlphaEnabled;
    private final float buttonAlphaDisabled;
    private final String shuffleOnContentDescription;
    private final String shuffleOffContentDescription;
    private final Drawable subtitleOnButtonDrawable;
    private final Drawable subtitleOffButtonDrawable;
    private final String subtitleOnContentDescription;
    private final String subtitleOffContentDescription;
    private final Drawable fullScreenExitDrawable;
    private final Drawable fullScreenEnterDrawable;
    private final String fullScreenExitContentDescription;
    private final String fullScreenEnterContentDescription;
    @Nullable
    private Player player;
    @Nullable
    private ProgressUpdateListener progressUpdateListener;
    @Nullable
    private OnFullScreenModeChangedListener onFullScreenModeChangedListener;
    private boolean isFullScreen;
    private boolean isAttachedToWindow;
    private boolean showMultiWindowTimeBar;
    private boolean multiWindowTimeBar;
    private boolean scrubbing;
    private int showTimeoutMs;
    private int timeBarMinUpdateIntervalMs;
    private int repeatToggleModes;
    private long[] adGroupTimesMs;
    private boolean[] playedAdGroups;
    private long[] extraAdGroupTimesMs;
    private boolean[] extraPlayedAdGroups;
    private long currentWindowOffset;
    private StyledPlayerControlViewLayoutManager controlViewLayoutManager;
    private Resources resources;
    private RecyclerView settingsView;
    private SettingsAdapter settingsAdapter;
    private PlaybackSpeedAdapter playbackSpeedAdapter;
    private PopupWindow settingsWindow;
    private boolean needToHideBars;
    private int settingsWindowMargin;
    private TextTrackSelectionAdapter textTrackSelectionAdapter;
    private AudioTrackSelectionAdapter audioTrackSelectionAdapter;
    private TrackNameProvider trackNameProvider;
    @Nullable
    private ImageView subtitleButton;
    @Nullable
    private ImageView fullScreenButton;
    @Nullable
    private ImageView minimalFullScreenButton;
    @Nullable
    private View settingsButton;
    @Nullable
    private View playbackSpeedButton;
    @Nullable
    private View audioTrackButton;

    public StyledPlayerControlView(Context context) {
        this(context, null);
    }

    public StyledPlayerControlView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StyledPlayerControlView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyledPlayerControlView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, @Nullable AttributeSet playbackAttrs) {
        super(context, attrs, defStyleAttr);
        View ffwdButton;
        int controllerLayoutId = R.layout.exo_styled_player_control_view;
        this.showTimeoutMs = 5000;
        this.repeatToggleModes = 0;
        this.timeBarMinUpdateIntervalMs = 200;
        boolean showRewindButton = true;
        boolean showFastForwardButton = true;
        boolean showPreviousButton = true;
        boolean showNextButton = true;
        boolean showShuffleButton = false;
        boolean showSubtitleButton = false;
        boolean animationEnabled = true;
        boolean showVrButton = false;
        if (playbackAttrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(playbackAttrs, R.styleable.StyledPlayerControlView, defStyleAttr, 0);
            try {
                controllerLayoutId = a.getResourceId(R.styleable.StyledPlayerControlView_controller_layout_id, controllerLayoutId);
                this.showTimeoutMs = a.getInt(R.styleable.StyledPlayerControlView_show_timeout, this.showTimeoutMs);
                this.repeatToggleModes = StyledPlayerControlView.getRepeatToggleModes(a, this.repeatToggleModes);
                showRewindButton = a.getBoolean(R.styleable.StyledPlayerControlView_show_rewind_button, showRewindButton);
                showFastForwardButton = a.getBoolean(R.styleable.StyledPlayerControlView_show_fastforward_button, showFastForwardButton);
                showPreviousButton = a.getBoolean(R.styleable.StyledPlayerControlView_show_previous_button, showPreviousButton);
                showNextButton = a.getBoolean(R.styleable.StyledPlayerControlView_show_next_button, showNextButton);
                showShuffleButton = a.getBoolean(R.styleable.StyledPlayerControlView_show_shuffle_button, showShuffleButton);
                showSubtitleButton = a.getBoolean(R.styleable.StyledPlayerControlView_show_subtitle_button, showSubtitleButton);
                showVrButton = a.getBoolean(R.styleable.StyledPlayerControlView_show_vr_button, showVrButton);
                this.setTimeBarMinUpdateInterval(a.getInt(R.styleable.StyledPlayerControlView_time_bar_min_update_interval, this.timeBarMinUpdateIntervalMs));
                animationEnabled = a.getBoolean(R.styleable.StyledPlayerControlView_animation_enabled, animationEnabled);
            }
            finally {
                a.recycle();
            }
        }
        LayoutInflater.from((Context)context).inflate(controllerLayoutId, (ViewGroup)this);
        this.setDescendantFocusability(262144);
        this.componentListener = new ComponentListener();
        this.visibilityListeners = new CopyOnWriteArrayList();
        this.period = new Timeline.Period();
        this.window = new Timeline.Window();
        this.formatBuilder = new StringBuilder();
        this.formatter = new Formatter(this.formatBuilder, Locale.getDefault());
        this.adGroupTimesMs = new long[0];
        this.playedAdGroups = new boolean[0];
        this.extraAdGroupTimesMs = new long[0];
        this.extraPlayedAdGroups = new boolean[0];
        this.updateProgressAction = this::updateProgress;
        this.durationView = (TextView)this.findViewById(R.id.exo_duration);
        this.positionView = (TextView)this.findViewById(R.id.exo_position);
        this.subtitleButton = (ImageView)this.findViewById(R.id.exo_subtitle);
        if (this.subtitleButton != null) {
            this.subtitleButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.fullScreenButton = (ImageView)this.findViewById(R.id.exo_fullscreen);
        StyledPlayerControlView.initializeFullScreenButton((View)this.fullScreenButton, this::onFullScreenButtonClicked);
        this.minimalFullScreenButton = (ImageView)this.findViewById(R.id.exo_minimal_fullscreen);
        StyledPlayerControlView.initializeFullScreenButton((View)this.minimalFullScreenButton, this::onFullScreenButtonClicked);
        this.settingsButton = this.findViewById(R.id.exo_settings);
        if (this.settingsButton != null) {
            this.settingsButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.playbackSpeedButton = this.findViewById(R.id.exo_playback_speed);
        if (this.playbackSpeedButton != null) {
            this.playbackSpeedButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.audioTrackButton = this.findViewById(R.id.exo_audio_track);
        if (this.audioTrackButton != null) {
            this.audioTrackButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        TimeBar customTimeBar = (TimeBar)this.findViewById(R.id.exo_progress);
        View timeBarPlaceholder = this.findViewById(R.id.exo_progress_placeholder);
        if (customTimeBar != null) {
            this.timeBar = customTimeBar;
        } else if (timeBarPlaceholder != null) {
            DefaultTimeBar defaultTimeBar = new DefaultTimeBar(context, null, 0, playbackAttrs, R.style.ExoStyledControls_TimeBar);
            defaultTimeBar.setId(R.id.exo_progress);
            defaultTimeBar.setLayoutParams(timeBarPlaceholder.getLayoutParams());
            ViewGroup parent = (ViewGroup)timeBarPlaceholder.getParent();
            int timeBarIndex = parent.indexOfChild(timeBarPlaceholder);
            parent.removeView(timeBarPlaceholder);
            parent.addView((View)defaultTimeBar, timeBarIndex);
            this.timeBar = defaultTimeBar;
        } else {
            this.timeBar = null;
        }
        if (this.timeBar != null) {
            this.timeBar.addListener(this.componentListener);
        }
        this.playPauseButton = this.findViewById(R.id.exo_play_pause);
        if (this.playPauseButton != null) {
            this.playPauseButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.previousButton = this.findViewById(R.id.exo_prev);
        if (this.previousButton != null) {
            this.previousButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.nextButton = this.findViewById(R.id.exo_next);
        if (this.nextButton != null) {
            this.nextButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        Typeface typeface = ResourcesCompat.getFont((Context)context, (int)R.font.roboto_medium_numbers);
        View rewButton = this.findViewById(R.id.exo_rew);
        TextView textView = this.rewindButtonTextView = rewButton == null ? (TextView)this.findViewById(R.id.exo_rew_with_amount) : null;
        if (this.rewindButtonTextView != null) {
            this.rewindButtonTextView.setTypeface(typeface);
        }
        Object object = this.rewindButton = rewButton == null ? this.rewindButtonTextView : rewButton;
        if (this.rewindButton != null) {
            this.rewindButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        TextView textView2 = this.fastForwardButtonTextView = (ffwdButton = this.findViewById(R.id.exo_ffwd)) == null ? (TextView)this.findViewById(R.id.exo_ffwd_with_amount) : null;
        if (this.fastForwardButtonTextView != null) {
            this.fastForwardButtonTextView.setTypeface(typeface);
        }
        Object object2 = this.fastForwardButton = ffwdButton == null ? this.fastForwardButtonTextView : ffwdButton;
        if (this.fastForwardButton != null) {
            this.fastForwardButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.repeatToggleButton = (ImageView)this.findViewById(R.id.exo_repeat_toggle);
        if (this.repeatToggleButton != null) {
            this.repeatToggleButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.shuffleButton = (ImageView)this.findViewById(R.id.exo_shuffle);
        if (this.shuffleButton != null) {
            this.shuffleButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.resources = context.getResources();
        this.buttonAlphaEnabled = (float)this.resources.getInteger(R.integer.exo_media_button_opacity_percentage_enabled) / 100.0f;
        this.buttonAlphaDisabled = (float)this.resources.getInteger(R.integer.exo_media_button_opacity_percentage_disabled) / 100.0f;
        this.vrButton = this.findViewById(R.id.exo_vr);
        if (this.vrButton != null) {
            this.updateButton(false, this.vrButton);
        }
        this.controlViewLayoutManager = new StyledPlayerControlViewLayoutManager(this);
        this.controlViewLayoutManager.setAnimationEnabled(animationEnabled);
        String[] settingTexts = new String[2];
        Drawable[] settingIcons = new Drawable[2];
        settingTexts[0] = this.resources.getString(R.string.exo_controls_playback_speed);
        settingIcons[0] = this.resources.getDrawable(R.drawable.exo_styled_controls_speed);
        settingTexts[1] = this.resources.getString(R.string.exo_track_selection_title_audio);
        settingIcons[1] = this.resources.getDrawable(R.drawable.exo_styled_controls_audiotrack);
        this.settingsAdapter = new SettingsAdapter(settingTexts, settingIcons);
        this.settingsWindowMargin = this.resources.getDimensionPixelSize(R.dimen.exo_settings_offset);
        this.settingsView = (RecyclerView)LayoutInflater.from((Context)context).inflate(R.layout.exo_styled_settings_list, null);
        this.settingsView.setAdapter((RecyclerView.Adapter)this.settingsAdapter);
        this.settingsView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.settingsWindow = new PopupWindow((View)this.settingsView, -2, -2, true);
        if (Util.SDK_INT < 23) {
            this.settingsWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        this.settingsWindow.setOnDismissListener((PopupWindow.OnDismissListener)this.componentListener);
        this.needToHideBars = true;
        this.trackNameProvider = new DefaultTrackNameProvider(this.getResources());
        this.subtitleOnButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_subtitle_on);
        this.subtitleOffButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_subtitle_off);
        this.subtitleOnContentDescription = this.resources.getString(R.string.exo_controls_cc_enabled_description);
        this.subtitleOffContentDescription = this.resources.getString(R.string.exo_controls_cc_disabled_description);
        this.textTrackSelectionAdapter = new TextTrackSelectionAdapter();
        this.audioTrackSelectionAdapter = new AudioTrackSelectionAdapter();
        this.playbackSpeedAdapter = new PlaybackSpeedAdapter(this.resources.getStringArray(R.array.exo_playback_speeds), this.resources.getIntArray(R.array.exo_speed_multiplied_by_100));
        this.fullScreenExitDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_fullscreen_exit);
        this.fullScreenEnterDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_fullscreen_enter);
        this.repeatOffButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_repeat_off);
        this.repeatOneButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_repeat_one);
        this.repeatAllButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_repeat_all);
        this.shuffleOnButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_shuffle_on);
        this.shuffleOffButtonDrawable = this.resources.getDrawable(R.drawable.exo_styled_controls_shuffle_off);
        this.fullScreenExitContentDescription = this.resources.getString(R.string.exo_controls_fullscreen_exit_description);
        this.fullScreenEnterContentDescription = this.resources.getString(R.string.exo_controls_fullscreen_enter_description);
        this.repeatOffButtonContentDescription = this.resources.getString(R.string.exo_controls_repeat_off_description);
        this.repeatOneButtonContentDescription = this.resources.getString(R.string.exo_controls_repeat_one_description);
        this.repeatAllButtonContentDescription = this.resources.getString(R.string.exo_controls_repeat_all_description);
        this.shuffleOnContentDescription = this.resources.getString(R.string.exo_controls_shuffle_on_description);
        this.shuffleOffContentDescription = this.resources.getString(R.string.exo_controls_shuffle_off_description);
        ViewGroup bottomBar = (ViewGroup)this.findViewById(R.id.exo_bottom_bar);
        this.controlViewLayoutManager.setShowButton((View)bottomBar, true);
        this.controlViewLayoutManager.setShowButton(this.fastForwardButton, showFastForwardButton);
        this.controlViewLayoutManager.setShowButton(this.rewindButton, showRewindButton);
        this.controlViewLayoutManager.setShowButton(this.previousButton, showPreviousButton);
        this.controlViewLayoutManager.setShowButton(this.nextButton, showNextButton);
        this.controlViewLayoutManager.setShowButton((View)this.shuffleButton, showShuffleButton);
        this.controlViewLayoutManager.setShowButton((View)this.subtitleButton, showSubtitleButton);
        this.controlViewLayoutManager.setShowButton(this.vrButton, showVrButton);
        this.controlViewLayoutManager.setShowButton((View)this.repeatToggleButton, this.repeatToggleModes != 0);
        this.addOnLayoutChangeListener(this::onLayoutChange);
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(@Nullable Player player) {
        Assertions.checkState((Looper.myLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        Assertions.checkArgument((player == null || player.getApplicationLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        if (this.player == player) {
            return;
        }
        if (this.player != null) {
            this.player.removeListener((Player.Listener)this.componentListener);
        }
        this.player = player;
        if (player != null) {
            player.addListener((Player.Listener)this.componentListener);
        }
        if (player instanceof ForwardingPlayer) {
            player = ((ForwardingPlayer)player).getWrappedPlayer();
        }
        this.updateAll();
    }

    public void setShowMultiWindowTimeBar(boolean showMultiWindowTimeBar) {
        this.showMultiWindowTimeBar = showMultiWindowTimeBar;
        this.updateTimeline();
    }

    public void setExtraAdGroupMarkers(@Nullable long[] extraAdGroupTimesMs, @Nullable boolean[] extraPlayedAdGroups) {
        if (extraAdGroupTimesMs == null) {
            this.extraAdGroupTimesMs = new long[0];
            this.extraPlayedAdGroups = new boolean[0];
        } else {
            Assertions.checkArgument((extraAdGroupTimesMs.length == (extraPlayedAdGroups = (boolean[])Assertions.checkNotNull((Object)extraPlayedAdGroups)).length ? 1 : 0) != 0);
            this.extraAdGroupTimesMs = extraAdGroupTimesMs;
            this.extraPlayedAdGroups = extraPlayedAdGroups;
        }
        this.updateTimeline();
    }

    public void addVisibilityListener(VisibilityListener listener) {
        Assertions.checkNotNull((Object)listener);
        this.visibilityListeners.add(listener);
    }

    public void removeVisibilityListener(VisibilityListener listener) {
        this.visibilityListeners.remove(listener);
    }

    public void setProgressUpdateListener(@Nullable ProgressUpdateListener listener) {
        this.progressUpdateListener = listener;
    }

    public void setShowRewindButton(boolean showRewindButton) {
        this.controlViewLayoutManager.setShowButton(this.rewindButton, showRewindButton);
        this.updateNavigation();
    }

    public void setShowFastForwardButton(boolean showFastForwardButton) {
        this.controlViewLayoutManager.setShowButton(this.fastForwardButton, showFastForwardButton);
        this.updateNavigation();
    }

    public void setShowPreviousButton(boolean showPreviousButton) {
        this.controlViewLayoutManager.setShowButton(this.previousButton, showPreviousButton);
        this.updateNavigation();
    }

    public void setShowNextButton(boolean showNextButton) {
        this.controlViewLayoutManager.setShowButton(this.nextButton, showNextButton);
        this.updateNavigation();
    }

    public int getShowTimeoutMs() {
        return this.showTimeoutMs;
    }

    public void setShowTimeoutMs(int showTimeoutMs) {
        this.showTimeoutMs = showTimeoutMs;
        if (this.isFullyVisible()) {
            this.controlViewLayoutManager.resetHideCallbacks();
        }
    }

    public int getRepeatToggleModes() {
        return this.repeatToggleModes;
    }

    public void setRepeatToggleModes(int repeatToggleModes) {
        this.repeatToggleModes = repeatToggleModes;
        if (this.player != null) {
            int currentMode = this.player.getRepeatMode();
            if (repeatToggleModes == 0 && currentMode != 0) {
                this.player.setRepeatMode(0);
            } else if (repeatToggleModes == 1 && currentMode == 2) {
                this.player.setRepeatMode(1);
            } else if (repeatToggleModes == 2 && currentMode == 1) {
                this.player.setRepeatMode(2);
            }
        }
        this.controlViewLayoutManager.setShowButton((View)this.repeatToggleButton, repeatToggleModes != 0);
        this.updateRepeatModeButton();
    }

    public boolean getShowShuffleButton() {
        return this.controlViewLayoutManager.getShowButton((View)this.shuffleButton);
    }

    public void setShowShuffleButton(boolean showShuffleButton) {
        this.controlViewLayoutManager.setShowButton((View)this.shuffleButton, showShuffleButton);
        this.updateShuffleButton();
    }

    public boolean getShowSubtitleButton() {
        return this.controlViewLayoutManager.getShowButton((View)this.subtitleButton);
    }

    public void setShowSubtitleButton(boolean showSubtitleButton) {
        this.controlViewLayoutManager.setShowButton((View)this.subtitleButton, showSubtitleButton);
    }

    public boolean getShowVrButton() {
        return this.controlViewLayoutManager.getShowButton(this.vrButton);
    }

    public void setShowVrButton(boolean showVrButton) {
        this.controlViewLayoutManager.setShowButton(this.vrButton, showVrButton);
    }

    public void setVrButtonListener(@Nullable View.OnClickListener onClickListener) {
        if (this.vrButton != null) {
            this.vrButton.setOnClickListener(onClickListener);
            this.updateButton(onClickListener != null, this.vrButton);
        }
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        this.controlViewLayoutManager.setAnimationEnabled(animationEnabled);
    }

    public boolean isAnimationEnabled() {
        return this.controlViewLayoutManager.isAnimationEnabled();
    }

    public void setTimeBarMinUpdateInterval(int minUpdateIntervalMs) {
        this.timeBarMinUpdateIntervalMs = Util.constrainValue((int)minUpdateIntervalMs, (int)16, (int)1000);
    }

    public void setOnFullScreenModeChangedListener(@Nullable OnFullScreenModeChangedListener listener) {
        this.onFullScreenModeChangedListener = listener;
        StyledPlayerControlView.updateFullScreenButtonVisibility((View)this.fullScreenButton, listener != null);
        StyledPlayerControlView.updateFullScreenButtonVisibility((View)this.minimalFullScreenButton, listener != null);
    }

    public void show() {
        this.controlViewLayoutManager.show();
    }

    public void hide() {
        this.controlViewLayoutManager.hide();
    }

    public void hideImmediately() {
        this.controlViewLayoutManager.hideImmediately();
    }

    public boolean isFullyVisible() {
        return this.controlViewLayoutManager.isFullyVisible();
    }

    public boolean isVisible() {
        return this.getVisibility() == 0;
    }

    void notifyOnVisibilityChange() {
        for (VisibilityListener visibilityListener : this.visibilityListeners) {
            visibilityListener.onVisibilityChange(this.getVisibility());
        }
    }

    void updateAll() {
        this.updatePlayPauseButton();
        this.updateNavigation();
        this.updateRepeatModeButton();
        this.updateShuffleButton();
        this.updateTrackLists();
        this.updatePlaybackSpeedList();
        this.updateTimeline();
    }

    private void updatePlayPauseButton() {
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        if (this.playPauseButton != null) {
            if (this.shouldShowPauseButton()) {
                ((ImageView)this.playPauseButton).setImageDrawable(this.resources.getDrawable(R.drawable.exo_styled_controls_pause));
                this.playPauseButton.setContentDescription((CharSequence)this.resources.getString(R.string.exo_controls_pause_description));
            } else {
                ((ImageView)this.playPauseButton).setImageDrawable(this.resources.getDrawable(R.drawable.exo_styled_controls_play));
                this.playPauseButton.setContentDescription((CharSequence)this.resources.getString(R.string.exo_controls_play_description));
            }
        }
    }

    private void updateNavigation() {
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        Player player = this.player;
        boolean enableSeeking = false;
        boolean enablePrevious = false;
        boolean enableRewind = false;
        boolean enableFastForward = false;
        boolean enableNext = false;
        if (player != null) {
            enableSeeking = player.isCommandAvailable(5);
            enablePrevious = player.isCommandAvailable(7);
            enableRewind = player.isCommandAvailable(11);
            enableFastForward = player.isCommandAvailable(12);
            enableNext = player.isCommandAvailable(9);
        }
        if (enableRewind) {
            this.updateRewindButton();
        }
        if (enableFastForward) {
            this.updateFastForwardButton();
        }
        this.updateButton(enablePrevious, this.previousButton);
        this.updateButton(enableRewind, this.rewindButton);
        this.updateButton(enableFastForward, this.fastForwardButton);
        this.updateButton(enableNext, this.nextButton);
        if (this.timeBar != null) {
            this.timeBar.setEnabled(enableSeeking);
        }
    }

    private void updateRewindButton() {
        long rewindMs = this.player != null ? this.player.getSeekBackIncrement() : 5000L;
        int rewindSec = (int)(rewindMs / 1000L);
        if (this.rewindButtonTextView != null) {
            this.rewindButtonTextView.setText((CharSequence)String.valueOf(rewindSec));
        }
        if (this.rewindButton != null) {
            this.rewindButton.setContentDescription((CharSequence)this.resources.getQuantityString(R.plurals.exo_controls_rewind_by_amount_description, rewindSec, new Object[]{rewindSec}));
        }
    }

    private void updateFastForwardButton() {
        long fastForwardMs = this.player != null ? this.player.getSeekForwardIncrement() : 15000L;
        int fastForwardSec = (int)(fastForwardMs / 1000L);
        if (this.fastForwardButtonTextView != null) {
            this.fastForwardButtonTextView.setText((CharSequence)String.valueOf(fastForwardSec));
        }
        if (this.fastForwardButton != null) {
            this.fastForwardButton.setContentDescription((CharSequence)this.resources.getQuantityString(R.plurals.exo_controls_fastforward_by_amount_description, fastForwardSec, new Object[]{fastForwardSec}));
        }
    }

    private void updateRepeatModeButton() {
        if (!this.isVisible() || !this.isAttachedToWindow || this.repeatToggleButton == null) {
            return;
        }
        if (this.repeatToggleModes == 0) {
            this.updateButton(false, (View)this.repeatToggleButton);
            return;
        }
        Player player = this.player;
        if (player == null) {
            this.updateButton(false, (View)this.repeatToggleButton);
            this.repeatToggleButton.setImageDrawable(this.repeatOffButtonDrawable);
            this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOffButtonContentDescription);
            return;
        }
        this.updateButton(true, (View)this.repeatToggleButton);
        switch (player.getRepeatMode()) {
            case 0: {
                this.repeatToggleButton.setImageDrawable(this.repeatOffButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOffButtonContentDescription);
                break;
            }
            case 1: {
                this.repeatToggleButton.setImageDrawable(this.repeatOneButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOneButtonContentDescription);
                break;
            }
            case 2: {
                this.repeatToggleButton.setImageDrawable(this.repeatAllButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatAllButtonContentDescription);
                break;
            }
        }
    }

    private void updateShuffleButton() {
        if (!this.isVisible() || !this.isAttachedToWindow || this.shuffleButton == null) {
            return;
        }
        Player player = this.player;
        if (!this.controlViewLayoutManager.getShowButton((View)this.shuffleButton)) {
            this.updateButton(false, (View)this.shuffleButton);
        } else if (player == null) {
            this.updateButton(false, (View)this.shuffleButton);
            this.shuffleButton.setImageDrawable(this.shuffleOffButtonDrawable);
            this.shuffleButton.setContentDescription((CharSequence)this.shuffleOffContentDescription);
        } else {
            this.updateButton(true, (View)this.shuffleButton);
            this.shuffleButton.setImageDrawable(player.getShuffleModeEnabled() ? this.shuffleOnButtonDrawable : this.shuffleOffButtonDrawable);
            this.shuffleButton.setContentDescription((CharSequence)(player.getShuffleModeEnabled() ? this.shuffleOnContentDescription : this.shuffleOffContentDescription));
        }
    }

    private void updateTrackLists() {
        this.initTrackSelectionAdapter();
        this.updateButton(this.textTrackSelectionAdapter.getItemCount() > 0, (View)this.subtitleButton);
    }

    private void initTrackSelectionAdapter() {
        this.textTrackSelectionAdapter.clear();
        this.audioTrackSelectionAdapter.clear();
        if (this.player == null || !this.player.isCommandAvailable(30) || !this.player.isCommandAvailable(29)) {
            return;
        }
        TracksInfo tracksInfo = this.player.getCurrentTracksInfo();
        this.audioTrackSelectionAdapter.init((List<TrackInformation>)this.gatherSupportedTrackInfosOfType(tracksInfo, 1));
        if (this.controlViewLayoutManager.getShowButton((View)this.subtitleButton)) {
            this.textTrackSelectionAdapter.init((List<TrackInformation>)this.gatherSupportedTrackInfosOfType(tracksInfo, 3));
        } else {
            this.textTrackSelectionAdapter.init((List<TrackInformation>)ImmutableList.of());
        }
    }

    private ImmutableList<TrackInformation> gatherSupportedTrackInfosOfType(TracksInfo tracksInfo, int trackType) {
        ImmutableList.Builder tracks = new ImmutableList.Builder();
        ImmutableList trackGroupInfos = tracksInfo.getTrackGroupInfos();
        for (int trackGroupIndex = 0; trackGroupIndex < trackGroupInfos.size(); ++trackGroupIndex) {
            TracksInfo.TrackGroupInfo trackGroupInfo = (TracksInfo.TrackGroupInfo)trackGroupInfos.get(trackGroupIndex);
            if (trackGroupInfo.getTrackType() != trackType) continue;
            TrackGroup trackGroup = trackGroupInfo.getTrackGroup();
            for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                if (!trackGroupInfo.isTrackSupported(trackIndex)) continue;
                String trackName = this.trackNameProvider.getTrackName(trackGroup.getFormat(trackIndex));
                tracks.add((Object)new TrackInformation(tracksInfo, trackGroupIndex, trackIndex, trackName));
            }
        }
        return tracks.build();
    }

    private void updateTimeline() {
        Player player = this.player;
        if (player == null) {
            return;
        }
        this.multiWindowTimeBar = this.showMultiWindowTimeBar && StyledPlayerControlView.canShowMultiWindowTimeBar(player.getCurrentTimeline(), this.window);
        this.currentWindowOffset = 0L;
        long durationUs = 0L;
        int adGroupCount = 0;
        Timeline timeline = player.getCurrentTimeline();
        if (!timeline.isEmpty()) {
            int currentWindowIndex = player.getCurrentMediaItemIndex();
            int firstWindowIndex = this.multiWindowTimeBar ? 0 : currentWindowIndex;
            int lastWindowIndex = this.multiWindowTimeBar ? timeline.getWindowCount() - 1 : currentWindowIndex;
            for (int i = firstWindowIndex; i <= lastWindowIndex; ++i) {
                if (i == currentWindowIndex) {
                    this.currentWindowOffset = Util.usToMs((long)durationUs);
                }
                timeline.getWindow(i, this.window);
                if (this.window.durationUs == -9223372036854775807L) {
                    Assertions.checkState((!this.multiWindowTimeBar ? 1 : 0) != 0);
                    break;
                }
                for (int j = this.window.firstPeriodIndex; j <= this.window.lastPeriodIndex; ++j) {
                    timeline.getPeriod(j, this.period);
                    int removedGroups = this.period.getRemovedAdGroupCount();
                    int totalGroups = this.period.getAdGroupCount();
                    for (int adGroupIndex = removedGroups; adGroupIndex < totalGroups; ++adGroupIndex) {
                        long adGroupTimeInWindowUs;
                        long adGroupTimeInPeriodUs = this.period.getAdGroupTimeUs(adGroupIndex);
                        if (adGroupTimeInPeriodUs == Long.MIN_VALUE) {
                            if (this.period.durationUs == -9223372036854775807L) continue;
                            adGroupTimeInPeriodUs = this.period.durationUs;
                        }
                        if ((adGroupTimeInWindowUs = adGroupTimeInPeriodUs + this.period.getPositionInWindowUs()) < 0L) continue;
                        if (adGroupCount == this.adGroupTimesMs.length) {
                            int newLength = this.adGroupTimesMs.length == 0 ? 1 : this.adGroupTimesMs.length * 2;
                            this.adGroupTimesMs = Arrays.copyOf(this.adGroupTimesMs, newLength);
                            this.playedAdGroups = Arrays.copyOf(this.playedAdGroups, newLength);
                        }
                        this.adGroupTimesMs[adGroupCount] = Util.usToMs((long)(durationUs + adGroupTimeInWindowUs));
                        this.playedAdGroups[adGroupCount] = this.period.hasPlayedAdGroup(adGroupIndex);
                        ++adGroupCount;
                    }
                }
                durationUs += this.window.durationUs;
            }
        }
        long durationMs = Util.usToMs((long)durationUs);
        if (this.durationView != null) {
            this.durationView.setText((CharSequence)Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)durationMs));
        }
        if (this.timeBar != null) {
            this.timeBar.setDuration(durationMs);
            int extraAdGroupCount = this.extraAdGroupTimesMs.length;
            int totalAdGroupCount = adGroupCount + extraAdGroupCount;
            if (totalAdGroupCount > this.adGroupTimesMs.length) {
                this.adGroupTimesMs = Arrays.copyOf(this.adGroupTimesMs, totalAdGroupCount);
                this.playedAdGroups = Arrays.copyOf(this.playedAdGroups, totalAdGroupCount);
            }
            System.arraycopy(this.extraAdGroupTimesMs, 0, this.adGroupTimesMs, adGroupCount, extraAdGroupCount);
            System.arraycopy(this.extraPlayedAdGroups, 0, this.playedAdGroups, adGroupCount, extraAdGroupCount);
            this.timeBar.setAdGroupTimesMs(this.adGroupTimesMs, this.playedAdGroups, totalAdGroupCount);
        }
        this.updateProgress();
    }

    private void updateProgress() {
        int playbackState;
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        Player player = this.player;
        long position = 0L;
        long bufferedPosition = 0L;
        if (player != null) {
            position = this.currentWindowOffset + player.getContentPosition();
            bufferedPosition = this.currentWindowOffset + player.getContentBufferedPosition();
        }
        if (this.positionView != null && !this.scrubbing) {
            this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)position));
        }
        if (this.timeBar != null) {
            this.timeBar.setPosition(position);
            this.timeBar.setBufferedPosition(bufferedPosition);
        }
        if (this.progressUpdateListener != null) {
            this.progressUpdateListener.onProgressUpdate(position, bufferedPosition);
        }
        this.removeCallbacks(this.updateProgressAction);
        int n = playbackState = player == null ? 1 : player.getPlaybackState();
        if (player != null && player.isPlaying()) {
            long mediaTimeDelayMs = this.timeBar != null ? this.timeBar.getPreferredUpdateDelay() : 1000L;
            long mediaTimeUntilNextFullSecondMs = 1000L - position % 1000L;
            mediaTimeDelayMs = Math.min(mediaTimeDelayMs, mediaTimeUntilNextFullSecondMs);
            float playbackSpeed = player.getPlaybackParameters().speed;
            long delayMs = playbackSpeed > 0.0f ? (long)((float)mediaTimeDelayMs / playbackSpeed) : 1000L;
            delayMs = Util.constrainValue((long)delayMs, (long)this.timeBarMinUpdateIntervalMs, (long)1000L);
            this.postDelayed(this.updateProgressAction, delayMs);
        } else if (playbackState != 4 && playbackState != 1) {
            this.postDelayed(this.updateProgressAction, 1000L);
        }
    }

    private void updatePlaybackSpeedList() {
        if (this.player == null) {
            return;
        }
        this.playbackSpeedAdapter.updateSelectedIndex(this.player.getPlaybackParameters().speed);
        this.settingsAdapter.setSubTextAtPosition(0, this.playbackSpeedAdapter.getSelectedText());
    }

    private void updateSettingsWindowSize() {
        this.settingsView.measure(0, 0);
        int maxWidth = this.getWidth() - this.settingsWindowMargin * 2;
        int itemWidth = this.settingsView.getMeasuredWidth();
        int width = Math.min(itemWidth, maxWidth);
        this.settingsWindow.setWidth(width);
        int maxHeight = this.getHeight() - this.settingsWindowMargin * 2;
        int totalHeight = this.settingsView.getMeasuredHeight();
        int height = Math.min(maxHeight, totalHeight);
        this.settingsWindow.setHeight(height);
    }

    private void displaySettingsWindow(RecyclerView.Adapter<?> adapter) {
        this.settingsView.setAdapter(adapter);
        this.updateSettingsWindowSize();
        this.needToHideBars = false;
        this.settingsWindow.dismiss();
        this.needToHideBars = true;
        int xoff = this.getWidth() - this.settingsWindow.getWidth() - this.settingsWindowMargin;
        int yoff = -this.settingsWindow.getHeight() - this.settingsWindowMargin;
        this.settingsWindow.showAsDropDown((View)this, xoff, yoff);
    }

    private void setPlaybackSpeed(float speed) {
        if (this.player == null) {
            return;
        }
        this.player.setPlaybackParameters(this.player.getPlaybackParameters().withSpeed(speed));
    }

    void requestPlayPauseFocus() {
        if (this.playPauseButton != null) {
            this.playPauseButton.requestFocus();
        }
    }

    private void updateButton(boolean enabled, @Nullable View view) {
        if (view == null) {
            return;
        }
        view.setEnabled(enabled);
        view.setAlpha(enabled ? this.buttonAlphaEnabled : this.buttonAlphaDisabled);
    }

    private void seekToTimeBarPosition(Player player, long positionMs) {
        int windowIndex;
        Timeline timeline = player.getCurrentTimeline();
        if (this.multiWindowTimeBar && !timeline.isEmpty()) {
            long windowDurationMs;
            int windowCount = timeline.getWindowCount();
            windowIndex = 0;
            while (positionMs >= (windowDurationMs = timeline.getWindow(windowIndex, this.window).getDurationMs())) {
                if (windowIndex == windowCount - 1) {
                    positionMs = windowDurationMs;
                    break;
                }
                positionMs -= windowDurationMs;
                ++windowIndex;
            }
        } else {
            windowIndex = player.getCurrentMediaItemIndex();
        }
        this.seekTo(player, windowIndex, positionMs);
        this.updateProgress();
    }

    private void seekTo(Player player, int windowIndex, long positionMs) {
        player.seekTo(windowIndex, positionMs);
    }

    private void onFullScreenButtonClicked(View v) {
        if (this.onFullScreenModeChangedListener == null) {
            return;
        }
        this.isFullScreen = !this.isFullScreen;
        this.updateFullScreenButtonForState(this.fullScreenButton, this.isFullScreen);
        this.updateFullScreenButtonForState(this.minimalFullScreenButton, this.isFullScreen);
        if (this.onFullScreenModeChangedListener != null) {
            this.onFullScreenModeChangedListener.onFullScreenModeChanged(this.isFullScreen);
        }
    }

    private void updateFullScreenButtonForState(@Nullable ImageView fullScreenButton, boolean isFullScreen) {
        if (fullScreenButton == null) {
            return;
        }
        if (isFullScreen) {
            fullScreenButton.setImageDrawable(this.fullScreenExitDrawable);
            fullScreenButton.setContentDescription((CharSequence)this.fullScreenExitContentDescription);
        } else {
            fullScreenButton.setImageDrawable(this.fullScreenEnterDrawable);
            fullScreenButton.setContentDescription((CharSequence)this.fullScreenEnterContentDescription);
        }
    }

    private void onSettingViewClicked(int position) {
        if (position == 0) {
            this.displaySettingsWindow(this.playbackSpeedAdapter);
        } else if (position == 1) {
            this.displaySettingsWindow(this.audioTrackSelectionAdapter);
        } else {
            this.settingsWindow.dismiss();
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.controlViewLayoutManager.onAttachedToWindow();
        this.isAttachedToWindow = true;
        if (this.isFullyVisible()) {
            this.controlViewLayoutManager.resetHideCallbacks();
        }
        this.updateAll();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.controlViewLayoutManager.onDetachedFromWindow();
        this.isAttachedToWindow = false;
        this.removeCallbacks(this.updateProgressAction);
        this.controlViewLayoutManager.removeHideCallbacks();
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return this.dispatchMediaKeyEvent(event) || super.dispatchKeyEvent(event);
    }

    public boolean dispatchMediaKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        Player player = this.player;
        if (player == null || !StyledPlayerControlView.isHandledMediaKey(keyCode)) {
            return false;
        }
        if (event.getAction() == 0) {
            if (keyCode == 90) {
                if (player.getPlaybackState() != 4) {
                    player.seekForward();
                }
            } else if (keyCode == 89) {
                player.seekBack();
            } else if (event.getRepeatCount() == 0) {
                switch (keyCode) {
                    case 79: 
                    case 85: {
                        this.dispatchPlayPause(player);
                        break;
                    }
                    case 126: {
                        this.dispatchPlay(player);
                        break;
                    }
                    case 127: {
                        this.dispatchPause(player);
                        break;
                    }
                    case 87: {
                        player.seekToNext();
                        break;
                    }
                    case 88: {
                        player.seekToPrevious();
                        break;
                    }
                }
            }
        }
        return true;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.controlViewLayoutManager.onLayout(changed, left, top, right, bottom);
    }

    private void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        int width = right - left;
        int height = bottom - top;
        int oldWidth = oldRight - oldLeft;
        int oldHeight = oldBottom - oldTop;
        if ((width != oldWidth || height != oldHeight) && this.settingsWindow.isShowing()) {
            this.updateSettingsWindowSize();
            int xOffset = this.getWidth() - this.settingsWindow.getWidth() - this.settingsWindowMargin;
            int yOffset = -this.settingsWindow.getHeight() - this.settingsWindowMargin;
            this.settingsWindow.update(v, xOffset, yOffset, -1, -1);
        }
    }

    private boolean shouldShowPauseButton() {
        return this.player != null && this.player.getPlaybackState() != 4 && this.player.getPlaybackState() != 1 && this.player.getPlayWhenReady();
    }

    private void dispatchPlayPause(Player player) {
        int state = player.getPlaybackState();
        if (state == 1 || state == 4 || !player.getPlayWhenReady()) {
            this.dispatchPlay(player);
        } else {
            this.dispatchPause(player);
        }
    }

    private void dispatchPlay(Player player) {
        int state = player.getPlaybackState();
        if (state == 1) {
            player.prepare();
        } else if (state == 4) {
            this.seekTo(player, player.getCurrentMediaItemIndex(), -9223372036854775807L);
        }
        player.play();
    }

    private void dispatchPause(Player player) {
        player.pause();
    }

    @SuppressLint(value={"InlinedApi"})
    private static boolean isHandledMediaKey(int keyCode) {
        return keyCode == 90 || keyCode == 89 || keyCode == 85 || keyCode == 79 || keyCode == 126 || keyCode == 127 || keyCode == 87 || keyCode == 88;
    }

    private static boolean canShowMultiWindowTimeBar(Timeline timeline, Timeline.Window window) {
        if (timeline.getWindowCount() > 100) {
            return false;
        }
        int windowCount = timeline.getWindowCount();
        for (int i = 0; i < windowCount; ++i) {
            if (timeline.getWindow((int)i, (Timeline.Window)window).durationUs != -9223372036854775807L) continue;
            return false;
        }
        return true;
    }

    private static void initializeFullScreenButton(View fullScreenButton, View.OnClickListener listener) {
        if (fullScreenButton == null) {
            return;
        }
        fullScreenButton.setVisibility(8);
        fullScreenButton.setOnClickListener(listener);
    }

    private static void updateFullScreenButtonVisibility(@Nullable View fullScreenButton, boolean visible) {
        if (fullScreenButton == null) {
            return;
        }
        if (visible) {
            fullScreenButton.setVisibility(0);
        } else {
            fullScreenButton.setVisibility(8);
        }
    }

    private static int getRepeatToggleModes(TypedArray a, int defaultValue) {
        return a.getInt(R.styleable.StyledPlayerControlView_repeat_toggle_modes, defaultValue);
    }

    @Pure
    private static TrackSelectionOverrides forceTrackSelection(TrackSelectionOverrides trackSelectionOverrides, TracksInfo tracksInfo, int forcedTrackGroupIndex, TrackSelectionOverrides.TrackSelectionOverride forcedTrackSelectionOverride) {
        TrackSelectionOverrides.Builder overridesBuilder = trackSelectionOverrides.buildUpon();
        int trackType = ((TracksInfo.TrackGroupInfo)tracksInfo.getTrackGroupInfos().get(forcedTrackGroupIndex)).getTrackType();
        overridesBuilder.setOverrideForType(forcedTrackSelectionOverride);
        ImmutableList trackGroupInfos = tracksInfo.getTrackGroupInfos();
        for (int i = 0; i < trackGroupInfos.size(); ++i) {
            TracksInfo.TrackGroupInfo trackGroupInfo = (TracksInfo.TrackGroupInfo)trackGroupInfos.get(i);
            if (i == forcedTrackGroupIndex || trackGroupInfo.getTrackType() != trackType) continue;
            TrackGroup trackGroup = trackGroupInfo.getTrackGroup();
            overridesBuilder.addOverride(new TrackSelectionOverrides.TrackSelectionOverride(trackGroup, (List)ImmutableList.of()));
        }
        return overridesBuilder.build();
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.ui");
    }

    private static class SubSettingViewHolder
    extends RecyclerView.ViewHolder {
        public final TextView textView;
        public final View checkView;

        public SubSettingViewHolder(View itemView) {
            super(itemView);
            if (Util.SDK_INT < 26) {
                itemView.setFocusable(true);
            }
            this.textView = (TextView)itemView.findViewById(R.id.exo_text);
            this.checkView = itemView.findViewById(R.id.exo_check);
        }
    }

    private abstract class TrackSelectionAdapter
    extends RecyclerView.Adapter<SubSettingViewHolder> {
        protected List<TrackInformation> tracks = new ArrayList<TrackInformation>();

        protected TrackSelectionAdapter() {
        }

        public abstract void init(List<TrackInformation> var1);

        public SubSettingViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View v = LayoutInflater.from((Context)StyledPlayerControlView.this.getContext()).inflate(R.layout.exo_styled_sub_settings_list_item, parent, false);
            return new SubSettingViewHolder(v);
        }

        protected abstract void onBindViewHolderAtZeroPosition(SubSettingViewHolder var1);

        protected abstract void onTrackSelection(String var1);

        public void onBindViewHolder(SubSettingViewHolder holder, int position) {
            if (StyledPlayerControlView.this.player == null) {
                return;
            }
            if (position == 0) {
                this.onBindViewHolderAtZeroPosition(holder);
            } else {
                TrackInformation track = this.tracks.get(position - 1);
                boolean explicitlySelected = ((Player)Assertions.checkNotNull((Object)((StyledPlayerControlView)StyledPlayerControlView.this).player)).getTrackSelectionParameters().trackSelectionOverrides.getOverride(track.trackGroup) != null && track.isSelected();
                holder.textView.setText((CharSequence)track.trackName);
                holder.checkView.setVisibility(explicitlySelected ? 0 : 4);
                holder.itemView.setOnClickListener(v -> {
                    if (StyledPlayerControlView.this.player == null) {
                        return;
                    }
                    TrackSelectionParameters trackSelectionParameters = StyledPlayerControlView.this.player.getTrackSelectionParameters();
                    TrackSelectionOverrides overrides = StyledPlayerControlView.forceTrackSelection(trackSelectionParameters.trackSelectionOverrides, track.tracksInfo, track.trackGroupIndex, new TrackSelectionOverrides.TrackSelectionOverride(track.trackGroup, (List)ImmutableList.of((Object)track.trackIndex)));
                    ((Player)Assertions.checkNotNull((Object)StyledPlayerControlView.this.player)).setTrackSelectionParameters(trackSelectionParameters.buildUpon().setTrackSelectionOverrides(overrides).build());
                    this.onTrackSelection(track.trackName);
                    StyledPlayerControlView.this.settingsWindow.dismiss();
                });
            }
        }

        public int getItemCount() {
            return this.tracks.isEmpty() ? 0 : this.tracks.size() + 1;
        }

        protected void clear() {
            this.tracks = Collections.emptyList();
        }
    }

    private final class AudioTrackSelectionAdapter
    extends TrackSelectionAdapter {
        private AudioTrackSelectionAdapter() {
        }

        @Override
        public void onBindViewHolderAtZeroPosition(SubSettingViewHolder holder) {
            holder.textView.setText(R.string.exo_track_selection_auto);
            TrackSelectionParameters parameters = ((Player)Assertions.checkNotNull((Object)StyledPlayerControlView.this.player)).getTrackSelectionParameters();
            boolean hasSelectionOverride = this.hasSelectionOverride(parameters.trackSelectionOverrides);
            holder.checkView.setVisibility(hasSelectionOverride ? 4 : 0);
            holder.itemView.setOnClickListener(v -> {
                if (StyledPlayerControlView.this.player == null) {
                    return;
                }
                TrackSelectionParameters trackSelectionParameters = StyledPlayerControlView.this.player.getTrackSelectionParameters();
                TrackSelectionOverrides trackSelectionOverrides = trackSelectionParameters.trackSelectionOverrides.buildUpon().clearOverridesOfType(1).build();
                ((Player)Util.castNonNull((Object)StyledPlayerControlView.this.player)).setTrackSelectionParameters(trackSelectionParameters.buildUpon().setTrackSelectionOverrides(trackSelectionOverrides).build());
                StyledPlayerControlView.this.settingsAdapter.setSubTextAtPosition(1, StyledPlayerControlView.this.getResources().getString(R.string.exo_track_selection_auto));
                StyledPlayerControlView.this.settingsWindow.dismiss();
            });
        }

        private boolean hasSelectionOverride(TrackSelectionOverrides trackSelectionOverrides) {
            int previousTrackGroupIndex = -1;
            for (int i = 0; i < this.tracks.size(); ++i) {
                TrackInformation track = (TrackInformation)this.tracks.get(i);
                if (track.trackGroupIndex == previousTrackGroupIndex) continue;
                if (trackSelectionOverrides.getOverride(track.trackGroup) != null) {
                    return true;
                }
                previousTrackGroupIndex = track.trackGroupIndex;
            }
            return false;
        }

        @Override
        public void onTrackSelection(String subtext) {
            StyledPlayerControlView.this.settingsAdapter.setSubTextAtPosition(1, subtext);
        }

        @Override
        public void init(List<TrackInformation> trackInformations) {
            int i;
            boolean hasSelectionOverride = false;
            for (i = 0; i < trackInformations.size(); ++i) {
                if (((Player)Assertions.checkNotNull((Object)((StyledPlayerControlView)StyledPlayerControlView.this).player)).getTrackSelectionParameters().trackSelectionOverrides.getOverride(trackInformations.get((int)i).trackGroup) == null) continue;
                hasSelectionOverride = true;
                break;
            }
            if (trackInformations.isEmpty()) {
                StyledPlayerControlView.this.settingsAdapter.setSubTextAtPosition(1, StyledPlayerControlView.this.getResources().getString(R.string.exo_track_selection_none));
            } else if (!hasSelectionOverride) {
                StyledPlayerControlView.this.settingsAdapter.setSubTextAtPosition(1, StyledPlayerControlView.this.getResources().getString(R.string.exo_track_selection_auto));
            } else {
                for (i = 0; i < trackInformations.size(); ++i) {
                    TrackInformation track = trackInformations.get(i);
                    if (!track.isSelected()) continue;
                    StyledPlayerControlView.this.settingsAdapter.setSubTextAtPosition(1, track.trackName);
                    break;
                }
            }
            this.tracks = trackInformations;
        }
    }

    private final class TextTrackSelectionAdapter
    extends TrackSelectionAdapter {
        private TextTrackSelectionAdapter() {
        }

        @Override
        public void init(List<TrackInformation> trackInformations) {
            boolean subtitleIsOn = false;
            for (int i = 0; i < trackInformations.size(); ++i) {
                if (!trackInformations.get(i).isSelected()) continue;
                subtitleIsOn = true;
                break;
            }
            if (StyledPlayerControlView.this.subtitleButton != null) {
                StyledPlayerControlView.this.subtitleButton.setImageDrawable(subtitleIsOn ? StyledPlayerControlView.this.subtitleOnButtonDrawable : StyledPlayerControlView.this.subtitleOffButtonDrawable);
                StyledPlayerControlView.this.subtitleButton.setContentDescription((CharSequence)(subtitleIsOn ? StyledPlayerControlView.this.subtitleOnContentDescription : StyledPlayerControlView.this.subtitleOffContentDescription));
            }
            this.tracks = trackInformations;
        }

        @Override
        public void onBindViewHolderAtZeroPosition(SubSettingViewHolder holder) {
            holder.textView.setText(R.string.exo_track_selection_none);
            boolean isTrackSelectionOff = true;
            for (int i = 0; i < this.tracks.size(); ++i) {
                if (!((TrackInformation)this.tracks.get(i)).isSelected()) continue;
                isTrackSelectionOff = false;
                break;
            }
            holder.checkView.setVisibility(isTrackSelectionOff ? 0 : 4);
            holder.itemView.setOnClickListener(v -> {
                if (StyledPlayerControlView.this.player != null) {
                    TrackSelectionParameters trackSelectionParameters = StyledPlayerControlView.this.player.getTrackSelectionParameters();
                    StyledPlayerControlView.this.player.setTrackSelectionParameters(trackSelectionParameters.buildUpon().setDisabledTrackTypes((Set)new ImmutableSet.Builder().addAll((Iterable)trackSelectionParameters.disabledTrackTypes).add((Object)3).build()).build());
                    StyledPlayerControlView.this.settingsWindow.dismiss();
                }
            });
        }

        @Override
        public void onBindViewHolder(SubSettingViewHolder holder, int position) {
            super.onBindViewHolder(holder, position);
            if (position > 0) {
                TrackInformation track = (TrackInformation)this.tracks.get(position - 1);
                holder.checkView.setVisibility(track.isSelected() ? 0 : 4);
            }
        }

        @Override
        public void onTrackSelection(String subtext) {
        }
    }

    private static final class TrackInformation {
        private TracksInfo tracksInfo;
        private int trackGroupIndex;
        public final TracksInfo.TrackGroupInfo trackGroupInfo;
        public final TrackGroup trackGroup;
        public final int trackIndex;
        public final String trackName;

        public TrackInformation(TracksInfo tracksInfo, int trackGroupIndex, int trackIndex, String trackName) {
            this.tracksInfo = tracksInfo;
            this.trackGroupIndex = trackGroupIndex;
            this.trackGroupInfo = (TracksInfo.TrackGroupInfo)tracksInfo.getTrackGroupInfos().get(trackGroupIndex);
            this.trackGroup = this.trackGroupInfo.getTrackGroup();
            this.trackIndex = trackIndex;
            this.trackName = trackName;
        }

        public boolean isSelected() {
            return this.trackGroupInfo.isTrackSelected(this.trackIndex);
        }
    }

    private final class PlaybackSpeedAdapter
    extends RecyclerView.Adapter<SubSettingViewHolder> {
        private final String[] playbackSpeedTexts;
        private final int[] playbackSpeedsMultBy100;
        private int selectedIndex;

        public PlaybackSpeedAdapter(String[] playbackSpeedTexts, int[] playbackSpeedsMultBy100) {
            this.playbackSpeedTexts = playbackSpeedTexts;
            this.playbackSpeedsMultBy100 = playbackSpeedsMultBy100;
        }

        public void updateSelectedIndex(float playbackSpeed) {
            int currentSpeedMultBy100 = Math.round(playbackSpeed * 100.0f);
            int closestMatchIndex = 0;
            int closestMatchDifference = Integer.MAX_VALUE;
            for (int i = 0; i < this.playbackSpeedsMultBy100.length; ++i) {
                int difference = Math.abs(currentSpeedMultBy100 - this.playbackSpeedsMultBy100[i]);
                if (difference >= closestMatchDifference) continue;
                closestMatchIndex = i;
                closestMatchDifference = difference;
            }
            this.selectedIndex = closestMatchIndex;
        }

        public String getSelectedText() {
            return this.playbackSpeedTexts[this.selectedIndex];
        }

        public SubSettingViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View v = LayoutInflater.from((Context)StyledPlayerControlView.this.getContext()).inflate(R.layout.exo_styled_sub_settings_list_item, parent, false);
            return new SubSettingViewHolder(v);
        }

        public void onBindViewHolder(SubSettingViewHolder holder, int position) {
            if (position < this.playbackSpeedTexts.length) {
                holder.textView.setText((CharSequence)this.playbackSpeedTexts[position]);
            }
            holder.checkView.setVisibility(position == this.selectedIndex ? 0 : 4);
            holder.itemView.setOnClickListener(v -> {
                if (position != this.selectedIndex) {
                    float speed = (float)this.playbackSpeedsMultBy100[position] / 100.0f;
                    StyledPlayerControlView.this.setPlaybackSpeed(speed);
                }
                StyledPlayerControlView.this.settingsWindow.dismiss();
            });
        }

        public int getItemCount() {
            return this.playbackSpeedTexts.length;
        }
    }

    private final class SettingViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView mainTextView;
        private final TextView subTextView;
        private final ImageView iconView;

        public SettingViewHolder(View itemView) {
            super(itemView);
            if (Util.SDK_INT < 26) {
                itemView.setFocusable(true);
            }
            this.mainTextView = (TextView)itemView.findViewById(R.id.exo_main_text);
            this.subTextView = (TextView)itemView.findViewById(R.id.exo_sub_text);
            this.iconView = (ImageView)itemView.findViewById(R.id.exo_icon);
            itemView.setOnClickListener(v -> StyledPlayerControlView.this.onSettingViewClicked(this.getAdapterPosition()));
        }
    }

    private class SettingsAdapter
    extends RecyclerView.Adapter<SettingViewHolder> {
        private final String[] mainTexts;
        private final String[] subTexts;
        private final Drawable[] iconIds;

        public SettingsAdapter(String[] mainTexts, Drawable[] iconIds) {
            this.mainTexts = mainTexts;
            this.subTexts = new String[mainTexts.length];
            this.iconIds = iconIds;
        }

        public SettingViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View v = LayoutInflater.from((Context)StyledPlayerControlView.this.getContext()).inflate(R.layout.exo_styled_settings_list_item, parent, false);
            return new SettingViewHolder(v);
        }

        public void onBindViewHolder(SettingViewHolder holder, int position) {
            holder.mainTextView.setText((CharSequence)this.mainTexts[position]);
            if (this.subTexts[position] == null) {
                holder.subTextView.setVisibility(8);
            } else {
                holder.subTextView.setText((CharSequence)this.subTexts[position]);
            }
            if (this.iconIds[position] == null) {
                holder.iconView.setVisibility(8);
            } else {
                holder.iconView.setImageDrawable(this.iconIds[position]);
            }
        }

        public long getItemId(int position) {
            return position;
        }

        public int getItemCount() {
            return this.mainTexts.length;
        }

        public void setSubTextAtPosition(int position, String subText) {
            this.subTexts[position] = subText;
        }
    }

    private final class ComponentListener
    implements Player.Listener,
    TimeBar.OnScrubListener,
    View.OnClickListener,
    PopupWindow.OnDismissListener {
        private ComponentListener() {
        }

        public void onEvents(Player player, Player.Events events) {
            if (events.containsAny(new int[]{4, 5})) {
                StyledPlayerControlView.this.updatePlayPauseButton();
            }
            if (events.containsAny(new int[]{4, 5, 7})) {
                StyledPlayerControlView.this.updateProgress();
            }
            if (events.contains(8)) {
                StyledPlayerControlView.this.updateRepeatModeButton();
            }
            if (events.contains(9)) {
                StyledPlayerControlView.this.updateShuffleButton();
            }
            if (events.containsAny(new int[]{8, 9, 11, 0, 16, 17, 13})) {
                StyledPlayerControlView.this.updateNavigation();
            }
            if (events.containsAny(new int[]{11, 0})) {
                StyledPlayerControlView.this.updateTimeline();
            }
            if (events.contains(12)) {
                StyledPlayerControlView.this.updatePlaybackSpeedList();
            }
            if (events.contains(2)) {
                StyledPlayerControlView.this.updateTrackLists();
            }
        }

        @Override
        public void onScrubStart(TimeBar timeBar, long position) {
            StyledPlayerControlView.this.scrubbing = true;
            if (StyledPlayerControlView.this.positionView != null) {
                StyledPlayerControlView.this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)StyledPlayerControlView.this.formatBuilder, (Formatter)StyledPlayerControlView.this.formatter, (long)position));
            }
            StyledPlayerControlView.this.controlViewLayoutManager.removeHideCallbacks();
        }

        @Override
        public void onScrubMove(TimeBar timeBar, long position) {
            if (StyledPlayerControlView.this.positionView != null) {
                StyledPlayerControlView.this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)StyledPlayerControlView.this.formatBuilder, (Formatter)StyledPlayerControlView.this.formatter, (long)position));
            }
        }

        @Override
        public void onScrubStop(TimeBar timeBar, long position, boolean canceled) {
            StyledPlayerControlView.this.scrubbing = false;
            if (!canceled && StyledPlayerControlView.this.player != null) {
                StyledPlayerControlView.this.seekToTimeBarPosition(StyledPlayerControlView.this.player, position);
            }
            StyledPlayerControlView.this.controlViewLayoutManager.resetHideCallbacks();
        }

        public void onDismiss() {
            if (StyledPlayerControlView.this.needToHideBars) {
                StyledPlayerControlView.this.controlViewLayoutManager.resetHideCallbacks();
            }
        }

        public void onClick(View view) {
            Player player = StyledPlayerControlView.this.player;
            if (player == null) {
                return;
            }
            StyledPlayerControlView.this.controlViewLayoutManager.resetHideCallbacks();
            if (StyledPlayerControlView.this.nextButton == view) {
                player.seekToNext();
            } else if (StyledPlayerControlView.this.previousButton == view) {
                player.seekToPrevious();
            } else if (StyledPlayerControlView.this.fastForwardButton == view) {
                if (player.getPlaybackState() != 4) {
                    player.seekForward();
                }
            } else if (StyledPlayerControlView.this.rewindButton == view) {
                player.seekBack();
            } else if (StyledPlayerControlView.this.playPauseButton == view) {
                StyledPlayerControlView.this.dispatchPlayPause(player);
            } else if (StyledPlayerControlView.this.repeatToggleButton == view) {
                player.setRepeatMode(RepeatModeUtil.getNextRepeatMode((int)player.getRepeatMode(), (int)StyledPlayerControlView.this.repeatToggleModes));
            } else if (StyledPlayerControlView.this.shuffleButton == view) {
                player.setShuffleModeEnabled(!player.getShuffleModeEnabled());
            } else if (StyledPlayerControlView.this.settingsButton == view) {
                StyledPlayerControlView.this.controlViewLayoutManager.removeHideCallbacks();
                StyledPlayerControlView.this.displaySettingsWindow(StyledPlayerControlView.this.settingsAdapter);
            } else if (StyledPlayerControlView.this.playbackSpeedButton == view) {
                StyledPlayerControlView.this.controlViewLayoutManager.removeHideCallbacks();
                StyledPlayerControlView.this.displaySettingsWindow(StyledPlayerControlView.this.playbackSpeedAdapter);
            } else if (StyledPlayerControlView.this.audioTrackButton == view) {
                StyledPlayerControlView.this.controlViewLayoutManager.removeHideCallbacks();
                StyledPlayerControlView.this.displaySettingsWindow(StyledPlayerControlView.this.audioTrackSelectionAdapter);
            } else if (StyledPlayerControlView.this.subtitleButton == view) {
                StyledPlayerControlView.this.controlViewLayoutManager.removeHideCallbacks();
                StyledPlayerControlView.this.displaySettingsWindow(StyledPlayerControlView.this.textTrackSelectionAdapter);
            }
        }
    }

    public static interface OnFullScreenModeChangedListener {
        public void onFullScreenModeChanged(boolean var1);
    }

    public static interface ProgressUpdateListener {
        public void onProgressUpdate(long var1, long var3);
    }

    public static interface VisibilityListener {
        public void onVisibilityChange(int var1);
    }
}

