/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.accessibility.CaptioningManager;
import android.widget.FrameLayout;
import androidx.annotation.Dimension;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.ui.CanvasSubtitleOutput;
import com.google.android.exoplayer2.ui.CaptionStyleCompat;
import com.google.android.exoplayer2.ui.SubtitleViewUtils;
import com.google.android.exoplayer2.ui.WebViewSubtitleOutput;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SubtitleView
extends FrameLayout
implements TextOutput {
    public static final float DEFAULT_TEXT_SIZE_FRACTION = 0.0533f;
    public static final float DEFAULT_BOTTOM_PADDING_FRACTION = 0.08f;
    public static final int VIEW_TYPE_CANVAS = 1;
    public static final int VIEW_TYPE_WEB = 2;
    private List<Cue> cues = Collections.emptyList();
    private CaptionStyleCompat style = CaptionStyleCompat.DEFAULT;
    private int defaultTextSizeType = 0;
    private float defaultTextSize = 0.0533f;
    private float bottomPaddingFraction = 0.08f;
    private boolean applyEmbeddedStyles = true;
    private boolean applyEmbeddedFontSizes = true;
    private int viewType;
    private Output output;
    private View innerSubtitleView;

    public SubtitleView(Context context) {
        this(context, null);
    }

    public SubtitleView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        CanvasSubtitleOutput canvasSubtitleOutput = new CanvasSubtitleOutput(context);
        this.output = canvasSubtitleOutput;
        this.innerSubtitleView = canvasSubtitleOutput;
        this.addView(this.innerSubtitleView);
        this.viewType = 1;
    }

    public void onCues(List<Cue> cues) {
        this.setCues(cues);
    }

    public void setCues(@Nullable List<Cue> cues) {
        this.cues = cues != null ? cues : Collections.emptyList();
        this.updateOutput();
    }

    public void setViewType(int viewType) {
        if (this.viewType == viewType) {
            return;
        }
        switch (viewType) {
            case 1: {
                this.setView(new CanvasSubtitleOutput(this.getContext()));
                break;
            }
            case 2: {
                this.setView(new WebViewSubtitleOutput(this.getContext()));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.viewType = viewType;
    }

    private <T extends View> void setView(T view) {
        this.removeView(this.innerSubtitleView);
        if (this.innerSubtitleView instanceof WebViewSubtitleOutput) {
            ((WebViewSubtitleOutput)this.innerSubtitleView).destroy();
        }
        this.innerSubtitleView = view;
        this.output = (Output)view;
        this.addView(view);
    }

    public void setFixedTextSize(@Dimension int unit, float size) {
        Context context = this.getContext();
        Resources resources = context == null ? Resources.getSystem() : context.getResources();
        this.setTextSize(2, TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)resources.getDisplayMetrics()));
    }

    public void setUserDefaultTextSize() {
        this.setFractionalTextSize(0.0533f * this.getUserCaptionFontScale());
    }

    public void setFractionalTextSize(float fractionOfHeight) {
        this.setFractionalTextSize(fractionOfHeight, false);
    }

    public void setFractionalTextSize(float fractionOfHeight, boolean ignorePadding) {
        this.setTextSize(ignorePadding ? 1 : 0, fractionOfHeight);
    }

    private void setTextSize(int textSizeType, float textSize) {
        this.defaultTextSizeType = textSizeType;
        this.defaultTextSize = textSize;
        this.updateOutput();
    }

    public void setApplyEmbeddedStyles(boolean applyEmbeddedStyles) {
        this.applyEmbeddedStyles = applyEmbeddedStyles;
        this.updateOutput();
    }

    public void setApplyEmbeddedFontSizes(boolean applyEmbeddedFontSizes) {
        this.applyEmbeddedFontSizes = applyEmbeddedFontSizes;
        this.updateOutput();
    }

    public void setUserDefaultStyle() {
        this.setStyle(this.getUserCaptionStyle());
    }

    public void setStyle(CaptionStyleCompat style2) {
        this.style = style2;
        this.updateOutput();
    }

    public void setBottomPaddingFraction(float bottomPaddingFraction) {
        this.bottomPaddingFraction = bottomPaddingFraction;
        this.updateOutput();
    }

    private float getUserCaptionFontScale() {
        if (Util.SDK_INT < 19 || this.isInEditMode()) {
            return 1.0f;
        }
        CaptioningManager captioningManager = (CaptioningManager)this.getContext().getSystemService("captioning");
        return captioningManager != null && captioningManager.isEnabled() ? captioningManager.getFontScale() : 1.0f;
    }

    private CaptionStyleCompat getUserCaptionStyle() {
        if (Util.SDK_INT < 19 || this.isInEditMode()) {
            return CaptionStyleCompat.DEFAULT;
        }
        CaptioningManager captioningManager = (CaptioningManager)this.getContext().getSystemService("captioning");
        return captioningManager != null && captioningManager.isEnabled() ? CaptionStyleCompat.createFromCaptionStyle(captioningManager.getUserStyle()) : CaptionStyleCompat.DEFAULT;
    }

    private void updateOutput() {
        this.output.update(this.getCuesWithStylingPreferencesApplied(), this.style, this.defaultTextSize, this.defaultTextSizeType, this.bottomPaddingFraction);
    }

    private List<Cue> getCuesWithStylingPreferencesApplied() {
        if (this.applyEmbeddedStyles && this.applyEmbeddedFontSizes) {
            return this.cues;
        }
        ArrayList<Cue> strippedCues = new ArrayList<Cue>(this.cues.size());
        for (int i = 0; i < this.cues.size(); ++i) {
            strippedCues.add(this.removeEmbeddedStyling(this.cues.get(i)));
        }
        return strippedCues;
    }

    private Cue removeEmbeddedStyling(Cue cue) {
        Cue.Builder strippedCue = cue.buildUpon();
        if (!this.applyEmbeddedStyles) {
            SubtitleViewUtils.removeAllEmbeddedStyling(strippedCue);
        } else if (!this.applyEmbeddedFontSizes) {
            SubtitleViewUtils.removeEmbeddedFontSizes(strippedCue);
        }
        return strippedCue.build();
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ViewType {
    }

    static interface Output {
        public void update(List<Cue> var1, CaptionStyleCompat var2, float var3, int var4, float var5);
    }
}

