/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.v4.media.session.MediaSessionCompat;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.media.app.NotificationCompat;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.DefaultControlDispatcher;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.PlaybackPreparer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.NotificationUtil;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlayerNotificationManager {
    public static final String ACTION_PLAY = "com.google.android.exoplayer.play";
    public static final String ACTION_PAUSE = "com.google.android.exoplayer.pause";
    public static final String ACTION_PREVIOUS = "com.google.android.exoplayer.prev";
    public static final String ACTION_NEXT = "com.google.android.exoplayer.next";
    public static final String ACTION_FAST_FORWARD = "com.google.android.exoplayer.ffwd";
    public static final String ACTION_REWIND = "com.google.android.exoplayer.rewind";
    public static final String ACTION_STOP = "com.google.android.exoplayer.stop";
    public static final String EXTRA_INSTANCE_ID = "INSTANCE_ID";
    private static final String ACTION_DISMISS = "com.google.android.exoplayer.dismiss";
    private static final int MSG_START_OR_UPDATE_NOTIFICATION = 0;
    private static final int MSG_UPDATE_NOTIFICATION_BITMAP = 1;
    public static final int DEFAULT_FAST_FORWARD_MS = 15000;
    public static final int DEFAULT_REWIND_MS = 5000;
    private static final long MAX_POSITION_FOR_SEEK_TO_PREVIOUS = 3000L;
    private static int instanceIdCounter;
    private final Context context;
    private final String channelId;
    private final int notificationId;
    private final MediaDescriptionAdapter mediaDescriptionAdapter;
    @Nullable
    private final CustomActionReceiver customActionReceiver;
    private final Handler mainHandler;
    private final NotificationManagerCompat notificationManager;
    private final IntentFilter intentFilter;
    private final Player.EventListener playerListener;
    private final NotificationBroadcastReceiver notificationBroadcastReceiver;
    private final Map<String, NotificationCompat.Action> playbackActions;
    private final Map<String, NotificationCompat.Action> customActions;
    private final PendingIntent dismissPendingIntent;
    private final int instanceId;
    private final Timeline.Window window;
    @Nullable
    private NotificationCompat.Builder builder;
    @Nullable
    private ArrayList<NotificationCompat.Action> builderActions;
    @Nullable
    private Player player;
    @Nullable
    private PlaybackPreparer playbackPreparer;
    private ControlDispatcher controlDispatcher;
    private boolean isNotificationStarted;
    private int currentNotificationTag;
    @Nullable
    private NotificationListener notificationListener;
    @Nullable
    private MediaSessionCompat.Token mediaSessionToken;
    private boolean useNavigationActions;
    private boolean useNavigationActionsInCompactView;
    private boolean usePlayPauseActions;
    private boolean useStopAction;
    private long fastForwardMs;
    private long rewindMs;
    private int badgeIconType;
    private boolean colorized;
    private int defaults;
    private int color;
    @DrawableRes
    private int smallIconResourceId;
    private int visibility;
    private int priority;
    private boolean useChronometer;

    @Deprecated
    public static PlayerNotificationManager createWithNotificationChannel(Context context, String channelId, @StringRes int channelName, int notificationId, MediaDescriptionAdapter mediaDescriptionAdapter) {
        return PlayerNotificationManager.createWithNotificationChannel(context, channelId, channelName, 0, notificationId, mediaDescriptionAdapter);
    }

    public static PlayerNotificationManager createWithNotificationChannel(Context context, String channelId, @StringRes int channelName, @StringRes int channelDescription, int notificationId, MediaDescriptionAdapter mediaDescriptionAdapter) {
        NotificationUtil.createNotificationChannel((Context)context, (String)channelId, (int)channelName, (int)channelDescription, (int)2);
        return new PlayerNotificationManager(context, channelId, notificationId, mediaDescriptionAdapter);
    }

    @Deprecated
    public static PlayerNotificationManager createWithNotificationChannel(Context context, String channelId, @StringRes int channelName, int notificationId, MediaDescriptionAdapter mediaDescriptionAdapter, @Nullable NotificationListener notificationListener) {
        return PlayerNotificationManager.createWithNotificationChannel(context, channelId, channelName, 0, notificationId, mediaDescriptionAdapter, notificationListener);
    }

    public static PlayerNotificationManager createWithNotificationChannel(Context context, String channelId, @StringRes int channelName, @StringRes int channelDescription, int notificationId, MediaDescriptionAdapter mediaDescriptionAdapter, @Nullable NotificationListener notificationListener) {
        NotificationUtil.createNotificationChannel((Context)context, (String)channelId, (int)channelName, (int)channelDescription, (int)2);
        return new PlayerNotificationManager(context, channelId, notificationId, mediaDescriptionAdapter, notificationListener);
    }

    public PlayerNotificationManager(Context context, String channelId, int notificationId, MediaDescriptionAdapter mediaDescriptionAdapter) {
        this(context, channelId, notificationId, mediaDescriptionAdapter, null, null);
    }

    public PlayerNotificationManager(Context context, String channelId, int notificationId, MediaDescriptionAdapter mediaDescriptionAdapter, @Nullable NotificationListener notificationListener) {
        this(context, channelId, notificationId, mediaDescriptionAdapter, notificationListener, null);
    }

    public PlayerNotificationManager(Context context, String channelId, int notificationId, MediaDescriptionAdapter mediaDescriptionAdapter, @Nullable CustomActionReceiver customActionReceiver) {
        this(context, channelId, notificationId, mediaDescriptionAdapter, null, customActionReceiver);
    }

    public PlayerNotificationManager(Context context, String channelId, int notificationId, MediaDescriptionAdapter mediaDescriptionAdapter, @Nullable NotificationListener notificationListener, @Nullable CustomActionReceiver customActionReceiver) {
        this.context = context = context.getApplicationContext();
        this.channelId = channelId;
        this.notificationId = notificationId;
        this.mediaDescriptionAdapter = mediaDescriptionAdapter;
        this.notificationListener = notificationListener;
        this.customActionReceiver = customActionReceiver;
        this.controlDispatcher = new DefaultControlDispatcher();
        this.window = new Timeline.Window();
        this.instanceId = instanceIdCounter++;
        this.mainHandler = Util.createHandler((Looper)Looper.getMainLooper(), msg -> this.handleMessage(msg));
        this.notificationManager = NotificationManagerCompat.from((Context)context);
        this.playerListener = new PlayerListener();
        this.notificationBroadcastReceiver = new NotificationBroadcastReceiver();
        this.intentFilter = new IntentFilter();
        this.useNavigationActions = true;
        this.usePlayPauseActions = true;
        this.colorized = true;
        this.useChronometer = true;
        this.color = 0;
        this.smallIconResourceId = R.drawable.exo_notification_small_icon;
        this.defaults = 0;
        this.priority = -1;
        this.fastForwardMs = 15000L;
        this.rewindMs = 5000L;
        this.badgeIconType = 1;
        this.visibility = 1;
        this.playbackActions = PlayerNotificationManager.createPlaybackActions(context, this.instanceId);
        for (String action : this.playbackActions.keySet()) {
            this.intentFilter.addAction(action);
        }
        this.customActions = customActionReceiver != null ? customActionReceiver.createCustomActions(context, this.instanceId) : Collections.emptyMap();
        for (String action : this.customActions.keySet()) {
            this.intentFilter.addAction(action);
        }
        this.dismissPendingIntent = PlayerNotificationManager.createBroadcastIntent(ACTION_DISMISS, context, this.instanceId);
        this.intentFilter.addAction(ACTION_DISMISS);
    }

    public final void setPlayer(@Nullable Player player) {
        Assertions.checkState((Looper.myLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        Assertions.checkArgument((player == null || player.getApplicationLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        if (this.player == player) {
            return;
        }
        if (this.player != null) {
            this.player.removeListener(this.playerListener);
            if (player == null) {
                this.stopNotification(false);
            }
        }
        this.player = player;
        if (player != null) {
            player.addListener(this.playerListener);
            this.postStartOrUpdateNotification();
        }
    }

    public void setPlaybackPreparer(@Nullable PlaybackPreparer playbackPreparer) {
        this.playbackPreparer = playbackPreparer;
    }

    public final void setControlDispatcher(ControlDispatcher controlDispatcher) {
        this.controlDispatcher = controlDispatcher != null ? controlDispatcher : new DefaultControlDispatcher();
    }

    @Deprecated
    public final void setNotificationListener(NotificationListener notificationListener) {
        this.notificationListener = notificationListener;
    }

    public final void setFastForwardIncrementMs(long fastForwardMs) {
        if (this.fastForwardMs == fastForwardMs) {
            return;
        }
        this.fastForwardMs = fastForwardMs;
        this.invalidate();
    }

    public final void setRewindIncrementMs(long rewindMs) {
        if (this.rewindMs == rewindMs) {
            return;
        }
        this.rewindMs = rewindMs;
        this.invalidate();
    }

    public final void setUseNavigationActions(boolean useNavigationActions) {
        if (this.useNavigationActions != useNavigationActions) {
            this.useNavigationActions = useNavigationActions;
            this.invalidate();
        }
    }

    public final void setUseNavigationActionsInCompactView(boolean useNavigationActionsInCompactView) {
        if (this.useNavigationActionsInCompactView != useNavigationActionsInCompactView) {
            this.useNavigationActionsInCompactView = useNavigationActionsInCompactView;
            this.invalidate();
        }
    }

    public final void setUsePlayPauseActions(boolean usePlayPauseActions) {
        if (this.usePlayPauseActions != usePlayPauseActions) {
            this.usePlayPauseActions = usePlayPauseActions;
            this.invalidate();
        }
    }

    public final void setUseStopAction(boolean useStopAction) {
        if (this.useStopAction == useStopAction) {
            return;
        }
        this.useStopAction = useStopAction;
        this.invalidate();
    }

    public final void setMediaSessionToken(MediaSessionCompat.Token token) {
        if (!Util.areEqual((Object)this.mediaSessionToken, (Object)token)) {
            this.mediaSessionToken = token;
            this.invalidate();
        }
    }

    public final void setBadgeIconType(int badgeIconType) {
        if (this.badgeIconType == badgeIconType) {
            return;
        }
        switch (badgeIconType) {
            case 0: 
            case 1: 
            case 2: {
                this.badgeIconType = badgeIconType;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.invalidate();
    }

    public final void setColorized(boolean colorized) {
        if (this.colorized != colorized) {
            this.colorized = colorized;
            this.invalidate();
        }
    }

    public final void setDefaults(int defaults) {
        if (this.defaults != defaults) {
            this.defaults = defaults;
            this.invalidate();
        }
    }

    public final void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.invalidate();
        }
    }

    public final void setPriority(int priority) {
        if (this.priority == priority) {
            return;
        }
        switch (priority) {
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                this.priority = priority;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.invalidate();
    }

    public final void setSmallIcon(@DrawableRes int smallIconResourceId) {
        if (this.smallIconResourceId != smallIconResourceId) {
            this.smallIconResourceId = smallIconResourceId;
            this.invalidate();
        }
    }

    public final void setUseChronometer(boolean useChronometer) {
        if (this.useChronometer != useChronometer) {
            this.useChronometer = useChronometer;
            this.invalidate();
        }
    }

    public final void setVisibility(int visibility) {
        if (this.visibility == visibility) {
            return;
        }
        switch (visibility) {
            case -1: 
            case 0: 
            case 1: {
                this.visibility = visibility;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.invalidate();
    }

    public void invalidate() {
        if (this.isNotificationStarted) {
            this.postStartOrUpdateNotification();
        }
    }

    private void startOrUpdateNotification(Player player, @Nullable Bitmap bitmap) {
        NotificationListener listener;
        boolean ongoing = this.getOngoing(player);
        this.builder = this.createNotification(player, this.builder, ongoing, bitmap);
        if (this.builder == null) {
            this.stopNotification(false);
            return;
        }
        Notification notification = this.builder.build();
        this.notificationManager.notify(this.notificationId, notification);
        if (!this.isNotificationStarted) {
            this.isNotificationStarted = true;
            this.context.registerReceiver((BroadcastReceiver)this.notificationBroadcastReceiver, this.intentFilter);
            if (this.notificationListener != null) {
                this.notificationListener.onNotificationStarted(this.notificationId, notification);
            }
        }
        if ((listener = this.notificationListener) != null) {
            listener.onNotificationPosted(this.notificationId, notification, ongoing);
        }
    }

    private void stopNotification(boolean dismissedByUser) {
        if (this.isNotificationStarted) {
            this.isNotificationStarted = false;
            this.mainHandler.removeMessages(0);
            this.notificationManager.cancel(this.notificationId);
            this.context.unregisterReceiver((BroadcastReceiver)this.notificationBroadcastReceiver);
            if (this.notificationListener != null) {
                this.notificationListener.onNotificationCancelled(this.notificationId, dismissedByUser);
                this.notificationListener.onNotificationCancelled(this.notificationId);
            }
        }
    }

    @Nullable
    protected NotificationCompat.Builder createNotification(Player player, @Nullable NotificationCompat.Builder builder, boolean ongoing, @Nullable Bitmap largeIcon) {
        int i;
        if (player.getPlaybackState() == 1 && (player.getCurrentTimeline().isEmpty() || this.playbackPreparer == null)) {
            this.builderActions = null;
            return null;
        }
        List<String> actionNames = this.getActions(player);
        ArrayList<NotificationCompat.Action> actions = new ArrayList<NotificationCompat.Action>(actionNames.size());
        for (i = 0; i < actionNames.size(); ++i) {
            NotificationCompat.Action action;
            String actionName = actionNames.get(i);
            NotificationCompat.Action action2 = action = this.playbackActions.containsKey(actionName) ? this.playbackActions.get(actionName) : this.customActions.get(actionName);
            if (action == null) continue;
            actions.add(action);
        }
        if (builder == null || !actions.equals(this.builderActions)) {
            builder = new NotificationCompat.Builder(this.context, this.channelId);
            this.builderActions = actions;
            for (i = 0; i < actions.size(); ++i) {
                builder.addAction((NotificationCompat.Action)actions.get(i));
            }
        }
        NotificationCompat.MediaStyle mediaStyle = new NotificationCompat.MediaStyle();
        if (this.mediaSessionToken != null) {
            mediaStyle.setMediaSession(this.mediaSessionToken);
        }
        mediaStyle.setShowActionsInCompactView(this.getActionIndicesForCompactView(actionNames, player));
        mediaStyle.setShowCancelButton(!ongoing);
        mediaStyle.setCancelButtonIntent(this.dismissPendingIntent);
        builder.setStyle((NotificationCompat.Style)mediaStyle);
        builder.setDeleteIntent(this.dismissPendingIntent);
        builder.setBadgeIconType(this.badgeIconType).setOngoing(ongoing).setColor(this.color).setColorized(this.colorized).setSmallIcon(this.smallIconResourceId).setVisibility(this.visibility).setPriority(this.priority).setDefaults(this.defaults);
        if (Util.SDK_INT >= 21 && this.useChronometer && player.isPlaying() && !player.isPlayingAd() && !player.isCurrentWindowDynamic() && player.getPlaybackParameters().speed == 1.0f) {
            builder.setWhen(System.currentTimeMillis() - player.getContentPosition()).setShowWhen(true).setUsesChronometer(true);
        } else {
            builder.setShowWhen(false).setUsesChronometer(false);
        }
        builder.setContentTitle((CharSequence)this.mediaDescriptionAdapter.getCurrentContentTitle(player));
        builder.setContentText((CharSequence)this.mediaDescriptionAdapter.getCurrentContentText(player));
        builder.setSubText((CharSequence)this.mediaDescriptionAdapter.getCurrentSubText(player));
        if (largeIcon == null) {
            largeIcon = this.mediaDescriptionAdapter.getCurrentLargeIcon(player, new BitmapCallback(++this.currentNotificationTag));
        }
        PlayerNotificationManager.setLargeIcon(builder, largeIcon);
        builder.setContentIntent(this.mediaDescriptionAdapter.createCurrentContentIntent(player));
        return builder;
    }

    protected List<String> getActions(Player player) {
        boolean enablePrevious = false;
        boolean enableRewind = false;
        boolean enableFastForward = false;
        boolean enableNext = false;
        Timeline timeline = player.getCurrentTimeline();
        if (!timeline.isEmpty() && !player.isPlayingAd()) {
            timeline.getWindow(player.getCurrentWindowIndex(), this.window);
            enablePrevious = this.window.isSeekable || !this.window.isDynamic || player.hasPrevious();
            enableRewind = this.rewindMs > 0L;
            enableFastForward = this.fastForwardMs > 0L;
            enableNext = this.window.isDynamic || player.hasNext();
        }
        ArrayList<String> stringActions = new ArrayList<String>();
        if (this.useNavigationActions && enablePrevious) {
            stringActions.add(ACTION_PREVIOUS);
        }
        if (enableRewind) {
            stringActions.add(ACTION_REWIND);
        }
        if (this.usePlayPauseActions) {
            if (this.shouldShowPauseButton(player)) {
                stringActions.add(ACTION_PAUSE);
            } else {
                stringActions.add(ACTION_PLAY);
            }
        }
        if (enableFastForward) {
            stringActions.add(ACTION_FAST_FORWARD);
        }
        if (this.useNavigationActions && enableNext) {
            stringActions.add(ACTION_NEXT);
        }
        if (this.customActionReceiver != null) {
            stringActions.addAll(this.customActionReceiver.getCustomActions(player));
        }
        if (this.useStopAction) {
            stringActions.add(ACTION_STOP);
        }
        return stringActions;
    }

    protected int[] getActionIndicesForCompactView(List<String> actionNames, Player player) {
        int pauseActionIndex = actionNames.indexOf(ACTION_PAUSE);
        int playActionIndex = actionNames.indexOf(ACTION_PLAY);
        int skipPreviousActionIndex = this.useNavigationActionsInCompactView ? actionNames.indexOf(ACTION_PREVIOUS) : -1;
        int skipNextActionIndex = this.useNavigationActionsInCompactView ? actionNames.indexOf(ACTION_NEXT) : -1;
        int[] actionIndices = new int[3];
        int actionCounter = 0;
        if (skipPreviousActionIndex != -1) {
            actionIndices[actionCounter++] = skipPreviousActionIndex;
        }
        boolean shouldShowPauseButton = this.shouldShowPauseButton(player);
        if (pauseActionIndex != -1 && shouldShowPauseButton) {
            actionIndices[actionCounter++] = pauseActionIndex;
        } else if (playActionIndex != -1 && !shouldShowPauseButton) {
            actionIndices[actionCounter++] = playActionIndex;
        }
        if (skipNextActionIndex != -1) {
            actionIndices[actionCounter++] = skipNextActionIndex;
        }
        return Arrays.copyOf(actionIndices, actionCounter);
    }

    protected boolean getOngoing(Player player) {
        int playbackState = player.getPlaybackState();
        return (playbackState == 2 || playbackState == 3) && player.getPlayWhenReady();
    }

    private void previous(Player player) {
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty() || player.isPlayingAd()) {
            return;
        }
        int windowIndex = player.getCurrentWindowIndex();
        timeline.getWindow(windowIndex, this.window);
        int previousWindowIndex = player.getPreviousWindowIndex();
        if (previousWindowIndex != -1 && (player.getCurrentPosition() <= 3000L || this.window.isDynamic && !this.window.isSeekable)) {
            this.seekTo(player, previousWindowIndex, -9223372036854775807L);
        } else {
            this.seekTo(player, windowIndex, 0L);
        }
    }

    private void next(Player player) {
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty() || player.isPlayingAd()) {
            return;
        }
        int windowIndex = player.getCurrentWindowIndex();
        int nextWindowIndex = player.getNextWindowIndex();
        if (nextWindowIndex != -1) {
            this.seekTo(player, nextWindowIndex, -9223372036854775807L);
        } else if (timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).isDynamic) {
            this.seekTo(player, windowIndex, -9223372036854775807L);
        }
    }

    private void rewind(Player player) {
        if (player.isCurrentWindowSeekable() && this.rewindMs > 0L) {
            this.seekToOffset(player, -this.rewindMs);
        }
    }

    private void fastForward(Player player) {
        if (player.isCurrentWindowSeekable() && this.fastForwardMs > 0L) {
            this.seekToOffset(player, this.fastForwardMs);
        }
    }

    private void seekToOffset(Player player, long offsetMs) {
        long positionMs = player.getCurrentPosition() + offsetMs;
        long durationMs = player.getDuration();
        if (durationMs != -9223372036854775807L) {
            positionMs = Math.min(positionMs, durationMs);
        }
        positionMs = Math.max(positionMs, 0L);
        this.seekTo(player, player.getCurrentWindowIndex(), positionMs);
    }

    private void seekTo(Player player, int windowIndex, long positionMs) {
        this.controlDispatcher.dispatchSeekTo(player, windowIndex, positionMs);
    }

    private boolean shouldShowPauseButton(Player player) {
        return player.getPlaybackState() != 4 && player.getPlaybackState() != 1 && player.getPlayWhenReady();
    }

    private void postStartOrUpdateNotification() {
        if (!this.mainHandler.hasMessages(0)) {
            this.mainHandler.sendEmptyMessage(0);
        }
    }

    private void postUpdateNotificationBitmap(Bitmap bitmap, int notificationTag) {
        this.mainHandler.obtainMessage(1, notificationTag, -1, (Object)bitmap).sendToTarget();
    }

    private boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                if (this.player == null) break;
                this.startOrUpdateNotification(this.player, null);
                break;
            }
            case 1: {
                if (this.player == null || !this.isNotificationStarted || this.currentNotificationTag != msg.arg1) break;
                this.startOrUpdateNotification(this.player, (Bitmap)msg.obj);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static Map<String, NotificationCompat.Action> createPlaybackActions(Context context, int instanceId) {
        HashMap<String, NotificationCompat.Action> actions = new HashMap<String, NotificationCompat.Action>();
        actions.put(ACTION_PLAY, new NotificationCompat.Action(R.drawable.exo_notification_play, (CharSequence)context.getString(R.string.exo_controls_play_description), PlayerNotificationManager.createBroadcastIntent(ACTION_PLAY, context, instanceId)));
        actions.put(ACTION_PAUSE, new NotificationCompat.Action(R.drawable.exo_notification_pause, (CharSequence)context.getString(R.string.exo_controls_pause_description), PlayerNotificationManager.createBroadcastIntent(ACTION_PAUSE, context, instanceId)));
        actions.put(ACTION_STOP, new NotificationCompat.Action(R.drawable.exo_notification_stop, (CharSequence)context.getString(R.string.exo_controls_stop_description), PlayerNotificationManager.createBroadcastIntent(ACTION_STOP, context, instanceId)));
        actions.put(ACTION_REWIND, new NotificationCompat.Action(R.drawable.exo_notification_rewind, (CharSequence)context.getString(R.string.exo_controls_rewind_description), PlayerNotificationManager.createBroadcastIntent(ACTION_REWIND, context, instanceId)));
        actions.put(ACTION_FAST_FORWARD, new NotificationCompat.Action(R.drawable.exo_notification_fastforward, (CharSequence)context.getString(R.string.exo_controls_fastforward_description), PlayerNotificationManager.createBroadcastIntent(ACTION_FAST_FORWARD, context, instanceId)));
        actions.put(ACTION_PREVIOUS, new NotificationCompat.Action(R.drawable.exo_notification_previous, (CharSequence)context.getString(R.string.exo_controls_previous_description), PlayerNotificationManager.createBroadcastIntent(ACTION_PREVIOUS, context, instanceId)));
        actions.put(ACTION_NEXT, new NotificationCompat.Action(R.drawable.exo_notification_next, (CharSequence)context.getString(R.string.exo_controls_next_description), PlayerNotificationManager.createBroadcastIntent(ACTION_NEXT, context, instanceId)));
        return actions;
    }

    private static PendingIntent createBroadcastIntent(String action, Context context, int instanceId) {
        Intent intent = new Intent(action).setPackage(context.getPackageName());
        intent.putExtra(EXTRA_INSTANCE_ID, instanceId);
        return PendingIntent.getBroadcast((Context)context, (int)instanceId, (Intent)intent, (int)0x8000000);
    }

    private static void setLargeIcon(NotificationCompat.Builder builder, @Nullable Bitmap largeIcon) {
        builder.setLargeIcon(largeIcon);
    }

    private class NotificationBroadcastReceiver
    extends BroadcastReceiver {
        private NotificationBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Player player = PlayerNotificationManager.this.player;
            if (player == null || !PlayerNotificationManager.this.isNotificationStarted || intent.getIntExtra(PlayerNotificationManager.EXTRA_INSTANCE_ID, PlayerNotificationManager.this.instanceId) != PlayerNotificationManager.this.instanceId) {
                return;
            }
            String action = intent.getAction();
            if (PlayerNotificationManager.ACTION_PLAY.equals(action)) {
                if (player.getPlaybackState() == 1) {
                    if (PlayerNotificationManager.this.playbackPreparer != null) {
                        PlayerNotificationManager.this.playbackPreparer.preparePlayback();
                    }
                } else if (player.getPlaybackState() == 4) {
                    PlayerNotificationManager.this.seekTo(player, player.getCurrentWindowIndex(), -9223372036854775807L);
                }
                PlayerNotificationManager.this.controlDispatcher.dispatchSetPlayWhenReady(player, true);
            } else if (PlayerNotificationManager.ACTION_PAUSE.equals(action)) {
                PlayerNotificationManager.this.controlDispatcher.dispatchSetPlayWhenReady(player, false);
            } else if (PlayerNotificationManager.ACTION_PREVIOUS.equals(action)) {
                PlayerNotificationManager.this.previous(player);
            } else if (PlayerNotificationManager.ACTION_REWIND.equals(action)) {
                PlayerNotificationManager.this.rewind(player);
            } else if (PlayerNotificationManager.ACTION_FAST_FORWARD.equals(action)) {
                PlayerNotificationManager.this.fastForward(player);
            } else if (PlayerNotificationManager.ACTION_NEXT.equals(action)) {
                PlayerNotificationManager.this.next(player);
            } else if (PlayerNotificationManager.ACTION_STOP.equals(action)) {
                PlayerNotificationManager.this.controlDispatcher.dispatchStop(player, true);
            } else if (PlayerNotificationManager.ACTION_DISMISS.equals(action)) {
                PlayerNotificationManager.this.stopNotification(true);
            } else if (action != null && PlayerNotificationManager.this.customActionReceiver != null && PlayerNotificationManager.this.customActions.containsKey(action)) {
                PlayerNotificationManager.this.customActionReceiver.onCustomAction(player, action, intent);
            }
        }
    }

    private class PlayerListener
    implements Player.EventListener {
        private PlayerListener() {
        }

        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            PlayerNotificationManager.this.postStartOrUpdateNotification();
        }

        public void onIsPlayingChanged(boolean isPlaying) {
            PlayerNotificationManager.this.postStartOrUpdateNotification();
        }

        public void onTimelineChanged(Timeline timeline, int reason) {
            PlayerNotificationManager.this.postStartOrUpdateNotification();
        }

        public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            PlayerNotificationManager.this.postStartOrUpdateNotification();
        }

        public void onPositionDiscontinuity(int reason) {
            PlayerNotificationManager.this.postStartOrUpdateNotification();
        }

        public void onRepeatModeChanged(int repeatMode) {
            PlayerNotificationManager.this.postStartOrUpdateNotification();
        }

        public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
            PlayerNotificationManager.this.postStartOrUpdateNotification();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Priority {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Visibility {
    }

    public final class BitmapCallback {
        private final int notificationTag;

        private BitmapCallback(int notificationTag) {
            this.notificationTag = notificationTag;
        }

        public void onBitmap(Bitmap bitmap) {
            if (bitmap != null) {
                PlayerNotificationManager.this.postUpdateNotificationBitmap(bitmap, this.notificationTag);
            }
        }
    }

    public static interface NotificationListener {
        @Deprecated
        default public void onNotificationStarted(int notificationId, Notification notification) {
        }

        @Deprecated
        default public void onNotificationCancelled(int notificationId) {
        }

        default public void onNotificationCancelled(int notificationId, boolean dismissedByUser) {
        }

        default public void onNotificationPosted(int notificationId, Notification notification, boolean ongoing) {
        }
    }

    public static interface CustomActionReceiver {
        public Map<String, NotificationCompat.Action> createCustomActions(Context var1, int var2);

        public List<String> getCustomActions(Player var1);

        public void onCustomAction(Player var1, String var2, Intent var3);
    }

    public static interface MediaDescriptionAdapter {
        public String getCurrentContentTitle(Player var1);

        @Nullable
        public PendingIntent createCurrentContentIntent(Player var1);

        @Nullable
        public String getCurrentContentText(Player var1);

        @Nullable
        default public String getCurrentSubText(Player player) {
            return null;
        }

        @Nullable
        public Bitmap getCurrentLargeIcon(Player var1, BitmapCallback var2);
    }
}

