/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui.spherical;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.os.SystemClock;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.AnyThread;
import androidx.annotation.UiThread;
import com.google.android.exoplayer2.ui.spherical.CanvasRenderer;
import com.google.android.exoplayer2.util.Assertions;

public final class GlViewGroup
extends FrameLayout {
    private final CanvasRenderer canvasRenderer = new CanvasRenderer();

    public GlViewGroup(Context context, int layoutId) {
        super(context);
        LayoutInflater.from((Context)context).inflate(layoutId, (ViewGroup)this);
        this.measure(-2, -2);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        Assertions.checkState((width > 0 && height > 0 ? 1 : 0) != 0);
        this.canvasRenderer.setSize(width, height);
        this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(width, height));
    }

    @UiThread
    public boolean isVisible() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (this.getChildAt(i).getVisibility() != 0) continue;
            return true;
        }
        return false;
    }

    public void dispatchDraw(Canvas notUsed) {
        Canvas glCanvas = this.canvasRenderer.lockCanvas();
        if (glCanvas == null) {
            this.postInvalidate();
            return;
        }
        glCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        super.dispatchDraw(glCanvas);
        this.canvasRenderer.unlockCanvasAndPost(glCanvas);
    }

    @UiThread
    public boolean simulateClick(int action, float yaw, float pitch) {
        if (!this.isVisible()) {
            return false;
        }
        PointF point = this.canvasRenderer.translateClick(yaw, pitch);
        if (point == null) {
            return false;
        }
        long now = SystemClock.uptimeMillis();
        MotionEvent event = MotionEvent.obtain((long)now, (long)now, (int)action, (float)point.x, (float)point.y, (int)1);
        this.dispatchTouchEvent(event);
        return true;
    }

    @AnyThread
    public CanvasRenderer getRenderer() {
        return this.canvasRenderer;
    }
}

