/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ControlDispatcher;
import com.google.android.exoplayer2.DefaultControlDispatcher;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.PlaybackPreparer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.ui.DefaultTimeBar;
import com.google.android.exoplayer2.ui.R;
import com.google.android.exoplayer2.ui.TimeBar;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.RepeatModeUtil;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;

public class PlayerControlView
extends FrameLayout {
    public static final int DEFAULT_FAST_FORWARD_MS = 15000;
    public static final int DEFAULT_REWIND_MS = 5000;
    public static final int DEFAULT_SHOW_TIMEOUT_MS = 5000;
    public static final int DEFAULT_REPEAT_TOGGLE_MODES = 0;
    public static final int DEFAULT_TIME_BAR_MIN_UPDATE_INTERVAL_MS = 200;
    public static final int MAX_WINDOWS_FOR_MULTI_WINDOW_TIME_BAR = 100;
    private static final long MAX_POSITION_FOR_SEEK_TO_PREVIOUS = 3000L;
    private static final int MAX_UPDATE_INTERVAL_MS = 1000;
    private final ComponentListener componentListener;
    private final View previousButton;
    private final View nextButton;
    private final View playButton;
    private final View pauseButton;
    private final View fastForwardButton;
    private final View rewindButton;
    private final ImageView repeatToggleButton;
    private final ImageView shuffleButton;
    private final View vrButton;
    private final TextView durationView;
    private final TextView positionView;
    private final TimeBar timeBar;
    private final StringBuilder formatBuilder;
    private final Formatter formatter;
    private final Timeline.Period period;
    private final Timeline.Window window;
    private final Runnable updateProgressAction;
    private final Runnable hideAction;
    private final Drawable repeatOffButtonDrawable;
    private final Drawable repeatOneButtonDrawable;
    private final Drawable repeatAllButtonDrawable;
    private final String repeatOffButtonContentDescription;
    private final String repeatOneButtonContentDescription;
    private final String repeatAllButtonContentDescription;
    private final Drawable shuffleOnButtonDrawable;
    private final Drawable shuffleOffButtonDrawable;
    private final float buttonAlphaEnabled;
    private final float buttonAlphaDisabled;
    private final String shuffleOnContentDescription;
    private final String shuffleOffContentDescription;
    @Nullable
    private Player player;
    private ControlDispatcher controlDispatcher;
    @Nullable
    private VisibilityListener visibilityListener;
    @Nullable
    private ProgressUpdateListener progressUpdateListener;
    @Nullable
    private PlaybackPreparer playbackPreparer;
    private boolean isAttachedToWindow;
    private boolean showMultiWindowTimeBar;
    private boolean multiWindowTimeBar;
    private boolean scrubbing;
    private int rewindMs;
    private int fastForwardMs;
    private int showTimeoutMs;
    private int timeBarMinUpdateIntervalMs;
    private int repeatToggleModes;
    private boolean showShuffleButton;
    private long hideAtMs;
    private long[] adGroupTimesMs;
    private boolean[] playedAdGroups;
    private long[] extraAdGroupTimesMs;
    private boolean[] extraPlayedAdGroups;
    private long currentWindowOffset;

    public PlayerControlView(Context context) {
        this(context, null);
    }

    public PlayerControlView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PlayerControlView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerControlView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, @Nullable AttributeSet playbackAttrs) {
        super(context, attrs, defStyleAttr);
        int controllerLayoutId = R.layout.exo_player_control_view;
        this.rewindMs = 5000;
        this.fastForwardMs = 15000;
        this.showTimeoutMs = 5000;
        this.repeatToggleModes = 0;
        this.timeBarMinUpdateIntervalMs = 200;
        this.hideAtMs = -9223372036854775807L;
        this.showShuffleButton = false;
        if (playbackAttrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(playbackAttrs, R.styleable.PlayerControlView, 0, 0);
            try {
                this.rewindMs = a.getInt(R.styleable.PlayerControlView_rewind_increment, this.rewindMs);
                this.fastForwardMs = a.getInt(R.styleable.PlayerControlView_fastforward_increment, this.fastForwardMs);
                this.showTimeoutMs = a.getInt(R.styleable.PlayerControlView_show_timeout, this.showTimeoutMs);
                controllerLayoutId = a.getResourceId(R.styleable.PlayerControlView_controller_layout_id, controllerLayoutId);
                this.repeatToggleModes = PlayerControlView.getRepeatToggleModes(a, this.repeatToggleModes);
                this.showShuffleButton = a.getBoolean(R.styleable.PlayerControlView_show_shuffle_button, this.showShuffleButton);
                this.setTimeBarMinUpdateInterval(a.getInt(R.styleable.PlayerControlView_time_bar_min_update_interval, this.timeBarMinUpdateIntervalMs));
            }
            finally {
                a.recycle();
            }
        }
        this.period = new Timeline.Period();
        this.window = new Timeline.Window();
        this.formatBuilder = new StringBuilder();
        this.formatter = new Formatter(this.formatBuilder, Locale.getDefault());
        this.adGroupTimesMs = new long[0];
        this.playedAdGroups = new boolean[0];
        this.extraAdGroupTimesMs = new long[0];
        this.extraPlayedAdGroups = new boolean[0];
        this.componentListener = new ComponentListener();
        this.controlDispatcher = new DefaultControlDispatcher();
        this.updateProgressAction = this::updateProgress;
        this.hideAction = this::hide;
        LayoutInflater.from((Context)context).inflate(controllerLayoutId, (ViewGroup)this);
        this.setDescendantFocusability(262144);
        TimeBar customTimeBar = (TimeBar)this.findViewById(R.id.exo_progress);
        View timeBarPlaceholder = this.findViewById(R.id.exo_progress_placeholder);
        if (customTimeBar != null) {
            this.timeBar = customTimeBar;
        } else if (timeBarPlaceholder != null) {
            DefaultTimeBar defaultTimeBar = new DefaultTimeBar(context, null, 0, playbackAttrs);
            defaultTimeBar.setId(R.id.exo_progress);
            defaultTimeBar.setLayoutParams(timeBarPlaceholder.getLayoutParams());
            ViewGroup parent = (ViewGroup)timeBarPlaceholder.getParent();
            int timeBarIndex = parent.indexOfChild(timeBarPlaceholder);
            parent.removeView(timeBarPlaceholder);
            parent.addView((View)defaultTimeBar, timeBarIndex);
            this.timeBar = defaultTimeBar;
        } else {
            this.timeBar = null;
        }
        this.durationView = (TextView)this.findViewById(R.id.exo_duration);
        this.positionView = (TextView)this.findViewById(R.id.exo_position);
        if (this.timeBar != null) {
            this.timeBar.addListener(this.componentListener);
        }
        this.playButton = this.findViewById(R.id.exo_play);
        if (this.playButton != null) {
            this.playButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.pauseButton = this.findViewById(R.id.exo_pause);
        if (this.pauseButton != null) {
            this.pauseButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.previousButton = this.findViewById(R.id.exo_prev);
        if (this.previousButton != null) {
            this.previousButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.nextButton = this.findViewById(R.id.exo_next);
        if (this.nextButton != null) {
            this.nextButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.rewindButton = this.findViewById(R.id.exo_rew);
        if (this.rewindButton != null) {
            this.rewindButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.fastForwardButton = this.findViewById(R.id.exo_ffwd);
        if (this.fastForwardButton != null) {
            this.fastForwardButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.repeatToggleButton = (ImageView)this.findViewById(R.id.exo_repeat_toggle);
        if (this.repeatToggleButton != null) {
            this.repeatToggleButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.shuffleButton = (ImageView)this.findViewById(R.id.exo_shuffle);
        if (this.shuffleButton != null) {
            this.shuffleButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.vrButton = this.findViewById(R.id.exo_vr);
        this.setShowVrButton(false);
        Resources resources = context.getResources();
        this.buttonAlphaEnabled = (float)resources.getInteger(R.integer.exo_media_button_opacity_percentage_enabled) / 100.0f;
        this.buttonAlphaDisabled = (float)resources.getInteger(R.integer.exo_media_button_opacity_percentage_disabled) / 100.0f;
        this.repeatOffButtonDrawable = resources.getDrawable(R.drawable.exo_controls_repeat_off);
        this.repeatOneButtonDrawable = resources.getDrawable(R.drawable.exo_controls_repeat_one);
        this.repeatAllButtonDrawable = resources.getDrawable(R.drawable.exo_controls_repeat_all);
        this.shuffleOnButtonDrawable = resources.getDrawable(R.drawable.exo_controls_shuffle_on);
        this.shuffleOffButtonDrawable = resources.getDrawable(R.drawable.exo_controls_shuffle_off);
        this.repeatOffButtonContentDescription = resources.getString(R.string.exo_controls_repeat_off_description);
        this.repeatOneButtonContentDescription = resources.getString(R.string.exo_controls_repeat_one_description);
        this.repeatAllButtonContentDescription = resources.getString(R.string.exo_controls_repeat_all_description);
        this.shuffleOnContentDescription = resources.getString(R.string.exo_controls_shuffle_on_description);
        this.shuffleOffContentDescription = resources.getString(R.string.exo_controls_shuffle_off_description);
    }

    private static int getRepeatToggleModes(TypedArray a, int repeatToggleModes) {
        return a.getInt(R.styleable.PlayerControlView_repeat_toggle_modes, repeatToggleModes);
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(@Nullable Player player) {
        Assertions.checkState((Looper.myLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        Assertions.checkArgument((player == null || player.getApplicationLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        if (this.player == player) {
            return;
        }
        if (this.player != null) {
            this.player.removeListener((Player.EventListener)this.componentListener);
        }
        this.player = player;
        if (player != null) {
            player.addListener((Player.EventListener)this.componentListener);
        }
        this.updateAll();
    }

    public void setShowMultiWindowTimeBar(boolean showMultiWindowTimeBar) {
        this.showMultiWindowTimeBar = showMultiWindowTimeBar;
        this.updateTimeline();
    }

    public void setExtraAdGroupMarkers(@Nullable long[] extraAdGroupTimesMs, @Nullable boolean[] extraPlayedAdGroups) {
        if (extraAdGroupTimesMs == null) {
            this.extraAdGroupTimesMs = new long[0];
            this.extraPlayedAdGroups = new boolean[0];
        } else {
            Assertions.checkArgument((extraAdGroupTimesMs.length == (extraPlayedAdGroups = (boolean[])Assertions.checkNotNull((Object)extraPlayedAdGroups)).length ? 1 : 0) != 0);
            this.extraAdGroupTimesMs = extraAdGroupTimesMs;
            this.extraPlayedAdGroups = extraPlayedAdGroups;
        }
        this.updateTimeline();
    }

    public void setVisibilityListener(VisibilityListener listener) {
        this.visibilityListener = listener;
    }

    public void setProgressUpdateListener(@Nullable ProgressUpdateListener listener) {
        this.progressUpdateListener = listener;
    }

    public void setPlaybackPreparer(@Nullable PlaybackPreparer playbackPreparer) {
        this.playbackPreparer = playbackPreparer;
    }

    public void setControlDispatcher(@Nullable ControlDispatcher controlDispatcher) {
        this.controlDispatcher = controlDispatcher == null ? new DefaultControlDispatcher() : controlDispatcher;
    }

    public void setRewindIncrementMs(int rewindMs) {
        this.rewindMs = rewindMs;
        this.updateNavigation();
    }

    public void setFastForwardIncrementMs(int fastForwardMs) {
        this.fastForwardMs = fastForwardMs;
        this.updateNavigation();
    }

    public int getShowTimeoutMs() {
        return this.showTimeoutMs;
    }

    public void setShowTimeoutMs(int showTimeoutMs) {
        this.showTimeoutMs = showTimeoutMs;
        if (this.isVisible()) {
            this.hideAfterTimeout();
        }
    }

    public int getRepeatToggleModes() {
        return this.repeatToggleModes;
    }

    public void setRepeatToggleModes(int repeatToggleModes) {
        this.repeatToggleModes = repeatToggleModes;
        if (this.player != null) {
            int currentMode = this.player.getRepeatMode();
            if (repeatToggleModes == 0 && currentMode != 0) {
                this.controlDispatcher.dispatchSetRepeatMode(this.player, 0);
            } else if (repeatToggleModes == 1 && currentMode == 2) {
                this.controlDispatcher.dispatchSetRepeatMode(this.player, 1);
            } else if (repeatToggleModes == 2 && currentMode == 1) {
                this.controlDispatcher.dispatchSetRepeatMode(this.player, 2);
            }
        }
        this.updateRepeatModeButton();
    }

    public boolean getShowShuffleButton() {
        return this.showShuffleButton;
    }

    public void setShowShuffleButton(boolean showShuffleButton) {
        this.showShuffleButton = showShuffleButton;
        this.updateShuffleButton();
    }

    public boolean getShowVrButton() {
        return this.vrButton != null && this.vrButton.getVisibility() == 0;
    }

    public void setShowVrButton(boolean showVrButton) {
        if (this.vrButton != null) {
            this.vrButton.setVisibility(showVrButton ? 0 : 8);
        }
    }

    public void setVrButtonListener(@Nullable View.OnClickListener onClickListener) {
        if (this.vrButton != null) {
            this.vrButton.setOnClickListener(onClickListener);
        }
    }

    public void setTimeBarMinUpdateInterval(int minUpdateIntervalMs) {
        this.timeBarMinUpdateIntervalMs = Util.constrainValue((int)minUpdateIntervalMs, (int)16, (int)1000);
    }

    public void show() {
        if (!this.isVisible()) {
            this.setVisibility(0);
            if (this.visibilityListener != null) {
                this.visibilityListener.onVisibilityChange(this.getVisibility());
            }
            this.updateAll();
            this.requestPlayPauseFocus();
        }
        this.hideAfterTimeout();
    }

    public void hide() {
        if (this.isVisible()) {
            this.setVisibility(8);
            if (this.visibilityListener != null) {
                this.visibilityListener.onVisibilityChange(this.getVisibility());
            }
            this.removeCallbacks(this.updateProgressAction);
            this.removeCallbacks(this.hideAction);
            this.hideAtMs = -9223372036854775807L;
        }
    }

    public boolean isVisible() {
        return this.getVisibility() == 0;
    }

    private void hideAfterTimeout() {
        this.removeCallbacks(this.hideAction);
        if (this.showTimeoutMs > 0) {
            this.hideAtMs = SystemClock.uptimeMillis() + (long)this.showTimeoutMs;
            if (this.isAttachedToWindow) {
                this.postDelayed(this.hideAction, this.showTimeoutMs);
            }
        } else {
            this.hideAtMs = -9223372036854775807L;
        }
    }

    private void updateAll() {
        this.updatePlayPauseButton();
        this.updateNavigation();
        this.updateRepeatModeButton();
        this.updateShuffleButton();
        this.updateTimeline();
    }

    private void updatePlayPauseButton() {
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        boolean requestPlayPauseFocus = false;
        boolean shouldShowPauseButton = this.shouldShowPauseButton();
        if (this.playButton != null) {
            requestPlayPauseFocus |= shouldShowPauseButton && this.playButton.isFocused();
            this.playButton.setVisibility(shouldShowPauseButton ? 8 : 0);
        }
        if (this.pauseButton != null) {
            requestPlayPauseFocus |= !shouldShowPauseButton && this.pauseButton.isFocused();
            this.pauseButton.setVisibility(shouldShowPauseButton ? 0 : 8);
        }
        if (requestPlayPauseFocus) {
            this.requestPlayPauseFocus();
        }
    }

    private void updateNavigation() {
        Timeline timeline;
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        boolean enableSeeking = false;
        boolean enablePrevious = false;
        boolean enableRewind = false;
        boolean enableFastForward = false;
        boolean enableNext = false;
        if (this.player != null && !(timeline = this.player.getCurrentTimeline()).isEmpty() && !this.player.isPlayingAd()) {
            boolean isSeekable;
            timeline.getWindow(this.player.getCurrentWindowIndex(), this.window);
            enableSeeking = isSeekable = this.window.isSeekable;
            enablePrevious = isSeekable || !this.window.isDynamic || this.player.hasPrevious();
            enableRewind = isSeekable && this.rewindMs > 0;
            enableFastForward = isSeekable && this.fastForwardMs > 0;
            enableNext = this.window.isDynamic || this.player.hasNext();
        }
        this.setButtonEnabled(enablePrevious, this.previousButton);
        this.setButtonEnabled(enableRewind, this.rewindButton);
        this.setButtonEnabled(enableFastForward, this.fastForwardButton);
        this.setButtonEnabled(enableNext, this.nextButton);
        if (this.timeBar != null) {
            this.timeBar.setEnabled(enableSeeking);
        }
    }

    private void updateRepeatModeButton() {
        if (!this.isVisible() || !this.isAttachedToWindow || this.repeatToggleButton == null) {
            return;
        }
        if (this.repeatToggleModes == 0) {
            this.repeatToggleButton.setVisibility(8);
            return;
        }
        if (this.player == null) {
            this.setButtonEnabled(false, (View)this.repeatToggleButton);
            this.repeatToggleButton.setImageDrawable(this.repeatOffButtonDrawable);
            this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOffButtonContentDescription);
            return;
        }
        this.setButtonEnabled(true, (View)this.repeatToggleButton);
        switch (this.player.getRepeatMode()) {
            case 0: {
                this.repeatToggleButton.setImageDrawable(this.repeatOffButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOffButtonContentDescription);
                break;
            }
            case 1: {
                this.repeatToggleButton.setImageDrawable(this.repeatOneButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOneButtonContentDescription);
                break;
            }
            case 2: {
                this.repeatToggleButton.setImageDrawable(this.repeatAllButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatAllButtonContentDescription);
                break;
            }
        }
        this.repeatToggleButton.setVisibility(0);
    }

    private void updateShuffleButton() {
        if (!this.isVisible() || !this.isAttachedToWindow || this.shuffleButton == null) {
            return;
        }
        if (!this.showShuffleButton) {
            this.shuffleButton.setVisibility(8);
        } else if (this.player == null) {
            this.setButtonEnabled(false, (View)this.shuffleButton);
            this.shuffleButton.setImageDrawable(this.shuffleOffButtonDrawable);
            this.shuffleButton.setContentDescription((CharSequence)this.shuffleOffContentDescription);
        } else {
            this.setButtonEnabled(true, (View)this.shuffleButton);
            this.shuffleButton.setImageDrawable(this.player.getShuffleModeEnabled() ? this.shuffleOnButtonDrawable : this.shuffleOffButtonDrawable);
            this.shuffleButton.setContentDescription((CharSequence)(this.player.getShuffleModeEnabled() ? this.shuffleOnContentDescription : this.shuffleOffContentDescription));
        }
    }

    private void updateTimeline() {
        if (this.player == null) {
            return;
        }
        this.multiWindowTimeBar = this.showMultiWindowTimeBar && PlayerControlView.canShowMultiWindowTimeBar(this.player.getCurrentTimeline(), this.window);
        this.currentWindowOffset = 0L;
        long durationUs = 0L;
        int adGroupCount = 0;
        Timeline timeline = this.player.getCurrentTimeline();
        if (!timeline.isEmpty()) {
            int currentWindowIndex = this.player.getCurrentWindowIndex();
            int firstWindowIndex = this.multiWindowTimeBar ? 0 : currentWindowIndex;
            int lastWindowIndex = this.multiWindowTimeBar ? timeline.getWindowCount() - 1 : currentWindowIndex;
            for (int i = firstWindowIndex; i <= lastWindowIndex; ++i) {
                if (i == currentWindowIndex) {
                    this.currentWindowOffset = C.usToMs((long)durationUs);
                }
                timeline.getWindow(i, this.window);
                if (this.window.durationUs == -9223372036854775807L) {
                    Assertions.checkState((!this.multiWindowTimeBar ? 1 : 0) != 0);
                    break;
                }
                for (int j = this.window.firstPeriodIndex; j <= this.window.lastPeriodIndex; ++j) {
                    timeline.getPeriod(j, this.period);
                    int periodAdGroupCount = this.period.getAdGroupCount();
                    for (int adGroupIndex = 0; adGroupIndex < periodAdGroupCount; ++adGroupIndex) {
                        long adGroupTimeInWindowUs;
                        long adGroupTimeInPeriodUs = this.period.getAdGroupTimeUs(adGroupIndex);
                        if (adGroupTimeInPeriodUs == Long.MIN_VALUE) {
                            if (this.period.durationUs == -9223372036854775807L) continue;
                            adGroupTimeInPeriodUs = this.period.durationUs;
                        }
                        if ((adGroupTimeInWindowUs = adGroupTimeInPeriodUs + this.period.getPositionInWindowUs()) < 0L || adGroupTimeInWindowUs > this.window.durationUs) continue;
                        if (adGroupCount == this.adGroupTimesMs.length) {
                            int newLength = this.adGroupTimesMs.length == 0 ? 1 : this.adGroupTimesMs.length * 2;
                            this.adGroupTimesMs = Arrays.copyOf(this.adGroupTimesMs, newLength);
                            this.playedAdGroups = Arrays.copyOf(this.playedAdGroups, newLength);
                        }
                        this.adGroupTimesMs[adGroupCount] = C.usToMs((long)(durationUs + adGroupTimeInWindowUs));
                        this.playedAdGroups[adGroupCount] = this.period.hasPlayedAdGroup(adGroupIndex);
                        ++adGroupCount;
                    }
                }
                durationUs += this.window.durationUs;
            }
        }
        long durationMs = C.usToMs((long)durationUs);
        if (this.durationView != null) {
            this.durationView.setText((CharSequence)Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)durationMs));
        }
        if (this.timeBar != null) {
            this.timeBar.setDuration(durationMs);
            int extraAdGroupCount = this.extraAdGroupTimesMs.length;
            int totalAdGroupCount = adGroupCount + extraAdGroupCount;
            if (totalAdGroupCount > this.adGroupTimesMs.length) {
                this.adGroupTimesMs = Arrays.copyOf(this.adGroupTimesMs, totalAdGroupCount);
                this.playedAdGroups = Arrays.copyOf(this.playedAdGroups, totalAdGroupCount);
            }
            System.arraycopy(this.extraAdGroupTimesMs, 0, this.adGroupTimesMs, adGroupCount, extraAdGroupCount);
            System.arraycopy(this.extraPlayedAdGroups, 0, this.playedAdGroups, adGroupCount, extraAdGroupCount);
            this.timeBar.setAdGroupTimesMs(this.adGroupTimesMs, this.playedAdGroups, totalAdGroupCount);
        }
        this.updateProgress();
    }

    private void updateProgress() {
        int playbackState;
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        long position = 0L;
        long bufferedPosition = 0L;
        if (this.player != null) {
            position = this.currentWindowOffset + this.player.getContentPosition();
            bufferedPosition = this.currentWindowOffset + this.player.getContentBufferedPosition();
        }
        if (this.positionView != null && !this.scrubbing) {
            this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)position));
        }
        if (this.timeBar != null) {
            this.timeBar.setPosition(position);
            this.timeBar.setBufferedPosition(bufferedPosition);
        }
        if (this.progressUpdateListener != null) {
            this.progressUpdateListener.onProgressUpdate(position, bufferedPosition);
        }
        this.removeCallbacks(this.updateProgressAction);
        int n = playbackState = this.player == null ? 1 : this.player.getPlaybackState();
        if (this.player != null && this.player.isPlaying()) {
            long mediaTimeDelayMs = this.timeBar != null ? this.timeBar.getPreferredUpdateDelay() : 1000L;
            long mediaTimeUntilNextFullSecondMs = 1000L - position % 1000L;
            mediaTimeDelayMs = Math.min(mediaTimeDelayMs, mediaTimeUntilNextFullSecondMs);
            float playbackSpeed = this.player.getPlaybackParameters().speed;
            long delayMs = playbackSpeed > 0.0f ? (long)((float)mediaTimeDelayMs / playbackSpeed) : 1000L;
            delayMs = Util.constrainValue((long)delayMs, (long)this.timeBarMinUpdateIntervalMs, (long)1000L);
            this.postDelayed(this.updateProgressAction, delayMs);
        } else if (playbackState != 4 && playbackState != 1) {
            this.postDelayed(this.updateProgressAction, 1000L);
        }
    }

    private void requestPlayPauseFocus() {
        boolean shouldShowPauseButton = this.shouldShowPauseButton();
        if (!shouldShowPauseButton && this.playButton != null) {
            this.playButton.requestFocus();
        } else if (shouldShowPauseButton && this.pauseButton != null) {
            this.pauseButton.requestFocus();
        }
    }

    private void setButtonEnabled(boolean enabled, View view) {
        if (view == null) {
            return;
        }
        view.setEnabled(enabled);
        view.setAlpha(enabled ? this.buttonAlphaEnabled : this.buttonAlphaDisabled);
        view.setVisibility(0);
    }

    private void previous(Player player) {
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty() || player.isPlayingAd()) {
            return;
        }
        int windowIndex = player.getCurrentWindowIndex();
        timeline.getWindow(windowIndex, this.window);
        int previousWindowIndex = player.getPreviousWindowIndex();
        if (previousWindowIndex != -1 && (player.getCurrentPosition() <= 3000L || this.window.isDynamic && !this.window.isSeekable)) {
            this.seekTo(player, previousWindowIndex, -9223372036854775807L);
        } else {
            this.seekTo(player, windowIndex, 0L);
        }
    }

    private void next(Player player) {
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty() || player.isPlayingAd()) {
            return;
        }
        int windowIndex = player.getCurrentWindowIndex();
        int nextWindowIndex = player.getNextWindowIndex();
        if (nextWindowIndex != -1) {
            this.seekTo(player, nextWindowIndex, -9223372036854775807L);
        } else if (timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).isDynamic) {
            this.seekTo(player, windowIndex, -9223372036854775807L);
        }
    }

    private void rewind(Player player) {
        if (player.isCurrentWindowSeekable() && this.rewindMs > 0) {
            this.seekToOffset(player, -this.rewindMs);
        }
    }

    private void fastForward(Player player) {
        if (player.isCurrentWindowSeekable() && this.fastForwardMs > 0) {
            this.seekToOffset(player, this.fastForwardMs);
        }
    }

    private void seekToOffset(Player player, long offsetMs) {
        long positionMs = player.getCurrentPosition() + offsetMs;
        long durationMs = player.getDuration();
        if (durationMs != -9223372036854775807L) {
            positionMs = Math.min(positionMs, durationMs);
        }
        positionMs = Math.max(positionMs, 0L);
        this.seekTo(player, player.getCurrentWindowIndex(), positionMs);
    }

    private void seekToTimeBarPosition(Player player, long positionMs) {
        boolean dispatched;
        int windowIndex;
        Timeline timeline = player.getCurrentTimeline();
        if (this.multiWindowTimeBar && !timeline.isEmpty()) {
            long windowDurationMs;
            int windowCount = timeline.getWindowCount();
            windowIndex = 0;
            while (positionMs >= (windowDurationMs = timeline.getWindow(windowIndex, this.window).getDurationMs())) {
                if (windowIndex == windowCount - 1) {
                    positionMs = windowDurationMs;
                    break;
                }
                positionMs -= windowDurationMs;
                ++windowIndex;
            }
        } else {
            windowIndex = player.getCurrentWindowIndex();
        }
        if (!(dispatched = this.seekTo(player, windowIndex, positionMs))) {
            this.updateProgress();
        }
    }

    private boolean seekTo(Player player, int windowIndex, long positionMs) {
        return this.controlDispatcher.dispatchSeekTo(player, windowIndex, positionMs);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isAttachedToWindow = true;
        if (this.hideAtMs != -9223372036854775807L) {
            long delayMs = this.hideAtMs - SystemClock.uptimeMillis();
            if (delayMs <= 0L) {
                this.hide();
            } else {
                this.postDelayed(this.hideAction, delayMs);
            }
        } else if (this.isVisible()) {
            this.hideAfterTimeout();
        }
        this.updateAll();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isAttachedToWindow = false;
        this.removeCallbacks(this.updateProgressAction);
        this.removeCallbacks(this.hideAction);
    }

    public final boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.removeCallbacks(this.hideAction);
        } else if (ev.getAction() == 1) {
            this.hideAfterTimeout();
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return this.dispatchMediaKeyEvent(event) || super.dispatchKeyEvent(event);
    }

    public boolean dispatchMediaKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (this.player == null || !PlayerControlView.isHandledMediaKey(keyCode)) {
            return false;
        }
        if (event.getAction() == 0) {
            if (keyCode == 90) {
                this.fastForward(this.player);
            } else if (keyCode == 89) {
                this.rewind(this.player);
            } else if (event.getRepeatCount() == 0) {
                switch (keyCode) {
                    case 85: {
                        this.controlDispatcher.dispatchSetPlayWhenReady(this.player, !this.player.getPlayWhenReady());
                        break;
                    }
                    case 126: {
                        this.controlDispatcher.dispatchSetPlayWhenReady(this.player, true);
                        break;
                    }
                    case 127: {
                        this.controlDispatcher.dispatchSetPlayWhenReady(this.player, false);
                        break;
                    }
                    case 87: {
                        this.next(this.player);
                        break;
                    }
                    case 88: {
                        this.previous(this.player);
                        break;
                    }
                }
            }
        }
        return true;
    }

    private boolean shouldShowPauseButton() {
        return this.player != null && this.player.getPlaybackState() != 4 && this.player.getPlaybackState() != 1 && this.player.getPlayWhenReady();
    }

    @SuppressLint(value={"InlinedApi"})
    private static boolean isHandledMediaKey(int keyCode) {
        return keyCode == 90 || keyCode == 89 || keyCode == 85 || keyCode == 126 || keyCode == 127 || keyCode == 87 || keyCode == 88;
    }

    private static boolean canShowMultiWindowTimeBar(Timeline timeline, Timeline.Window window) {
        if (timeline.getWindowCount() > 100) {
            return false;
        }
        int windowCount = timeline.getWindowCount();
        for (int i = 0; i < windowCount; ++i) {
            if (timeline.getWindow((int)i, (Timeline.Window)window).durationUs != -9223372036854775807L) continue;
            return false;
        }
        return true;
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.ui");
    }

    private final class ComponentListener
    implements Player.EventListener,
    TimeBar.OnScrubListener,
    View.OnClickListener {
        private ComponentListener() {
        }

        @Override
        public void onScrubStart(TimeBar timeBar, long position) {
            PlayerControlView.this.scrubbing = true;
            if (PlayerControlView.this.positionView != null) {
                PlayerControlView.this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)PlayerControlView.this.formatBuilder, (Formatter)PlayerControlView.this.formatter, (long)position));
            }
        }

        @Override
        public void onScrubMove(TimeBar timeBar, long position) {
            if (PlayerControlView.this.positionView != null) {
                PlayerControlView.this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)PlayerControlView.this.formatBuilder, (Formatter)PlayerControlView.this.formatter, (long)position));
            }
        }

        @Override
        public void onScrubStop(TimeBar timeBar, long position, boolean canceled) {
            PlayerControlView.this.scrubbing = false;
            if (!canceled && PlayerControlView.this.player != null) {
                PlayerControlView.this.seekToTimeBarPosition(PlayerControlView.this.player, position);
            }
        }

        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            PlayerControlView.this.updatePlayPauseButton();
            PlayerControlView.this.updateProgress();
        }

        public void onIsPlayingChanged(boolean isPlaying) {
            PlayerControlView.this.updateProgress();
        }

        public void onRepeatModeChanged(int repeatMode) {
            PlayerControlView.this.updateRepeatModeButton();
            PlayerControlView.this.updateNavigation();
        }

        public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
            PlayerControlView.this.updateShuffleButton();
            PlayerControlView.this.updateNavigation();
        }

        public void onPositionDiscontinuity(int reason) {
            PlayerControlView.this.updateNavigation();
            PlayerControlView.this.updateTimeline();
        }

        public void onTimelineChanged(Timeline timeline, @Nullable Object manifest, int reason) {
            PlayerControlView.this.updateNavigation();
            PlayerControlView.this.updateTimeline();
        }

        public void onClick(View view) {
            Player player = PlayerControlView.this.player;
            if (player == null) {
                return;
            }
            if (PlayerControlView.this.nextButton == view) {
                PlayerControlView.this.next(player);
            } else if (PlayerControlView.this.previousButton == view) {
                PlayerControlView.this.previous(player);
            } else if (PlayerControlView.this.fastForwardButton == view) {
                PlayerControlView.this.fastForward(player);
            } else if (PlayerControlView.this.rewindButton == view) {
                PlayerControlView.this.rewind(player);
            } else if (PlayerControlView.this.playButton == view) {
                if (player.getPlaybackState() == 1) {
                    if (PlayerControlView.this.playbackPreparer != null) {
                        PlayerControlView.this.playbackPreparer.preparePlayback();
                    }
                } else if (player.getPlaybackState() == 4) {
                    PlayerControlView.this.seekTo(player, player.getCurrentWindowIndex(), -9223372036854775807L);
                }
                PlayerControlView.this.controlDispatcher.dispatchSetPlayWhenReady(player, true);
            } else if (PlayerControlView.this.pauseButton == view) {
                PlayerControlView.this.controlDispatcher.dispatchSetPlayWhenReady(player, false);
            } else if (PlayerControlView.this.repeatToggleButton == view) {
                PlayerControlView.this.controlDispatcher.dispatchSetRepeatMode(player, RepeatModeUtil.getNextRepeatMode((int)player.getRepeatMode(), (int)PlayerControlView.this.repeatToggleModes));
            } else if (PlayerControlView.this.shuffleButton == view) {
                PlayerControlView.this.controlDispatcher.dispatchSetShuffleModeEnabled(player, !player.getShuffleModeEnabled());
            }
        }
    }

    public static interface ProgressUpdateListener {
        public void onProgressUpdate(long var1, long var3);
    }

    public static interface VisibilityListener {
        public void onVisibilityChange(int var1);
    }
}

