/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.media.MediaCodec;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.effect.Presentation;
import com.google.android.exoplayer2.effect.ScaleToFitTransformation;
import com.google.android.exoplayer2.transformer.BaseSamplePipeline;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.EncoderUtil;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.Transformer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.DebugViewProvider;
import com.google.android.exoplayer2.util.Effect;
import com.google.android.exoplayer2.util.FrameInfo;
import com.google.android.exoplayer2.util.FrameProcessingException;
import com.google.android.exoplayer2.util.FrameProcessor;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.SurfaceInfo;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.dataflow.qual.Pure;

final class VideoTranscodingSamplePipeline
extends BaseSamplePipeline {
    private final int maxPendingFrameCount;
    private final DecoderInputBuffer decoderInputBuffer;
    private final Codec decoder;
    private final ArrayList<Long> decodeOnlyPresentationTimestamps;
    private final FrameProcessor frameProcessor;
    private final EncoderWrapper encoderWrapper;
    private final DecoderInputBuffer encoderOutputBuffer;

    public VideoTranscodingSamplePipeline(Context context, Format inputFormat, long streamOffsetUs, long streamStartPositionUs, TransformationRequest transformationRequest, ImmutableList<Effect> effects, FrameProcessor.Factory frameProcessorFactory, Codec.DecoderFactory decoderFactory, Codec.EncoderFactory encoderFactory, MuxerWrapper muxerWrapper, FallbackListener fallbackListener, final Transformer.AsyncErrorListener asyncErrorListener, DebugViewProvider debugViewProvider) throws TransformationException {
        super(inputFormat, streamOffsetUs, streamStartPositionUs, transformationRequest.flattenForSlowMotion, muxerWrapper);
        if (ColorInfo.isTransferHdr((ColorInfo)inputFormat.colorInfo)) {
            if (transformationRequest.forceInterpretHdrVideoAsSdr) {
                if (Util.SDK_INT < 29) {
                    throw TransformationException.createForCodec((Throwable)new IllegalArgumentException("Interpreting HDR video as SDR is not supported."), true, true, inputFormat, null, 3004);
                }
                inputFormat = inputFormat.buildUpon().setColorInfo(ColorInfo.SDR_BT709_LIMITED).build();
            } else if (Util.SDK_INT < 31 || VideoTranscodingSamplePipeline.deviceNeedsNoToneMappingWorkaround()) {
                throw TransformationException.createForCodec((Throwable)new IllegalArgumentException("HDR editing and tone mapping is not supported."), true, false, inputFormat, null, 4004);
            }
        }
        this.decoderInputBuffer = new DecoderInputBuffer(0);
        this.encoderOutputBuffer = new DecoderInputBuffer(0);
        this.decodeOnlyPresentationTimestamps = new ArrayList();
        int decodedWidth = inputFormat.rotationDegrees % 180 == 0 ? inputFormat.width : inputFormat.height;
        int decodedHeight = inputFormat.rotationDegrees % 180 == 0 ? inputFormat.height : inputFormat.width;
        ImmutableList.Builder effectsListBuilder = new ImmutableList.Builder().addAll(effects);
        if (transformationRequest.scaleX != 1.0f || transformationRequest.scaleY != 1.0f || transformationRequest.rotationDegrees != 0.0f) {
            effectsListBuilder.add((Object)new ScaleToFitTransformation.Builder().setScale(transformationRequest.scaleX, transformationRequest.scaleY).setRotationDegrees(transformationRequest.rotationDegrees).build());
        }
        if (transformationRequest.outputHeight != -1) {
            effectsListBuilder.add((Object)Presentation.createForHeight((int)transformationRequest.outputHeight));
        }
        this.encoderWrapper = new EncoderWrapper(encoderFactory, inputFormat, (List<String>)muxerWrapper.getSupportedSampleMimeTypes(2), transformationRequest, fallbackListener);
        try {
            this.frameProcessor = frameProcessorFactory.create(context, new FrameProcessor.Listener(){

                public void onOutputSizeChanged(int width, int height) {
                    try {
                        ((FrameProcessor)Assertions.checkNotNull((Object)VideoTranscodingSamplePipeline.this.frameProcessor)).setOutputSurfaceInfo(VideoTranscodingSamplePipeline.this.encoderWrapper.getSurfaceInfo(width, height));
                    }
                    catch (TransformationException exception) {
                        asyncErrorListener.onTransformationException(exception);
                    }
                }

                public void onOutputFrameAvailable(long presentationTimeUs) {
                }

                public void onFrameProcessingError(FrameProcessingException exception) {
                    asyncErrorListener.onTransformationException(TransformationException.createForFrameProcessingException(exception, 5001));
                }

                public void onFrameProcessingEnded() {
                    try {
                        VideoTranscodingSamplePipeline.this.encoderWrapper.signalEndOfInputStream();
                    }
                    catch (TransformationException exception) {
                        asyncErrorListener.onTransformationException(exception);
                    }
                }
            }, (List)effectsListBuilder.build(), debugViewProvider, this.encoderWrapper.getSupportedInputColor(), true);
        }
        catch (FrameProcessingException e) {
            throw TransformationException.createForFrameProcessingException(e, 5001);
        }
        this.frameProcessor.setInputFrameInfo(new FrameInfo(decodedWidth, decodedHeight, inputFormat.pixelWidthHeightRatio, streamOffsetUs));
        boolean isToneMappingRequired = ColorInfo.isTransferHdr((ColorInfo)inputFormat.colorInfo) && !ColorInfo.isTransferHdr((ColorInfo)this.encoderWrapper.getSupportedInputColor());
        this.decoder = decoderFactory.createForVideoDecoding(inputFormat, this.frameProcessor.getInputSurface(), isToneMappingRequired);
        this.maxPendingFrameCount = this.decoder.getMaxPendingFrameCount();
    }

    @Override
    public void release() {
        this.frameProcessor.release();
        this.decoder.release();
        this.encoderWrapper.release();
    }

    @Override
    @Nullable
    protected DecoderInputBuffer dequeueInputBufferInternal() throws TransformationException {
        return this.decoder.maybeDequeueInputBuffer(this.decoderInputBuffer) ? this.decoderInputBuffer : null;
    }

    @Override
    protected void queueInputBufferInternal() throws TransformationException {
        if (this.decoderInputBuffer.isDecodeOnly()) {
            this.decodeOnlyPresentationTimestamps.add(this.decoderInputBuffer.timeUs);
        }
        this.decoder.queueInputBuffer(this.decoderInputBuffer);
    }

    @Override
    protected boolean processDataUpToMuxer() throws TransformationException {
        if (this.decoder.isEnded()) {
            return false;
        }
        boolean processedData = false;
        while (this.maybeProcessDecoderOutput()) {
            processedData = true;
        }
        if (this.decoder.isEnded()) {
            this.frameProcessor.signalEndOfInput();
        }
        return processedData;
    }

    @Override
    @Nullable
    protected Format getMuxerInputFormat() throws TransformationException {
        return this.encoderWrapper.getOutputFormat();
    }

    @Override
    @Nullable
    protected DecoderInputBuffer getMuxerInputBuffer() throws TransformationException {
        this.encoderOutputBuffer.data = this.encoderWrapper.getOutputBuffer();
        if (this.encoderOutputBuffer.data == null) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo = (MediaCodec.BufferInfo)Assertions.checkNotNull((Object)this.encoderWrapper.getOutputBufferInfo());
        this.encoderOutputBuffer.timeUs = bufferInfo.presentationTimeUs;
        this.encoderOutputBuffer.setFlags(bufferInfo.flags);
        return this.encoderOutputBuffer;
    }

    @Override
    protected void releaseMuxerInputBuffer() throws TransformationException {
        this.encoderWrapper.releaseOutputBuffer(false);
    }

    @Override
    protected boolean isMuxerInputEnded() {
        return this.encoderWrapper.isEnded();
    }

    @Pure
    private static TransformationRequest createSupportedTransformationRequest(TransformationRequest transformationRequest, boolean hasOutputFormatRotation, Format requestedFormat, Format supportedFormat, boolean isToneMappedToSdr) {
        if (transformationRequest.enableRequestSdrToneMapping == isToneMappedToSdr && Util.areEqual((Object)requestedFormat.sampleMimeType, (Object)supportedFormat.sampleMimeType) && (hasOutputFormatRotation ? requestedFormat.width == supportedFormat.width : requestedFormat.height == supportedFormat.height)) {
            return transformationRequest;
        }
        TransformationRequest.Builder transformationRequestBuilder = transformationRequest.buildUpon();
        if (transformationRequest.enableRequestSdrToneMapping != isToneMappedToSdr) {
            Assertions.checkState((boolean)isToneMappedToSdr);
            transformationRequestBuilder.setEnableRequestSdrToneMapping(true).experimental_setEnableHdrEditing(false);
        }
        return transformationRequestBuilder.setVideoMimeType(supportedFormat.sampleMimeType).setResolution(hasOutputFormatRotation ? requestedFormat.width : requestedFormat.height).build();
    }

    private static boolean deviceNeedsNoToneMappingWorkaround() {
        return Util.MANUFACTURER.equals("Google") && (Build.ID.startsWith("TP1A") || Build.ID.startsWith("rwd9.220429.053"));
    }

    private boolean maybeProcessDecoderOutput() throws TransformationException {
        MediaCodec.BufferInfo decoderOutputBufferInfo = this.decoder.getOutputBufferInfo();
        if (decoderOutputBufferInfo == null) {
            return false;
        }
        if (this.isDecodeOnlyBuffer(decoderOutputBufferInfo.presentationTimeUs)) {
            this.decoder.releaseOutputBuffer(false);
            return true;
        }
        if (this.maxPendingFrameCount != Integer.MAX_VALUE && this.frameProcessor.getPendingInputFrameCount() == this.maxPendingFrameCount) {
            return false;
        }
        this.frameProcessor.registerInputFrame();
        this.decoder.releaseOutputBuffer(true);
        return true;
    }

    private boolean isDecodeOnlyBuffer(long presentationTimeUs) {
        int size = this.decodeOnlyPresentationTimestamps.size();
        for (int i = 0; i < size; ++i) {
            if (this.decodeOnlyPresentationTimestamps.get(i) != presentationTimeUs) continue;
            this.decodeOnlyPresentationTimestamps.remove(i);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static final class EncoderWrapper {
        private static final String TAG = "EncoderWrapper";
        private final Codec.EncoderFactory encoderFactory;
        private final Format inputFormat;
        private final List<String> allowedOutputMimeTypes;
        private final TransformationRequest transformationRequest;
        private final FallbackListener fallbackListener;
        private final String requestedOutputMimeType;
        private final ImmutableList<String> supportedEncoderNamesForHdrEditing;
        private @MonotonicNonNull SurfaceInfo encoderSurfaceInfo;
        private volatile @MonotonicNonNull Codec encoder;
        private volatile int outputRotationDegrees;
        private volatile boolean releaseEncoder;

        public EncoderWrapper(Codec.EncoderFactory encoderFactory, Format inputFormat, List<String> allowedOutputMimeTypes, TransformationRequest transformationRequest, FallbackListener fallbackListener) {
            this.encoderFactory = encoderFactory;
            this.inputFormat = inputFormat;
            this.allowedOutputMimeTypes = allowedOutputMimeTypes;
            this.transformationRequest = transformationRequest;
            this.fallbackListener = fallbackListener;
            this.requestedOutputMimeType = transformationRequest.videoMimeType != null ? transformationRequest.videoMimeType : (String)Assertions.checkNotNull((Object)inputFormat.sampleMimeType);
            this.supportedEncoderNamesForHdrEditing = EncoderUtil.getSupportedEncoderNamesForHdrEditing(this.requestedOutputMimeType, inputFormat.colorInfo);
        }

        public ColorInfo getSupportedInputColor() {
            boolean isInputToneMapped;
            boolean isHdrEditingEnabled = this.transformationRequest.enableHdrEditing && !this.transformationRequest.enableRequestSdrToneMapping && !this.supportedEncoderNamesForHdrEditing.isEmpty();
            boolean bl = isInputToneMapped = !isHdrEditingEnabled && ColorInfo.isTransferHdr((ColorInfo)this.inputFormat.colorInfo);
            if (isInputToneMapped) {
                return ColorInfo.SDR_BT709_LIMITED;
            }
            if (this.inputFormat.colorInfo == null) {
                Log.d((String)TAG, (String)"colorInfo is null. Defaulting to SDR_BT709_LIMITED.");
                return ColorInfo.SDR_BT709_LIMITED;
            }
            return this.inputFormat.colorInfo;
        }

        @Nullable
        public SurfaceInfo getSurfaceInfo(int requestedWidth, int requestedHeight) throws TransformationException {
            boolean flipOrientation;
            if (this.releaseEncoder) {
                return null;
            }
            if (this.encoderSurfaceInfo != null) {
                return this.encoderSurfaceInfo;
            }
            boolean bl = flipOrientation = requestedWidth < requestedHeight;
            if (flipOrientation) {
                int temp = requestedWidth;
                requestedWidth = requestedHeight;
                requestedHeight = temp;
                this.outputRotationDegrees = 90;
            }
            Format requestedEncoderFormat = new Format.Builder().setWidth(requestedWidth).setHeight(requestedHeight).setRotationDegrees(0).setFrameRate(this.inputFormat.frameRate).setSampleMimeType(this.requestedOutputMimeType).setColorInfo(this.getSupportedInputColor()).build();
            this.encoder = this.encoderFactory.createForVideoEncoding(requestedEncoderFormat, this.allowedOutputMimeTypes);
            Format encoderSupportedFormat = this.encoder.getConfigurationFormat();
            if (ColorInfo.isTransferHdr((ColorInfo)requestedEncoderFormat.colorInfo)) {
                if (!this.requestedOutputMimeType.equals(encoderSupportedFormat.sampleMimeType)) {
                    throw this.createEncodingException(new IllegalStateException("MIME type fallback unsupported with HDR editing"), encoderSupportedFormat);
                }
                if (!this.supportedEncoderNamesForHdrEditing.contains((Object)this.encoder.getName())) {
                    throw this.createEncodingException(new IllegalStateException("Selected encoder doesn't support HDR editing"), encoderSupportedFormat);
                }
            }
            boolean isInputToneMapped = ColorInfo.isTransferHdr((ColorInfo)this.inputFormat.colorInfo) && !ColorInfo.isTransferHdr((ColorInfo)requestedEncoderFormat.colorInfo);
            this.fallbackListener.onTransformationRequestFinalized(VideoTranscodingSamplePipeline.createSupportedTransformationRequest(this.transformationRequest, flipOrientation, requestedEncoderFormat, encoderSupportedFormat, isInputToneMapped));
            this.encoderSurfaceInfo = new SurfaceInfo(this.encoder.getInputSurface(), encoderSupportedFormat.width, encoderSupportedFormat.height, this.outputRotationDegrees);
            if (this.releaseEncoder) {
                this.encoder.release();
            }
            return this.encoderSurfaceInfo;
        }

        public void signalEndOfInputStream() throws TransformationException {
            if (this.encoder != null) {
                this.encoder.signalEndOfInputStream();
            }
        }

        @Nullable
        public Format getOutputFormat() throws TransformationException {
            if (this.encoder == null) {
                return null;
            }
            Format outputFormat = this.encoder.getOutputFormat();
            if (outputFormat != null && this.outputRotationDegrees != 0) {
                outputFormat = outputFormat.buildUpon().setRotationDegrees(this.outputRotationDegrees).build();
            }
            return outputFormat;
        }

        @Nullable
        public ByteBuffer getOutputBuffer() throws TransformationException {
            return this.encoder != null ? this.encoder.getOutputBuffer() : null;
        }

        @Nullable
        public MediaCodec.BufferInfo getOutputBufferInfo() throws TransformationException {
            return this.encoder != null ? this.encoder.getOutputBufferInfo() : null;
        }

        public void releaseOutputBuffer(boolean render) throws TransformationException {
            if (this.encoder != null) {
                this.encoder.releaseOutputBuffer(render);
            }
        }

        public boolean isEnded() {
            return this.encoder != null && this.encoder.isEnded();
        }

        public void release() {
            if (this.encoder != null) {
                this.encoder.release();
            }
            this.releaseEncoder = true;
        }

        private TransformationException createEncodingException(Exception cause, Format format) {
            return TransformationException.createForCodec((Throwable)cause, true, false, format, ((Codec)Assertions.checkNotNull((Object)this.encoder)).getName(), 4002);
        }
    }
}

