/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.PassthroughSamplePipeline;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.transformer.Transformer;
import com.google.android.exoplayer2.transformer.TransformerBaseRenderer;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.transformer.VideoTranscodingSamplePipeline;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.DebugViewProvider;
import com.google.android.exoplayer2.util.Effect;
import com.google.android.exoplayer2.util.FrameProcessor;
import com.google.common.collect.ImmutableList;

final class TransformerVideoRenderer
extends TransformerBaseRenderer {
    private static final String TAG = "TVideoRenderer";
    private final Context context;
    private final boolean clippingStartsAtKeyFrame;
    private final ImmutableList<Effect> effects;
    private final FrameProcessor.Factory frameProcessorFactory;
    private final Codec.EncoderFactory encoderFactory;
    private final Codec.DecoderFactory decoderFactory;
    private final DebugViewProvider debugViewProvider;
    private final DecoderInputBuffer decoderInputBuffer;

    public TransformerVideoRenderer(Context context, MuxerWrapper muxerWrapper, TransformerMediaClock mediaClock, TransformationRequest transformationRequest, boolean clippingStartsAtKeyFrame, ImmutableList<Effect> effects, FrameProcessor.Factory frameProcessorFactory, Codec.EncoderFactory encoderFactory, Codec.DecoderFactory decoderFactory, Transformer.AsyncErrorListener asyncErrorListener, FallbackListener fallbackListener, DebugViewProvider debugViewProvider) {
        super(2, muxerWrapper, mediaClock, transformationRequest, asyncErrorListener, fallbackListener);
        this.context = context;
        this.clippingStartsAtKeyFrame = clippingStartsAtKeyFrame;
        this.effects = effects;
        this.frameProcessorFactory = frameProcessorFactory;
        this.encoderFactory = encoderFactory;
        this.decoderFactory = decoderFactory;
        this.debugViewProvider = debugViewProvider;
        this.decoderInputBuffer = new DecoderInputBuffer(0);
    }

    public String getName() {
        return TAG;
    }

    @Override
    protected boolean ensureConfigured() throws TransformationException {
        if (this.samplePipeline != null) {
            return true;
        }
        FormatHolder formatHolder = this.getFormatHolder();
        int result = this.readSource(formatHolder, this.decoderInputBuffer, 2);
        if (result != -5) {
            return false;
        }
        Format inputFormat = (Format)Assertions.checkNotNull((Object)formatHolder.format);
        this.samplePipeline = this.shouldTranscode(inputFormat) ? new VideoTranscodingSamplePipeline(this.context, inputFormat, this.streamOffsetUs, this.streamStartPositionUs, this.transformationRequest, this.effects, this.frameProcessorFactory, this.decoderFactory, this.encoderFactory, this.muxerWrapper, this.fallbackListener, this.asyncErrorListener, this.debugViewProvider) : new PassthroughSamplePipeline(inputFormat, this.streamOffsetUs, this.streamStartPositionUs, this.transformationRequest, this.muxerWrapper, this.fallbackListener);
        return true;
    }

    private boolean shouldTranscode(Format inputFormat) {
        int decodedHeight;
        if (this.streamStartPositionUs - this.streamOffsetUs != 0L && !this.clippingStartsAtKeyFrame) {
            return true;
        }
        if (this.encoderFactory.videoNeedsEncoding()) {
            return true;
        }
        if (this.transformationRequest.enableRequestSdrToneMapping) {
            return true;
        }
        if (this.transformationRequest.forceInterpretHdrVideoAsSdr) {
            return true;
        }
        if (this.transformationRequest.videoMimeType != null && !this.transformationRequest.videoMimeType.equals(inputFormat.sampleMimeType)) {
            return true;
        }
        if (this.transformationRequest.videoMimeType == null && !this.muxerWrapper.supportsSampleMimeType(inputFormat.sampleMimeType)) {
            return true;
        }
        if (inputFormat.pixelWidthHeightRatio != 1.0f) {
            return true;
        }
        if (this.transformationRequest.rotationDegrees != 0.0f) {
            return true;
        }
        if (this.transformationRequest.scaleX != 1.0f) {
            return true;
        }
        if (this.transformationRequest.scaleY != 1.0f) {
            return true;
        }
        int n = decodedHeight = inputFormat.rotationDegrees % 180 == 0 ? inputFormat.height : inputFormat.width;
        if (this.transformationRequest.outputHeight != -1 && this.transformationRequest.outputHeight != decodedHeight) {
            return true;
        }
        return !this.effects.isEmpty();
    }
}

