/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.media.MediaCodec;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.transformer.BaseSamplePipeline;
import com.google.android.exoplayer2.transformer.Codec;
import com.google.android.exoplayer2.transformer.FallbackListener;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.SegmentSpeedProvider;
import com.google.android.exoplayer2.transformer.SpeedChangingAudioProcessor;
import com.google.android.exoplayer2.transformer.TransformationException;
import com.google.android.exoplayer2.transformer.TransformationRequest;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.util.List;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.dataflow.qual.Pure;

final class AudioTranscodingSamplePipeline
extends BaseSamplePipeline {
    private static final int DEFAULT_ENCODER_BITRATE = 131072;
    private final Codec decoder;
    private final DecoderInputBuffer decoderInputBuffer = new DecoderInputBuffer(0);
    @Nullable
    private final SpeedChangingAudioProcessor speedChangingAudioProcessor;
    private final Codec encoder;
    private final AudioProcessor.AudioFormat encoderInputAudioFormat;
    private final DecoderInputBuffer encoderInputBuffer = new DecoderInputBuffer(0);
    private final DecoderInputBuffer encoderOutputBuffer = new DecoderInputBuffer(0);
    private ByteBuffer processorOutputBuffer;
    private long nextEncoderInputBufferTimeUs;
    private long encoderBufferDurationRemainder;

    public AudioTranscodingSamplePipeline(Format inputFormat, long streamOffsetUs, long streamStartPositionUs, TransformationRequest transformationRequest, Codec.DecoderFactory decoderFactory, Codec.EncoderFactory encoderFactory, MuxerWrapper muxerWrapper, FallbackListener fallbackListener) throws TransformationException {
        super(inputFormat, streamOffsetUs, streamStartPositionUs, transformationRequest.flattenForSlowMotion, muxerWrapper);
        this.decoder = decoderFactory.createForAudioDecoding(inputFormat);
        AudioProcessor.AudioFormat encoderInputAudioFormat = new AudioProcessor.AudioFormat(inputFormat.sampleRate, inputFormat.channelCount, 2);
        if (transformationRequest.flattenForSlowMotion) {
            this.speedChangingAudioProcessor = new SpeedChangingAudioProcessor(new SegmentSpeedProvider(inputFormat));
            try {
                encoderInputAudioFormat = this.speedChangingAudioProcessor.configure(encoderInputAudioFormat);
            }
            catch (AudioProcessor.UnhandledAudioFormatException impossible) {
                throw new IllegalStateException(impossible);
            }
            this.speedChangingAudioProcessor.flush();
        } else {
            this.speedChangingAudioProcessor = null;
        }
        this.processorOutputBuffer = AudioProcessor.EMPTY_BUFFER;
        this.encoderInputAudioFormat = encoderInputAudioFormat;
        Format requestedOutputFormat = new Format.Builder().setSampleMimeType(transformationRequest.audioMimeType == null ? inputFormat.sampleMimeType : transformationRequest.audioMimeType).setSampleRate(encoderInputAudioFormat.sampleRate).setChannelCount(encoderInputAudioFormat.channelCount).setAverageBitrate(131072).build();
        this.encoder = encoderFactory.createForAudioEncoding(requestedOutputFormat, (List<String>)muxerWrapper.getSupportedSampleMimeTypes(1));
        fallbackListener.onTransformationRequestFinalized(AudioTranscodingSamplePipeline.createFallbackTransformationRequest(transformationRequest, requestedOutputFormat, this.encoder.getConfigurationFormat()));
        this.nextEncoderInputBufferTimeUs = streamOffsetUs;
    }

    @Override
    public void release() {
        if (this.speedChangingAudioProcessor != null) {
            this.speedChangingAudioProcessor.reset();
        }
        this.decoder.release();
        this.encoder.release();
    }

    @Override
    @Nullable
    protected DecoderInputBuffer dequeueInputBufferInternal() throws TransformationException {
        return this.decoder.maybeDequeueInputBuffer(this.decoderInputBuffer) ? this.decoderInputBuffer : null;
    }

    @Override
    protected void queueInputBufferInternal() throws TransformationException {
        this.decoder.queueInputBuffer(this.decoderInputBuffer);
    }

    @Override
    protected boolean processDataUpToMuxer() throws TransformationException {
        if (this.speedChangingAudioProcessor != null) {
            return this.feedEncoderFromProcessor() || this.feedProcessorFromDecoder();
        }
        return this.feedEncoderFromDecoder();
    }

    @Override
    @Nullable
    protected Format getMuxerInputFormat() throws TransformationException {
        return this.encoder.getOutputFormat();
    }

    @Override
    @Nullable
    protected DecoderInputBuffer getMuxerInputBuffer() throws TransformationException {
        this.encoderOutputBuffer.data = this.encoder.getOutputBuffer();
        if (this.encoderOutputBuffer.data == null) {
            return null;
        }
        this.encoderOutputBuffer.timeUs = ((MediaCodec.BufferInfo)Assertions.checkNotNull((Object)this.encoder.getOutputBufferInfo())).presentationTimeUs;
        this.encoderOutputBuffer.setFlags(1);
        return this.encoderOutputBuffer;
    }

    @Override
    protected void releaseMuxerInputBuffer() throws TransformationException {
        this.encoder.releaseOutputBuffer(false);
    }

    @Override
    protected boolean isMuxerInputEnded() {
        return this.encoder.isEnded();
    }

    private boolean feedEncoderFromDecoder() throws TransformationException {
        if (!this.encoder.maybeDequeueInputBuffer(this.encoderInputBuffer)) {
            return false;
        }
        if (this.decoder.isEnded()) {
            this.queueEndOfStreamToEncoder();
            return false;
        }
        ByteBuffer decoderOutputBuffer = this.decoder.getOutputBuffer();
        if (decoderOutputBuffer == null) {
            return false;
        }
        this.feedEncoder(decoderOutputBuffer);
        if (!decoderOutputBuffer.hasRemaining()) {
            this.decoder.releaseOutputBuffer(false);
        }
        return true;
    }

    @RequiresNonNull(value={"speedChangingAudioProcessor"})
    private boolean feedEncoderFromProcessor() throws TransformationException {
        if (!this.encoder.maybeDequeueInputBuffer(this.encoderInputBuffer)) {
            return false;
        }
        if (!this.processorOutputBuffer.hasRemaining()) {
            this.processorOutputBuffer = this.speedChangingAudioProcessor.getOutput();
            if (!this.processorOutputBuffer.hasRemaining()) {
                if (this.decoder.isEnded() && this.speedChangingAudioProcessor.isEnded()) {
                    this.queueEndOfStreamToEncoder();
                }
                return false;
            }
        }
        this.feedEncoder(this.processorOutputBuffer);
        return true;
    }

    @RequiresNonNull(value={"speedChangingAudioProcessor"})
    private boolean feedProcessorFromDecoder() throws TransformationException {
        if (this.processorOutputBuffer.hasRemaining() || this.speedChangingAudioProcessor.getOutput().hasRemaining()) {
            return false;
        }
        if (this.decoder.isEnded()) {
            this.speedChangingAudioProcessor.queueEndOfStream();
            return false;
        }
        Assertions.checkState((!this.speedChangingAudioProcessor.isEnded() ? 1 : 0) != 0);
        ByteBuffer decoderOutputBuffer = this.decoder.getOutputBuffer();
        if (decoderOutputBuffer == null) {
            return false;
        }
        this.speedChangingAudioProcessor.queueInput(decoderOutputBuffer);
        if (!decoderOutputBuffer.hasRemaining()) {
            this.decoder.releaseOutputBuffer(false);
        }
        return true;
    }

    private void feedEncoder(ByteBuffer inputBuffer) throws TransformationException {
        ByteBuffer encoderInputBufferData = (ByteBuffer)Assertions.checkNotNull((Object)this.encoderInputBuffer.data);
        int bufferLimit = inputBuffer.limit();
        inputBuffer.limit(Math.min(bufferLimit, inputBuffer.position() + encoderInputBufferData.capacity()));
        encoderInputBufferData.put(inputBuffer);
        this.encoderInputBuffer.timeUs = this.nextEncoderInputBufferTimeUs;
        this.computeNextEncoderInputBufferTimeUs(encoderInputBufferData.position(), this.encoderInputAudioFormat.bytesPerFrame, this.encoderInputAudioFormat.sampleRate);
        this.encoderInputBuffer.setFlags(0);
        this.encoderInputBuffer.flip();
        inputBuffer.limit(bufferLimit);
        this.encoder.queueInputBuffer(this.encoderInputBuffer);
    }

    private void queueEndOfStreamToEncoder() throws TransformationException {
        Assertions.checkState((((ByteBuffer)Assertions.checkNotNull((Object)this.encoderInputBuffer.data)).position() == 0 ? 1 : 0) != 0);
        this.encoderInputBuffer.timeUs = this.nextEncoderInputBufferTimeUs;
        this.encoderInputBuffer.addFlag(4);
        this.encoderInputBuffer.flip();
        this.encoder.queueInputBuffer(this.encoderInputBuffer);
    }

    private void computeNextEncoderInputBufferTimeUs(long bytesWritten, int bytesPerFrame, int sampleRate) {
        long numerator = bytesWritten * 1000000L + this.encoderBufferDurationRemainder;
        long denominator = (long)bytesPerFrame * (long)sampleRate;
        long bufferDurationUs = numerator / denominator;
        this.encoderBufferDurationRemainder = numerator - bufferDurationUs * denominator;
        if (this.encoderBufferDurationRemainder > 0L) {
            ++bufferDurationUs;
            this.encoderBufferDurationRemainder -= denominator;
        }
        this.nextEncoderInputBufferTimeUs += bufferDurationUs;
    }

    @Pure
    private static TransformationRequest createFallbackTransformationRequest(TransformationRequest transformationRequest, Format requestedFormat, Format actualFormat) {
        if (Util.areEqual((Object)requestedFormat.sampleMimeType, (Object)actualFormat.sampleMimeType)) {
            return transformationRequest;
        }
        return transformationRequest.buildUpon().setAudioMimeType(actualFormat.sampleMimeType).build();
    }
}

