/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.id3;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataInputBuffer;
import com.google.android.exoplayer2.metadata.SimpleMetadataDecoder;
import com.google.android.exoplayer2.metadata.id3.ApicFrame;
import com.google.android.exoplayer2.metadata.id3.BinaryFrame;
import com.google.android.exoplayer2.metadata.id3.ChapterFrame;
import com.google.android.exoplayer2.metadata.id3.ChapterTocFrame;
import com.google.android.exoplayer2.metadata.id3.CommentFrame;
import com.google.android.exoplayer2.metadata.id3.GeobFrame;
import com.google.android.exoplayer2.metadata.id3.Id3Frame;
import com.google.android.exoplayer2.metadata.id3.MlltFrame;
import com.google.android.exoplayer2.metadata.id3.PrivFrame;
import com.google.android.exoplayer2.metadata.id3.TextInformationFrame;
import com.google.android.exoplayer2.metadata.id3.UrlLinkFrame;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Ascii;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@Deprecated
public final class Id3Decoder
extends SimpleMetadataDecoder {
    public static final FramePredicate NO_FRAMES_PREDICATE = (majorVersion, id0, id1, id2, id3) -> false;
    private static final String TAG = "Id3Decoder";
    public static final int ID3_TAG = 0x494433;
    public static final int ID3_HEADER_LENGTH = 10;
    private static final int FRAME_FLAG_V3_IS_COMPRESSED = 128;
    private static final int FRAME_FLAG_V3_IS_ENCRYPTED = 64;
    private static final int FRAME_FLAG_V3_HAS_GROUP_IDENTIFIER = 32;
    private static final int FRAME_FLAG_V4_IS_COMPRESSED = 8;
    private static final int FRAME_FLAG_V4_IS_ENCRYPTED = 4;
    private static final int FRAME_FLAG_V4_HAS_GROUP_IDENTIFIER = 64;
    private static final int FRAME_FLAG_V4_IS_UNSYNCHRONIZED = 2;
    private static final int FRAME_FLAG_V4_HAS_DATA_LENGTH = 1;
    private static final int ID3_TEXT_ENCODING_ISO_8859_1 = 0;
    private static final int ID3_TEXT_ENCODING_UTF_16 = 1;
    private static final int ID3_TEXT_ENCODING_UTF_16BE = 2;
    private static final int ID3_TEXT_ENCODING_UTF_8 = 3;
    @Nullable
    private final FramePredicate framePredicate;

    public Id3Decoder() {
        this(null);
    }

    public Id3Decoder(@Nullable FramePredicate framePredicate) {
        this.framePredicate = framePredicate;
    }

    @Override
    @Nullable
    protected Metadata decode(MetadataInputBuffer inputBuffer, ByteBuffer buffer) {
        return this.decode(buffer.array(), buffer.limit());
    }

    @Nullable
    public Metadata decode(byte[] data, int size) {
        ArrayList<Id3Frame> id3Frames = new ArrayList<Id3Frame>();
        ParsableByteArray id3Data = new ParsableByteArray(data, size);
        Id3Header id3Header = Id3Decoder.decodeHeader(id3Data);
        if (id3Header == null) {
            return null;
        }
        int startPosition = id3Data.getPosition();
        int frameHeaderSize = id3Header.majorVersion == 2 ? 6 : 10;
        int framesSize = id3Header.framesSize;
        if (id3Header.isUnsynchronized) {
            framesSize = Id3Decoder.removeUnsynchronization(id3Data, id3Header.framesSize);
        }
        id3Data.setLimit(startPosition + framesSize);
        boolean unsignedIntFrameSizeHack = false;
        if (!Id3Decoder.validateFrames(id3Data, id3Header.majorVersion, frameHeaderSize, false)) {
            if (id3Header.majorVersion == 4 && Id3Decoder.validateFrames(id3Data, 4, frameHeaderSize, true)) {
                unsignedIntFrameSizeHack = true;
            } else {
                Log.w((String)TAG, (String)("Failed to validate ID3 tag with majorVersion=" + id3Header.majorVersion));
                return null;
            }
        }
        while (id3Data.bytesLeft() >= frameHeaderSize) {
            Id3Frame frame = Id3Decoder.decodeFrame(id3Header.majorVersion, id3Data, unsignedIntFrameSizeHack, frameHeaderSize, this.framePredicate);
            if (frame == null) continue;
            id3Frames.add(frame);
        }
        return new Metadata(id3Frames);
    }

    @Nullable
    private static Id3Header decodeHeader(ParsableByteArray data) {
        boolean hasExtendedHeader;
        if (data.bytesLeft() < 10) {
            Log.w((String)TAG, (String)"Data too short to be an ID3 tag");
            return null;
        }
        int id = data.readUnsignedInt24();
        if (id != 0x494433) {
            Log.w((String)TAG, (String)("Unexpected first three bytes of ID3 tag header: 0x" + String.format("%06X", id)));
            return null;
        }
        int majorVersion = data.readUnsignedByte();
        data.skipBytes(1);
        int flags = data.readUnsignedByte();
        int framesSize = data.readSynchSafeInt();
        if (majorVersion == 2) {
            boolean isCompressed;
            boolean bl = isCompressed = (flags & 0x40) != 0;
            if (isCompressed) {
                Log.w((String)TAG, (String)"Skipped ID3 tag with majorVersion=2 and undefined compression scheme");
                return null;
            }
        } else if (majorVersion == 3) {
            boolean bl = hasExtendedHeader = (flags & 0x40) != 0;
            if (hasExtendedHeader) {
                int extendedHeaderSize = data.readInt();
                data.skipBytes(extendedHeaderSize);
                framesSize -= extendedHeaderSize + 4;
            }
        } else if (majorVersion == 4) {
            boolean hasFooter;
            boolean bl = hasExtendedHeader = (flags & 0x40) != 0;
            if (hasExtendedHeader) {
                int extendedHeaderSize = data.readSynchSafeInt();
                data.skipBytes(extendedHeaderSize - 4);
                framesSize -= extendedHeaderSize;
            }
            boolean bl2 = hasFooter = (flags & 0x10) != 0;
            if (hasFooter) {
                framesSize -= 10;
            }
        } else {
            Log.w((String)TAG, (String)("Skipped ID3 tag with unsupported majorVersion=" + majorVersion));
            return null;
        }
        boolean isUnsynchronized = majorVersion < 4 && (flags & 0x80) != 0;
        return new Id3Header(majorVersion, isUnsynchronized, framesSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validateFrames(ParsableByteArray id3Data, int majorVersion, int frameHeaderSize, boolean unsignedIntFrameSizeHack) {
        int startPosition = id3Data.getPosition();
        try {
            while (id3Data.bytesLeft() >= frameHeaderSize) {
                boolean bl;
                int flags;
                long frameSize;
                int id;
                if (majorVersion >= 3) {
                    id = id3Data.readInt();
                    frameSize = id3Data.readUnsignedInt();
                    flags = id3Data.readUnsignedShort();
                } else {
                    id = id3Data.readUnsignedInt24();
                    frameSize = id3Data.readUnsignedInt24();
                    flags = 0;
                }
                if (id == 0 && frameSize == 0L && flags == 0) {
                    bl = true;
                    return bl;
                }
                if (majorVersion == 4 && !unsignedIntFrameSizeHack) {
                    if ((frameSize & 0x808080L) != 0L) {
                        bl = false;
                        return bl;
                    }
                    frameSize = frameSize & 0xFFL | (frameSize >> 8 & 0xFFL) << 7 | (frameSize >> 16 & 0xFFL) << 14 | (frameSize >> 24 & 0xFFL) << 21;
                }
                boolean hasGroupIdentifier = false;
                boolean hasDataLength = false;
                if (majorVersion == 4) {
                    hasGroupIdentifier = (flags & 0x40) != 0;
                    hasDataLength = (flags & 1) != 0;
                } else if (majorVersion == 3) {
                    hasGroupIdentifier = (flags & 0x20) != 0;
                    hasDataLength = (flags & 0x80) != 0;
                }
                int minimumFrameSize = 0;
                if (hasGroupIdentifier) {
                    ++minimumFrameSize;
                }
                if (hasDataLength) {
                    minimumFrameSize += 4;
                }
                if (frameSize < (long)minimumFrameSize) {
                    boolean bl2 = false;
                    return bl2;
                }
                if ((long)id3Data.bytesLeft() < frameSize) {
                    boolean bl3 = false;
                    return bl3;
                }
                id3Data.skipBytes((int)frameSize);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            id3Data.setPosition(startPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Id3Frame decodeFrame(int majorVersion, ParsableByteArray id3Data, boolean unsignedIntFrameSizeHack, int frameHeaderSize, @Nullable FramePredicate framePredicate) {
        int flags;
        int frameSize;
        int frameId3;
        int frameId0 = id3Data.readUnsignedByte();
        int frameId1 = id3Data.readUnsignedByte();
        int frameId2 = id3Data.readUnsignedByte();
        int n = frameId3 = majorVersion >= 3 ? id3Data.readUnsignedByte() : 0;
        if (majorVersion == 4) {
            frameSize = id3Data.readUnsignedIntToInt();
            if (!unsignedIntFrameSizeHack) {
                frameSize = frameSize & 0xFF | (frameSize >> 8 & 0xFF) << 7 | (frameSize >> 16 & 0xFF) << 14 | (frameSize >> 24 & 0xFF) << 21;
            }
        } else {
            frameSize = majorVersion == 3 ? id3Data.readUnsignedIntToInt() : id3Data.readUnsignedInt24();
        }
        int n2 = flags = majorVersion >= 3 ? id3Data.readUnsignedShort() : 0;
        if (frameId0 == 0 && frameId1 == 0 && frameId2 == 0 && frameId3 == 0 && frameSize == 0 && flags == 0) {
            id3Data.setPosition(id3Data.limit());
            return null;
        }
        int nextFramePosition = id3Data.getPosition() + frameSize;
        if (nextFramePosition > id3Data.limit()) {
            Log.w((String)TAG, (String)"Frame size exceeds remaining tag data");
            id3Data.setPosition(id3Data.limit());
            return null;
        }
        if (framePredicate != null && !framePredicate.evaluate(majorVersion, frameId0, frameId1, frameId2, frameId3)) {
            id3Data.setPosition(nextFramePosition);
            return null;
        }
        boolean isCompressed = false;
        boolean isEncrypted = false;
        boolean isUnsynchronized = false;
        boolean hasDataLength = false;
        boolean hasGroupIdentifier = false;
        if (majorVersion == 3) {
            isCompressed = (flags & 0x80) != 0;
            isEncrypted = (flags & 0x40) != 0;
            hasGroupIdentifier = (flags & 0x20) != 0;
            hasDataLength = isCompressed;
        } else if (majorVersion == 4) {
            hasGroupIdentifier = (flags & 0x40) != 0;
            isCompressed = (flags & 8) != 0;
            isEncrypted = (flags & 4) != 0;
            isUnsynchronized = (flags & 2) != 0;
            boolean bl = hasDataLength = (flags & 1) != 0;
        }
        if (isCompressed || isEncrypted) {
            Log.w((String)TAG, (String)"Skipping unsupported compressed or encrypted frame");
            id3Data.setPosition(nextFramePosition);
            return null;
        }
        if (hasGroupIdentifier) {
            --frameSize;
            id3Data.skipBytes(1);
        }
        if (hasDataLength) {
            frameSize -= 4;
            id3Data.skipBytes(4);
        }
        if (isUnsynchronized) {
            frameSize = Id3Decoder.removeUnsynchronization(id3Data, frameSize);
        }
        try {
            String id;
            Id3Frame frame;
            if (frameId0 == 84 && frameId1 == 88 && frameId2 == 88 && (majorVersion == 2 || frameId3 == 88)) {
                frame = Id3Decoder.decodeTxxxFrame(id3Data, frameSize);
            } else if (frameId0 == 84) {
                id = Id3Decoder.getFrameId(majorVersion, frameId0, frameId1, frameId2, frameId3);
                frame = Id3Decoder.decodeTextInformationFrame(id3Data, frameSize, id);
            } else if (frameId0 == 87 && frameId1 == 88 && frameId2 == 88 && (majorVersion == 2 || frameId3 == 88)) {
                frame = Id3Decoder.decodeWxxxFrame(id3Data, frameSize);
            } else if (frameId0 == 87) {
                id = Id3Decoder.getFrameId(majorVersion, frameId0, frameId1, frameId2, frameId3);
                frame = Id3Decoder.decodeUrlLinkFrame(id3Data, frameSize, id);
            } else if (frameId0 == 80 && frameId1 == 82 && frameId2 == 73 && frameId3 == 86) {
                frame = Id3Decoder.decodePrivFrame(id3Data, frameSize);
            } else if (frameId0 == 71 && frameId1 == 69 && frameId2 == 79 && (frameId3 == 66 || majorVersion == 2)) {
                frame = Id3Decoder.decodeGeobFrame(id3Data, frameSize);
            } else if (majorVersion == 2 ? frameId0 == 80 && frameId1 == 73 && frameId2 == 67 : frameId0 == 65 && frameId1 == 80 && frameId2 == 73 && frameId3 == 67) {
                frame = Id3Decoder.decodeApicFrame(id3Data, frameSize, majorVersion);
            } else if (frameId0 == 67 && frameId1 == 79 && frameId2 == 77 && (frameId3 == 77 || majorVersion == 2)) {
                frame = Id3Decoder.decodeCommentFrame(id3Data, frameSize);
            } else if (frameId0 == 67 && frameId1 == 72 && frameId2 == 65 && frameId3 == 80) {
                frame = Id3Decoder.decodeChapterFrame(id3Data, frameSize, majorVersion, unsignedIntFrameSizeHack, frameHeaderSize, framePredicate);
            } else if (frameId0 == 67 && frameId1 == 84 && frameId2 == 79 && frameId3 == 67) {
                frame = Id3Decoder.decodeChapterTOCFrame(id3Data, frameSize, majorVersion, unsignedIntFrameSizeHack, frameHeaderSize, framePredicate);
            } else if (frameId0 == 77 && frameId1 == 76 && frameId2 == 76 && frameId3 == 84) {
                frame = Id3Decoder.decodeMlltFrame(id3Data, frameSize);
            } else {
                id = Id3Decoder.getFrameId(majorVersion, frameId0, frameId1, frameId2, frameId3);
                frame = Id3Decoder.decodeBinaryFrame(id3Data, frameSize, id);
            }
            if (frame == null) {
                Log.w((String)TAG, (String)("Failed to decode frame: id=" + Id3Decoder.getFrameId(majorVersion, frameId0, frameId1, frameId2, frameId3) + ", frameSize=" + frameSize));
            }
            TextInformationFrame textInformationFrame = frame;
            return textInformationFrame;
        }
        finally {
            id3Data.setPosition(nextFramePosition);
        }
    }

    @Nullable
    private static TextInformationFrame decodeTxxxFrame(ParsableByteArray id3Data, int frameSize) {
        if (frameSize < 1) {
            return null;
        }
        int encoding = id3Data.readUnsignedByte();
        byte[] data = new byte[frameSize - 1];
        id3Data.readBytes(data, 0, frameSize - 1);
        int descriptionEndIndex = Id3Decoder.indexOfTerminator(data, 0, encoding);
        String description = new String(data, 0, descriptionEndIndex, Id3Decoder.getCharset(encoding));
        ImmutableList<String> values = Id3Decoder.decodeTextInformationFrameValues(data, encoding, descriptionEndIndex + Id3Decoder.delimiterLength(encoding));
        return new TextInformationFrame("TXXX", description, (List<String>)values);
    }

    @Nullable
    private static TextInformationFrame decodeTextInformationFrame(ParsableByteArray id3Data, int frameSize, String id) {
        if (frameSize < 1) {
            return null;
        }
        int encoding = id3Data.readUnsignedByte();
        byte[] data = new byte[frameSize - 1];
        id3Data.readBytes(data, 0, frameSize - 1);
        ImmutableList<String> values = Id3Decoder.decodeTextInformationFrameValues(data, encoding, 0);
        return new TextInformationFrame(id, null, (List<String>)values);
    }

    private static ImmutableList<String> decodeTextInformationFrameValues(byte[] data, int encoding, int index) {
        if (index >= data.length) {
            return ImmutableList.of((Object)"");
        }
        ImmutableList.Builder values = ImmutableList.builder();
        int valueStartIndex = index;
        int valueEndIndex = Id3Decoder.indexOfTerminator(data, valueStartIndex, encoding);
        while (valueStartIndex < valueEndIndex) {
            String value = new String(data, valueStartIndex, valueEndIndex - valueStartIndex, Id3Decoder.getCharset(encoding));
            values.add((Object)value);
            valueStartIndex = valueEndIndex + Id3Decoder.delimiterLength(encoding);
            valueEndIndex = Id3Decoder.indexOfTerminator(data, valueStartIndex, encoding);
        }
        ImmutableList result = values.build();
        return result.isEmpty() ? ImmutableList.of((Object)"") : result;
    }

    @Nullable
    private static UrlLinkFrame decodeWxxxFrame(ParsableByteArray id3Data, int frameSize) {
        if (frameSize < 1) {
            return null;
        }
        int encoding = id3Data.readUnsignedByte();
        byte[] data = new byte[frameSize - 1];
        id3Data.readBytes(data, 0, frameSize - 1);
        int descriptionEndIndex = Id3Decoder.indexOfTerminator(data, 0, encoding);
        String description = new String(data, 0, descriptionEndIndex, Id3Decoder.getCharset(encoding));
        int urlStartIndex = descriptionEndIndex + Id3Decoder.delimiterLength(encoding);
        int urlEndIndex = Id3Decoder.indexOfZeroByte(data, urlStartIndex);
        String url = Id3Decoder.decodeStringIfValid(data, urlStartIndex, urlEndIndex, Charsets.ISO_8859_1);
        return new UrlLinkFrame("WXXX", description, url);
    }

    private static UrlLinkFrame decodeUrlLinkFrame(ParsableByteArray id3Data, int frameSize, String id) {
        byte[] data = new byte[frameSize];
        id3Data.readBytes(data, 0, frameSize);
        int urlEndIndex = Id3Decoder.indexOfZeroByte(data, 0);
        String url = new String(data, 0, urlEndIndex, Charsets.ISO_8859_1);
        return new UrlLinkFrame(id, null, url);
    }

    private static PrivFrame decodePrivFrame(ParsableByteArray id3Data, int frameSize) {
        byte[] data = new byte[frameSize];
        id3Data.readBytes(data, 0, frameSize);
        int ownerEndIndex = Id3Decoder.indexOfZeroByte(data, 0);
        String owner = new String(data, 0, ownerEndIndex, Charsets.ISO_8859_1);
        int privateDataStartIndex = ownerEndIndex + 1;
        byte[] privateData = Id3Decoder.copyOfRangeIfValid(data, privateDataStartIndex, data.length);
        return new PrivFrame(owner, privateData);
    }

    private static GeobFrame decodeGeobFrame(ParsableByteArray id3Data, int frameSize) {
        int encoding = id3Data.readUnsignedByte();
        Charset charset = Id3Decoder.getCharset(encoding);
        byte[] data = new byte[frameSize - 1];
        id3Data.readBytes(data, 0, frameSize - 1);
        int mimeTypeEndIndex = Id3Decoder.indexOfZeroByte(data, 0);
        String mimeType = new String(data, 0, mimeTypeEndIndex, Charsets.ISO_8859_1);
        int filenameStartIndex = mimeTypeEndIndex + 1;
        int filenameEndIndex = Id3Decoder.indexOfTerminator(data, filenameStartIndex, encoding);
        String filename = Id3Decoder.decodeStringIfValid(data, filenameStartIndex, filenameEndIndex, charset);
        int descriptionStartIndex = filenameEndIndex + Id3Decoder.delimiterLength(encoding);
        int descriptionEndIndex = Id3Decoder.indexOfTerminator(data, descriptionStartIndex, encoding);
        String description = Id3Decoder.decodeStringIfValid(data, descriptionStartIndex, descriptionEndIndex, charset);
        int objectDataStartIndex = descriptionEndIndex + Id3Decoder.delimiterLength(encoding);
        byte[] objectData = Id3Decoder.copyOfRangeIfValid(data, objectDataStartIndex, data.length);
        return new GeobFrame(mimeType, filename, description, objectData);
    }

    private static ApicFrame decodeApicFrame(ParsableByteArray id3Data, int frameSize, int majorVersion) {
        String mimeType;
        int mimeTypeEndIndex;
        int encoding = id3Data.readUnsignedByte();
        Charset charset = Id3Decoder.getCharset(encoding);
        byte[] data = new byte[frameSize - 1];
        id3Data.readBytes(data, 0, frameSize - 1);
        if (majorVersion == 2) {
            mimeTypeEndIndex = 2;
            mimeType = "image/" + Ascii.toLowerCase((String)new String(data, 0, 3, Charsets.ISO_8859_1));
            if ("image/jpg".equals(mimeType)) {
                mimeType = "image/jpeg";
            }
        } else {
            mimeTypeEndIndex = Id3Decoder.indexOfZeroByte(data, 0);
            mimeType = Ascii.toLowerCase((String)new String(data, 0, mimeTypeEndIndex, Charsets.ISO_8859_1));
            if (mimeType.indexOf(47) == -1) {
                mimeType = "image/" + mimeType;
            }
        }
        int pictureType = data[mimeTypeEndIndex + 1] & 0xFF;
        int descriptionStartIndex = mimeTypeEndIndex + 2;
        int descriptionEndIndex = Id3Decoder.indexOfTerminator(data, descriptionStartIndex, encoding);
        String description = new String(data, descriptionStartIndex, descriptionEndIndex - descriptionStartIndex, charset);
        int pictureDataStartIndex = descriptionEndIndex + Id3Decoder.delimiterLength(encoding);
        byte[] pictureData = Id3Decoder.copyOfRangeIfValid(data, pictureDataStartIndex, data.length);
        return new ApicFrame(mimeType, description, pictureType, pictureData);
    }

    @Nullable
    private static CommentFrame decodeCommentFrame(ParsableByteArray id3Data, int frameSize) {
        if (frameSize < 4) {
            return null;
        }
        int encoding = id3Data.readUnsignedByte();
        Charset charset = Id3Decoder.getCharset(encoding);
        byte[] data = new byte[3];
        id3Data.readBytes(data, 0, 3);
        String language = new String(data, 0, 3);
        data = new byte[frameSize - 4];
        id3Data.readBytes(data, 0, frameSize - 4);
        int descriptionEndIndex = Id3Decoder.indexOfTerminator(data, 0, encoding);
        String description = new String(data, 0, descriptionEndIndex, charset);
        int textStartIndex = descriptionEndIndex + Id3Decoder.delimiterLength(encoding);
        int textEndIndex = Id3Decoder.indexOfTerminator(data, textStartIndex, encoding);
        String text = Id3Decoder.decodeStringIfValid(data, textStartIndex, textEndIndex, charset);
        return new CommentFrame(language, description, text);
    }

    private static ChapterFrame decodeChapterFrame(ParsableByteArray id3Data, int frameSize, int majorVersion, boolean unsignedIntFrameSizeHack, int frameHeaderSize, @Nullable FramePredicate framePredicate) {
        long endOffset;
        int framePosition = id3Data.getPosition();
        int chapterIdEndIndex = Id3Decoder.indexOfZeroByte(id3Data.getData(), framePosition);
        String chapterId = new String(id3Data.getData(), framePosition, chapterIdEndIndex - framePosition, Charsets.ISO_8859_1);
        id3Data.setPosition(chapterIdEndIndex + 1);
        int startTime = id3Data.readInt();
        int endTime = id3Data.readInt();
        long startOffset = id3Data.readUnsignedInt();
        if (startOffset == 0xFFFFFFFFL) {
            startOffset = -1L;
        }
        if ((endOffset = id3Data.readUnsignedInt()) == 0xFFFFFFFFL) {
            endOffset = -1L;
        }
        ArrayList<Id3Frame> subFrames = new ArrayList<Id3Frame>();
        int limit = framePosition + frameSize;
        while (id3Data.getPosition() < limit) {
            Id3Frame frame = Id3Decoder.decodeFrame(majorVersion, id3Data, unsignedIntFrameSizeHack, frameHeaderSize, framePredicate);
            if (frame == null) continue;
            subFrames.add(frame);
        }
        Id3Frame[] subFrameArray = subFrames.toArray(new Id3Frame[0]);
        return new ChapterFrame(chapterId, startTime, endTime, startOffset, endOffset, subFrameArray);
    }

    private static ChapterTocFrame decodeChapterTOCFrame(ParsableByteArray id3Data, int frameSize, int majorVersion, boolean unsignedIntFrameSizeHack, int frameHeaderSize, @Nullable FramePredicate framePredicate) {
        int framePosition = id3Data.getPosition();
        int elementIdEndIndex = Id3Decoder.indexOfZeroByte(id3Data.getData(), framePosition);
        String elementId = new String(id3Data.getData(), framePosition, elementIdEndIndex - framePosition, Charsets.ISO_8859_1);
        id3Data.setPosition(elementIdEndIndex + 1);
        int ctocFlags = id3Data.readUnsignedByte();
        boolean isRoot = (ctocFlags & 2) != 0;
        boolean isOrdered = (ctocFlags & 1) != 0;
        int childCount = id3Data.readUnsignedByte();
        String[] children = new String[childCount];
        for (int i = 0; i < childCount; ++i) {
            int startIndex = id3Data.getPosition();
            int endIndex = Id3Decoder.indexOfZeroByte(id3Data.getData(), startIndex);
            children[i] = new String(id3Data.getData(), startIndex, endIndex - startIndex, Charsets.ISO_8859_1);
            id3Data.setPosition(endIndex + 1);
        }
        ArrayList<Id3Frame> subFrames = new ArrayList<Id3Frame>();
        int limit = framePosition + frameSize;
        while (id3Data.getPosition() < limit) {
            Id3Frame frame = Id3Decoder.decodeFrame(majorVersion, id3Data, unsignedIntFrameSizeHack, frameHeaderSize, framePredicate);
            if (frame == null) continue;
            subFrames.add(frame);
        }
        Id3Frame[] subFrameArray = subFrames.toArray(new Id3Frame[0]);
        return new ChapterTocFrame(elementId, isRoot, isOrdered, children, subFrameArray);
    }

    private static MlltFrame decodeMlltFrame(ParsableByteArray id3Data, int frameSize) {
        int mpegFramesBetweenReference = id3Data.readUnsignedShort();
        int bytesBetweenReference = id3Data.readUnsignedInt24();
        int millisecondsBetweenReference = id3Data.readUnsignedInt24();
        int bitsForBytesDeviation = id3Data.readUnsignedByte();
        int bitsForMillisecondsDeviation = id3Data.readUnsignedByte();
        ParsableBitArray references = new ParsableBitArray();
        references.reset(id3Data);
        int referencesBits = 8 * (frameSize - 10);
        int bitsPerReference = bitsForBytesDeviation + bitsForMillisecondsDeviation;
        int referencesCount = referencesBits / bitsPerReference;
        int[] bytesDeviations = new int[referencesCount];
        int[] millisecondsDeviations = new int[referencesCount];
        for (int i = 0; i < referencesCount; ++i) {
            int bytesDeviation = references.readBits(bitsForBytesDeviation);
            int millisecondsDeviation = references.readBits(bitsForMillisecondsDeviation);
            bytesDeviations[i] = bytesDeviation;
            millisecondsDeviations[i] = millisecondsDeviation;
        }
        return new MlltFrame(mpegFramesBetweenReference, bytesBetweenReference, millisecondsBetweenReference, bytesDeviations, millisecondsDeviations);
    }

    private static BinaryFrame decodeBinaryFrame(ParsableByteArray id3Data, int frameSize, String id) {
        byte[] frame = new byte[frameSize];
        id3Data.readBytes(frame, 0, frameSize);
        return new BinaryFrame(id, frame);
    }

    private static int removeUnsynchronization(ParsableByteArray data, int length) {
        int startPosition;
        byte[] bytes = data.getData();
        int i = startPosition = data.getPosition();
        while (i + 1 < startPosition + length) {
            if ((bytes[i] & 0xFF) == 255 && bytes[i + 1] == 0) {
                int relativePosition = i - startPosition;
                System.arraycopy(bytes, i + 2, bytes, i + 1, length - relativePosition - 2);
                --length;
            }
            ++i;
        }
        return length;
    }

    private static Charset getCharset(int encodingByte) {
        switch (encodingByte) {
            case 1: {
                return Charsets.UTF_16;
            }
            case 2: {
                return Charsets.UTF_16BE;
            }
            case 3: {
                return Charsets.UTF_8;
            }
        }
        return Charsets.ISO_8859_1;
    }

    private static String getFrameId(int majorVersion, int frameId0, int frameId1, int frameId2, int frameId3) {
        return majorVersion == 2 ? String.format(Locale.US, "%c%c%c", frameId0, frameId1, frameId2) : String.format(Locale.US, "%c%c%c%c", frameId0, frameId1, frameId2, frameId3);
    }

    private static int indexOfTerminator(byte[] data, int fromIndex, int encoding) {
        int terminationPos = Id3Decoder.indexOfZeroByte(data, fromIndex);
        if (encoding == 0 || encoding == 3) {
            return terminationPos;
        }
        while (terminationPos < data.length - 1) {
            if ((terminationPos - fromIndex) % 2 == 0 && data[terminationPos + 1] == 0) {
                return terminationPos;
            }
            terminationPos = Id3Decoder.indexOfZeroByte(data, terminationPos + 1);
        }
        return data.length;
    }

    private static int indexOfZeroByte(byte[] data, int fromIndex) {
        for (int i = fromIndex; i < data.length; ++i) {
            if (data[i] != 0) continue;
            return i;
        }
        return data.length;
    }

    private static int delimiterLength(int encodingByte) {
        return encodingByte == 0 || encodingByte == 3 ? 1 : 2;
    }

    private static byte[] copyOfRangeIfValid(byte[] data, int from, int to) {
        if (to <= from) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        return Arrays.copyOfRange(data, from, to);
    }

    private static String decodeStringIfValid(byte[] data, int from, int to, Charset charset) {
        if (to <= from || to > data.length) {
            return "";
        }
        return new String(data, from, to - from, charset);
    }

    public static interface FramePredicate {
        public boolean evaluate(int var1, int var2, int var3, int var4, int var5);
    }

    private static final class Id3Header {
        private final int majorVersion;
        private final boolean isUnsynchronized;
        private final int framesSize;

        public Id3Header(int majorVersion, boolean isUnsynchronized, int framesSize) {
            this.majorVersion = majorVersion;
            this.isUnsynchronized = isUnsynchronized;
            this.framesSize = framesSize;
        }
    }
}

