/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.flac;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Charsets;
import java.util.Arrays;

@Deprecated
public final class PictureFrame
implements Metadata.Entry {
    public final int pictureType;
    public final String mimeType;
    public final String description;
    public final int width;
    public final int height;
    public final int depth;
    public final int colors;
    public final byte[] pictureData;
    public static final Parcelable.Creator<PictureFrame> CREATOR = new Parcelable.Creator<PictureFrame>(){

        public PictureFrame createFromParcel(Parcel in) {
            return new PictureFrame(in);
        }

        public PictureFrame[] newArray(int size) {
            return new PictureFrame[size];
        }
    };

    public PictureFrame(int pictureType, String mimeType, String description, int width, int height, int depth, int colors, byte[] pictureData) {
        this.pictureType = pictureType;
        this.mimeType = mimeType;
        this.description = description;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.colors = colors;
        this.pictureData = pictureData;
    }

    PictureFrame(Parcel in) {
        this.pictureType = in.readInt();
        this.mimeType = (String)Util.castNonNull((Object)in.readString());
        this.description = (String)Util.castNonNull((Object)in.readString());
        this.width = in.readInt();
        this.height = in.readInt();
        this.depth = in.readInt();
        this.colors = in.readInt();
        this.pictureData = (byte[])Util.castNonNull((Object)in.createByteArray());
    }

    public void populateMediaMetadata(MediaMetadata.Builder builder) {
        builder.maybeSetArtworkData(this.pictureData, this.pictureType);
    }

    public String toString() {
        return "Picture: mimeType=" + this.mimeType + ", description=" + this.description;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PictureFrame other = (PictureFrame)obj;
        return this.pictureType == other.pictureType && this.mimeType.equals(other.mimeType) && this.description.equals(other.description) && this.width == other.width && this.height == other.height && this.depth == other.depth && this.colors == other.colors && Arrays.equals(this.pictureData, other.pictureData);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.pictureType;
        result = 31 * result + this.mimeType.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.depth;
        result = 31 * result + this.colors;
        result = 31 * result + Arrays.hashCode(this.pictureData);
        return result;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.pictureType);
        dest.writeString(this.mimeType);
        dest.writeString(this.description);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeInt(this.depth);
        dest.writeInt(this.colors);
        dest.writeByteArray(this.pictureData);
    }

    public int describeContents() {
        return 0;
    }

    public static PictureFrame fromPictureBlock(ParsableByteArray pictureBlock) {
        int pictureType = pictureBlock.readInt();
        int mimeTypeLength = pictureBlock.readInt();
        String mimeType = pictureBlock.readString(mimeTypeLength, Charsets.US_ASCII);
        int descriptionLength = pictureBlock.readInt();
        String description = pictureBlock.readString(descriptionLength);
        int width = pictureBlock.readInt();
        int height = pictureBlock.readInt();
        int depth = pictureBlock.readInt();
        int colors = pictureBlock.readInt();
        int pictureDataLength = pictureBlock.readInt();
        byte[] pictureData = new byte[pictureDataLength];
        pictureBlock.readBytes(pictureData, 0, pictureDataLength);
        return new PictureFrame(pictureType, mimeType, description, width, height, depth, colors, pictureData);
    }
}

