/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorUtil;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.SeekPoint;
import com.google.android.exoplayer2.extractor.ogg.OggPageHeader;
import com.google.android.exoplayer2.extractor.ogg.OggSeeker;
import com.google.android.exoplayer2.extractor.ogg.StreamReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;

@Deprecated
final class DefaultOggSeeker
implements OggSeeker {
    private static final int MATCH_RANGE = 72000;
    private static final int MATCH_BYTE_RANGE = 100000;
    private static final int DEFAULT_OFFSET = 30000;
    private static final int STATE_SEEK_TO_END = 0;
    private static final int STATE_READ_LAST_PAGE = 1;
    private static final int STATE_SEEK = 2;
    private static final int STATE_SKIP = 3;
    private static final int STATE_IDLE = 4;
    private final OggPageHeader pageHeader;
    private final long payloadStartPosition;
    private final long payloadEndPosition;
    private final StreamReader streamReader;
    private int state;
    private long totalGranules;
    private long positionBeforeSeekToEnd;
    private long targetGranule;
    private long start;
    private long end;
    private long startGranule;
    private long endGranule;

    public DefaultOggSeeker(StreamReader streamReader, long payloadStartPosition, long payloadEndPosition, long firstPayloadPageSize, long firstPayloadPageGranulePosition, boolean firstPayloadPageIsLastPage) {
        Assertions.checkArgument((payloadStartPosition >= 0L && payloadEndPosition > payloadStartPosition ? 1 : 0) != 0);
        this.streamReader = streamReader;
        this.payloadStartPosition = payloadStartPosition;
        this.payloadEndPosition = payloadEndPosition;
        if (firstPayloadPageSize == payloadEndPosition - payloadStartPosition || firstPayloadPageIsLastPage) {
            this.totalGranules = firstPayloadPageGranulePosition;
            this.state = 4;
        } else {
            this.state = 0;
        }
        this.pageHeader = new OggPageHeader();
    }

    @Override
    public long read(ExtractorInput input) throws IOException {
        switch (this.state) {
            case 4: {
                return -1L;
            }
            case 0: {
                this.positionBeforeSeekToEnd = input.getPosition();
                this.state = 1;
                long lastPageSearchPosition = this.payloadEndPosition - 65307L;
                if (lastPageSearchPosition > this.positionBeforeSeekToEnd) {
                    return lastPageSearchPosition;
                }
            }
            case 1: {
                this.totalGranules = this.readGranuleOfLastPage(input);
                this.state = 4;
                return this.positionBeforeSeekToEnd;
            }
            case 2: {
                long position = this.getNextSeekPosition(input);
                if (position != -1L) {
                    return position;
                }
                this.state = 3;
            }
            case 3: {
                this.skipToPageOfTargetGranule(input);
                this.state = 4;
                return -(this.startGranule + 2L);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    @Nullable
    public OggSeekMap createSeekMap() {
        return this.totalGranules != 0L ? new OggSeekMap() : null;
    }

    @Override
    public void startSeek(long targetGranule) {
        this.targetGranule = Util.constrainValue((long)targetGranule, (long)0L, (long)(this.totalGranules - 1L));
        this.state = 2;
        this.start = this.payloadStartPosition;
        this.end = this.payloadEndPosition;
        this.startGranule = 0L;
        this.endGranule = this.totalGranules;
    }

    private long getNextSeekPosition(ExtractorInput input) throws IOException {
        if (this.start == this.end) {
            return -1L;
        }
        long currentPosition = input.getPosition();
        if (!this.pageHeader.skipToNextPage(input, this.end)) {
            if (this.start == currentPosition) {
                throw new IOException("No ogg page can be found.");
            }
            return this.start;
        }
        this.pageHeader.populate(input, false);
        input.resetPeekPosition();
        long granuleDistance = this.targetGranule - this.pageHeader.granulePosition;
        int pageSize = this.pageHeader.headerSize + this.pageHeader.bodySize;
        if (0L <= granuleDistance && granuleDistance < 72000L) {
            return -1L;
        }
        if (granuleDistance < 0L) {
            this.end = currentPosition;
            this.endGranule = this.pageHeader.granulePosition;
        } else {
            this.start = input.getPosition() + (long)pageSize;
            this.startGranule = this.pageHeader.granulePosition;
        }
        if (this.end - this.start < 100000L) {
            this.end = this.start;
            return this.start;
        }
        long offset = (long)pageSize * (granuleDistance <= 0L ? 2L : 1L);
        long nextPosition = input.getPosition() - offset + granuleDistance * (this.end - this.start) / (this.endGranule - this.startGranule);
        return Util.constrainValue((long)nextPosition, (long)this.start, (long)(this.end - 1L));
    }

    private void skipToPageOfTargetGranule(ExtractorInput input) throws IOException {
        while (true) {
            this.pageHeader.skipToNextPage(input);
            this.pageHeader.populate(input, false);
            if (this.pageHeader.granulePosition > this.targetGranule) break;
            input.skipFully(this.pageHeader.headerSize + this.pageHeader.bodySize);
            this.start = input.getPosition();
            this.startGranule = this.pageHeader.granulePosition;
        }
        input.resetPeekPosition();
    }

    @VisibleForTesting
    long readGranuleOfLastPage(ExtractorInput input) throws IOException {
        this.pageHeader.reset();
        if (!this.pageHeader.skipToNextPage(input)) {
            throw new EOFException();
        }
        this.pageHeader.populate(input, false);
        input.skipFully(this.pageHeader.headerSize + this.pageHeader.bodySize);
        long granulePosition = this.pageHeader.granulePosition;
        while ((this.pageHeader.type & 4) != 4 && this.pageHeader.skipToNextPage(input) && input.getPosition() < this.payloadEndPosition) {
            boolean hasPopulated = this.pageHeader.populate(input, true);
            if (!hasPopulated || !ExtractorUtil.skipFullyQuietly(input, this.pageHeader.headerSize + this.pageHeader.bodySize)) {
                return granulePosition;
            }
            granulePosition = this.pageHeader.granulePosition;
        }
        return granulePosition;
    }

    private final class OggSeekMap
    implements SeekMap {
        private OggSeekMap() {
        }

        @Override
        public boolean isSeekable() {
            return true;
        }

        @Override
        public SeekMap.SeekPoints getSeekPoints(long timeUs) {
            long targetGranule = DefaultOggSeeker.this.streamReader.convertTimeToGranule(timeUs);
            long estimatedPosition = DefaultOggSeeker.this.payloadStartPosition + BigInteger.valueOf(targetGranule).multiply(BigInteger.valueOf(DefaultOggSeeker.this.payloadEndPosition - DefaultOggSeeker.this.payloadStartPosition)).divide(BigInteger.valueOf(DefaultOggSeeker.this.totalGranules)).longValue() - 30000L;
            estimatedPosition = Util.constrainValue((long)estimatedPosition, (long)DefaultOggSeeker.this.payloadStartPosition, (long)(DefaultOggSeeker.this.payloadEndPosition - 1L));
            return new SeekMap.SeekPoints(new SeekPoint(timeUs, estimatedPosition));
        }

        @Override
        public long getDurationUs() {
            return DefaultOggSeeker.this.streamReader.convertGranuleToTime(DefaultOggSeeker.this.totalGranules);
        }
    }
}

