/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp4;

import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.mp4.SlowMotionData;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Deprecated
final class SefReader {
    private static final int STATE_SHOULD_CHECK_FOR_SEF = 0;
    private static final int STATE_CHECKING_FOR_SEF = 1;
    private static final int STATE_READING_SDRS = 2;
    private static final int STATE_READING_SEF_DATA = 3;
    private static final int TYPE_SLOW_MOTION_DATA = 2192;
    private static final int TYPE_SUPER_SLOW_MOTION_DATA = 2816;
    private static final int TYPE_SUPER_SLOW_MOTION_BGM = 2817;
    private static final int TYPE_SUPER_SLOW_MOTION_EDIT_DATA = 2819;
    private static final int TYPE_SUPER_SLOW_DEFLICKERING_ON = 2820;
    private static final String TAG = "SefReader";
    private static final int SAMSUNG_TAIL_SIGNATURE = 1397048916;
    private static final int TAIL_HEADER_LENGTH = 12;
    private static final int TAIL_FOOTER_LENGTH = 8;
    private static final int LENGTH_OF_ONE_SDR = 12;
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final Splitter ASTERISK_SPLITTER = Splitter.on((char)'*');
    private final List<DataReference> dataReferences = new ArrayList<DataReference>();
    private int readerState = 0;
    private int tailLength;

    public void reset() {
        this.dataReferences.clear();
        this.readerState = 0;
    }

    public int read(ExtractorInput input, PositionHolder seekPosition, List<Metadata.Entry> slowMotionMetadataEntries) throws IOException {
        switch (this.readerState) {
            case 0: {
                long inputLength = input.getLength();
                seekPosition.position = inputLength == -1L || inputLength < 8L ? 0L : inputLength - 8L;
                this.readerState = 1;
                break;
            }
            case 1: {
                this.checkForSefData(input, seekPosition);
                break;
            }
            case 2: {
                this.readSdrs(input, seekPosition);
                break;
            }
            case 3: {
                this.readSefData(input, slowMotionMetadataEntries);
                seekPosition.position = 0L;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return 1;
    }

    private void checkForSefData(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        ParsableByteArray scratch = new ParsableByteArray(8);
        input.readFully(scratch.getData(), 0, 8);
        this.tailLength = scratch.readLittleEndianInt() + 8;
        if (scratch.readInt() != 1397048916) {
            seekPosition.position = 0L;
            return;
        }
        seekPosition.position = input.getPosition() - (long)(this.tailLength - 12);
        this.readerState = 2;
    }

    private void readSdrs(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        long streamLength = input.getLength();
        int sdrsLength = this.tailLength - 12 - 8;
        ParsableByteArray scratch = new ParsableByteArray(sdrsLength);
        input.readFully(scratch.getData(), 0, sdrsLength);
        block3: for (int i = 0; i < sdrsLength / 12; ++i) {
            scratch.skipBytes(2);
            short dataType = scratch.readLittleEndianShort();
            switch (dataType) {
                case 2192: 
                case 2816: 
                case 2817: 
                case 2819: 
                case 2820: {
                    long startOffset = streamLength - (long)this.tailLength - (long)scratch.readLittleEndianInt();
                    int size = scratch.readLittleEndianInt();
                    this.dataReferences.add(new DataReference(dataType, startOffset, size));
                    continue block3;
                }
                default: {
                    scratch.skipBytes(8);
                }
            }
        }
        if (this.dataReferences.isEmpty()) {
            seekPosition.position = 0L;
            return;
        }
        this.readerState = 3;
        seekPosition.position = this.dataReferences.get((int)0).startOffset;
    }

    private void readSefData(ExtractorInput input, List<Metadata.Entry> slowMotionMetadataEntries) throws IOException {
        long dataStartOffset = input.getPosition();
        int totalDataLength = (int)(input.getLength() - input.getPosition() - (long)this.tailLength);
        ParsableByteArray data = new ParsableByteArray(totalDataLength);
        input.readFully(data.getData(), 0, totalDataLength);
        block4: for (int i = 0; i < this.dataReferences.size(); ++i) {
            DataReference dataReference = this.dataReferences.get(i);
            int intendedPosition = (int)(dataReference.startOffset - dataStartOffset);
            data.setPosition(intendedPosition);
            data.skipBytes(4);
            int nameLength = data.readLittleEndianInt();
            String name = data.readString(nameLength);
            int dataType = SefReader.nameToDataType(name);
            int remainingDataLength = dataReference.size - (8 + nameLength);
            switch (dataType) {
                case 2192: {
                    slowMotionMetadataEntries.add(SefReader.readSlowMotionData(data, remainingDataLength));
                    continue block4;
                }
                case 2816: 
                case 2817: 
                case 2819: 
                case 2820: {
                    continue block4;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private static SlowMotionData readSlowMotionData(ParsableByteArray data, int dataLength) throws ParserException {
        ArrayList<SlowMotionData.Segment> segments = new ArrayList<SlowMotionData.Segment>();
        String dataString = data.readString(dataLength);
        List segmentStrings = ASTERISK_SPLITTER.splitToList((CharSequence)dataString);
        for (int i = 0; i < segmentStrings.size(); ++i) {
            List values = COLON_SPLITTER.splitToList((CharSequence)segmentStrings.get(i));
            if (values.size() != 3) {
                throw ParserException.createForMalformedContainer(null, null);
            }
            try {
                long startTimeMs = Long.parseLong((String)values.get(0));
                long endTimeMs = Long.parseLong((String)values.get(1));
                int speedMode = Integer.parseInt((String)values.get(2));
                int speedDivisor = 1 << speedMode - 1;
                segments.add(new SlowMotionData.Segment(startTimeMs, endTimeMs, speedDivisor));
                continue;
            }
            catch (NumberFormatException e) {
                throw ParserException.createForMalformedContainer(null, (Throwable)e);
            }
        }
        return new SlowMotionData(segments);
    }

    private static int nameToDataType(String name) throws ParserException {
        switch (name) {
            case "SlowMotion_Data": {
                return 2192;
            }
            case "Super_SlowMotion_Data": {
                return 2816;
            }
            case "Super_SlowMotion_BGM": {
                return 2817;
            }
            case "Super_SlowMotion_Edit_Data": {
                return 2819;
            }
            case "Super_SlowMotion_Deflickering_On": {
                return 2820;
            }
        }
        throw ParserException.createForMalformedContainer((String)"Invalid SEF name", null);
    }

    private static final class DataReference {
        public final int dataType;
        public final long startOffset;
        public final int size;

        public DataReference(int dataType, long startOffset, int size) {
            this.dataType = dataType;
            this.startOffset = startOffset;
            this.size = size;
        }
    }
}

