/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.extractor.BinarySearchSeeker;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ts.TsUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

@Deprecated
final class TsBinarySearchSeeker
extends BinarySearchSeeker {
    private static final long SEEK_TOLERANCE_US = 100000L;
    private static final int MINIMUM_SEARCH_RANGE_BYTES = 940;

    public TsBinarySearchSeeker(TimestampAdjuster pcrTimestampAdjuster, long streamDurationUs, long inputLength, int pcrPid, int timestampSearchBytes) {
        super(new BinarySearchSeeker.DefaultSeekTimestampConverter(), new TsPcrSeeker(pcrPid, pcrTimestampAdjuster, timestampSearchBytes), streamDurationUs, 0L, streamDurationUs + 1L, 0L, inputLength, 188L, 940);
    }

    private static final class TsPcrSeeker
    implements BinarySearchSeeker.TimestampSeeker {
        private final TimestampAdjuster pcrTimestampAdjuster;
        private final ParsableByteArray packetBuffer;
        private final int pcrPid;
        private final int timestampSearchBytes;

        public TsPcrSeeker(int pcrPid, TimestampAdjuster pcrTimestampAdjuster, int timestampSearchBytes) {
            this.pcrPid = pcrPid;
            this.pcrTimestampAdjuster = pcrTimestampAdjuster;
            this.timestampSearchBytes = timestampSearchBytes;
            this.packetBuffer = new ParsableByteArray();
        }

        @Override
        public BinarySearchSeeker.TimestampSearchResult searchForTimestamp(ExtractorInput input, long targetTimestamp) throws IOException {
            long inputPosition = input.getPosition();
            int bytesToSearch = (int)Math.min((long)this.timestampSearchBytes, input.getLength() - inputPosition);
            this.packetBuffer.reset(bytesToSearch);
            input.peekFully(this.packetBuffer.getData(), 0, bytesToSearch);
            return this.searchForPcrValueInBuffer(this.packetBuffer, targetTimestamp, inputPosition);
        }

        private BinarySearchSeeker.TimestampSearchResult searchForPcrValueInBuffer(ParsableByteArray packetBuffer, long targetPcrTimeUs, long bufferStartOffset) {
            int startOfPacket;
            int endOfPacket;
            int limit = packetBuffer.limit();
            long startOfLastPacketPosition = -1L;
            long endOfLastPacketPosition = -1L;
            long lastPcrTimeUsInRange = -9223372036854775807L;
            while (packetBuffer.bytesLeft() >= 188 && (endOfPacket = (startOfPacket = TsUtil.findSyncBytePosition(packetBuffer.getData(), packetBuffer.getPosition(), limit)) + 188) <= limit) {
                long pcrValue = TsUtil.readPcrFromPacket(packetBuffer, startOfPacket, this.pcrPid);
                if (pcrValue != -9223372036854775807L) {
                    long pcrTimeUs = this.pcrTimestampAdjuster.adjustTsTimestamp(pcrValue);
                    if (pcrTimeUs > targetPcrTimeUs) {
                        if (lastPcrTimeUsInRange == -9223372036854775807L) {
                            return BinarySearchSeeker.TimestampSearchResult.overestimatedResult(pcrTimeUs, bufferStartOffset);
                        }
                        return BinarySearchSeeker.TimestampSearchResult.targetFoundResult(bufferStartOffset + startOfLastPacketPosition);
                    }
                    if (pcrTimeUs + 100000L > targetPcrTimeUs) {
                        long startOfPacketInStream = bufferStartOffset + (long)startOfPacket;
                        return BinarySearchSeeker.TimestampSearchResult.targetFoundResult(startOfPacketInStream);
                    }
                    lastPcrTimeUsInRange = pcrTimeUs;
                    startOfLastPacketPosition = startOfPacket;
                }
                packetBuffer.setPosition(endOfPacket);
                endOfLastPacketPosition = endOfPacket;
            }
            if (lastPcrTimeUsInRange != -9223372036854775807L) {
                long endOfLastPacketPositionInStream = bufferStartOffset + endOfLastPacketPosition;
                return BinarySearchSeeker.TimestampSearchResult.underestimatedResult(lastPcrTimeUsInRange, endOfLastPacketPositionInStream);
            }
            return BinarySearchSeeker.TimestampSearchResult.NO_TIMESTAMP_IN_RANGE_RESULT;
        }

        @Override
        public void onSeekFinished() {
            this.packetBuffer.reset(Util.EMPTY_BYTE_ARRAY);
        }
    }
}

