/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.avi;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.extractor.avi.AviChunk;
import com.google.android.exoplayer2.extractor.avi.AviMainHeaderChunk;
import com.google.android.exoplayer2.extractor.avi.AviStreamHeaderChunk;
import com.google.android.exoplayer2.extractor.avi.StreamFormatChunk;
import com.google.android.exoplayer2.extractor.avi.StreamNameChunk;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.common.collect.ImmutableList;

@Deprecated
final class ListChunk
implements AviChunk {
    public final ImmutableList<AviChunk> children;
    private final int type;

    public static ListChunk parseFrom(int listType, ParsableByteArray body) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        int listBodyEndPosition = body.limit();
        int currentTrackType = -2;
        while (body.bytesLeft() > 8) {
            AviChunk aviChunk;
            int type = body.readLittleEndianInt();
            int size = body.readLittleEndianInt();
            int innerBoxBodyEndPosition = body.getPosition() + size;
            body.setLimit(innerBoxBodyEndPosition);
            if (type == 1414744396) {
                int innerListType = body.readLittleEndianInt();
                aviChunk = ListChunk.parseFrom(innerListType, body);
            } else {
                aviChunk = ListChunk.createBox(type, currentTrackType, body);
            }
            if (aviChunk != null) {
                if (aviChunk.getType() == 1752331379) {
                    currentTrackType = ((AviStreamHeaderChunk)aviChunk).getTrackType();
                }
                builder.add((Object)aviChunk);
            }
            body.setPosition(innerBoxBodyEndPosition);
            body.setLimit(listBodyEndPosition);
        }
        return new ListChunk(listType, (ImmutableList<AviChunk>)builder.build());
    }

    private ListChunk(int type, ImmutableList<AviChunk> children) {
        this.type = type;
        this.children = children;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Nullable
    public <T extends AviChunk> T getChild(Class<T> c) {
        for (AviChunk aviChunk : this.children) {
            if (aviChunk.getClass() != c) continue;
            return (T)aviChunk;
        }
        return null;
    }

    @Nullable
    private static AviChunk createBox(int chunkType, int trackType, ParsableByteArray body) {
        switch (chunkType) {
            case 1751742049: {
                return AviMainHeaderChunk.parseFrom(body);
            }
            case 1752331379: {
                return AviStreamHeaderChunk.parseFrom(body);
            }
            case 1718776947: {
                return StreamFormatChunk.parseFrom(trackType, body);
            }
            case 1852994675: {
                return StreamNameChunk.parseFrom(body);
            }
        }
        return null;
    }
}

