/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import android.util.Base64;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.VorbisBitArray;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.flac.PictureFrame;
import com.google.android.exoplayer2.metadata.vorbis.VorbisComment;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class VorbisUtil {
    private static final String TAG = "VorbisUtil";

    public static int iLog(int x) {
        int val = 0;
        while (x > 0) {
            ++val;
            x >>>= 1;
        }
        return val;
    }

    public static VorbisIdHeader readVorbisIdentificationHeader(ParsableByteArray headerData) throws ParserException {
        int bitrateMinimum;
        int bitrateNominal;
        VorbisUtil.verifyVorbisHeaderCapturePattern(1, headerData, false);
        int version = headerData.readLittleEndianUnsignedIntToInt();
        int channels = headerData.readUnsignedByte();
        int sampleRate = headerData.readLittleEndianUnsignedIntToInt();
        int bitrateMaximum = headerData.readLittleEndianInt();
        if (bitrateMaximum <= 0) {
            bitrateMaximum = -1;
        }
        if ((bitrateNominal = headerData.readLittleEndianInt()) <= 0) {
            bitrateNominal = -1;
        }
        if ((bitrateMinimum = headerData.readLittleEndianInt()) <= 0) {
            bitrateMinimum = -1;
        }
        int blockSize = headerData.readUnsignedByte();
        int blockSize0 = (int)Math.pow(2.0, blockSize & 0xF);
        int blockSize1 = (int)Math.pow(2.0, (blockSize & 0xF0) >> 4);
        boolean framingFlag = (headerData.readUnsignedByte() & 1) > 0;
        byte[] data = Arrays.copyOf(headerData.getData(), headerData.limit());
        return new VorbisIdHeader(version, channels, sampleRate, bitrateMaximum, bitrateNominal, bitrateMinimum, blockSize0, blockSize1, framingFlag, data);
    }

    public static CommentHeader readVorbisCommentHeader(ParsableByteArray headerData) throws ParserException {
        return VorbisUtil.readVorbisCommentHeader(headerData, true, true);
    }

    public static CommentHeader readVorbisCommentHeader(ParsableByteArray headerData, boolean hasMetadataHeader, boolean hasFramingBit) throws ParserException {
        if (hasMetadataHeader) {
            VorbisUtil.verifyVorbisHeaderCapturePattern(3, headerData, false);
        }
        int length = 7;
        int len = (int)headerData.readLittleEndianUnsignedInt();
        length += 4;
        String vendor = headerData.readString(len);
        length += vendor.length();
        long commentListLen = headerData.readLittleEndianUnsignedInt();
        String[] comments = new String[(int)commentListLen];
        length += 4;
        int i = 0;
        while ((long)i < commentListLen) {
            len = (int)headerData.readLittleEndianUnsignedInt();
            length += 4;
            comments[i] = headerData.readString(len);
            length += comments[i].length();
            ++i;
        }
        if (hasFramingBit && (headerData.readUnsignedByte() & 1) == 0) {
            throw ParserException.createForMalformedContainer((String)"framing bit expected to be set", null);
        }
        return new CommentHeader(vendor, comments, ++length);
    }

    @Nullable
    public static Metadata parseVorbisComments(List<String> vorbisComments) {
        ArrayList<Object> metadataEntries = new ArrayList<Object>();
        for (int i = 0; i < vorbisComments.size(); ++i) {
            String vorbisComment = vorbisComments.get(i);
            String[] keyAndValue = Util.splitAtFirst((String)vorbisComment, (String)"=");
            if (keyAndValue.length != 2) {
                Log.w((String)TAG, (String)("Failed to parse Vorbis comment: " + vorbisComment));
                continue;
            }
            if (keyAndValue[0].equals("METADATA_BLOCK_PICTURE")) {
                try {
                    byte[] decoded = Base64.decode((String)keyAndValue[1], (int)0);
                    metadataEntries.add(PictureFrame.fromPictureBlock(new ParsableByteArray(decoded)));
                }
                catch (RuntimeException e) {
                    Log.w((String)TAG, (String)"Failed to parse vorbis picture", (Throwable)e);
                }
                continue;
            }
            VorbisComment entry = new VorbisComment(keyAndValue[0], keyAndValue[1]);
            metadataEntries.add(entry);
        }
        return metadataEntries.isEmpty() ? null : new Metadata(metadataEntries);
    }

    public static boolean verifyVorbisHeaderCapturePattern(int headerType, ParsableByteArray header, boolean quiet) throws ParserException {
        if (header.bytesLeft() < 7) {
            if (quiet) {
                return false;
            }
            throw ParserException.createForMalformedContainer((String)("too short header: " + header.bytesLeft()), null);
        }
        if (header.readUnsignedByte() != headerType) {
            if (quiet) {
                return false;
            }
            throw ParserException.createForMalformedContainer((String)("expected header type " + Integer.toHexString(headerType)), null);
        }
        if (header.readUnsignedByte() != 118 || header.readUnsignedByte() != 111 || header.readUnsignedByte() != 114 || header.readUnsignedByte() != 98 || header.readUnsignedByte() != 105 || header.readUnsignedByte() != 115) {
            if (quiet) {
                return false;
            }
            throw ParserException.createForMalformedContainer((String)"expected characters 'vorbis'", null);
        }
        return true;
    }

    public static Mode[] readVorbisModes(ParsableByteArray headerData, int channels) throws ParserException {
        VorbisUtil.verifyVorbisHeaderCapturePattern(5, headerData, false);
        int numberOfBooks = headerData.readUnsignedByte() + 1;
        VorbisBitArray bitArray = new VorbisBitArray(headerData.getData());
        bitArray.skipBits(headerData.getPosition() * 8);
        for (int i = 0; i < numberOfBooks; ++i) {
            VorbisUtil.skipBook(bitArray);
        }
        int timeCount = bitArray.readBits(6) + 1;
        for (int i = 0; i < timeCount; ++i) {
            if (bitArray.readBits(16) == 0) continue;
            throw ParserException.createForMalformedContainer((String)"placeholder of time domain transforms not zeroed out", null);
        }
        VorbisUtil.readFloors(bitArray);
        VorbisUtil.readResidues(bitArray);
        VorbisUtil.readMappings(channels, bitArray);
        Mode[] modes = VorbisUtil.readModes(bitArray);
        if (!bitArray.readBit()) {
            throw ParserException.createForMalformedContainer((String)"framing bit after modes not set as expected", null);
        }
        return modes;
    }

    private static Mode[] readModes(VorbisBitArray bitArray) {
        int modeCount = bitArray.readBits(6) + 1;
        Mode[] modes = new Mode[modeCount];
        for (int i = 0; i < modeCount; ++i) {
            boolean blockFlag = bitArray.readBit();
            int windowType = bitArray.readBits(16);
            int transformType = bitArray.readBits(16);
            int mapping = bitArray.readBits(8);
            modes[i] = new Mode(blockFlag, windowType, transformType, mapping);
        }
        return modes;
    }

    private static void readMappings(int channels, VorbisBitArray bitArray) throws ParserException {
        int mappingsCount = bitArray.readBits(6) + 1;
        for (int i = 0; i < mappingsCount; ++i) {
            int j;
            int mappingType = bitArray.readBits(16);
            if (mappingType != 0) {
                Log.e((String)TAG, (String)("mapping type other than 0 not supported: " + mappingType));
                continue;
            }
            int submaps = bitArray.readBit() ? bitArray.readBits(4) + 1 : 1;
            if (bitArray.readBit()) {
                int couplingSteps = bitArray.readBits(8) + 1;
                for (j = 0; j < couplingSteps; ++j) {
                    bitArray.skipBits(VorbisUtil.iLog(channels - 1));
                    bitArray.skipBits(VorbisUtil.iLog(channels - 1));
                }
            }
            if (bitArray.readBits(2) != 0) {
                throw ParserException.createForMalformedContainer((String)"to reserved bits must be zero after mapping coupling steps", null);
            }
            if (submaps > 1) {
                for (j = 0; j < channels; ++j) {
                    bitArray.skipBits(4);
                }
            }
            for (j = 0; j < submaps; ++j) {
                bitArray.skipBits(8);
                bitArray.skipBits(8);
                bitArray.skipBits(8);
            }
        }
    }

    private static void readResidues(VorbisBitArray bitArray) throws ParserException {
        int residueCount = bitArray.readBits(6) + 1;
        for (int i = 0; i < residueCount; ++i) {
            int j;
            int residueType = bitArray.readBits(16);
            if (residueType > 2) {
                throw ParserException.createForMalformedContainer((String)"residueType greater than 2 is not decodable", null);
            }
            bitArray.skipBits(24);
            bitArray.skipBits(24);
            bitArray.skipBits(24);
            int classifications = bitArray.readBits(6) + 1;
            bitArray.skipBits(8);
            int[] cascade = new int[classifications];
            for (j = 0; j < classifications; ++j) {
                int highBits = 0;
                int lowBits = bitArray.readBits(3);
                if (bitArray.readBit()) {
                    highBits = bitArray.readBits(5);
                }
                cascade[j] = highBits * 8 + lowBits;
            }
            for (j = 0; j < classifications; ++j) {
                for (int k = 0; k < 8; ++k) {
                    if ((cascade[j] & 1 << k) == 0) continue;
                    bitArray.skipBits(8);
                }
            }
        }
    }

    private static void readFloors(VorbisBitArray bitArray) throws ParserException {
        int floorCount = bitArray.readBits(6) + 1;
        block4: for (int i = 0; i < floorCount; ++i) {
            int floorType = bitArray.readBits(16);
            switch (floorType) {
                case 0: {
                    bitArray.skipBits(8);
                    bitArray.skipBits(16);
                    bitArray.skipBits(16);
                    bitArray.skipBits(6);
                    bitArray.skipBits(8);
                    int floorNumberOfBooks = bitArray.readBits(4) + 1;
                    for (int j = 0; j < floorNumberOfBooks; ++j) {
                        bitArray.skipBits(8);
                    }
                    continue block4;
                }
                case 1: {
                    int partitions = bitArray.readBits(5);
                    int maximumClass = -1;
                    int[] partitionClassList = new int[partitions];
                    for (int j = 0; j < partitions; ++j) {
                        partitionClassList[j] = bitArray.readBits(4);
                        if (partitionClassList[j] <= maximumClass) continue;
                        maximumClass = partitionClassList[j];
                    }
                    int[] classDimensions = new int[maximumClass + 1];
                    for (int j = 0; j < classDimensions.length; ++j) {
                        classDimensions[j] = bitArray.readBits(3) + 1;
                        int classSubclasses = bitArray.readBits(2);
                        if (classSubclasses > 0) {
                            bitArray.skipBits(8);
                        }
                        for (int k = 0; k < 1 << classSubclasses; ++k) {
                            bitArray.skipBits(8);
                        }
                    }
                    bitArray.skipBits(2);
                    int rangeBits = bitArray.readBits(4);
                    int count = 0;
                    int k = 0;
                    for (int j = 0; j < partitions; ++j) {
                        int idx = partitionClassList[j];
                        count += classDimensions[idx];
                        while (k < count) {
                            bitArray.skipBits(rangeBits);
                            ++k;
                        }
                    }
                    continue block4;
                }
                default: {
                    throw ParserException.createForMalformedContainer((String)("floor type greater than 1 not decodable: " + floorType), null);
                }
            }
        }
    }

    private static void skipBook(VorbisBitArray bitArray) throws ParserException {
        int lookupType;
        if (bitArray.readBits(24) != 5653314) {
            throw ParserException.createForMalformedContainer((String)("expected code book to start with [0x56, 0x43, 0x42] at " + bitArray.getPosition()), null);
        }
        int dimensions = bitArray.readBits(16);
        int entries = bitArray.readBits(24);
        boolean isOrdered = bitArray.readBit();
        if (!isOrdered) {
            boolean isSparse = bitArray.readBit();
            for (int i = 0; i < entries; ++i) {
                if (isSparse) {
                    if (!bitArray.readBit()) continue;
                    bitArray.skipBits(5);
                    continue;
                }
                bitArray.skipBits(5);
            }
        } else {
            bitArray.skipBits(5);
            for (int i = 0; i < entries; i += bitArray.readBits(VorbisUtil.iLog(entries - i))) {
            }
        }
        if ((lookupType = bitArray.readBits(4)) > 2) {
            throw ParserException.createForMalformedContainer((String)("lookup type greater than 2 not decodable: " + lookupType), null);
        }
        if (lookupType == 1 || lookupType == 2) {
            bitArray.skipBits(32);
            bitArray.skipBits(32);
            int valueBits = bitArray.readBits(4) + 1;
            bitArray.skipBits(1);
            long lookupValuesCount = lookupType == 1 ? (dimensions != 0 ? VorbisUtil.mapType1QuantValues(entries, dimensions) : 0L) : (long)entries * (long)dimensions;
            bitArray.skipBits((int)(lookupValuesCount * (long)valueBits));
        }
    }

    private static long mapType1QuantValues(long entries, long dimension) {
        return (long)Math.floor(Math.pow(entries, 1.0 / (double)dimension));
    }

    private VorbisUtil() {
    }

    public static final class Mode {
        public final boolean blockFlag;
        public final int windowType;
        public final int transformType;
        public final int mapping;

        public Mode(boolean blockFlag, int windowType, int transformType, int mapping) {
            this.blockFlag = blockFlag;
            this.windowType = windowType;
            this.transformType = transformType;
            this.mapping = mapping;
        }
    }

    public static final class VorbisIdHeader {
        public final int version;
        public final int channels;
        public final int sampleRate;
        public final int bitrateMaximum;
        public final int bitrateNominal;
        public final int bitrateMinimum;
        public final int blockSize0;
        public final int blockSize1;
        public final boolean framingFlag;
        public final byte[] data;

        public VorbisIdHeader(int version, int channels, int sampleRate, int bitrateMaximum, int bitrateNominal, int bitrateMinimum, int blockSize0, int blockSize1, boolean framingFlag, byte[] data) {
            this.version = version;
            this.channels = channels;
            this.sampleRate = sampleRate;
            this.bitrateMaximum = bitrateMaximum;
            this.bitrateNominal = bitrateNominal;
            this.bitrateMinimum = bitrateMinimum;
            this.blockSize0 = blockSize0;
            this.blockSize1 = blockSize1;
            this.framingFlag = framingFlag;
            this.data = data;
        }
    }

    public static final class CommentHeader {
        public final String vendor;
        public final String[] comments;
        public final int length;

        public CommentHeader(String vendor, String[] comments, int length) {
            this.vendor = vendor;
            this.comments = comments;
            this.length = length;
        }
    }
}

