/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;

@Deprecated
public final class CeaUtil {
    private static final String TAG = "CeaUtil";
    public static final int USER_DATA_IDENTIFIER_GA94 = 1195456820;
    public static final int USER_DATA_TYPE_CODE_MPEG_CC = 3;
    private static final int PAYLOAD_TYPE_CC = 4;
    private static final int COUNTRY_CODE = 181;
    private static final int PROVIDER_CODE_ATSC = 49;
    private static final int PROVIDER_CODE_DIRECTV = 47;

    public static void consume(long presentationTimeUs, ParsableByteArray seiBuffer, TrackOutput[] outputs) {
        while (seiBuffer.bytesLeft() > 1) {
            int payloadType = CeaUtil.readNon255TerminatedValue(seiBuffer);
            int payloadSize = CeaUtil.readNon255TerminatedValue(seiBuffer);
            int nextPayloadPosition = seiBuffer.getPosition() + payloadSize;
            if (payloadSize == -1 || payloadSize > seiBuffer.bytesLeft()) {
                Log.w((String)TAG, (String)"Skipping remainder of malformed SEI NAL unit.");
                nextPayloadPosition = seiBuffer.limit();
            } else if (payloadType == 4 && payloadSize >= 8) {
                boolean messageIsSupportedCeaCaption;
                int countryCode = seiBuffer.readUnsignedByte();
                int providerCode = seiBuffer.readUnsignedShort();
                int userIdentifier = 0;
                if (providerCode == 49) {
                    userIdentifier = seiBuffer.readInt();
                }
                int userDataTypeCode = seiBuffer.readUnsignedByte();
                if (providerCode == 47) {
                    seiBuffer.skipBytes(1);
                }
                boolean bl = messageIsSupportedCeaCaption = countryCode == 181 && (providerCode == 49 || providerCode == 47) && userDataTypeCode == 3;
                if (providerCode == 49) {
                    messageIsSupportedCeaCaption &= userIdentifier == 1195456820;
                }
                if (messageIsSupportedCeaCaption) {
                    CeaUtil.consumeCcData(presentationTimeUs, seiBuffer, outputs);
                }
            }
            seiBuffer.setPosition(nextPayloadPosition);
        }
    }

    public static void consumeCcData(long presentationTimeUs, ParsableByteArray ccDataBuffer, TrackOutput[] outputs) {
        boolean processCcDataFlag;
        int firstByte = ccDataBuffer.readUnsignedByte();
        boolean bl = processCcDataFlag = (firstByte & 0x40) != 0;
        if (!processCcDataFlag) {
            return;
        }
        int ccCount = firstByte & 0x1F;
        ccDataBuffer.skipBytes(1);
        int sampleLength = ccCount * 3;
        int sampleStartPosition = ccDataBuffer.getPosition();
        for (TrackOutput output : outputs) {
            ccDataBuffer.setPosition(sampleStartPosition);
            output.sampleData(ccDataBuffer, sampleLength);
            if (presentationTimeUs == -9223372036854775807L) continue;
            output.sampleMetadata(presentationTimeUs, 1, sampleLength, 0, null);
        }
    }

    private static int readNon255TerminatedValue(ParsableByteArray buffer) {
        int b;
        int value = 0;
        do {
            if (buffer.bytesLeft() == 0) {
                return -1;
            }
            b = buffer.readUnsignedByte();
            value += b;
        } while (b == 255);
        return value;
    }

    private CeaUtil() {
    }
}

