/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp3;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.audio.MpegAudioUtil;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.SeekPoint;
import com.google.android.exoplayer2.extractor.mp3.Seeker;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;

final class VbriSeeker
implements Seeker {
    private static final String TAG = "VbriSeeker";
    private final long[] timesUs;
    private final long[] positions;
    private final long durationUs;
    private final long dataEndPosition;

    @Nullable
    public static VbriSeeker create(long inputLength, long position, MpegAudioUtil.Header mpegAudioHeader, ParsableByteArray frame) {
        frame.skipBytes(10);
        int numFrames = frame.readInt();
        if (numFrames <= 0) {
            return null;
        }
        int sampleRate = mpegAudioHeader.sampleRate;
        long durationUs = Util.scaleLargeTimestamp((long)numFrames, (long)(1000000L * (long)(sampleRate >= 32000 ? 1152 : 576)), (long)sampleRate);
        int entryCount = frame.readUnsignedShort();
        int scale = frame.readUnsignedShort();
        int entrySize = frame.readUnsignedShort();
        frame.skipBytes(2);
        long minPosition = position + (long)mpegAudioHeader.frameSize;
        long[] timesUs = new long[entryCount];
        long[] positions = new long[entryCount];
        for (int index = 0; index < entryCount; ++index) {
            int segmentSize;
            timesUs[index] = (long)index * durationUs / (long)entryCount;
            positions[index] = Math.max(position, minPosition);
            switch (entrySize) {
                case 1: {
                    segmentSize = frame.readUnsignedByte();
                    break;
                }
                case 2: {
                    segmentSize = frame.readUnsignedShort();
                    break;
                }
                case 3: {
                    segmentSize = frame.readUnsignedInt24();
                    break;
                }
                case 4: {
                    segmentSize = frame.readUnsignedIntToInt();
                    break;
                }
                default: {
                    return null;
                }
            }
            position += (long)segmentSize * (long)scale;
        }
        if (inputLength != -1L && inputLength != position) {
            Log.w((String)TAG, (String)("VBRI data size mismatch: " + inputLength + ", " + position));
        }
        return new VbriSeeker(timesUs, positions, durationUs, position);
    }

    private VbriSeeker(long[] timesUs, long[] positions, long durationUs, long dataEndPosition) {
        this.timesUs = timesUs;
        this.positions = positions;
        this.durationUs = durationUs;
        this.dataEndPosition = dataEndPosition;
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        int tableIndex = Util.binarySearchFloor((long[])this.timesUs, (long)timeUs, (boolean)true, (boolean)true);
        SeekPoint seekPoint = new SeekPoint(this.timesUs[tableIndex], this.positions[tableIndex]);
        if (seekPoint.timeUs >= timeUs || tableIndex == this.timesUs.length - 1) {
            return new SeekMap.SeekPoints(seekPoint);
        }
        SeekPoint nextSeekPoint = new SeekPoint(this.timesUs[tableIndex + 1], this.positions[tableIndex + 1]);
        return new SeekMap.SeekPoints(seekPoint, nextSeekPoint);
    }

    @Override
    public long getTimeUs(long position) {
        return this.timesUs[Util.binarySearchFloor((long[])this.positions, (long)position, (boolean)true, (boolean)true)];
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public long getDataEndPosition() {
        return this.dataEndPosition;
    }
}

