/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.emsg;

import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataInputBuffer;
import com.google.android.exoplayer2.metadata.SimpleMetadataDecoder;
import com.google.android.exoplayer2.metadata.emsg.EventMessage;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class EventMessageDecoder
extends SimpleMetadataDecoder {
    @Override
    protected Metadata decode(MetadataInputBuffer inputBuffer, ByteBuffer buffer) {
        return new Metadata(new Metadata.Entry[]{this.decode(new ParsableByteArray(buffer.array(), buffer.limit()))});
    }

    public EventMessage decode(ParsableByteArray emsgData) {
        String schemeIdUri = (String)Assertions.checkNotNull((Object)emsgData.readNullTerminatedString());
        String value = (String)Assertions.checkNotNull((Object)emsgData.readNullTerminatedString());
        long durationMs = emsgData.readLong();
        long id = emsgData.readLong();
        byte[] messageData = Arrays.copyOfRange(emsgData.getData(), emsgData.getPosition(), emsgData.limit());
        return new EventMessage(schemeIdUri, value, durationMs, id, messageData);
    }
}

