/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.OpusUtil;
import com.google.android.exoplayer2.extractor.ogg.StreamReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

final class OpusReader
extends StreamReader {
    private static final int OPUS_CODE = 1332770163;
    private static final byte[] OPUS_SIGNATURE = new byte[]{79, 112, 117, 115, 72, 101, 97, 100};
    private boolean headerRead;

    OpusReader() {
    }

    public static boolean verifyBitstreamType(ParsableByteArray data) {
        if (data.bytesLeft() < OPUS_SIGNATURE.length) {
            return false;
        }
        byte[] header = new byte[OPUS_SIGNATURE.length];
        data.readBytes(header, 0, OPUS_SIGNATURE.length);
        return Arrays.equals(header, OPUS_SIGNATURE);
    }

    @Override
    protected void reset(boolean headerData) {
        super.reset(headerData);
        if (headerData) {
            this.headerRead = false;
        }
    }

    @Override
    protected long preparePayload(ParsableByteArray packet) {
        return this.convertTimeToGranule(this.getPacketDurationUs(packet.getData()));
    }

    @Override
    @EnsuresNonNullIf(expression={"#3.format"}, result=false)
    protected boolean readHeaders(ParsableByteArray packet, long position, StreamReader.SetupData setupData) {
        if (!this.headerRead) {
            byte[] headerBytes = Arrays.copyOf(packet.getData(), packet.limit());
            int channelCount = OpusUtil.getChannelCount(headerBytes);
            List<byte[]> initializationData = OpusUtil.buildInitializationData(headerBytes);
            setupData.format = new Format.Builder().setSampleMimeType("audio/opus").setChannelCount(channelCount).setSampleRate(48000).setInitializationData(initializationData).build();
            this.headerRead = true;
            return true;
        }
        Assertions.checkNotNull((Object)setupData.format);
        boolean headerPacket = packet.readInt() == 1332770163;
        packet.setPosition(0);
        return headerPacket;
    }

    private long getPacketDurationUs(byte[] packet) {
        int frames;
        int toc = packet[0] & 0xFF;
        switch (toc & 3) {
            case 0: {
                frames = 1;
                break;
            }
            case 1: 
            case 2: {
                frames = 2;
                break;
            }
            default: {
                frames = packet[1] & 0x3F;
            }
        }
        int config = toc >> 3;
        int length = config & 3;
        length = config >= 16 ? 2500 << length : (config >= 12 ? 10000 << (length & 1) : (length == 3 ? 60000 : 10000 << length));
        return (long)frames * (long)length;
    }
}

