/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mp3;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.MpegAudioUtil;
import com.google.android.exoplayer2.extractor.DummyTrackOutput;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.GaplessInfoHolder;
import com.google.android.exoplayer2.extractor.Id3Peeker;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.mp3.ConstantBitrateSeeker;
import com.google.android.exoplayer2.extractor.mp3.IndexSeeker;
import com.google.android.exoplayer2.extractor.mp3.MlltSeeker;
import com.google.android.exoplayer2.extractor.mp3.Seeker;
import com.google.android.exoplayer2.extractor.mp3.VbriSeeker;
import com.google.android.exoplayer2.extractor.mp3.XingSeeker;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.id3.Id3Decoder;
import com.google.android.exoplayer2.metadata.id3.MlltFrame;
import com.google.android.exoplayer2.metadata.id3.TextInformationFrame;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public final class Mp3Extractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new Mp3Extractor()};
    public static final int FLAG_ENABLE_CONSTANT_BITRATE_SEEKING = 1;
    public static final int FLAG_ENABLE_CONSTANT_BITRATE_SEEKING_ALWAYS = 2;
    public static final int FLAG_ENABLE_INDEX_SEEKING = 4;
    public static final int FLAG_DISABLE_ID3_METADATA = 8;
    private static final Id3Decoder.FramePredicate REQUIRED_ID3_FRAME_PREDICATE = (majorVersion, id0, id1, id2, id3) -> id0 == 67 && id1 == 79 && id2 == 77 && (id3 == 77 || majorVersion == 2) || id0 == 77 && id1 == 76 && id2 == 76 && (id3 == 84 || majorVersion == 2);
    private static final int MAX_SYNC_BYTES = 131072;
    private static final int MAX_SNIFF_BYTES = 32768;
    private static final int SCRATCH_LENGTH = 10;
    private static final int MPEG_AUDIO_HEADER_MASK = -128000;
    private static final int SEEK_HEADER_XING = 1483304551;
    private static final int SEEK_HEADER_INFO = 1231971951;
    private static final int SEEK_HEADER_VBRI = 1447187017;
    private static final int SEEK_HEADER_UNSET = 0;
    private final int flags;
    private final long forcedFirstSampleTimestampUs;
    private final ParsableByteArray scratch;
    private final MpegAudioUtil.Header synchronizedHeader;
    private final GaplessInfoHolder gaplessInfoHolder;
    private final Id3Peeker id3Peeker;
    private final TrackOutput skippingTrackOutput;
    private @MonotonicNonNull ExtractorOutput extractorOutput;
    private @MonotonicNonNull TrackOutput realTrackOutput;
    private TrackOutput currentTrackOutput;
    private int synchronizedHeaderData;
    @Nullable
    private Metadata metadata;
    private long basisTimeUs;
    private long samplesRead;
    private long firstSamplePosition;
    private int sampleBytesRemaining;
    private @MonotonicNonNull Seeker seeker;
    private boolean disableSeeking;
    private boolean isSeekInProgress;
    private long seekTimeUs;

    public Mp3Extractor() {
        this(0);
    }

    public Mp3Extractor(int flags) {
        this(flags, -9223372036854775807L);
    }

    public Mp3Extractor(int flags, long forcedFirstSampleTimestampUs) {
        if ((flags & 2) != 0) {
            flags |= 1;
        }
        this.flags = flags;
        this.forcedFirstSampleTimestampUs = forcedFirstSampleTimestampUs;
        this.scratch = new ParsableByteArray(10);
        this.synchronizedHeader = new MpegAudioUtil.Header();
        this.gaplessInfoHolder = new GaplessInfoHolder();
        this.basisTimeUs = -9223372036854775807L;
        this.id3Peeker = new Id3Peeker();
        this.currentTrackOutput = this.skippingTrackOutput = new DummyTrackOutput();
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        return this.synchronize(input, true);
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
        this.currentTrackOutput = this.realTrackOutput = this.extractorOutput.track(0, 1);
        this.extractorOutput.endTracks();
    }

    @Override
    public void seek(long position, long timeUs) {
        this.synchronizedHeaderData = 0;
        this.basisTimeUs = -9223372036854775807L;
        this.samplesRead = 0L;
        this.sampleBytesRemaining = 0;
        this.seekTimeUs = timeUs;
        if (this.seeker instanceof IndexSeeker && !((IndexSeeker)this.seeker).isTimeUsInIndex(timeUs)) {
            this.isSeekInProgress = true;
            this.currentTrackOutput = this.skippingTrackOutput;
        }
    }

    @Override
    public void release() {
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        this.assertInitialized();
        int readResult = this.readInternal(input);
        if (readResult == -1 && this.seeker instanceof IndexSeeker) {
            long durationUs = this.computeTimeUs(this.samplesRead);
            if (this.seeker.getDurationUs() != durationUs) {
                ((IndexSeeker)this.seeker).setDurationUs(durationUs);
                this.extractorOutput.seekMap(this.seeker);
            }
        }
        return readResult;
    }

    public void disableSeeking() {
        this.disableSeeking = true;
    }

    @RequiresNonNull(value={"extractorOutput", "realTrackOutput"})
    private int readInternal(ExtractorInput input) throws IOException {
        long inputPosition;
        if (this.synchronizedHeaderData == 0) {
            try {
                this.synchronize(input, false);
            }
            catch (EOFException e) {
                return -1;
            }
        }
        if (this.seeker == null) {
            this.seeker = this.computeSeeker(input);
            this.extractorOutput.seekMap(this.seeker);
            this.currentTrackOutput.format(new Format.Builder().setSampleMimeType(this.synchronizedHeader.mimeType).setMaxInputSize(4096).setChannelCount(this.synchronizedHeader.channels).setSampleRate(this.synchronizedHeader.sampleRate).setEncoderDelay(this.gaplessInfoHolder.encoderDelay).setEncoderPadding(this.gaplessInfoHolder.encoderPadding).setMetadata((this.flags & 8) != 0 ? null : this.metadata).build());
            this.firstSamplePosition = input.getPosition();
        } else if (this.firstSamplePosition != 0L && (inputPosition = input.getPosition()) < this.firstSamplePosition) {
            input.skipFully((int)(this.firstSamplePosition - inputPosition));
        }
        return this.readSample(input);
    }

    @RequiresNonNull(value={"realTrackOutput", "seeker"})
    private int readSample(ExtractorInput extractorInput) throws IOException {
        int bytesAppended;
        if (this.sampleBytesRemaining == 0) {
            extractorInput.resetPeekPosition();
            if (this.peekEndOfStreamOrHeader(extractorInput)) {
                return -1;
            }
            this.scratch.setPosition(0);
            int sampleHeaderData = this.scratch.readInt();
            if (!Mp3Extractor.headersMatch(sampleHeaderData, this.synchronizedHeaderData) || MpegAudioUtil.getFrameSize(sampleHeaderData) == -1) {
                extractorInput.skipFully(1);
                this.synchronizedHeaderData = 0;
                return 0;
            }
            this.synchronizedHeader.setForHeaderData(sampleHeaderData);
            if (this.basisTimeUs == -9223372036854775807L) {
                this.basisTimeUs = this.seeker.getTimeUs(extractorInput.getPosition());
                if (this.forcedFirstSampleTimestampUs != -9223372036854775807L) {
                    long embeddedFirstSampleTimestampUs = this.seeker.getTimeUs(0L);
                    this.basisTimeUs += this.forcedFirstSampleTimestampUs - embeddedFirstSampleTimestampUs;
                }
            }
            this.sampleBytesRemaining = this.synchronizedHeader.frameSize;
            if (this.seeker instanceof IndexSeeker) {
                IndexSeeker indexSeeker = (IndexSeeker)this.seeker;
                indexSeeker.maybeAddSeekPoint(this.computeTimeUs(this.samplesRead + (long)this.synchronizedHeader.samplesPerFrame), extractorInput.getPosition() + (long)this.synchronizedHeader.frameSize);
                if (this.isSeekInProgress && indexSeeker.isTimeUsInIndex(this.seekTimeUs)) {
                    this.isSeekInProgress = false;
                    this.currentTrackOutput = this.realTrackOutput;
                }
            }
        }
        if ((bytesAppended = this.currentTrackOutput.sampleData(extractorInput, this.sampleBytesRemaining, true)) == -1) {
            return -1;
        }
        this.sampleBytesRemaining -= bytesAppended;
        if (this.sampleBytesRemaining > 0) {
            return 0;
        }
        this.currentTrackOutput.sampleMetadata(this.computeTimeUs(this.samplesRead), 1, this.synchronizedHeader.frameSize, 0, null);
        this.samplesRead += (long)this.synchronizedHeader.samplesPerFrame;
        this.sampleBytesRemaining = 0;
        return 0;
    }

    private long computeTimeUs(long samplesRead) {
        return this.basisTimeUs + samplesRead * 1000000L / (long)this.synchronizedHeader.sampleRate;
    }

    private boolean synchronize(ExtractorInput input, boolean sniffing) throws IOException {
        int validFrameCount = 0;
        int candidateSynchronizedHeaderData = 0;
        int peekedId3Bytes = 0;
        int searchedBytes = 0;
        int searchLimitBytes = sniffing ? 32768 : 131072;
        input.resetPeekPosition();
        if (input.getPosition() == 0L) {
            boolean parseAllId3Frames = (this.flags & 8) == 0;
            Id3Decoder.FramePredicate id3FramePredicate = parseAllId3Frames ? null : REQUIRED_ID3_FRAME_PREDICATE;
            this.metadata = this.id3Peeker.peekId3Data(input, id3FramePredicate);
            if (this.metadata != null) {
                this.gaplessInfoHolder.setFromMetadata(this.metadata);
            }
            peekedId3Bytes = (int)input.getPeekPosition();
            if (!sniffing) {
                input.skipFully(peekedId3Bytes);
            }
        }
        while (true) {
            int frameSize;
            if (this.peekEndOfStreamOrHeader(input)) {
                if (validFrameCount > 0) break;
                throw new EOFException();
            }
            this.scratch.setPosition(0);
            int headerData = this.scratch.readInt();
            if (candidateSynchronizedHeaderData != 0 && !Mp3Extractor.headersMatch(headerData, candidateSynchronizedHeaderData) || (frameSize = MpegAudioUtil.getFrameSize(headerData)) == -1) {
                if (searchedBytes++ == searchLimitBytes) {
                    if (!sniffing) {
                        throw ParserException.createForMalformedContainer((String)"Searched too many bytes.", null);
                    }
                    return false;
                }
                validFrameCount = 0;
                candidateSynchronizedHeaderData = 0;
                if (sniffing) {
                    input.resetPeekPosition();
                    input.advancePeekPosition(peekedId3Bytes + searchedBytes);
                    continue;
                }
                input.skipFully(1);
                continue;
            }
            if (++validFrameCount == 1) {
                this.synchronizedHeader.setForHeaderData(headerData);
                candidateSynchronizedHeaderData = headerData;
            } else if (validFrameCount == 4) break;
            input.advancePeekPosition(frameSize - 4);
        }
        if (sniffing) {
            input.skipFully(peekedId3Bytes + searchedBytes);
        } else {
            input.resetPeekPosition();
        }
        this.synchronizedHeaderData = candidateSynchronizedHeaderData;
        return true;
    }

    private boolean peekEndOfStreamOrHeader(ExtractorInput extractorInput) throws IOException {
        long dataEndPosition;
        if (this.seeker != null && (dataEndPosition = this.seeker.getDataEndPosition()) != -1L && extractorInput.getPeekPosition() > dataEndPosition - 4L) {
            return true;
        }
        try {
            return !extractorInput.peekFully(this.scratch.getData(), 0, 4, true);
        }
        catch (EOFException e) {
            return true;
        }
    }

    private Seeker computeSeeker(ExtractorInput input) throws IOException {
        Seeker seekFrameSeeker = this.maybeReadSeekFrame(input);
        MlltSeeker metadataSeeker = Mp3Extractor.maybeHandleSeekMetadata(this.metadata, input.getPosition());
        if (this.disableSeeking) {
            return new Seeker.UnseekableSeeker();
        }
        Seeker resultSeeker = null;
        if ((this.flags & 4) != 0) {
            long durationUs;
            long dataEndPosition = -1L;
            if (metadataSeeker != null) {
                durationUs = metadataSeeker.getDurationUs();
                dataEndPosition = metadataSeeker.getDataEndPosition();
            } else if (seekFrameSeeker != null) {
                durationUs = seekFrameSeeker.getDurationUs();
                dataEndPosition = seekFrameSeeker.getDataEndPosition();
            } else {
                durationUs = Mp3Extractor.getId3TlenUs(this.metadata);
            }
            resultSeeker = new IndexSeeker(durationUs, input.getPosition(), dataEndPosition);
        } else if (metadataSeeker != null) {
            resultSeeker = metadataSeeker;
        } else if (seekFrameSeeker != null) {
            resultSeeker = seekFrameSeeker;
        }
        if (resultSeeker == null || !resultSeeker.isSeekable() && (this.flags & 1) != 0) {
            resultSeeker = this.getConstantBitrateSeeker(input, (this.flags & 2) != 0);
        }
        return resultSeeker;
    }

    @Nullable
    private Seeker maybeReadSeekFrame(ExtractorInput input) throws IOException {
        Seeker seeker;
        ParsableByteArray frame = new ParsableByteArray(this.synchronizedHeader.frameSize);
        input.peekFully(frame.getData(), 0, this.synchronizedHeader.frameSize);
        int xingBase = (this.synchronizedHeader.version & 1) != 0 ? (this.synchronizedHeader.channels != 1 ? 36 : 21) : (this.synchronizedHeader.channels != 1 ? 21 : 13);
        int seekHeader = Mp3Extractor.getSeekFrameHeader(frame, xingBase);
        if (seekHeader == 1483304551 || seekHeader == 1231971951) {
            seeker = XingSeeker.create(input.getLength(), input.getPosition(), this.synchronizedHeader, frame);
            if (seeker != null && !this.gaplessInfoHolder.hasGaplessInfo()) {
                input.resetPeekPosition();
                input.advancePeekPosition(xingBase + 141);
                input.peekFully(this.scratch.getData(), 0, 3);
                this.scratch.setPosition(0);
                this.gaplessInfoHolder.setFromXingHeaderValue(this.scratch.readUnsignedInt24());
            }
            input.skipFully(this.synchronizedHeader.frameSize);
            if (seeker != null && !seeker.isSeekable() && seekHeader == 1231971951) {
                return this.getConstantBitrateSeeker(input, false);
            }
        } else if (seekHeader == 1447187017) {
            seeker = VbriSeeker.create(input.getLength(), input.getPosition(), this.synchronizedHeader, frame);
            input.skipFully(this.synchronizedHeader.frameSize);
        } else {
            seeker = null;
            input.resetPeekPosition();
        }
        return seeker;
    }

    private Seeker getConstantBitrateSeeker(ExtractorInput input, boolean allowSeeksIfLengthUnknown) throws IOException {
        input.peekFully(this.scratch.getData(), 0, 4);
        this.scratch.setPosition(0);
        this.synchronizedHeader.setForHeaderData(this.scratch.readInt());
        return new ConstantBitrateSeeker(input.getLength(), input.getPosition(), this.synchronizedHeader, allowSeeksIfLengthUnknown);
    }

    @EnsuresNonNull(value={"extractorOutput", "realTrackOutput"})
    private void assertInitialized() {
        Assertions.checkStateNotNull((Object)this.realTrackOutput);
        Util.castNonNull((Object)this.extractorOutput);
    }

    private static boolean headersMatch(int headerA, long headerB) {
        return (long)(headerA & 0xFFFE0C00) == (headerB & 0xFFFFFFFFFFFE0C00L);
    }

    private static int getSeekFrameHeader(ParsableByteArray frame, int xingBase) {
        if (frame.limit() >= xingBase + 4) {
            frame.setPosition(xingBase);
            int headerData = frame.readInt();
            if (headerData == 1483304551 || headerData == 1231971951) {
                return headerData;
            }
        }
        if (frame.limit() >= 40) {
            frame.setPosition(36);
            if (frame.readInt() == 1447187017) {
                return 1447187017;
            }
        }
        return 0;
    }

    @Nullable
    private static MlltSeeker maybeHandleSeekMetadata(@Nullable Metadata metadata, long firstFramePosition) {
        if (metadata != null) {
            int length = metadata.length();
            for (int i = 0; i < length; ++i) {
                Metadata.Entry entry = metadata.get(i);
                if (!(entry instanceof MlltFrame)) continue;
                return MlltSeeker.create(firstFramePosition, (MlltFrame)entry, Mp3Extractor.getId3TlenUs(metadata));
            }
        }
        return null;
    }

    private static long getId3TlenUs(@Nullable Metadata metadata) {
        if (metadata != null) {
            int length = metadata.length();
            for (int i = 0; i < length; ++i) {
                Metadata.Entry entry = metadata.get(i);
                if (!(entry instanceof TextInformationFrame) || !((TextInformationFrame)entry).id.equals("TLEN")) continue;
                return Util.msToUs((long)Long.parseLong(((TextInformationFrame)entry).value));
            }
        }
        return -9223372036854775807L;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

