/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.jpeg;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.jpeg.MotionPhotoDescription;
import com.google.android.exoplayer2.extractor.jpeg.StartOffsetExtractorInput;
import com.google.android.exoplayer2.extractor.jpeg.StartOffsetExtractorOutput;
import com.google.android.exoplayer2.extractor.jpeg.XmpMotionPhotoDescriptionParser;
import com.google.android.exoplayer2.extractor.mp4.Mp4Extractor;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.mp4.MotionPhotoMetadata;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class JpegExtractor
implements Extractor {
    private static final int STATE_READING_MARKER = 0;
    private static final int STATE_READING_SEGMENT_LENGTH = 1;
    private static final int STATE_READING_SEGMENT = 2;
    private static final int STATE_SNIFFING_MOTION_PHOTO_VIDEO = 4;
    private static final int STATE_READING_MOTION_PHOTO_VIDEO = 5;
    private static final int STATE_ENDED = 6;
    private static final int EXIF_ID_CODE_LENGTH = 6;
    private static final long EXIF_HEADER = 1165519206L;
    private static final int MARKER_SOI = 65496;
    private static final int MARKER_SOS = 65498;
    private static final int MARKER_APP0 = 65504;
    private static final int MARKER_APP1 = 65505;
    private static final String HEADER_XMP_APP1 = "http://ns.adobe.com/xap/1.0/";
    private static final int IMAGE_TRACK_ID = 1024;
    private final ParsableByteArray scratch = new ParsableByteArray(6);
    private @MonotonicNonNull ExtractorOutput extractorOutput;
    private int state;
    private int marker;
    private int segmentLength;
    private long mp4StartPosition = -1L;
    @Nullable
    private MotionPhotoMetadata motionPhotoMetadata;
    private @MonotonicNonNull ExtractorInput lastExtractorInput;
    private @MonotonicNonNull StartOffsetExtractorInput mp4ExtractorStartOffsetExtractorInput;
    @Nullable
    private Mp4Extractor mp4Extractor;

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        if (this.peekMarker(input) != 65496) {
            return false;
        }
        this.marker = this.peekMarker(input);
        if (this.marker == 65504) {
            this.advancePeekPositionToNextSegment(input);
            this.marker = this.peekMarker(input);
        }
        if (this.marker != 65505) {
            return false;
        }
        input.advancePeekPosition(2);
        this.scratch.reset(6);
        input.peekFully(this.scratch.getData(), 0, 6);
        return this.scratch.readUnsignedInt() == 1165519206L && this.scratch.readUnsignedShort() == 0;
    }

    @Override
    public void init(ExtractorOutput output) {
        this.extractorOutput = output;
    }

    @Override
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        switch (this.state) {
            case 0: {
                this.readMarker(input);
                return 0;
            }
            case 1: {
                this.readSegmentLength(input);
                return 0;
            }
            case 2: {
                this.readSegment(input);
                return 0;
            }
            case 4: {
                if (input.getPosition() != this.mp4StartPosition) {
                    seekPosition.position = this.mp4StartPosition;
                    return 1;
                }
                this.sniffMotionPhotoVideo(input);
                return 0;
            }
            case 5: {
                int readResult;
                if (this.mp4ExtractorStartOffsetExtractorInput == null || input != this.lastExtractorInput) {
                    this.lastExtractorInput = input;
                    this.mp4ExtractorStartOffsetExtractorInput = new StartOffsetExtractorInput(input, this.mp4StartPosition);
                }
                if ((readResult = ((Mp4Extractor)Assertions.checkNotNull((Object)this.mp4Extractor)).read(this.mp4ExtractorStartOffsetExtractorInput, seekPosition)) == 1) {
                    seekPosition.position += this.mp4StartPosition;
                }
                return readResult;
            }
            case 6: {
                return -1;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void seek(long position, long timeUs) {
        if (position == 0L) {
            this.state = 0;
            this.mp4Extractor = null;
        } else if (this.state == 5) {
            ((Mp4Extractor)Assertions.checkNotNull((Object)this.mp4Extractor)).seek(position, timeUs);
        }
    }

    @Override
    public void release() {
        if (this.mp4Extractor != null) {
            this.mp4Extractor.release();
        }
    }

    private int peekMarker(ExtractorInput input) throws IOException {
        this.scratch.reset(2);
        input.peekFully(this.scratch.getData(), 0, 2);
        return this.scratch.readUnsignedShort();
    }

    private void advancePeekPositionToNextSegment(ExtractorInput input) throws IOException {
        this.scratch.reset(2);
        input.peekFully(this.scratch.getData(), 0, 2);
        int segmentLength = this.scratch.readUnsignedShort() - 2;
        input.advancePeekPosition(segmentLength);
    }

    private void readMarker(ExtractorInput input) throws IOException {
        this.scratch.reset(2);
        input.readFully(this.scratch.getData(), 0, 2);
        this.marker = this.scratch.readUnsignedShort();
        if (this.marker == 65498) {
            if (this.mp4StartPosition != -1L) {
                this.state = 4;
            } else {
                this.endReadingWithImageTrack();
            }
        } else if ((this.marker < 65488 || this.marker > 65497) && this.marker != 65281) {
            this.state = 1;
        }
    }

    private void readSegmentLength(ExtractorInput input) throws IOException {
        this.scratch.reset(2);
        input.readFully(this.scratch.getData(), 0, 2);
        this.segmentLength = this.scratch.readUnsignedShort() - 2;
        this.state = 2;
    }

    private void readSegment(ExtractorInput input) throws IOException {
        if (this.marker == 65505) {
            String xmpString;
            ParsableByteArray payload = new ParsableByteArray(this.segmentLength);
            input.readFully(payload.getData(), 0, this.segmentLength);
            if (this.motionPhotoMetadata == null && HEADER_XMP_APP1.equals(payload.readNullTerminatedString()) && (xmpString = payload.readNullTerminatedString()) != null) {
                this.motionPhotoMetadata = JpegExtractor.getMotionPhotoMetadata(xmpString, input.getLength());
                if (this.motionPhotoMetadata != null) {
                    this.mp4StartPosition = this.motionPhotoMetadata.videoStartPosition;
                }
            }
        } else {
            input.skipFully(this.segmentLength);
        }
        this.state = 0;
    }

    private void sniffMotionPhotoVideo(ExtractorInput input) throws IOException {
        boolean peekedData = input.peekFully(this.scratch.getData(), 0, 1, true);
        if (!peekedData) {
            this.endReadingWithImageTrack();
        } else {
            input.resetPeekPosition();
            if (this.mp4Extractor == null) {
                this.mp4Extractor = new Mp4Extractor();
            }
            this.mp4ExtractorStartOffsetExtractorInput = new StartOffsetExtractorInput(input, this.mp4StartPosition);
            if (this.mp4Extractor.sniff(this.mp4ExtractorStartOffsetExtractorInput)) {
                this.mp4Extractor.init(new StartOffsetExtractorOutput(this.mp4StartPosition, (ExtractorOutput)Assertions.checkNotNull((Object)this.extractorOutput)));
                this.startReadingMotionPhoto();
            } else {
                this.endReadingWithImageTrack();
            }
        }
    }

    private void startReadingMotionPhoto() {
        this.outputImageTrack((Metadata.Entry)Assertions.checkNotNull((Object)this.motionPhotoMetadata));
        this.state = 5;
    }

    private void endReadingWithImageTrack() {
        this.outputImageTrack(new Metadata.Entry[0]);
        ((ExtractorOutput)Assertions.checkNotNull((Object)this.extractorOutput)).endTracks();
        this.extractorOutput.seekMap(new SeekMap.Unseekable(-9223372036854775807L));
        this.state = 6;
    }

    private void outputImageTrack(Metadata.Entry ... metadataEntries) {
        TrackOutput imageTrackOutput = ((ExtractorOutput)Assertions.checkNotNull((Object)this.extractorOutput)).track(1024, 4);
        imageTrackOutput.format(new Format.Builder().setMetadata(new Metadata(metadataEntries)).build());
    }

    @Nullable
    private static MotionPhotoMetadata getMotionPhotoMetadata(String xmpString, long inputLength) throws IOException {
        if (inputLength == -1L) {
            return null;
        }
        MotionPhotoDescription motionPhotoDescription = XmpMotionPhotoDescriptionParser.parse(xmpString);
        if (motionPhotoDescription == null) {
            return null;
        }
        return motionPhotoDescription.getMotionPhotoMetadata(inputLength);
    }
}

