/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.decoder;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.decoder.Buffer;
import com.google.android.exoplayer2.decoder.CryptoInfo;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public class DecoderInputBuffer
extends Buffer {
    public static final int BUFFER_REPLACEMENT_MODE_DISABLED = 0;
    public static final int BUFFER_REPLACEMENT_MODE_NORMAL = 1;
    public static final int BUFFER_REPLACEMENT_MODE_DIRECT = 2;
    @Nullable
    public Format format;
    public final CryptoInfo cryptoInfo = new CryptoInfo();
    @Nullable
    public ByteBuffer data;
    public boolean waitingForKeys;
    public long timeUs;
    @Nullable
    public ByteBuffer supplementalData;
    private final int bufferReplacementMode;
    private final int paddingSize;

    public static DecoderInputBuffer newNoDataInstance() {
        return new DecoderInputBuffer(0);
    }

    public DecoderInputBuffer(int bufferReplacementMode) {
        this(bufferReplacementMode, 0);
    }

    public DecoderInputBuffer(int bufferReplacementMode, int paddingSize) {
        this.bufferReplacementMode = bufferReplacementMode;
        this.paddingSize = paddingSize;
    }

    @EnsuresNonNull(value={"supplementalData"})
    public void resetSupplementalData(int length) {
        if (this.supplementalData == null || this.supplementalData.capacity() < length) {
            this.supplementalData = ByteBuffer.allocate(length);
        } else {
            this.supplementalData.clear();
        }
    }

    @EnsuresNonNull(value={"data"})
    public void ensureSpaceForWrite(int length) {
        int position;
        int requiredCapacity;
        length += this.paddingSize;
        ByteBuffer currentData = this.data;
        if (currentData == null) {
            this.data = this.createReplacementByteBuffer(length);
            return;
        }
        int capacity = currentData.capacity();
        if (capacity >= (requiredCapacity = (position = currentData.position()) + length)) {
            this.data = currentData;
            return;
        }
        ByteBuffer newData = this.createReplacementByteBuffer(requiredCapacity);
        newData.order(currentData.order());
        if (position > 0) {
            currentData.flip();
            newData.put(currentData);
        }
        this.data = newData;
    }

    public final boolean isEncrypted() {
        return this.getFlag(0x40000000);
    }

    public final void flip() {
        if (this.data != null) {
            this.data.flip();
        }
        if (this.supplementalData != null) {
            this.supplementalData.flip();
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.data != null) {
            this.data.clear();
        }
        if (this.supplementalData != null) {
            this.supplementalData.clear();
        }
        this.waitingForKeys = false;
    }

    private ByteBuffer createReplacementByteBuffer(int requiredCapacity) {
        if (this.bufferReplacementMode == 1) {
            return ByteBuffer.allocate(requiredCapacity);
        }
        if (this.bufferReplacementMode == 2) {
            return ByteBuffer.allocateDirect(requiredCapacity);
        }
        int currentCapacity = this.data == null ? 0 : this.data.capacity();
        throw new InsufficientCapacityException(currentCapacity, requiredCapacity);
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.decoder");
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface BufferReplacementMode {
    }

    public static final class InsufficientCapacityException
    extends IllegalStateException {
        public final int currentCapacity;
        public final int requiredCapacity;

        public InsufficientCapacityException(int currentCapacity, int requiredCapacity) {
            super(new StringBuilder(44).append("Buffer too small (").append(currentCapacity).append(" < ").append(requiredCapacity).append(")").toString());
            this.currentCapacity = currentCapacity;
            this.requiredCapacity = requiredCapacity;
        }
    }
}

