/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.crypto;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

@Deprecated
public final class AesFlushingCipher {
    private final Cipher cipher;
    private final int blockSize;
    private final byte[] zerosBlock;
    private final byte[] flushedBlock;
    private int pendingXorBytes;

    public AesFlushingCipher(int mode, byte[] secretKey, @Nullable String nonce, long offset) {
        this(mode, secretKey, AesFlushingCipher.getFNV64Hash(nonce), offset);
    }

    public AesFlushingCipher(int mode, byte[] secretKey, long nonce, long offset) {
        try {
            this.cipher = Cipher.getInstance("AES/CTR/NoPadding");
            this.blockSize = this.cipher.getBlockSize();
            this.zerosBlock = new byte[this.blockSize];
            this.flushedBlock = new byte[this.blockSize];
            long counter = offset / (long)this.blockSize;
            int startPadding = (int)(offset % (long)this.blockSize);
            this.cipher.init(mode, (Key)new SecretKeySpec(secretKey, Util.splitAtFirst((String)this.cipher.getAlgorithm(), (String)"/")[0]), new IvParameterSpec(this.getInitializationVector(nonce, counter)));
            if (startPadding != 0) {
                this.updateInPlace(new byte[startPadding], 0, startPadding);
            }
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateInPlace(byte[] data, int offset, int length) {
        this.update(data, offset, length, data, offset);
    }

    public void update(byte[] in, int inOffset, int length, byte[] out, int outOffset) {
        while (this.pendingXorBytes > 0) {
            out[outOffset] = (byte)(in[inOffset] ^ this.flushedBlock[this.blockSize - this.pendingXorBytes]);
            ++outOffset;
            ++inOffset;
            --this.pendingXorBytes;
            if (--length != 0) continue;
            return;
        }
        int written = this.nonFlushingUpdate(in, inOffset, length, out, outOffset);
        if (length == written) {
            return;
        }
        int bytesToFlush = length - written;
        Assertions.checkState((bytesToFlush < this.blockSize ? 1 : 0) != 0);
        outOffset += written;
        this.pendingXorBytes = this.blockSize - bytesToFlush;
        written = this.nonFlushingUpdate(this.zerosBlock, 0, this.pendingXorBytes, this.flushedBlock, 0);
        Assertions.checkState((written == this.blockSize ? 1 : 0) != 0);
        for (int i = 0; i < bytesToFlush; ++i) {
            out[outOffset++] = this.flushedBlock[i];
        }
    }

    private int nonFlushingUpdate(byte[] in, int inOffset, int length, byte[] out, int outOffset) {
        try {
            return this.cipher.update(in, inOffset, length, out, outOffset);
        }
        catch (ShortBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] getInitializationVector(long nonce, long counter) {
        return ByteBuffer.allocate(16).putLong(nonce).putLong(counter).array();
    }

    private static long getFNV64Hash(@Nullable String input) {
        if (input == null) {
            return 0L;
        }
        long hash = 0L;
        for (int i = 0; i < input.length(); ++i) {
            hash ^= (long)input.charAt(i);
            hash += (hash << 1) + (hash << 4) + (hash << 5) + (hash << 7) + (hash << 8) + (hash << 40);
        }
        return hash;
    }
}

