/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.BaseDataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;

@Deprecated
public final class ByteArrayDataSource
extends BaseDataSource {
    private final byte[] data;
    @Nullable
    private Uri uri;
    private int readPosition;
    private int bytesRemaining;
    private boolean opened;

    public ByteArrayDataSource(byte[] data) {
        super(false);
        Assertions.checkNotNull((Object)data);
        Assertions.checkArgument((data.length > 0 ? 1 : 0) != 0);
        this.data = data;
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        this.uri = dataSpec.uri;
        this.transferInitializing(dataSpec);
        if (dataSpec.position > (long)this.data.length) {
            throw new DataSourceException(2008);
        }
        this.readPosition = (int)dataSpec.position;
        this.bytesRemaining = this.data.length - (int)dataSpec.position;
        if (dataSpec.length != -1L) {
            this.bytesRemaining = (int)Math.min((long)this.bytesRemaining, dataSpec.length);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return dataSpec.length != -1L ? dataSpec.length : (long)this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0) {
            return -1;
        }
        length = Math.min(length, this.bytesRemaining);
        System.arraycopy(this.data, this.readPosition, buffer, offset, length);
        this.readPosition += length;
        this.bytesRemaining -= length;
        this.bytesTransferred(length);
        return length;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void close() {
        if (this.opened) {
            this.opened = false;
            this.transferEnded();
        }
        this.uri = null;
    }
}

