/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.DataSource;
import java.io.IOException;
import java.util.Arrays;

public final class DataSourceUtil {
    private DataSourceUtil() {
    }

    public static byte[] readToEnd(DataSource dataSource) throws IOException {
        byte[] data = new byte[1024];
        int position = 0;
        int bytesRead = 0;
        while (bytesRead != -1) {
            if (position == data.length) {
                data = Arrays.copyOf(data, data.length * 2);
            }
            if ((bytesRead = dataSource.read(data, position, data.length - position)) == -1) continue;
            position += bytesRead;
        }
        return Arrays.copyOf(data, position);
    }

    public static byte[] readExactly(DataSource dataSource, int length) throws IOException {
        int bytesRead;
        byte[] data = new byte[length];
        for (int position = 0; position < length; position += bytesRead) {
            bytesRead = dataSource.read(data, position, data.length - position);
            if (bytesRead != -1) continue;
            throw new IllegalStateException("Not enough data could be read: " + position + " < " + length);
        }
        return data;
    }

    public static void closeQuietly(@Nullable DataSource dataSource) {
        try {
            if (dataSource != null) {
                dataSource.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

