/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import java.util.Locale;

public final class UrlTemplate {
    private static final String REPRESENTATION = "RepresentationID";
    private static final String NUMBER = "Number";
    private static final String BANDWIDTH = "Bandwidth";
    private static final String TIME = "Time";
    private static final String ESCAPED_DOLLAR = "$$";
    private static final String DEFAULT_FORMAT_TAG = "%01d";
    private static final int REPRESENTATION_ID = 1;
    private static final int NUMBER_ID = 2;
    private static final int BANDWIDTH_ID = 3;
    private static final int TIME_ID = 4;
    private final String[] urlPieces;
    private final int[] identifiers;
    private final String[] identifierFormatTags;
    private final int identifierCount;

    public static UrlTemplate compile(String template) {
        String[] urlPieces = new String[5];
        int[] identifiers = new int[4];
        String[] identifierFormatTags = new String[4];
        int identifierCount = UrlTemplate.parseTemplate(template, urlPieces, identifiers, identifierFormatTags);
        return new UrlTemplate(urlPieces, identifiers, identifierFormatTags, identifierCount);
    }

    private UrlTemplate(String[] urlPieces, int[] identifiers, String[] identifierFormatTags, int identifierCount) {
        this.urlPieces = urlPieces;
        this.identifiers = identifiers;
        this.identifierFormatTags = identifierFormatTags;
        this.identifierCount = identifierCount;
    }

    public String buildUri(String representationId, int segmentNumber, int bandwidth, long time) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.identifierCount; ++i) {
            builder.append(this.urlPieces[i]);
            if (this.identifiers[i] == 1) {
                builder.append(representationId);
                continue;
            }
            if (this.identifiers[i] == 2) {
                builder.append(String.format(Locale.US, this.identifierFormatTags[i], segmentNumber));
                continue;
            }
            if (this.identifiers[i] == 3) {
                builder.append(String.format(Locale.US, this.identifierFormatTags[i], bandwidth));
                continue;
            }
            if (this.identifiers[i] != 4) continue;
            builder.append(String.format(Locale.US, this.identifierFormatTags[i], time));
        }
        builder.append(this.urlPieces[this.identifierCount]);
        return builder.toString();
    }

    private static int parseTemplate(String template, String[] urlPieces, int[] identifiers, String[] identifierFormatTags) {
        urlPieces[0] = "";
        int templateIndex = 0;
        int identifierCount = 0;
        while (templateIndex < template.length()) {
            int dollarIndex = template.indexOf("$", templateIndex);
            if (dollarIndex == -1) {
                int n = identifierCount;
                urlPieces[n] = urlPieces[n] + template.substring(templateIndex);
                templateIndex = template.length();
                continue;
            }
            if (dollarIndex != templateIndex) {
                int n = identifierCount;
                urlPieces[n] = urlPieces[n] + template.substring(templateIndex, dollarIndex);
                templateIndex = dollarIndex;
                continue;
            }
            if (template.startsWith(ESCAPED_DOLLAR, templateIndex)) {
                int n = identifierCount;
                urlPieces[n] = urlPieces[n] + "$";
                templateIndex += 2;
                continue;
            }
            int secondIndex = template.indexOf("$", templateIndex + 1);
            String identifier = template.substring(templateIndex + 1, secondIndex);
            if (identifier.equals(REPRESENTATION)) {
                identifiers[identifierCount] = 1;
            } else {
                int formatTagIndex = identifier.indexOf("%0");
                String formatTag = DEFAULT_FORMAT_TAG;
                if (formatTagIndex != -1) {
                    formatTag = identifier.substring(formatTagIndex);
                    if (!formatTag.endsWith("d")) {
                        formatTag = formatTag + "d";
                    }
                    identifier = identifier.substring(0, formatTagIndex);
                }
                switch (identifier) {
                    case "Number": {
                        identifiers[identifierCount] = 2;
                        break;
                    }
                    case "Bandwidth": {
                        identifiers[identifierCount] = 3;
                        break;
                    }
                    case "Time": {
                        identifiers[identifierCount] = 4;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid template: " + template);
                    }
                }
                identifierFormatTags[identifierCount] = formatTag;
            }
            urlPieces[++identifierCount] = "";
            templateIndex = secondIndex + 1;
        }
        return identifierCount;
    }
}

