/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash.manifest;

import android.net.Uri;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.source.dash.manifest.AdaptationSet;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.manifest.Representation;
import com.google.android.exoplayer2.source.dash.manifest.RepresentationKey;
import com.google.android.exoplayer2.source.dash.manifest.UtcTimingElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DashManifest {
    public final long availabilityStartTime;
    public final long duration;
    public final long minBufferTime;
    public final boolean dynamic;
    public final long minUpdatePeriod;
    public final long timeShiftBufferDepth;
    public final long suggestedPresentationDelay;
    public final UtcTimingElement utcTiming;
    public final Uri location;
    private final List<Period> periods;

    public DashManifest(long availabilityStartTime, long duration, long minBufferTime, boolean dynamic, long minUpdatePeriod, long timeShiftBufferDepth, long suggestedPresentationDelay, UtcTimingElement utcTiming, Uri location, List<Period> periods) {
        this.availabilityStartTime = availabilityStartTime;
        this.duration = duration;
        this.minBufferTime = minBufferTime;
        this.dynamic = dynamic;
        this.minUpdatePeriod = minUpdatePeriod;
        this.timeShiftBufferDepth = timeShiftBufferDepth;
        this.suggestedPresentationDelay = suggestedPresentationDelay;
        this.utcTiming = utcTiming;
        this.location = location;
        this.periods = periods == null ? Collections.emptyList() : periods;
    }

    public final int getPeriodCount() {
        return this.periods.size();
    }

    public final Period getPeriod(int index) {
        return this.periods.get(index);
    }

    public final long getPeriodDurationMs(int index) {
        return index == this.periods.size() - 1 ? (this.duration == -9223372036854775807L ? -9223372036854775807L : this.duration - this.periods.get((int)index).startMs) : this.periods.get((int)(index + 1)).startMs - this.periods.get((int)index).startMs;
    }

    public final long getPeriodDurationUs(int index) {
        return C.msToUs((long)this.getPeriodDurationMs(index));
    }

    public final DashManifest copy(List<RepresentationKey> representationKeys) {
        LinkedList<RepresentationKey> keys = new LinkedList<RepresentationKey>(representationKeys);
        Collections.sort(keys);
        keys.add(new RepresentationKey(-1, -1, -1));
        ArrayList<Period> copyPeriods = new ArrayList<Period>();
        long shiftMs = 0L;
        for (int periodIndex = 0; periodIndex < this.getPeriodCount(); ++periodIndex) {
            if (keys.peek().periodIndex != periodIndex) {
                long periodDurationMs = this.getPeriodDurationMs(periodIndex);
                if (periodDurationMs == -9223372036854775807L) continue;
                shiftMs += periodDurationMs;
                continue;
            }
            Period period = this.getPeriod(periodIndex);
            ArrayList<AdaptationSet> copyAdaptationSets = DashManifest.copyAdaptationSets(period.adaptationSets, keys);
            copyPeriods.add(new Period(period.id, period.startMs - shiftMs, copyAdaptationSets));
        }
        long newDuration = this.duration != -9223372036854775807L ? this.duration - shiftMs : -9223372036854775807L;
        return new DashManifest(this.availabilityStartTime, newDuration, this.minBufferTime, this.dynamic, this.minUpdatePeriod, this.timeShiftBufferDepth, this.suggestedPresentationDelay, this.utcTiming, this.location, copyPeriods);
    }

    private static ArrayList<AdaptationSet> copyAdaptationSets(List<AdaptationSet> adaptationSets, LinkedList<RepresentationKey> keys) {
        RepresentationKey key = keys.poll();
        int periodIndex = key.periodIndex;
        ArrayList<AdaptationSet> copyAdaptationSets = new ArrayList<AdaptationSet>();
        do {
            int adaptationSetIndex = key.adaptationSetIndex;
            AdaptationSet adaptationSet = adaptationSets.get(adaptationSetIndex);
            List<Representation> representations = adaptationSet.representations;
            ArrayList<Representation> copyRepresentations = new ArrayList<Representation>();
            do {
                Representation representation = representations.get(key.representationIndex);
                copyRepresentations.add(representation);
                key = keys.poll();
            } while (key.periodIndex == periodIndex && key.adaptationSetIndex == adaptationSetIndex);
            copyAdaptationSets.add(new AdaptationSet(adaptationSet.id, adaptationSet.type, copyRepresentations, adaptationSet.accessibilityDescriptors));
        } while (key.periodIndex == periodIndex);
        keys.addFirst(key);
        return copyAdaptationSets;
    }
}

