/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.source.dash.DashSegmentIndex;
import com.google.android.exoplayer2.source.dash.manifest.RangedUri;

public final class DashWrappingSegmentIndex
implements DashSegmentIndex {
    private final ChunkIndex chunkIndex;
    private final long timeOffsetUs;

    public DashWrappingSegmentIndex(ChunkIndex chunkIndex, long timeOffsetUs) {
        this.chunkIndex = chunkIndex;
        this.timeOffsetUs = timeOffsetUs;
    }

    @Override
    public long getFirstSegmentNum() {
        return 0L;
    }

    @Override
    public long getFirstAvailableSegmentNum(long periodDurationUs, long nowUnixTimeUs) {
        return 0L;
    }

    @Override
    public long getSegmentCount(long periodDurationUs) {
        return this.chunkIndex.length;
    }

    @Override
    public long getAvailableSegmentCount(long periodDurationUs, long nowUnixTimeUs) {
        return this.chunkIndex.length;
    }

    @Override
    public long getNextSegmentAvailableTimeUs(long periodDurationUs, long nowUnixTimeUs) {
        return -9223372036854775807L;
    }

    @Override
    public long getTimeUs(long segmentNum) {
        return this.chunkIndex.timesUs[(int)segmentNum] - this.timeOffsetUs;
    }

    @Override
    public long getDurationUs(long segmentNum, long periodDurationUs) {
        return this.chunkIndex.durationsUs[(int)segmentNum];
    }

    @Override
    public RangedUri getSegmentUrl(long segmentNum) {
        return new RangedUri(null, this.chunkIndex.offsets[(int)segmentNum], this.chunkIndex.sizes[(int)segmentNum]);
    }

    @Override
    public long getSegmentNum(long timeUs, long periodDurationUs) {
        return this.chunkIndex.getChunkIndex(timeUs + this.timeOffsetUs);
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

