/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.util.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public final class AudioProcessingPipeline {
    private final ImmutableList<AudioProcessor> audioProcessors;
    private final List<AudioProcessor> activeAudioProcessors;
    private ByteBuffer[] outputBuffers;
    private AudioProcessor.AudioFormat outputAudioFormat;
    private AudioProcessor.AudioFormat pendingOutputAudioFormat;
    private boolean inputEnded;

    public AudioProcessingPipeline(ImmutableList<AudioProcessor> audioProcessors) {
        this.audioProcessors = audioProcessors;
        this.activeAudioProcessors = new ArrayList<AudioProcessor>();
        this.outputBuffers = new ByteBuffer[0];
        this.outputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.pendingOutputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.inputEnded = false;
    }

    @CanIgnoreReturnValue
    public AudioProcessor.AudioFormat configure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        if (inputAudioFormat.equals(AudioProcessor.AudioFormat.NOT_SET)) {
            throw new AudioProcessor.UnhandledAudioFormatException(inputAudioFormat);
        }
        AudioProcessor.AudioFormat intermediateAudioFormat = inputAudioFormat;
        for (int i = 0; i < this.audioProcessors.size(); ++i) {
            AudioProcessor audioProcessor = (AudioProcessor)this.audioProcessors.get(i);
            AudioProcessor.AudioFormat nextFormat = audioProcessor.configure(intermediateAudioFormat);
            if (!audioProcessor.isActive()) continue;
            Assertions.checkState(!nextFormat.equals(AudioProcessor.AudioFormat.NOT_SET));
            intermediateAudioFormat = nextFormat;
        }
        this.pendingOutputAudioFormat = intermediateAudioFormat;
        return this.pendingOutputAudioFormat;
    }

    public void flush() {
        int i;
        this.activeAudioProcessors.clear();
        this.outputAudioFormat = this.pendingOutputAudioFormat;
        this.inputEnded = false;
        for (i = 0; i < this.audioProcessors.size(); ++i) {
            AudioProcessor audioProcessor = (AudioProcessor)this.audioProcessors.get(i);
            audioProcessor.flush();
            if (!audioProcessor.isActive()) continue;
            this.activeAudioProcessors.add(audioProcessor);
        }
        this.outputBuffers = new ByteBuffer[this.activeAudioProcessors.size()];
        for (i = 0; i <= this.getFinalOutputBufferIndex(); ++i) {
            this.outputBuffers[i] = this.activeAudioProcessors.get(i).getOutput();
        }
    }

    public AudioProcessor.AudioFormat getOutputAudioFormat() {
        return this.outputAudioFormat;
    }

    public boolean isOperational() {
        return !this.activeAudioProcessors.isEmpty();
    }

    public void queueInput(ByteBuffer inputBuffer) {
        if (!this.isOperational() || this.inputEnded) {
            return;
        }
        this.processData(inputBuffer);
    }

    public ByteBuffer getOutput() {
        if (!this.isOperational()) {
            return AudioProcessor.EMPTY_BUFFER;
        }
        ByteBuffer outputBuffer = this.outputBuffers[this.getFinalOutputBufferIndex()];
        if (!outputBuffer.hasRemaining()) {
            this.processData(AudioProcessor.EMPTY_BUFFER);
        }
        return outputBuffer;
    }

    public void queueEndOfStream() {
        if (!this.isOperational() || this.inputEnded) {
            return;
        }
        this.inputEnded = true;
        this.activeAudioProcessors.get(0).queueEndOfStream();
    }

    public boolean isEnded() {
        return this.inputEnded && this.activeAudioProcessors.get(this.getFinalOutputBufferIndex()).isEnded() && !this.outputBuffers[this.getFinalOutputBufferIndex()].hasRemaining();
    }

    public void reset() {
        for (int i = 0; i < this.audioProcessors.size(); ++i) {
            AudioProcessor audioProcessor = (AudioProcessor)this.audioProcessors.get(i);
            audioProcessor.flush();
            audioProcessor.reset();
        }
        this.outputBuffers = new ByteBuffer[0];
        this.outputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.pendingOutputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.inputEnded = false;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AudioProcessingPipeline)) {
            return false;
        }
        AudioProcessingPipeline that = (AudioProcessingPipeline)o;
        if (this.audioProcessors.size() != that.audioProcessors.size()) {
            return false;
        }
        for (int i = 0; i < this.audioProcessors.size(); ++i) {
            if (this.audioProcessors.get(i) == that.audioProcessors.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.audioProcessors.hashCode();
    }

    private void processData(ByteBuffer inputBuffer) {
        boolean progressMade = true;
        while (progressMade) {
            progressMade = false;
            for (int index = 0; index <= this.getFinalOutputBufferIndex(); ++index) {
                if (this.outputBuffers[index].hasRemaining()) continue;
                AudioProcessor audioProcessor = this.activeAudioProcessors.get(index);
                if (audioProcessor.isEnded()) {
                    if (this.outputBuffers[index].hasRemaining() || index >= this.getFinalOutputBufferIndex()) continue;
                    this.activeAudioProcessors.get(index + 1).queueEndOfStream();
                    continue;
                }
                ByteBuffer input = index > 0 ? this.outputBuffers[index - 1] : (inputBuffer.hasRemaining() ? inputBuffer : AudioProcessor.EMPTY_BUFFER);
                long inputBytes = input.remaining();
                audioProcessor.queueInput(input);
                this.outputBuffers[index] = audioProcessor.getOutput();
                progressMade |= inputBytes - (long)input.remaining() > 0L || this.outputBuffers[index].hasRemaining();
            }
        }
    }

    private int getFinalOutputBufferIndex() {
        return this.outputBuffers.length - 1;
    }
}

