/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public final class CodecSpecificDataUtil {
    private static final byte[] NAL_START_CODE = new byte[]{0, 0, 0, 1};
    private static final String[] HEVC_GENERAL_PROFILE_SPACE_STRINGS = new String[]{"", "A", "B", "C"};
    private static final int VISUAL_OBJECT_LAYER = 1;
    private static final int VISUAL_OBJECT_LAYER_START = 32;
    private static final int EXTENDED_PAR = 15;
    private static final int RECTANGULAR = 0;

    public static Pair<Integer, Integer> parseAlacAudioSpecificConfig(byte[] audioSpecificConfig) {
        ParsableByteArray byteArray = new ParsableByteArray(audioSpecificConfig);
        byteArray.setPosition(9);
        int channelCount = byteArray.readUnsignedByte();
        byteArray.setPosition(20);
        int sampleRate = byteArray.readUnsignedIntToInt();
        return Pair.create((Object)sampleRate, (Object)channelCount);
    }

    public static List<byte[]> buildCea708InitializationData(boolean isWideAspectRatio) {
        byte[] byArray;
        if (isWideAspectRatio) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        return Collections.singletonList(byArray);
    }

    public static boolean parseCea708InitializationData(List<byte[]> initializationData) {
        return initializationData.size() == 1 && initializationData.get(0).length == 1 && initializationData.get(0)[0] == 1;
    }

    public static Pair<Integer, Integer> getVideoResolutionFromMpeg4VideoConfig(byte[] videoSpecificConfig) {
        int videoObjectLayerShape;
        int aspectRatioInfo;
        int offset = 0;
        boolean foundVOL = false;
        ParsableByteArray scratchBytes = new ParsableByteArray(videoSpecificConfig);
        while (offset + 3 < videoSpecificConfig.length) {
            if (scratchBytes.readUnsignedInt24() != 1 || (videoSpecificConfig[offset + 3] & 0xF0) != 32) {
                scratchBytes.setPosition(scratchBytes.getPosition() - 2);
                ++offset;
                continue;
            }
            foundVOL = true;
            break;
        }
        Assertions.checkArgument(foundVOL, "Invalid input: VOL not found.");
        ParsableBitArray scratchBits = new ParsableBitArray(videoSpecificConfig);
        scratchBits.skipBits((offset + 4) * 8);
        scratchBits.skipBits(1);
        scratchBits.skipBits(8);
        if (scratchBits.readBit()) {
            scratchBits.skipBits(4);
            scratchBits.skipBits(3);
        }
        if ((aspectRatioInfo = scratchBits.readBits(4)) == 15) {
            scratchBits.skipBits(8);
            scratchBits.skipBits(8);
        }
        if (scratchBits.readBit()) {
            scratchBits.skipBits(2);
            scratchBits.skipBits(1);
            if (scratchBits.readBit()) {
                scratchBits.skipBits(79);
            }
        }
        Assertions.checkArgument((videoObjectLayerShape = scratchBits.readBits(2)) == 0, "Only supports rectangular video object layer shape.");
        Assertions.checkArgument(scratchBits.readBit());
        int vopTimeIncrementResolution = scratchBits.readBits(16);
        Assertions.checkArgument(scratchBits.readBit());
        if (scratchBits.readBit()) {
            Assertions.checkArgument(vopTimeIncrementResolution > 0);
            --vopTimeIncrementResolution;
            int numBitsToSkip = 0;
            while (vopTimeIncrementResolution > 0) {
                ++numBitsToSkip;
                vopTimeIncrementResolution >>= 1;
            }
            scratchBits.skipBits(numBitsToSkip);
        }
        Assertions.checkArgument(scratchBits.readBit());
        int videoObjectLayerWidth = scratchBits.readBits(13);
        Assertions.checkArgument(scratchBits.readBit());
        int videoObjectLayerHeight = scratchBits.readBits(13);
        Assertions.checkArgument(scratchBits.readBit());
        scratchBits.skipBits(1);
        return Pair.create((Object)videoObjectLayerWidth, (Object)videoObjectLayerHeight);
    }

    public static String buildAvcCodecString(int profileIdc, int constraintsFlagsAndReservedZero2Bits, int levelIdc) {
        return String.format("avc1.%02X%02X%02X", profileIdc, constraintsFlagsAndReservedZero2Bits, levelIdc);
    }

    public static String buildHevcCodecString(int generalProfileSpace, boolean generalTierFlag, int generalProfileIdc, int generalProfileCompatibilityFlags, int[] constraintBytes, int generalLevelIdc) {
        int trailingZeroIndex;
        StringBuilder builder = new StringBuilder(Util.formatInvariant("hvc1.%s%d.%X.%c%d", HEVC_GENERAL_PROFILE_SPACE_STRINGS[generalProfileSpace], generalProfileIdc, generalProfileCompatibilityFlags, Character.valueOf(generalTierFlag ? (char)'H' : 'L'), generalLevelIdc));
        for (trailingZeroIndex = constraintBytes.length; trailingZeroIndex > 0 && constraintBytes[trailingZeroIndex - 1] == 0; --trailingZeroIndex) {
        }
        for (int i = 0; i < trailingZeroIndex; ++i) {
            builder.append(String.format(".%02X", constraintBytes[i]));
        }
        return builder.toString();
    }

    public static byte[] buildNalUnit(byte[] data, int offset, int length) {
        byte[] nalUnit = new byte[length + NAL_START_CODE.length];
        System.arraycopy(NAL_START_CODE, 0, nalUnit, 0, NAL_START_CODE.length);
        System.arraycopy(data, offset, nalUnit, NAL_START_CODE.length, length);
        return nalUnit;
    }

    @Nullable
    public static byte[][] splitNalUnits(byte[] data) {
        if (!CodecSpecificDataUtil.isNalStartCode(data, 0)) {
            return null;
        }
        ArrayList<Integer> starts = new ArrayList<Integer>();
        int nalUnitIndex = 0;
        do {
            starts.add(nalUnitIndex);
        } while ((nalUnitIndex = CodecSpecificDataUtil.findNalStartCode(data, nalUnitIndex + NAL_START_CODE.length)) != -1);
        byte[][] split = new byte[starts.size()][];
        for (int i = 0; i < starts.size(); ++i) {
            int startIndex = (Integer)starts.get(i);
            int endIndex = i < starts.size() - 1 ? (Integer)starts.get(i + 1) : data.length;
            byte[] nal = new byte[endIndex - startIndex];
            System.arraycopy(data, startIndex, nal, 0, nal.length);
            split[i] = nal;
        }
        return split;
    }

    private static int findNalStartCode(byte[] data, int index) {
        int endIndex = data.length - NAL_START_CODE.length;
        for (int i = index; i <= endIndex; ++i) {
            if (!CodecSpecificDataUtil.isNalStartCode(data, i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isNalStartCode(byte[] data, int index) {
        if (data.length - index <= NAL_START_CODE.length) {
            return false;
        }
        for (int j = 0; j < NAL_START_CODE.length; ++j) {
            if (data[index + j] == NAL_START_CODE[j]) continue;
            return false;
        }
        return true;
    }

    private CodecSpecificDataUtil() {
    }
}

